Attribute VB_Name = "RenderStation"
Public Declare Function EnumFontFamilies Lib "gdi32" Alias "EnumFontFamiliesA" (ByVal hdc As Long, ByVal lpszFamily As String, ByVal lpEnumFontFamProc As Long, lParam As Any) As Long
Public Declare Function EnumFontFamiliesEx Lib "gdi32.dll" Alias "EnumFontFamiliesExA" (ByVal hdc As Long, lpLogfont As LOGFONT, ByVal lpEnumFontFamExProc As Long, ByVal lParam As Long, ByVal dwFlags As Long) As Long
Public Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Public Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long


Public contcharset          As Integer
Public fonts(1000)          As fontsSystem
Public contfonts            As Integer
Public fontSelected         As Integer
Public CP                   As Long
Public TextPreview          As String
Public RTLActivate          As Boolean
Public charSetGet           As KnownCharset
Public nameFont             As String
Public styleFont            As String
Public sizeEdge             As Integer
Public sizeFont             As Integer
Public isPreview            As Boolean

Public Const LF_FACESIZE = 32
Public Const TWIPSPERPIXEL = 15
Public Const FW_DONTCARE = 0
Public Const FW_THIN = 100
Public Const FW_EXTRALIGHT = 200
Public Const FW_ULTRALIGHT = 200
Public Const FW_LIGHT = 300
Public Const FW_NORMAL = 400
Public Const FW_REGULAR = 400
Public Const FW_MEDIUM = 500
Public Const FW_SEMIBOLD = 600
Public Const FW_DEMIBOLD = 600
Public Const FW_BOLD = 700
Public Const FW_EXTRABOLD = 800
Public Const FW_ULTRABOLD = 800
Public Const FW_HEAVY = 900
Public Const FW_BLACK = 900
Public Const TRUETYPE_FONTTYPE = &H4
Public Const THAI = 874
Public Const CHINESESIMPLIFIED = 936
Public Const KOREAN = 949
Public Const CHINESEBIG = 950
Public Const EUROPECENTRAL = 1250
Public Const CYRILLIC = 1251
Public Const LATINI = 1252
Public Const GREEK = 1253
Public Const TURKISH = 1254
Public Const HEBREW = 1255
Public Const arabic = 1256
Public Const BALTIC = 1257
Public Const VIETNAM = 1258
Public Const JAPANESE = 932
Public Const CP_ACP = 0
Public Const CP_SYMBOL = 42



Public Type LOGFONT
     lfHeight           As Long
     lfWidth            As Long
     lfEscapement       As Long
     lfOrientation      As Long
     lfWeight           As Long
     lfItalic           As Byte
     lfUnderline        As Byte
     lfStrikeOut        As Byte
     lfCharSet          As Byte
     lfOutPrecision     As Byte
     lfClipPrecision    As Byte
     lfQuality          As Byte
     lfPitchAndFamily   As Byte
     lfFaceName         As String * LF_FACESIZE
End Type


Public Enum KnownCharset
    ANSI_CHARSET = 0
    DEFAULT_CHARSET = 1
    SYMBOL_CHARSET = 2
    MAC_CHARSET = 77
    SHIFTJIS_CHARSET = 128
    HANGEUL_CHARSET = 129
    JOHAB_CHARSET = 130
    GB2312_CHARSET = 134
    CHINESEBIG5_CHARSET = 136
    GREEK_CHARSET = 161
    TURKISH_CHARSET = 162
    VIETNAMESE_CHARSET = 163
    HEBREW_CHARSET = 177
    ARABIC_CHARSET = 178
    BALTIC_CHARSET = 186
    RUSSIAN_CHARSET = 204
    THAI_CHARSET = 222
    EASTEUROPE_CHARSET = 238
    OEM_CHARSET = 255
End Enum

Public Type NEWTEXTMETRIC
    tmHeight            As Long
    tmAscent            As Long
    tmDescent           As Long
    tmInternalLeading   As Long
    tmExternalLeading   As Long
    tmAveCharWidth      As Long
    tmMaxCharWidth      As Long
    tmWeight            As Long
    tmOverhang          As Long
    tmDigitizedAspectX  As Long
    tmDigitizedAspectY  As Long
    tmFirstChar         As Byte
    tmLastChar          As Byte
    tmDefaultChar       As Byte
    tmBreakChar         As Byte
    tmItalic            As Byte
    tmUnderlined        As Byte
    tmStruckOut         As Byte
    tmPitchAndFamily    As Byte
    tmCharSet           As Byte
    ntmFlags            As Long
    ntmSizeEM           As Long
    ntmCellHeight       As Long
    ntmAveWidth         As Long
End Type

Public Type characterSets
    id                  As Integer
    name                As String
    CP                  As Integer
End Type

Public Type fontsSystem
    name                As String
    style               As String
    length              As Integer
    Charsets(1000)      As characterSets
End Type

Public Type RECT
   Left                 As Long
   top                  As Long
   Right                As Long
   Bottom               As Long
End Type

Public Type RECTF
   Left                 As Long
   top                  As Long
   Right                As Long
   Bottom               As Long
End Type

Public Function EnumFontFamProc(lpElf As LOGFONT, lpNtm As NEWTEXTMETRIC, ByVal FontType As Long, lParam As Long) As Long
    Dim fontfamily  As Long
    Dim isAvailable As Long
    
    isAvailable = 0
    If (FontType _
    And TRUETYPE_FONTTYPE) = TRUETYPE_FONTTYPE _
    And Mid(StrConv(lpElf.lfFaceName, vbUnicode), 1, 1) <> "@" _
    And StrConv(lpElf.lfFaceName, vbUnicode) <> "" Then
        GdipCreateFontFamilyFromName StrConv(lpElf.lfFaceName, vbUnicode), 0, fontfamily
        GdipIsStyleAvailable fontfamily, 0, isAvailable
        If isAvailable <> 0 Then
            Form8.List1.AddItem StrConv(lpElf.lfFaceName, vbUnicode)
        End If
    End If
    EnumFontFamProc = 1
End Function

