Attribute VB_Name = "BitMapBas"
Option Explicit

Private Declare Function CreateBitmap& Lib "gdi32" (ByVal nWidth&, ByVal nHeight&, ByVal nPlanes&, ByVal nBitCount&, ByVal lpBits As Any)
Declare Function StretchBlt Lib "gdi32" (ByVal hDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) As Long
Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hDC As Long) As Long
Declare Function CreateCompatibleBitmap Lib "gdi32" (ByVal hDC As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long
Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Declare Function SetBkColor Lib "gdi32" (ByVal hDC As Long, ByVal crColor As Long) As Long
Declare Function CreateSolidBrush Lib "gdi32" (ByVal crColor As Long) As Long

Public Const SRCCOPY = &HCC0020
Public Const SRCAND = &H8800C6
Public Const SRCPAINT = &HEE0086
Public Const SRCINVERT = &H660046
'
''Insert the following code to your form:
'
'Public Sub ReplaceColor(ByRef picThis As PictureBox, ByVal lFromColour As Long, ByVal lToColor As Long)
'    Dim lW As Long
'    Dim lH As Long
'    Dim lMaskDC As Long, lMaskBMP As Long, lMaskBMPOLd As Long
'    Dim lCopyDC As Long, lCopyBMP As Long, lCopyBMPOLd As Long
'    Dim tR As RECT
'    Dim hBr As Long
'
'    lW = picThis.Width \ TWIPSPERPIXEL
'    lH = picThis.Height \ TWIPSPERPIXEL
'
'    If (CreateDC(picThis, lW, lH, lMaskDC, lMaskBMP, lMaskBMPOLd, True)) Then
'        If (CreateDC(picThis, lW, lH, lCopyDC, lCopyBMP, lCopyBMPOLd)) Then
'            SetBkColor picThis.hDC, lFromColour
'            BitBlt lMaskDC, 0, 0, lW, lH, picThis.hDC, 0, 0, SRCCOPY
'            tR.Right = lW: tR.Bottom = lH
'            hBr = CreateSolidBrush(lToColor)
'            FillRect lCopyDC, tR, hBr
'            DeleteObject hBr
'            BitBlt lCopyDC, 0, 0, lW, lH, lMaskDC, 0, 0, SRCAND
'            hBr = CreateSolidBrush(&HFFFFFF)
'            FillRect lMaskDC, tR, hBr
'            DeleteObject hBr
'            BitBlt lMaskDC, 0, 0, lW, lH, picThis.hDC, 0, 0, SRCINVERT
'            SetBkColor picThis.hDC, &HFFFFFF
'            BitBlt picThis.hDC, 0, 0, lW, lH, lMaskDC, 0, 0, SRCAND
'            BitBlt picThis.hDC, 0, 0, lW, lH, lCopyDC, 0, 0, SRCPAINT
'            picThis.Refresh
'            SelectObject lCopyDC, lCopyBMPOLd
'            DeleteObject lCopyBMP
'            DeleteObject lCopyDC
'        End If
'        SelectObject lMaskDC, lMaskBMPOLd
'        DeleteObject lMaskBMP
'        DeleteObject lMaskDC
'    End If
'End Sub
'
'Public Function CreateDC(ByRef picThis As PictureBox, ByVal lW As Long, ByVal lH As Long, ByRef lhDC As Long, ByRef lhBmp As Long, ByRef lhBmpOld As Long, Optional ByVal bMono As Boolean = False) As Boolean
'    If (bMono) Then
'        lhDC = CreateCompatibleDC(0)
'    Else
'        lhDC = CreateCompatibleDC(picThis.hDC)
'    End If
'    If (lhDC <> 0) Then
'        If (bMono) Then
'            lhBmp = CreateCompatibleBitmap(lhDC, lW, lH)
'        Else
'            lhBmp = CreateCompatibleBitmap(picThis.hDC, lW, lH)
'        End If
'        If (lhBmp <> 0) Then
'            lhBmpOld = SelectObject(lhDC, lhBmp)
'            CreateDC = True
'        Else
'            DeleteObject lhDC
'            lhDC = 0
'        End If
'    End If
'End Function

Public Sub BitBltItNow(hDestDC As Long, lDestX, lDestY, hSourceDC As Long, lSourceW As Long, lSourceH As Long, lStartX As Long, lStartY As Long)
    Dim lRet As Long
    lRet = BitBlt(hDestDC, lDestX, lDestY, lSourceW, lSourceH, hSourceDC, lStartX, lStartY, SRCCOPY)
End Sub

Public Sub StretchBitMap(hDestDC As Long, lDestX As Long, lDestY As Long, lDestW As Long, lDestH As Long, hSourceDC As Long, lSourceW As Long, lSourceH As Long)
    Call StretchBlt(hDestDC, lDestX, lDestY, lDestW, lDestH, hSourceDC, 0, 0, lSourceW, lSourceH, SRCCOPY)
End Sub

Public Sub TransTileToForm(hDestDC As Long, lDestW As Long, lDestH As Long, hSourceDC As Long, lSourceW As Long, lSourceH As Long, lTransColor As Long)
    'Same thing as TileToForm except that it calls TransBltNow instead of a basic BitBlt
    Dim lRet As Long
    Dim lRows As Long
    Dim lCols As Long
    Dim i As Long
    Dim j As Long
    Dim lDestX As Long
    Dim lDestY As Long
    
    lCols = lDestW \ lSourceW
    lRows = lDestH \ lSourceH

    For i = 0 To lCols
        lDestX = i * lSourceW
        For j = 0 To lRows
            lDestY = j * lSourceH
            TransBltNow hDestDC, lDestX, lDestY, lSourceW, lSourceH, hSourceDC, 0, 0, lTransColor
        Next
    Next
End Sub
Public Sub TileToForm(hDestDC As Long, lDestW As Long, lDestH As Long, hSourceDC As Long, lSourceW As Long, lSourceH As Long)

    'Tiles to source bitmap on to the destination
    Dim lRet As Long
    Dim lRows As Long
    Dim lCols As Long
    Dim i As Long
    Dim j As Long
    Dim lDestX As Long
    Dim lDestY As Long
    
    'Figure out how many bitmaps will fit across
    lCols = lDestW \ lSourceW
    'Figure out how many bitmaps will fit down
    lRows = lDestH \ lSourceH

    'A nested loop to copy rows and cols
    For i = 0 To lCols
        lDestX = i * lSourceW
        For j = 0 To lRows
            lDestY = j * lSourceH
            lRet = BitBlt(hDestDC, lDestX, lDestY, lSourceW, lSourceH, hSourceDC, 0, 0, SRCCOPY)
        Next
    Next
End Sub


Public Sub TransBltNow(hDestDC As Long, lDestX As Long, lDestY As Long, lWidth As Long, lHeight As Long, hSourceDC As Long, lSourceX As Long, lSourceY As Long, lTransColor As Long)
'   This function copies a bitmap from one device context to the other
'   where every pixel in the source bitmap that matches the specified color
'   becomes transparent, letting the destination bitmap show through.

    Dim lOldColor As Long
    Dim hMaskDC As Long
    Dim hMaskBmp As Long
    Dim hOldMaskBmp As Long
    Dim hTempBmp As Long
    Dim hTempDC As Long
    Dim hOldTempBmp As Long
    Dim hDummy As Long
    Dim lRet As Long

    '   The Background colors of Source and Destination DCs must
    '   be the transparancy color in order to create a mask.
    lOldColor = SetBkColor&(hSourceDC, lTransColor)
    lOldColor = SetBkColor&(hDestDC, lTransColor)
    
    '   The mask DC must be compatible with the destination dc,
    '   but the mask has to be created as a monochrome bitmap.
    '   For this reason, we create a compatible dc and bitblt
    '   the mono mask into it.
    
    '   Create the Mask DC, and a compatible bitmap to go in it.
    hMaskDC = CreateCompatibleDC(hDestDC)
    hMaskBmp = CreateCompatibleBitmap(hDestDC, lWidth, lHeight)
    '   Move the Mask bitmap into the Mask DC
    
    hOldMaskBmp = SelectObject(hMaskDC, hMaskBmp)
    
    '   Create a monochrome bitmap that will be the actual mask bitmap.
    hTempBmp = CreateBitmap(lWidth, lHeight, 1, 1, 0&)
    
    '   Create a temporary DC, and put the mono bitmap into it
    hTempDC = CreateCompatibleDC(hDestDC)
    
    hOldTempBmp = SelectObject(hTempDC, hTempBmp)

    '   BitBlt the Source image into the mono dc to create a mono mask.
    If BitBlt(hTempDC, 0, 0, lWidth, lHeight, hSourceDC, lSourceX, lSourceY, SRCCOPY) Then
        'ReplaceColor Form11.Picture1, vbBlue, vbBlack
        '   Copy the mono mask into our Mask DC
        hDummy = BitBlt(hMaskDC, 0, 0, lWidth, lHeight, hTempDC, 0, 0, SRCCOPY)
    End If

    hTempBmp = SelectObject(hTempDC, hOldTempBmp)
    hDummy = DeleteObject(hTempBmp)
    hDummy = DeleteDC(hTempDC)

    '   Copy the source to the destination with XOR
    lRet = BitBlt(hDestDC, lDestX, lDestY, lWidth, lHeight, hSourceDC, lSourceX, lSourceY, SRCINVERT)
    '   Copy the Mask to the destination with AND
    lRet = BitBlt(hDestDC, lDestX, lDestY, lWidth, lHeight, hMaskDC, 0, 0, SRCAND)
    '   Again, copy the source to the destination with XOR
    lRet = BitBlt(hDestDC, lDestX, lDestY, lWidth, lHeight, hSourceDC, lSourceX, lSourceY, SRCINVERT)
'
    '   Clean up mask DC and bitmap
    hMaskBmp = SelectObject(hMaskDC, hOldMaskBmp)
    hDummy = DeleteObject(hMaskBmp)
    hDummy = DeleteDC(hMaskDC)
    
End Sub
