VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cTextureBrush"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Declare Function PatBlt Lib "gdi32" (ByVal hDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal dwRop As Long) As Long
Private Declare Function GetObjectAPI Lib "gdi32" Alias "GetObjectA" (ByVal hObject As Long, ByVal nCount As Long, lpObject As Any) As Long
Private Declare Function SetBrushOrgEx Lib "gdi32" (ByVal hDC As Long, ByVal nXOrg As Long, ByVal nYOrg As Long, lppt As Any) As Long
Private Declare Function CreateDCAsNull Lib "gdi32" Alias "CreateDCA" (ByVal lpDriverName As String, lpDeviceName As Any, lpOutput As Any, lpInitData As Any) As Long
Private Declare Function OleTranslateColor Lib "OLEPRO32.DLL" (ByVal OLE_COLOR As Long, ByVal HPALETTE As Long, pccolorref As Long) As Long
Private Declare Function CreatePatternBrush Lib "gdi32" (ByVal hBitmap As Long) As Long
Private Const CLR_INVALID = -1


Public Enum EPBRasterOperations
   PATCOPY = &HF00021           ' (DWORD) dest = pattern
   PATINVERT = &H5A0049         ' (DWORD) dest = pattern XOR dest
   PATPAINT = &HFB0A09          ' (DWORD) dest = DPSnoo
End Enum

Private m_hBrush As Long
Private m_lWidth As Long
Private m_lHeight As Long

Public Sub CreateFromPicture(picThis As IPicture)
   ' Create a copy of the bitmap:
   Dim lhDC As Long
   Dim lhDCCopy As Long
   Dim lhBmpCopy As Long
   Dim lhBmpCopyOld As Long
   Dim lhBmpOld As Long
   Dim lhDCC As Long
   Dim tBM As BITMAP
   
   GetObjectAPI picThis.Handle, Len(tBM), tBM
   lhDCC = CreateDCAsNull("DISPLAY", ByVal 0&, ByVal 0&, ByVal 0&)
   lhDC = CreateCompatibleDC(lhDCC)
   lhBmpOld = SelectObject(lhDC, picThis.Handle)
   
   lhDCCopy = CreateCompatibleDC(lhDCC)
   lhBmpCopy = CreateCompatibleBitmap(lhDCC, tBM.bmWidth, tBM.bmHeight)
   lhBmpCopyOld = SelectObject(lhDCCopy, lhBmpCopy)

   BitBlt lhDCCopy, 0, 0, tBM.bmWidth, tBM.bmHeight, lhDC, 0, 0, vbSrcCopy
   
   If Not (lhDCC = 0) Then
      DeleteDC lhDCC
   End If
   If Not (lhBmpOld = 0) Then
      SelectObject lhDC, lhBmpOld
   End If
   If Not (lhDC = 0) Then
      DeleteDC lhDC
   End If
   If Not (lhBmpCopyOld = 0) Then
      SelectObject lhDCCopy, lhBmpCopyOld
   End If
   If Not (lhDCCopy = 0) Then
      DeleteDC lhDCCopy
   End If
   
   CreateFromHBitmap lhBmpCopy
   DeleteObject lhBmpCopy
End Sub
Public Sub CreateFromDC(ByVal lhDC As Long, ByVal lWidth As Long, ByVal lHeight As Long)
   ' Copy the bitmap in lHDC:
   Dim lhDCCopy As Long
   Dim lhBmpCopy As Long
   Dim lhBmpCopyOld As Long
   Dim lhDCC As Long
   Dim tBM As BITMAP
   
   lhDCC = CreateDCAsNull("DISPLAY", ByVal 0&, ByVal 0&, ByVal 0&)
   lhDCCopy = CreateCompatibleDC(lhDCC)
   lhBmpCopy = CreateCompatibleBitmap(lhDCC, lWidth, lHeight)
   lhBmpCopyOld = SelectObject(lhDCCopy, lhBmpCopy)
   
   BitBlt lhDCCopy, 0, 0, lWidth, lHeight, lhDC, 0, 0, vbSrcCopy
   
   If Not (lhDCC = 0) Then
      DeleteDC lhDCC
   End If
   If Not (lhBmpCopyOld = 0) Then
      SelectObject lhDCCopy, lhBmpCopyOld
   End If
   If Not (lhDCCopy = 0) Then
      DeleteDC lhDCCopy
   End If
   
   CreateFromHBitmap lhBmpCopy
   DeleteObject lhBmpCopy
End Sub

Public Sub CreateFromHBitmap(ByVal hBmp As Long)
   Destroy
   Dim tBM As BITMAP
   GetObjectAPI hBmp, Len(tBM), tBM
   m_hBrush = CreatePatternBrush(hBmp)
   m_lWidth = tBM.bmWidth
   m_lHeight = tBM.bmHeight
   
End Sub

Public Sub DrawLine(ByVal hDC As Long, ByVal xPixels As Long, ByVal yPixels As Long, ByVal widthPixels As Long, ByVal heightPixels As Long, Optional ByVal eRop As EPBRasterOperations = PATCOPY, Optional ByVal oBackColor As OLE_COLOR = -1, Optional ByVal oForeColor As OLE_COLOR = -1)
Dim hOldBrush As Long
Dim lBkColor As Long
Dim lForeColor As Long
   hOldBrush = SelectObject(hDC, m_hBrush)
      If Not (oBackColor = -1) Then
         lBkColor = SetBkColor(hDC, TranslateColor(oBackColor))
      End If
      If Not (oForeColor = -1) Then
         lForeColor = SetTextColor(hDC, TranslateColor(oForeColor))
      End If
   PatBlt hDC, xPixels, yPixels, widthPixels, heightPixels, eRop
   If Not (oBackColor = -1) Then
      SetBkColor hDC, lBkColor
   End If
   If Not (oForeColor = -1) Then
       SetTextColor hDC, lForeColor
   End If
   SelectObject hDC, hOldBrush
End Sub

Public Sub Rectangle(ByVal hDC As Long, ByVal xPixels As Long, ByVal yPixels As Long, ByVal widthRectPixels As Long, ByVal heightRectPixels As Long, ByVal lineSizePixels As Long, Optional ByVal eRop As EPBRasterOperations = PATCOPY, Optional ByVal bFill As Boolean = False, Optional ByVal oBackColor As OLE_COLOR = -1, Optional ByVal oForeColor As OLE_COLOR = -1)
Dim lBkColor As Long
Dim lForeColor As Long

   If bFill Then
      Dim tR As RECT
      tR.left = xPixels: tR.top = xPixels
      tR.right = tR.left + widthRectPixels: tR.bottom = tR.top + heightRectPixels
      FillRect hDC, tR, m_hBrush
   Else
      Dim hOldBrush As Long
      hOldBrush = SelectObject(hDC, m_hBrush)
      If Not (oBackColor = -1) Then
         lBkColor = SetBkColor(hDC, TranslateColor(oBackColor))
      End If
      If Not (oForeColor = -1) Then
         lForeColor = SetTextColor(hDC, TranslateColor(oForeColor))
      End If
      PatBlt hDC, xPixels, yPixels, widthRectPixels, lineSizePixels, eRop
      PatBlt hDC, xPixels + widthRectPixels, yPixels, lineSizePixels, heightRectPixels, eRop
      PatBlt hDC, xPixels, yPixels + heightRectPixels, widthRectPixels, lineSizePixels, eRop
      PatBlt hDC, xPixels, yPixels, lineSizePixels, heightRectPixels, eRop
      If Not (oBackColor = -1) Then
         SetBkColor hDC, lBkColor
      End If
      If Not (oForeColor = -1) Then
          SetTextColor hDC, lForeColor
      End If
      SelectObject hDC, hOldBrush
   End If
End Sub
   
Public Sub SetBrushOrigin(ByVal hDC As Long, ByVal xPixels As Long, ByVal yPixels As Long)
   SetBrushOrgEx hDC, -xPixels And m_lWidth, -yPixels And m_lHeight, ByVal 0&
End Sub

Private Function TranslateColor(ByVal oClr As OLE_COLOR, Optional hPal As Long = 0) As Long
    ' Convert Automation color to Windows color
    If OleTranslateColor(oClr, hPal, TranslateColor) Then
        TranslateColor = CLR_INVALID
    End If
End Function
Public Sub Destroy()
   If m_hBrush <> 0 Then
      DeleteObject m_hBrush
      m_hBrush = 0
   End If
End Sub

Private Sub Class_Terminate()
   Destroy
End Sub
