/*************************************************************

				QuickCrypt Library 2.5

Module Name:    QuickCrypt.h

Abstract:       Master include file for QuickCrypt Library
			
	
			Copyright (c) 1999-2003, SlavaSoft Inc.
	
	  
*************************************************************/

#ifndef __QUICKCRYPT_H__
#define __QUICKCRYPT_H__

#if defined (_MSC_VER) && (_MSC_VER >= 1020)
#pragma once
#endif

#if defined (_MSC_VER)
#if !defined( _SL_QUICKCRYPT_IMPLEMENTATION ) && !defined( _SL_NOFORCE_LIBS )
#ifdef _SL_STATIC
	#pragma comment( lib, "QuickCryptS.lib" )
#else
	#pragma comment( lib, "QuickCrypt.lib" )
#endif //_SL_STATIC

#endif

#endif

#if ( defined (_MSC_VER) && (_MSC_VER >= 800) ) || defined(_STDCALL_SUPPORTED)
#define SL_CRYPTCALL _stdcall
#else
#define SL_CRYPTCALL
#endif

#define SLC_DES_BLOCKSIZE 8
#define SLC_DES_CONTEXTSIZE 168
#define SLC_DES_DEFAULTKEYSIZE 8

#define SLC_DES_EDE3_BLOCKSIZE SLC_DES_BLOCKSIZE
#define SLC_DES_EDE3_CONTEXTSIZE 440
#define SLC_DES_EDE3_DEFAULTKEYSIZE 24

#define SLC_DES_EDE2_BLOCKSIZE SLC_DES_BLOCKSIZE
#define SLC_DES_EDE2_CONTEXTSIZE 308
#define SLC_DES_EDE2_DEFAULTKEYSIZE 16

#define SLC_DESX_BLOCKSIZE SLC_DES_BLOCKSIZE
#define SLC_DESX_CONTEXTSIZE ( SLC_DES_CONTEXTSIZE + 24 + 28 + 8 )
#define SLC_DESX_DEFAULTKEYSIZE 24

#define SLC_RIJNDAEL_BLOCKSIZE 16
#define SLC_RIJNDAEL_CONTEXTSIZE 312
#define SLC_RIJNDAEL_DEFAULTKEYSIZE 16

#define SLC_AES_BLOCKSIZE SLC_RIJNDAEL_BLOCKSIZE
#define SLC_AES_CONTEXTSIZE SLC_RIJNDAEL_CONTEXTSIZE
#define SLC_AES_DEFAULTKEYSIZE SLC_RIJNDAEL_DEFAULTKEYSIZE

#define SLC_BLOWFISH_BLOCKSIZE 8
#define SLC_BLOWFISH_CONTEXTSIZE 4208
#define SLC_BLOWFISH_DEFAULTKEYSIZE 56

#define SLC_GOST_BLOCKSIZE 8
#define SLC_GOST_CONTEXTSIZE 76
#define SLC_GOST_DEFAULTKEYSIZE 32 

enum SL_CIPHER_DIR
{
	SLC_ENCRYPT = 0,
	SLC_DECRYPT = 1
};

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void			SL_CRYPTCALL SL_DES_Init( void* pContext, int nDir, const void* pKey, unsigned int nKeyLen );
void			SL_CRYPTCALL SL_DES_ProcessBlock( const void* pContext, void* pDestBlock, const void* pSrcBlock );
int				SL_CRYPTCALL SL_DES_CheckKeyParityBits( const void* pKey );
void			SL_CRYPTCALL SL_DES_CorrectKeyParityBits( void* pKey );

void			SL_CRYPTCALL SL_DES_EDE3_Init( void* pContext, int nDir, const void* pKey, unsigned int nKeyLen );
void			SL_CRYPTCALL SL_DES_EDE3_ProcessBlock( const void* pContext, void* pDestBlock, const void* pSrcBlock );

void			SL_CRYPTCALL SL_DES_EDE2_Init( void* pContext, int nDir, const void* pKey, unsigned int nKeyLen );
void			SL_CRYPTCALL SL_DES_EDE2_ProcessBlock( const void* pContext, void* pDestBlock, const void* pSrcBlock );

void			SL_CRYPTCALL SL_DESX_Init( void* pContext, int nDir, const void* pKey, unsigned int nKeyLen );
void			SL_CRYPTCALL SL_DESX_ProcessBlock( const void* pContext, void* pDestBlock, const void* pSrcBlock );


void			SL_CRYPTCALL SL_RIJNDAEL_Init( void* pContext, int nDir, const void* pKey, unsigned int nKeyLen );
void			SL_CRYPTCALL SL_RIJNDAEL_ProcessBlock( const void* pContext, void* pDestBlock, const void* pSrcBlock );

#define			SL_AES_Init			SL_RIJNDAEL_Init
#define			SL_AES_ProcessBlock	SL_RIJNDAEL_ProcessBlock

void			SL_CRYPTCALL SL_BLOWFISH_Init( void* pContext, int nDir, const void* pKey, unsigned int nKeyLen );
void			SL_CRYPTCALL SL_BLOWFISH_ProcessBlock( const void* pContext, void* pDestBlock, const void* pSrcBlock );

void			SL_CRYPTCALL SL_GOST_Init( void* pContext, int nDir, const void* pKey, unsigned int nKeyLen );
void			SL_CRYPTCALL SL_GOST_ProcessBlock( const void* pContext, void* pDestBlock, const void* pSrcBlock );

int				SL_CRYPTCALL SL_CBC_Init( void* pContext, int nDir,  const void* pIV, int bPadded );
void			SL_CRYPTCALL SL_CBC_ProcessBlock( void* pContext, void* pDestBlock, const void* pSrcBlock );
unsigned int	SL_CRYPTCALL SL_CBC_ProcessLastBlock( void* pContext, void* pDestBlock, const void* pSrcBlock, unsigned int nSize );
unsigned int	SL_CRYPTCALL SL_CBC_Process( void* pContext, void* pDest, const void* pSrc, unsigned int nSize );

int				SL_CRYPTCALL SL_CFB_Init( void* pContext, int nDir, const void* pIV, unsigned int fs );
void			SL_CRYPTCALL SL_CFB_Process( void* pContext, void* pDest, const void* pSrc, unsigned int nSize );

int				SL_CRYPTCALL SL_OFB_Init( void* pContext, const void* pIV, unsigned int fs );
void			SL_CRYPTCALL SL_OFB_Process( void* pContext, void* pDest, const void* pSrc, unsigned int nSize );

int				SL_CRYPTCALL SL_CTR_Init( void* pContext, const void* pIV );
void			SL_CRYPTCALL SL_CTR_Process( void* pContext, void* pDest, const void* pSrc, unsigned int nSize );
void			SL_CRYPTCALL SL_CTR_Seek( void* pContext, unsigned int nPos );

#ifdef __cplusplus
}

#ifdef NO_NAMESPACE

#ifndef USING_NAMESPACE
#define USING_NAMESPACE( X )
#endif

#ifndef NAMESPACE_BEGIN
#define NAMESPACE_BEGIN( X )
#endif

#ifndef NAMESPACE_END
#define NAMESPACE_END
#endif

#else

#ifndef USING_NAMESPACE
#define USING_NAMESPACE( X ) using namespace X;
#endif

#ifndef NAMESPACE_BEGIN
#define NAMESPACE_BEGIN( X ) namespace X {
#endif

#ifndef NAMESPACE_END
#define NAMESPACE_END }
#endif

#endif

NAMESPACE_BEGIN( QuickCrypt )

class CDES
{
public:
	enum { BLOCKSIZE = SLC_DES_BLOCKSIZE, DEFAULTKEYSIZE = SLC_DES_DEFAULTKEYSIZE, CONTEXTSIZE = SLC_DES_CONTEXTSIZE };
	CDES( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_DES_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	CDES( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int ){ SL_DES_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }

	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_DES_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int ){ SL_DES_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }

	void ProcessBlock( unsigned char* pDestBlock, const unsigned char* pSrcBlock ){ SL_DES_ProcessBlock( m_context, pDestBlock, pSrcBlock ); }
	void ProcessBlock( unsigned char* pBlock ){ SL_DES_ProcessBlock( m_context, pBlock, pBlock ); }
	
	void* GetContext(){ return m_context; }

	static bool CheckKeyParityBits( const unsigned char* pKey ){ return SL_DES_CheckKeyParityBits( pKey ) ? true : false; }
	static void CorrectKeyParityBits( unsigned char* pKey ){ SL_DES_CorrectKeyParityBits( pKey ); }

private:
	unsigned char m_context[ CONTEXTSIZE ];
};

class CDES_EDE3
{
public:
	enum { BLOCKSIZE = SLC_DES_EDE3_BLOCKSIZE, DEFAULTKEYSIZE = SLC_DES_EDE3_DEFAULTKEYSIZE, CONTEXTSIZE = SLC_DES_EDE3_CONTEXTSIZE };
	CDES_EDE3( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_DES_EDE3_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	CDES_EDE3( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int ){ SL_DES_EDE3_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }

	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_DES_EDE3_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int ){ SL_DES_EDE3_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }

	void ProcessBlock( unsigned char* pDestBlock, const unsigned char* pSrcBlock ){ SL_DES_EDE3_ProcessBlock( m_context, pDestBlock, pSrcBlock ); }
	void ProcessBlock( unsigned char* pBlock ){ SL_DES_EDE3_ProcessBlock( m_context, pBlock, pBlock ); }
	
	void* GetContext(){ return m_context; }

private:
	unsigned char m_context[ CONTEXTSIZE ];
};

class CDES_EDE2
{
public:
	enum { BLOCKSIZE = SLC_DES_EDE2_BLOCKSIZE, DEFAULTKEYSIZE = SLC_DES_EDE2_DEFAULTKEYSIZE, CONTEXTSIZE = SLC_DES_EDE2_CONTEXTSIZE };
	CDES_EDE2( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_DES_EDE2_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	CDES_EDE2( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int ){ SL_DES_EDE2_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }

	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_DES_EDE2_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int ){ SL_DES_EDE2_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }

	void ProcessBlock( unsigned char* pDestBlock, const unsigned char* pSrcBlock ){ SL_DES_EDE2_ProcessBlock( m_context, pDestBlock, pSrcBlock ); }
	void ProcessBlock( unsigned char* pBlock ){ SL_DES_EDE2_ProcessBlock( m_context, pBlock, pBlock ); }
	
	void* GetContext(){ return m_context; }

private:
	unsigned char m_context[ CONTEXTSIZE ];
};

class CDESX
{
public:
	enum { BLOCKSIZE = SLC_DESX_BLOCKSIZE, DEFAULTKEYSIZE = SLC_DESX_DEFAULTKEYSIZE, CONTEXTSIZE = SLC_DESX_CONTEXTSIZE };
	CDESX( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_DESX_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	CDESX( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int ){ SL_DESX_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }

	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_DESX_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int ){ SL_DESX_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }

	void ProcessBlock( unsigned char* pDestBlock, const unsigned char* pSrcBlock ){ SL_DESX_ProcessBlock( m_context, pDestBlock, pSrcBlock ); }
	void ProcessBlock( unsigned char* pBlock ){ SL_DESX_ProcessBlock( m_context, pBlock, pBlock ); }
	
	void* GetContext(){ return m_context; }

private:
	unsigned char m_context[ CONTEXTSIZE ];
};

class CRijndael
{
public:
	enum { BLOCKSIZE = SLC_RIJNDAEL_BLOCKSIZE, DEFAULTKEYSIZE = SLC_RIJNDAEL_DEFAULTKEYSIZE, CONTEXTSIZE = SLC_RIJNDAEL_CONTEXTSIZE };

	CRijndael( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_RIJNDAEL_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	CRijndael( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int nKeyLen ){ SL_RIJNDAEL_Init( m_context, dir, pKey, nKeyLen ); }

	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_RIJNDAEL_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int nKeyLen ){ SL_RIJNDAEL_Init( m_context, dir, pKey, nKeyLen ); }

	void ProcessBlock( unsigned char* pDestBlock, const unsigned char* pSrcBlock ){ SL_RIJNDAEL_ProcessBlock( m_context, pDestBlock, pSrcBlock ); }
	void ProcessBlock( unsigned char* pBlock ){ SL_RIJNDAEL_ProcessBlock( m_context, pBlock, pBlock ); }

	void* GetContext(){ return m_context; }

private:
	unsigned char m_context[ CONTEXTSIZE ];
};

typedef CRijndael CAES;

class CBlowfish
{
public:
	enum { BLOCKSIZE = SLC_BLOWFISH_BLOCKSIZE, DEFAULTKEYSIZE = SLC_BLOWFISH_DEFAULTKEYSIZE, CONTEXTSIZE = SLC_BLOWFISH_CONTEXTSIZE };

	CBlowfish( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_BLOWFISH_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	CBlowfish( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int nKeyLen ){ SL_BLOWFISH_Init( m_context, dir, pKey, nKeyLen ); }

	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_BLOWFISH_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int nKeyLen ){ SL_BLOWFISH_Init( m_context, dir, pKey, nKeyLen ); }

	void ProcessBlock( unsigned char* pDestBlock, const unsigned char* pSrcBlock ){ SL_BLOWFISH_ProcessBlock( m_context, pDestBlock, pSrcBlock ); }
	void ProcessBlock( unsigned char* pBlock ){ SL_BLOWFISH_ProcessBlock( m_context, pBlock, pBlock ); }

	void* GetContext(){ return m_context; }

private:
	unsigned char m_context[ CONTEXTSIZE ];
};

class CGOST
{
public:
	enum { BLOCKSIZE = SLC_GOST_BLOCKSIZE, DEFAULTKEYSIZE = SLC_GOST_DEFAULTKEYSIZE, CONTEXTSIZE = SLC_GOST_CONTEXTSIZE };
	CGOST( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_GOST_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	CGOST( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int ){ SL_GOST_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	
	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey ){ SL_GOST_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }
	void Init( SL_CIPHER_DIR dir, const unsigned char* pKey, unsigned int ){ SL_GOST_Init( m_context, dir, pKey, DEFAULTKEYSIZE ); }


	void ProcessBlock( unsigned char* pDestBlock, const unsigned char* pSrcBlock ){ SL_GOST_ProcessBlock( m_context, pDestBlock, pSrcBlock ); }
	void ProcessBlock( unsigned char* pBlock ){ SL_GOST_ProcessBlock( m_context, pBlock, pBlock ); }
	
	void* GetContext(){ return m_context; }

private:
	unsigned char m_context[ CONTEXTSIZE ];
};

template< class T >
class CCFBMode
{
public:

	enum{ BLOCKSIZE = T::BLOCKSIZE, DEFAULTKEYSIZE = T::DEFAULTKEYSIZE };

	CCFBMode( SL_CIPHER_DIR dir, 
		      const unsigned char* pIV, 
			  const unsigned char* pKey, 
			  unsigned int nKeyLen = DEFAULTKEYSIZE, 
			  unsigned int fs = 0 )	: m_t( SLC_ENCRYPT, pKey, nKeyLen )
	{ 
		SL_CFB_Init( m_t.GetContext(), dir, pIV, fs );
	}

	void Init( SL_CIPHER_DIR dir, const unsigned char* pIV, unsigned int fs = 0 )
	{
		SL_CFB_Init( m_t.GetContext(), dir, pIV, fs ); 
	}

	void Init( SL_CIPHER_DIR dir, 
		       const unsigned char* pIV, 
			   const unsigned char* pKey, 
			   unsigned int nKeyLen = DEFAULTKEYSIZE, 
			   unsigned int fs = 0 )
	{ 
		m_t.Init( SLC_ENCRYPT, pKey, nKeyLen );
		SL_CFB_Init( m_t.GetContext(), dir, pIV, fs ); 
	}
	
	void Process( unsigned char* pDest, const unsigned char* pSrc, unsigned int nSize ){ SL_CFB_Process( m_t.GetContext(), pDest, pSrc, nSize ); }

private:
	T m_t;
};

template< class T >
class COFBMode
{
public:
	enum{ BLOCKSIZE = T::BLOCKSIZE, DEFAULTKEYSIZE = T::DEFAULTKEYSIZE };

	COFBMode( const unsigned char* pIV, 
			  const unsigned char* pKey, 
			  unsigned int nKeyLen = DEFAULTKEYSIZE, 
			  unsigned int fs = 0 ):m_t( SLC_ENCRYPT, pKey, nKeyLen )
	{ 
		SL_OFB_Init( m_t.GetContext(), pIV, fs ); 
	}
	void Init( const unsigned char* pIV, unsigned int fs = 0 )
	{
		SL_OFB_Init( m_t.GetContext(), pIV, fs ); 
	}

	void Init( const unsigned char* pIV,
			   const unsigned char* pKey, 
			   unsigned int nKeyLen = DEFAULTKEYSIZE, 
			   unsigned int fs = 0 )
	{ 
		m_t.Init( SLC_ENCRYPT, pKey, nKeyLen );
		SL_OFB_Init( m_t.GetContext(), pIV, fs ); 
	} 
	void Process( unsigned char* pDest, const unsigned char* pSrc, unsigned int nSize ){ SL_OFB_Process( m_t.GetContext(), pDest, pSrc, nSize ); }
private:
	T m_t;
};

template < class T >
class CCounterMode
{
public:
	enum{ BLOCKSIZE = T::BLOCKSIZE, DEFAULTKEYSIZE = T::DEFAULTKEYSIZE };

	CCounterMode( const unsigned char* pIV,  
				  const unsigned char* pKey,
				  unsigned int nKeyLen = DEFAULTKEYSIZE ):m_t( SLC_ENCRYPT, pKey, nKeyLen )
	{ 
		SL_CTR_Init( m_t.GetContext(), pIV ); 
	}
	void Init( const unsigned char* pIV ){ SL_CTR_Init( m_t.GetContext(), pIV ); }
	void Init( const unsigned char* pIV,  
			   const unsigned char* pKey,
			   unsigned int nKeyLen = DEFAULTKEYSIZE )
	{ 
		m_t.Init( SLC_ENCRYPT, pKey, nKeyLen );
		SL_CTR_Init( m_t.GetContext(), pIV ); 
	}
	
	void Process( unsigned char* pDest, const unsigned char* pSrc, unsigned int nSize ){ SL_CTR_Process( m_t.GetContext(), pDest, pSrc, nSize ); }

	void Seek( unsigned int nPos ){ SL_CTR_Seek( m_t.GetContext(), nPos ); }

private:
	T m_t;
};

template < class T >
class CCBCMode
{
public:
	enum{ BLOCKSIZE = T::BLOCKSIZE, DEFAULTKEYSIZE = T::DEFAULTKEYSIZE };
	CCBCMode( SL_CIPHER_DIR dir, 
			  const unsigned char* pIV,
			  const unsigned char* pKey,
			  unsigned int nKeyLen = DEFAULTKEYSIZE,
			  bool bPadded = true ):m_t( dir, pKey, nKeyLen )
	{ 
		SL_CBC_Init( m_t.GetContext(), dir, pIV, bPadded ? 1 : 0 ); 
	}
	void Init( SL_CIPHER_DIR dir, 
			   const unsigned char* pIV,
			   const unsigned char* pKey,
			   unsigned int nKeyLen = DEFAULTKEYSIZE,
			   bool bPadded = true )
	{ 
		m_t.Init( dir, pKey, nKeyLen );
		SL_CBC_Init( m_t.GetContext(), dir, pIV, bPadded ? 1 : 0 ); 
	}

	void ProcessBlock( unsigned char* pDestBlock, const unsigned char* pSrcBlock ){ SL_CBC_ProcessBlock( m_t.GetContext(), pDestBlock, pSrcBlock ); }
	unsigned int ProcessLastBlock( unsigned char* pDestBlock, const unsigned char* pSrcBlock, unsigned int nSize ){ return SL_CBC_ProcessLastBlock( m_t.GetContext(), pDestBlock, pSrcBlock, nSize ); }
	
	unsigned int Process( unsigned char* pDest, const unsigned char* pSrc, unsigned int nSize ){ return SL_CBC_Process( m_t.GetContext(), pDest, pSrc, nSize ); }

private:
	T m_t;
};

NAMESPACE_END

#endif /* __cplusplus */


#endif//#ifndef __QUICKCRYPT_H__
