// Mp3ToWav.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h>
#include <string.h>
#include <streams.h>
#include <initguid.h>
#include "dllutil.h"
#include "dshowutil.h"
#include "resource.h"

#include <dshow.h>

#include <Qedit.h>
#include <commctrl.h>

#include <stdio.h>
#include <iostream>
using namespace std;

#include <stdlib.h>


#define INITGUID	
DEFINE_GUID(CLSID_WaveParser,
0xD51BD5A1, 0x7548, 0x11CF, 0xA5, 0x20, 0x00, 0x80, 0xC7, 0x7E, 0xF5, 0x8A);

#define INITGUID	
DEFINE_GUID(CLSID_MPEG3Decoder,
0x38BE3000, 0xDBF4, 0x11D0, 0x86, 0x0E, 0x00, 0xA0, 0x24, 0xCF, 0xEF, 0x6D);

#define INITGUID	
DEFINE_GUID(CLSID_MediaLooksQT,
0x7CE55CCC, 0x403E, 0x4A29, 0x82, 0x81, 0xBF, 0x85, 0x42, 0xA0, 0xC3, 0x7D);

#define HELPER_RELEASE(x)   if (x != NULL) \
                            { \
                                x->Release(); \
                                x = NULL; \
                            }

static const GUID CLSID_WavDest = { 0x3c78b8e2, 0x6c4d, 0x11d1, { 0xad, 0xe2, 0x0, 0x0, 0xf8, 0x75, 0x4b, 0x99 } };


IGraphBuilder *g_pGraphBuilder; 

IBaseFilter*	g_pSource=NULL;
IBaseFilter*	g_pAviSplitter=NULL;
IBaseFilter*	g_pMPEG3Decoder=NULL;
IBaseFilter *g_pSampleGrabber=NULL;
IBaseFilter *g_pWavDest;
IBaseFilter*	g_pFileWriter=NULL;

IFileSinkFilter2 *g_pSink= NULL;
IMediaControl*	g_pMediaControl;
IMediaEventEx*	g_pMediaEvent;

HINSTANCE hInstance;
HWND hWndQCBar;

IMediaSeeking *pSeek = NULL;
REFERENCE_TIME rtTotal=0;
REFERENCE_TIME rtNow=0;
HRESULT hr;
long total=0;
bool isVideoMov;

CComPtr<IPin> pOutSeeking;

class CSampleGrabberCB : public ISampleGrabberCB 
{
public:

    STDMETHODIMP_(ULONG) AddRef() { return 2; }
    STDMETHODIMP_(ULONG) Release() { return 1; }
    STDMETHODIMP QueryInterface(REFIID riid, void ** ppv)
    {
        CheckPointer(ppv,E_POINTER);
        
        if( riid == IID_ISampleGrabberCB || riid == IID_IUnknown ) 
        {
            *ppv = (void *) static_cast<ISampleGrabberCB*> ( this );
            return NOERROR;
        }    

        return E_NOINTERFACE;
    }
    
    STDMETHODIMP SampleCB( double SampleTime, IMediaSample * pSample )
    {
        return 0;
    }
    
    STDMETHODIMP BufferCB( double SampleTime, BYTE * pBuffer, long BufferSize )
    { 
        total=total+BufferSize;
		return 0;
    }
};

CSampleGrabberCB CB;


void CreateGraphAndFiltersMov(const wchar_t *wfilename,const wchar_t *wfiledestname)
{

	HRESULT hr; 
	hr = CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
    if (FAILED(hr))
    {
        return;
    }
  	
	hr=CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC,IID_IGraphBuilder,(void**)&g_pGraphBuilder);	
	if (FAILED(hr))
		return;

	g_pGraphBuilder->QueryInterface(IID_IMediaControl, (void**)&g_pMediaControl);
	g_pGraphBuilder->QueryInterface(IID_IMediaEvent, (void**)&g_pMediaEvent);

	CoCreateInstance(CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSampleGrabber);
	CoCreateInstance(CLSID_MediaLooksQT, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSource);
	CoCreateInstance(CLSID_WavDest, NULL, CLSCTX_INPROC,IID_IBaseFilter, (void **)&g_pWavDest);
	CoCreateInstance(CLSID_FileWriter, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pFileWriter);

	g_pGraphBuilder->AddSourceFilter(wfilename, L"Source Filter", &g_pSource);
	g_pGraphBuilder->AddFilter(g_pSampleGrabber,  L"Sample Grabber");
	g_pGraphBuilder->AddFilter(g_pWavDest, NULL);
	g_pGraphBuilder->AddFilter(g_pFileWriter, NULL);
	
	g_pFileWriter->QueryInterface(IID_IFileSinkFilter2, (void**)&g_pSink);
	g_pSink->SetMode(AM_FILE_OVERWRITE);
	g_pSink->SetFileName(wfiledestname, NULL);

	ISampleGrabber *pGrabber;
    g_pSampleGrabber->QueryInterface(IID_ISampleGrabber, (void**)&pGrabber);
	pGrabber->SetBufferSamples( FALSE );
	pGrabber->SetCallback(&CB,1);
}


void CreateGraphAndFiltersAvi(const wchar_t *wfilename,const wchar_t *wfiledestname)
{

	HRESULT hr; 
	hr = CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
    if (FAILED(hr))
    {
        return;
    }
  	
	hr=CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC,IID_IGraphBuilder,(void**)&g_pGraphBuilder);	
	if (FAILED(hr))
		return;

	g_pGraphBuilder->QueryInterface(IID_IMediaControl, (void**)&g_pMediaControl);
	g_pGraphBuilder->QueryInterface(IID_IMediaEvent, (void**)&g_pMediaEvent);

//2010
	CoCreateInstance(CLSID_FileSource, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSource);
	CoCreateInstance(CLSID_AviSplitter, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pAviSplitter);
	CoCreateInstance(CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSampleGrabber);
	CoCreateInstance(CLSID_MPEG3Decoder, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pMPEG3Decoder);	
	CoCreateInstance(CLSID_WavDest, NULL, CLSCTX_INPROC,IID_IBaseFilter, (void **)&g_pWavDest);
	CoCreateInstance(CLSID_FileWriter, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pFileWriter);

	g_pGraphBuilder->AddSourceFilter(wfilename, L"Source Filter", &g_pSource);
	g_pGraphBuilder->AddFilter(g_pAviSplitter, NULL);
	g_pGraphBuilder->AddFilter(g_pSampleGrabber,  L"Sample Grabber");
	g_pGraphBuilder->AddFilter(g_pMPEG3Decoder, NULL);	
	g_pGraphBuilder->AddFilter(g_pWavDest, NULL);
	g_pGraphBuilder->AddFilter(g_pFileWriter, NULL);
	
	g_pFileWriter->QueryInterface(IID_IFileSinkFilter2, (void**)&g_pSink);
	g_pSink->SetMode(AM_FILE_OVERWRITE);
	g_pSink->SetFileName(wfiledestname, NULL);

	ISampleGrabber *pGrabber;
    g_pSampleGrabber->QueryInterface(IID_ISampleGrabber, (void**)&pGrabber);
	pGrabber->SetBufferSamples( FALSE );
	pGrabber->SetCallback(&CB,1);
}



HRESULT ConnectFiltersA(IGraphBuilder *pGraph,IBaseFilter *pSou,int pinOutNum, IBaseFilter *pDest, int pinInNum)   
{
    if ((pGraph == NULL) || (pSou == NULL) || (pDest == NULL))
    {
        return E_POINTER;
    }

	HRESULT hr;

	CComPtr<IPin> pOut = GetOutPin(pSou,pinOutNum);
	CComPtr<IPin> pIn = GetInPin(pDest,pinInNum);

	hr = pGraph->Connect(pOut, pIn);

    return hr;
}


void ConnectFiltersMov()
{

	ConnectFiltersA(g_pGraphBuilder, g_pSource,1,g_pSampleGrabber,0);
	ConnectFiltersA(g_pGraphBuilder, g_pSampleGrabber,0,g_pWavDest,0);
	ConnectFiltersA(g_pGraphBuilder, g_pWavDest,0,g_pFileWriter,0);
}

void ConnectFiltersAvi()
{
	ConnectFiltersA(g_pGraphBuilder, g_pSource,0, g_pAviSplitter,0);
    ConnectFiltersA(g_pGraphBuilder, g_pAviSplitter,1, g_pSampleGrabber,0);
	ConnectFiltersA(g_pGraphBuilder, g_pSampleGrabber,0, g_pMPEG3Decoder,0);
	ConnectFiltersA(g_pGraphBuilder, g_pMPEG3Decoder,0,g_pWavDest,0);
	ConnectFiltersA(g_pGraphBuilder, g_pWavDest,0,g_pFileWriter,0);
}

void CleanUpDirectShow()
{
 
//	if(g_pMediaControl){(g_pMediaControl)->Release();(g_pMediaControl)=NULL;}
//	if(g_pMediaEvent){(g_pMediaEvent)->Release();(g_pMediaEvent)=NULL;}
//  if(g_pSink){(g_pSink)->Release();(g_pSink)=NULL;}
					
//	pOutSeeking = NULL;
//	if(pSeek){(pSeek)->Release();(pSeek)=NULL;}

    HELPER_RELEASE(g_pMediaControl);
	HELPER_RELEASE(g_pMediaEvent);
	HELPER_RELEASE(g_pSource);
	HELPER_RELEASE(g_pAviSplitter);
	HELPER_RELEASE(g_pMPEG3Decoder);
	HELPER_RELEASE(g_pWavDest);
	HELPER_RELEASE(g_pFileWriter);
	HELPER_RELEASE(g_pSink);
	HELPER_RELEASE(pSeek);
	HELPER_RELEASE(g_pGraphBuilder);
	/*
	if(g_pSource)
	{
	  g_pGraphBuilder->RemoveFilter(g_pSource);
	  g_pSource->Release();
	}
	else
	{	
	  g_pSource=NULL;
	}

	if(g_pAviSplitter)
	{
	  g_pGraphBuilder->RemoveFilter(g_pAviSplitter);
	  g_pAviSplitter->Release();
	}
	else
	{	
	  g_pAviSplitter=NULL;
	}
	
	if(g_pMPEG3Decoder)
	{
	  g_pGraphBuilder->RemoveFilter(g_pMPEG3Decoder);
	  g_pMPEG3Decoder->Release();
	}
	else
	{	
	  g_pMPEG3Decoder=NULL;
	}

	if(g_pWavDest)
	{
	  g_pGraphBuilder->RemoveFilter(g_pWavDest);
	  g_pWavDest->Release();
	}
	else
	{	
	  g_pWavDest=NULL;
	}

	if(g_pFileWriter)
	{
	  g_pGraphBuilder->RemoveFilter(g_pFileWriter);
	  g_pFileWriter->Release();
	}
	else
	{	
	  g_pFileWriter=NULL;
	}

	if(g_pGraphBuilder)
	{
	  g_pGraphBuilder->Release();
	}
	else
	{	
	  g_pGraphBuilder=NULL;
	}
    */
}

/*__declspec(dllexport) CALLBACK*/ 
long _cdecl ConvertAviToWav(const wchar_t *stringMP3, const wchar_t *stringWAV)
{

	long KBitsPSecond=320;

	long evCode,retval;  	
	long param1, param2;
    bool bComplete = false;
    bool checkitout = true;

    retval = 0;

	CoInitialize(NULL);
		
	WNDCLASSEX wndclass;
	MSG msg;

	wndclass.cbSize = sizeof(wndclass);
	wndclass.style = 0;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = DLGWINDOWEXTRA;
	wndclass.hInstance = hInstance;
	wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndclass.lpszMenuName = NULL;
	
	RegisterClassEx(&wndclass);
                                                                        
	hWndQCBar = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_QCBAR), 0, NULL);
	if (hWndQCBar!= NULL)
	{
		ShowWindow(hWndQCBar,SW_SHOW);       
	}

	if (isVideoMov){
		CreateGraphAndFiltersMov(stringMP3,stringWAV);
		ConnectFiltersMov();
	}
	else{
		CreateGraphAndFiltersAvi(stringMP3,stringWAV);
		ConnectFiltersAvi();
	}

	pOutSeeking = GetOutPin(g_pWavDest,0);
	pOutSeeking->QueryInterface(IID_IMediaSeeking, (void**)&pSeek);
	pSeek->GetDuration(&rtTotal);
	SendDlgItemMessage(hWndQCBar, IDC_PROGRESS1, PBM_SETRANGE, 0, MAKELPARAM(0, (((rtTotal/10000)* KBitsPSecond) / 8)/10000));
	SendDlgItemMessage(hWndQCBar, IDC_PROGRESS1, PBM_SETPOS, 10, 0);
	total=0;

/*	CleanUpDirectShow();
	CoUninitialize();
	ShowWindow(hWndQCBar,SW_HIDE);
	hWndQCBar = NULL;
	checkitout = false;
*/
	g_pMediaControl->Run();

    while (checkitout)
	{
		while (SUCCEEDED(g_pMediaEvent->GetEvent(&evCode, &param1, &param2, 0)))
		{
			g_pMediaEvent->FreeEventParams(evCode, param1, param2);
			switch(evCode)
			{
				case EC_USERABORT:
					::MessageBoxA(NULL,"Process was aborted by user.",NULL,0);
				    bComplete = true;
					checkitout = false;
					retval = 2;
					break;
				case EC_ERRORABORT:
				    ::MessageBoxA(NULL,"Error parsing avi file.",NULL,0);
				    bComplete = true;
					checkitout = false;
					retval = 3;
					break;
				case EC_COMPLETE:
					bComplete = true;
					checkitout = false;
					retval = 1;
					break;
			}
		}

		SendDlgItemMessage(hWndQCBar, IDC_PROGRESS1, PBM_SETPOS, total/10000, 0);
        
		if (bComplete)
		{
			g_pMediaControl->Stop(); 
			CleanUpDirectShow();
			CoUninitialize();
			ShowWindow(hWndQCBar,SW_HIDE);
			hWndQCBar = NULL;
			checkitout = false;
		}

		Sleep(300);

	}

	return retval;//(SysAllocString(stringWAV)); 	

   /*	
	CreateGraphAndFilters(stringMP3,stringWAV);
	ConnectFilters();

	g_pMediaControl->Run();
	g_pMediaEvent->WaitForCompletion(INFINITE,&evCode); 
	g_pMediaControl->Stop(); 
			
    CoUninitialize();		
	return(SysAllocString(stringWAV)); 
	*/								   
}

/*__declspec(dllexport) CALLBACK*/
long _stdcall ConvertAviToWavCall(const wchar_t *stringMP3, const wchar_t *stringWAV, long videoExt)
{
	if (videoExt==0)
		isVideoMov = true;
	else
		isVideoMov = false;
	return ConvertAviToWav(stringMP3, stringWAV);
}

BOOL APIENTRY DllMain( HINSTANCE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	switch(ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		hInstance = hModule;
		break;
	
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}



