// Mp3ToWav.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h>
#include <string.h>
#include <streams.h>
#include <initguid.h>
#include "dllutil.h"
#include "dshowutil.h"
#include "resource.h"

#include <dshow.h>

#include <Qedit.h>
#include <commctrl.h>

#include <stdio.h>
#include <iostream>
using namespace std;

#include <stdlib.h>


#define INITGUID	
DEFINE_GUID(CLSID_WaveParser,
0xD51BD5A1, 0x7548, 0x11CF, 0xA5, 0x20, 0x00, 0x80, 0xC7, 0x7E, 0xF5, 0x8A);

#define INITGUID	
DEFINE_GUID(CLSID_MPEG3Decoder,
0x38BE3000, 0xDBF4, 0x11D0, 0x86, 0x0E, 0x00, 0xA0, 0x24, 0xCF, 0xEF, 0x6D);

static const GUID CLSID_WavDest = { 0x3c78b8e2, 0x6c4d, 0x11d1, { 0xad, 0xe2, 0x0, 0x0, 0xf8, 0x75, 0x4b, 0x99 } };


IGraphBuilder *g_pGraphBuilder; 

IBaseFilter*	g_pSource=NULL;
IBaseFilter*	g_pAviSplitter=NULL;
IBaseFilter*	g_pMPEG3Decoder=NULL;
IBaseFilter *g_pSampleGrabber=NULL;
IBaseFilter *g_pWavDest;
IBaseFilter*	g_pFileWriter=NULL;

IFileSinkFilter2 *g_pSink= NULL;
IMediaControl*	g_pMediaControl;
IMediaEventEx*	g_pMediaEvent;

HINSTANCE hInstance;
HWND hWndQCBar;

IMediaSeeking *pSeek = NULL;
REFERENCE_TIME rtTotal=0;
REFERENCE_TIME rtNow=0;
HRESULT hr;
long total=0;
CComPtr<IPin> pOutSeeking;

class CSampleGrabberCB : public ISampleGrabberCB 
{
public:

    STDMETHODIMP_(ULONG) AddRef() { return 2; }
    STDMETHODIMP_(ULONG) Release() { return 1; }
    STDMETHODIMP QueryInterface(REFIID riid, void ** ppv)
    {
        CheckPointer(ppv,E_POINTER);
        
        if( riid == IID_ISampleGrabberCB || riid == IID_IUnknown ) 
        {
            *ppv = (void *) static_cast<ISampleGrabberCB*> ( this );
            return NOERROR;
        }    

        return E_NOINTERFACE;
    }
    
    STDMETHODIMP SampleCB( double SampleTime, IMediaSample * pSample )
    {
        return 0;
    }
    
    STDMETHODIMP BufferCB( double SampleTime, BYTE * pBuffer, long BufferSize )
    { 
        total=total+BufferSize;
		return 0;
    }
};

CSampleGrabberCB CB;


void CreateGraphAndFilters(const wchar_t *wfilename,const wchar_t *wfiledestname)
{
	HRESULT hr; 
	hr = CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
    if (FAILED(hr))
    {
        return;
    }
  	
	hr=CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC,IID_IGraphBuilder,(void**)&g_pGraphBuilder);	
	if (FAILED(hr))
		return;

	g_pGraphBuilder->QueryInterface(IID_IMediaControl, (void**)&g_pMediaControl);
	g_pGraphBuilder->QueryInterface(IID_IMediaEvent, (void**)&g_pMediaEvent);

	CoCreateInstance(CLSID_FileSource, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSource);
	CoCreateInstance(CLSID_AviSplitter, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pAviSplitter);
	CoCreateInstance(CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSampleGrabber);
	CoCreateInstance(CLSID_MPEG3Decoder, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pMPEG3Decoder);
	CoCreateInstance(CLSID_WavDest, NULL, CLSCTX_INPROC,IID_IBaseFilter, (void **)&g_pWavDest);
	CoCreateInstance(CLSID_FileWriter, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pFileWriter);

	g_pGraphBuilder->AddSourceFilter(wfilename, L"Source Filter", &g_pSource);
	g_pGraphBuilder->AddFilter(g_pAviSplitter, L"Avi Splitter");
	g_pGraphBuilder->AddFilter(g_pSampleGrabber,  L"Sample Grabber");
	g_pGraphBuilder->AddFilter(g_pMPEG3Decoder, L"Mp3 Decoder");
	g_pGraphBuilder->AddFilter(g_pWavDest, L"Wav Dest");
	g_pGraphBuilder->AddFilter(g_pFileWriter, L"File Writer");
	
	g_pFileWriter->QueryInterface(IID_IFileSinkFilter2, (void**)&g_pSink);
	g_pSink->SetMode(AM_FILE_OVERWRITE);
	g_pSink->SetFileName(wfiledestname, NULL);

	ISampleGrabber *pGrabber;
    g_pSampleGrabber->QueryInterface(IID_ISampleGrabber, (void**)&pGrabber);
	pGrabber->SetBufferSamples( FALSE );
	pGrabber->SetCallback(&CB,1);
}



////////////////////////////////////////////////////////////


HRESULT EnumeFilters (IFilterGraph *pGraph) 
{
    IEnumFilters *pEnum = NULL;
    IBaseFilter *pFilter;
    ULONG cFetched;


    HRESULT hr = pGraph->EnumFilters(&pEnum);
    if (FAILED(hr)) return hr;

    while(pEnum->Next(1, &pFilter, &cFetched) == S_OK)
    {
        FILTER_INFO FilterInfo;
        hr = pFilter->QueryFilterInfo(&FilterInfo);
        if (FAILED(hr))
        {
            MessageBox(NULL, TEXT("Could not get the filter info"),
                TEXT("Error"), MB_OK | MB_ICONERROR);
            continue;  // Maybe the next one will work.
        }

#ifdef UNICODE
        MessageBox(NULL, FilterInfo.achName, TEXT("Filter Name"), MB_OK);
#else
        char szName[MAX_FILTER_NAME];
        int cch = WideCharToMultiByte(CP_ACP, 0, FilterInfo.achName,
            MAX_FILTER_NAME, szName, MAX_FILTER_NAME, 0, 0);
        if (chh > 0)
            MessageBox(NULL, szName, TEXT("Filter Name"), MB_OK);
#endif

        // The FILTER_INFO structure holds a pointer to the Filter Graph
        // Manager, with a reference count that must be released.
        if (FilterInfo.pGraph != NULL)
        {
            FilterInfo.pGraph->Release();
        }
        pFilter->Release();
    }

    pEnum->Release();
    return S_OK;
}


////////////////////////////////////////////////////////////////////////////////////////////
/*
void EnumFilters(const wchar_t *wfilename,const wchar_t *wfiledestname)
{

	IEnumFilters*	EnumFilters;
	IBaseFilter*	Renderer;
	ULONG		fetched;
	FILTER_INFO *pInfo;
	bool		FoundRenderer = false;	
	
*/
  
/*	
	IBaseFilter*	Gargle;
	IEnumPins*	EnumPins;
	IPin*		InPin;	// renderer input
	IPin*		OutPin;	// decoder or other filter output;
	IPin*		GargleIn;
	IPin*		GargeOut;
	
	PIN_INFO	pinfo;
	int		numoutputpins = 0;
*/	
//	g_pGraphBuilder->RenderFile(wfilename,0);	// 'L' macro makes it WCHAR like we need it to be

/*
	g_pGraphBuilder->EnumFilters(&EnumFilters);
	EnumFilters->Reset();
	while (FoundRenderer == false)
	{
		EnumFilters->Next(1, &Renderer, &fetched);	// get next filter
		Renderer->QueryFilterInfo(pInfo);
		MessageBox(NULL,pInfo->achName,NULL,0);
	}
*/	
/*
		CLSID_AudioRender
        CLSID_DSoundRender

		COn el basefilter 


	    Renderer->EnumPins(&EnumPins);
		EnumPins->Reset();
		numoutputpins = 0;
		while (EnumPins->Next(1, &InPin, &fetched) == S_OK)
		{
			InPin->QueryPinInfo(&pinfo);
			pinfo.pFilter->Release();
			InPin->Release();
			if (pinfo.dir == PINDIR_OUTPUT)
			{
				numoutputpins++;
				break;		// we can jump out if we found an output pin
			}
			
		}
		EnumPins->Release();
		if (numoutputpins == 0)
			FoundRenderer = true;
		else
			Renderer->Release();
	}	
	EnumFilters->Release();		// Find renderer input
	Filter->EnumPins(&EnumPins);
	EnumPins->Reset();
	EnumPins->Next(1, &InPin, &fetched);	// first one is only one
	EnumPins->Release();	// Find ouput pin on filter it is connected to
	Pin->ConnectedTo(&OutPin);	// Disconnect the filters - note that we have to call Disconnect for both pins
	g_pGraphBuilder->Disconnect(InPin);
	g_pGraphBuilder->Disconnect(OutPin);
	
	// Create Gargle filter - CLSID for gargle filter is defined in garguids.h in sample source
	CoCreateInstance(CLSID_Gargle, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&Gargle);
	g_pGraphBuilder->AddFilter(Gargle, NULL);
	
	// get it's pins
	Gargle->EnumPins(&EnumPins);
	EnumPins->Reset();
	EnumPins->Next(1, &GargleIn, &fetched);
	GargleIn->QueryPinInfo(&pinfo);
	pinfo.pFilter->Release();
	if (pinfo.dir = PINDIR_OUTPUT)
	{
		GargleOut = GargleIn;		
		EnumPins->Next(1, &GargleIn, &fetched);
	}
	else
		EnumPins->Next(1, &GargleOut, &fetched);
	
	// now connect pins
	g_pGraphBuilder->Connect(OutPin, GargleIn);
	g_pGraphBuilder->Connect(GargleOut, InPin);

  */

//}

///////////////////////////////////////////////////////////////



HRESULT ConnectFiltersA(IGraphBuilder *pGraph,IBaseFilter *pSou,int pinOutNum, IBaseFilter *pDest, int pinInNum)   
{
    if ((pGraph == NULL) || (pSou == NULL) || (pDest == NULL))
    {
        return E_POINTER;
    }

	HRESULT hr;

	CComPtr<IPin> pOut = GetOutPin(pSou,pinOutNum);
	CComPtr<IPin> pIn = GetInPin(pDest,pinInNum);

	hr = pGraph->Connect(pOut, pIn);

    return hr;
}


void ConnectFilters()
{
	ConnectFiltersA(g_pGraphBuilder, g_pSource,0, g_pAviSplitter,0);
    ConnectFiltersA(g_pGraphBuilder, g_pAviSplitter,1, g_pSampleGrabber,0);
	ConnectFiltersA(g_pGraphBuilder, g_pSampleGrabber,0, g_pMPEG3Decoder,0);
	ConnectFiltersA(g_pGraphBuilder, g_pMPEG3Decoder,0,g_pWavDest,0);
	ConnectFiltersA(g_pGraphBuilder, g_pWavDest,0,g_pFileWriter,0);
}

void CleanUpDirectShow()
{
 
	if(g_pMediaControl){(g_pMediaControl)->Release();(g_pMediaControl)=NULL;}
	if(g_pMediaEvent){(g_pMediaEvent)->Release();(g_pMediaEvent)=NULL;}
    if(g_pSink){(g_pSink)->Release();(g_pSink)=NULL;}
					
	pOutSeeking = NULL;
	if(pSeek){(pSeek)->Release();(pSeek)=NULL;}

							
	if(g_pSource)
	{
	  g_pGraphBuilder->RemoveFilter(g_pSource);
	  g_pSource->Release();
	}
	else
	{	
	  g_pSource=NULL;
	}

	if(g_pAviSplitter)
	{
	  g_pGraphBuilder->RemoveFilter(g_pAviSplitter);
	  g_pAviSplitter->Release();
	}
	else
	{	
	  g_pAviSplitter=NULL;
	}
	
	if(g_pMPEG3Decoder)
	{
	  g_pGraphBuilder->RemoveFilter(g_pMPEG3Decoder);
	  g_pMPEG3Decoder->Release();
	}
	else
	{	
	  g_pMPEG3Decoder=NULL;
	}

	if(g_pWavDest)
	{
	  g_pGraphBuilder->RemoveFilter(g_pWavDest);
	  g_pWavDest->Release();
	}
	else
	{	
	  g_pWavDest=NULL;
	}

	if(g_pFileWriter)
	{
	  g_pGraphBuilder->RemoveFilter(g_pFileWriter);
	  g_pFileWriter->Release();
	}
	else
	{	
	  g_pFileWriter=NULL;
	}

	if(g_pGraphBuilder)
	{
	  g_pGraphBuilder->Release();
	}
	else
	{	
	  g_pGraphBuilder=NULL;
	}

}


void deleteChainFilters(IPin *pFirstPin, IPin *pInPin)
{
	PIN_INFO pPinInfo;
	IBaseFilter *pFilter;
	pInPin->QueryPinInfo(&pPinInfo);
	pFilter = pPinInfo.pFilter;
	if (pPinInfo.pFilter != NULL)
    {
        pPinInfo.pFilter->Release();
    }

	FILTER_INFO pfilterInfo;
	pFilter->QueryFilterInfo(&pfilterInfo); 
	MessageBox(NULL,pfilterInfo.achName ,NULL,0);
	if (pfilterInfo.pGraph != NULL)
    {
        pfilterInfo.pGraph->Release();
    }
  
	IEnumPins *EnumPins = NULL;
	IPin *pOutPin;
	IPin *pNextPin;
	ULONG ulFound;

	pFilter->EnumPins(&EnumPins);
	while(S_OK == EnumPins->Next(1, &pOutPin, &ulFound))
	{   
		PIN_DIRECTION pindir = (PIN_DIRECTION) 3;
		pOutPin->QueryDirection(&pindir);
		if(pindir == PINDIR_OUTPUT)
		{
			MessageBoxA(NULL,"cont pins out",NULL,0);
			if(pOutPin->ConnectedTo(&pNextPin)==S_OK)
			{
				deleteChainFilters(pOutPin,pNextPin);
			}
		}
	}
	EnumPins->Release();

	g_pGraphBuilder->Disconnect(pFirstPin); 
	g_pGraphBuilder->Disconnect(pInPin); 
    g_pGraphBuilder->RemoveFilter(pFilter);
}


BSTR __declspec(dllexport) CALLBACK ConvertAviToWav(const wchar_t *stringMP3, const wchar_t *stringWAV)
{

	long evCode;  	
	long param1, param2;
    bool bComplete = false;
    bool checkitout = true;

	CoInitialize(NULL);
		
	WNDCLASSEX wndclass;
	MSG msg;

	wndclass.cbSize = sizeof(wndclass);
	wndclass.style = 0;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = DLGWINDOWEXTRA;
	wndclass.hInstance = hInstance;
	wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndclass.lpszMenuName = NULL;
	
	RegisterClassEx(&wndclass);
                                                                        
	hWndQCBar = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_QCBAR), 0, NULL);
	if (hWndQCBar!= NULL)
	{
		ShowWindow(hWndQCBar,SW_SHOW);       
	}

//	CreateGraphAndFilters(stringMP3,stringWAV);
//	ConnectFilters();
///////////////////////////////////////////////////////////////////////////////		
	HRESULT hr; 
	hr = CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
   
	hr=CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC,IID_IGraphBuilder,(void**)&g_pGraphBuilder);	

	g_pGraphBuilder->RenderFile(stringMP3,0);	// 'L' macro makes it WCHAR like we need it to be

	FILTER_INFO *pInfo;
	PIN_INFO *pPinInfo;
	IPin *pPinSplitter;
	IPin *pPinN;
	IEnumFilters *EnumFilters;
	IEnumPins *EnumPins=0;
	IBaseFilter*	Renderer;
	IBaseFilter*	FileSplitter;
	ULONG		fetched, inPins, outPins, ulFound;

	//aqui el pin de salida del filtro antes del audioRenderer
/*	FindAudioRenderer(g_pGraphBuilder, &audioRenderer, &pPinBeforeRend, &pPinRend);
	g_pGraphBuilder->Disconnect(pPinBeforeRend); 
	g_pGraphBuilder->Disconnect(pPinRend); 
    g_pGraphBuilder->RemoveFilter(audioRenderer);
*/	

	IPin *pPinRend;
	IPin *pPinBeforeRend;
	IBaseFilter*	audioRenderer;
	ULONG ulOutPins,ulInPins;


	g_pGraphBuilder->EnumFilters(&EnumFilters);
	EnumFilters->Reset();
	while (EnumFilters->Next(1, &audioRenderer, &fetched)==S_OK)
	{
		CountFilterPins(audioRenderer, &ulInPins, &ulOutPins);
		if ((ulInPins == 1) && (ulOutPins == 0))
		{
			pPinRend = 0;
			pPinRend = GetInPin(audioRenderer, 0);
            AM_MEDIA_TYPE *type;
			pPinRend->ConnectionMediaType(type);
			if (type->majortype == MEDIATYPE_Audio)
			{
				pPinRend->ConnectedTo(&pPinBeforeRend);
				break;
			}
		}		
        audioRenderer->Release();
	}	
	EnumFilters->Release(); 


	g_pGraphBuilder->Disconnect(pPinBeforeRend); 
	g_pGraphBuilder->Disconnect(pPinRend); 
    g_pGraphBuilder->RemoveFilter(audioRenderer);


	g_pGraphBuilder->EnumFilters(&EnumFilters);
	EnumFilters->Reset();
	while (EnumFilters->Next(1, &FileSplitter, &fetched)==S_OK)
	{
		CountFilterPins(FileSplitter, &inPins, &outPins);		
		if (outPins==2)
		{
			hr = FileSplitter->EnumPins(&EnumPins);
			EnumPins->Reset();
			while(S_OK == EnumPins->Next(1, &pPinSplitter, &ulFound))
			{
				PIN_DIRECTION pindir = (PIN_DIRECTION) 3;
				pPinSplitter->QueryDirection(&pindir);
				if(pindir == PINDIR_OUTPUT)
				{   
					AM_MEDIA_TYPE *type;
					pPinSplitter->ConnectionMediaType(type);
					if (type->majortype == MEDIATYPE_Video)
					{
						pPinSplitter->ConnectedTo(&pPinN);
						break;
					}
				}
				pPinSplitter->Release();
			} 
			EnumPins->Release();
		}
        FileSplitter->Release();
	}	
	EnumFilters->Release(); 
	deleteChainFilters(pPinSplitter,pPinN);

    EnumeFilters(g_pGraphBuilder);

	g_pGraphBuilder->QueryInterface(IID_IMediaControl, (void**)&g_pMediaControl);
	g_pGraphBuilder->QueryInterface(IID_IMediaEvent, (void**)&g_pMediaEvent);
	
	CoCreateInstance(CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSampleGrabber);
	CoCreateInstance(CLSID_WavDest, NULL, CLSCTX_INPROC,IID_IBaseFilter, (void **)&g_pWavDest);
	CoCreateInstance(CLSID_FileWriter, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pFileWriter);

	g_pGraphBuilder->AddFilter(g_pSampleGrabber,  L"Sample Grabber");
	g_pGraphBuilder->AddFilter(g_pWavDest, L"Wav Dest");
	g_pGraphBuilder->AddFilter(g_pFileWriter, L"File Writer");
	
	ISampleGrabber *pGrabber;
    g_pSampleGrabber->QueryInterface(IID_ISampleGrabber, (void**)&pGrabber);
	pGrabber->SetBufferSamples( FALSE );
	pGrabber->SetCallback(&CB,1);
	
	g_pFileWriter->QueryInterface(IID_IFileSinkFilter2, (void**)&g_pSink);
	g_pSink->SetMode(AM_FILE_OVERWRITE);
	g_pSink->SetFileName(stringWAV, NULL);

    
//////////////////////////////////////////////////////////////////


	pOutSeeking = GetOutPin(g_pWavDest,0);
	pOutSeeking->QueryInterface(IID_IMediaSeeking, (void**)&pSeek);
	pSeek->GetDuration(&rtTotal);
	SendDlgItemMessage(hWndQCBar, IDC_PROGRESS1, PBM_SETRANGE, 0, MAKELPARAM(0, ((rtTotal / 10000000)*16000)/1000));
	SendDlgItemMessage(hWndQCBar, IDC_PROGRESS1, PBM_SETPOS, 10, 0);
	total=0;

	g_pMediaControl->Run();

    while (checkitout)
	{
		while (SUCCEEDED(g_pMediaEvent->GetEvent(&evCode, &param1, &param2, 0)))
		{
			g_pMediaEvent->FreeEventParams(evCode, param1, param2);
			switch(evCode)
			{
				case EC_USERABORT:
					::MessageBox(NULL,NULL,NULL,0);
				    bComplete = true;
					checkitout = false;
					break;
				case EC_ERRORABORT:
				    ::MessageBox(NULL,NULL,NULL,0);
				    bComplete = true;
					checkitout = false;
					break;
				case EC_COMPLETE:
					bComplete = true;
					checkitout = false;
					break;
			}
		}

		SendDlgItemMessage(hWndQCBar, IDC_PROGRESS1, PBM_SETPOS, total/1000, 0);
        
		if (bComplete)
		{
			g_pMediaControl->Stop(); 
			CleanUpDirectShow();
			CoUninitialize();
			ShowWindow(hWndQCBar,SW_HIDE);
			hWndQCBar = NULL;
			checkitout = false;
		}

		Sleep(300);

	}

	return(SysAllocString(stringWAV)); 	
								   
}


BOOL APIENTRY DllMain( HINSTANCE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	switch(ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		hInstance = hModule;
		break;
	
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}



