// CAec.cpp: implementation of the CAec class.
//
//////////////////////////////////////////////////////////////////////
//#include "Forcelib.h"
#include "stdafx.h"

//JOSNER 12/2013 quite esta puse la de abajo 
//#include "AecMfc32TimeCode.h"

#include "CAec.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#include "Aec_nttc.h"

UINT IsrThreadProc(LPVOID pParam /* CIsrThreadInfo ptr */);

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


//	Adrienne Electronics Corporation
//
//#include <windows.h>
//#include "CAec.h"	//also has "   #include "Aec_nttc.h"   "
// ********************************************************************
//CAec.cpp
CAec::CAec()	//constructor
{
	modp_settings = 0x80808080;	//only non-zero default (for 21/RDR boards).
	Set_MODP_flags();
	BrdFE = 0;		//bit 4 will hold "ISR"/Int line driving status bit. 
	ISRRun = false;
	//TODO: Add additional time to the TIMEOUT
	ComTimeout = 50;	// 50ms timeout default, Public (alterable)
	IntTimeout = 10;	// 10ms timeout if command sent under ISR conditions
	exiting = false;
	SonySetup = false;
	FoundCnt = 0;		// changed when board is found
	RegCnt = 0;			// value returned from DLL
	IntPending = false;	// default value
	Offset0 = 0;
	ISRpending = false;
	CmdPending = false;
//	OffsetIntEnables = 0x03F0;		//need different if type=4
//	OffsetIntPrePending = 0x03F2;
//	OffsetIntPending = 0x03FD;
//	OffsetIntCode = 0x03FE;
//	OffsetCommand = 0x03FF;
	selection = 0;
	Find();


	//JOSNER LAST
//	DWORD dw = GetPriorityClass(GetCurrentProcess());
//	dw = REALTIME_PRIORITY_CLASS;
//	SetPriorityClass(GetCurrentProcess(), dw);	



  /*  cfile_object.Open( "c:\\ucancode_cfile_example.txt",  CFile::modeCreate|CFile:: modeReadWrite);

	char szSampleText[100];
    strcpy(szSampleText, "Sample Text for CFile Write function Example");
    cfile_object.Write (szSampleText,sizeof(szSampleText));  
*/
}

CAec::~CAec()
{

	if (ISRRun)
	{
		//clear the IRQ interrupt enable ....
		DoISR(false);
		Sleep(50);
	}
}


// --------------------------------------------------------------------
BOOL CAec::check(int i)	//private function. i = table index (number found)
{
	// if reading one byte returns TRUE, a board is registered
	// at this address! Exit if no board is registered
	OffsetR = 0x0000;	//base address of all boards
	//OffsetW = 0x03FF;	// command input address
	TRACE("AEC_PCTC_READ_1BYTE\n");
	booltemp2 = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
	//booltemp2 = AEC_PCTC_WRITE_1BYTE	(LPBYTE,  LPWORD, LPWORD);
	CkType = 0;	//preset for no device found
	if (booltemp2)
	{
		TRACE("AEC_PCTC_CHECK_BOARD\n");
		CkType = AEC_PCTC_CHECK_BOARD (&Addr);		
		if	(CkType == 0 )  // if device is registered but does not check-out,
		{					// try sending the reset byte and try again

			// send RESET command
			OneBW = 0x02;
			//booltemp2 = AEC_PCTC_WRITE_1BYTE(&OneBW, &OffsetW, &Addr);
			TRACE("AEC_PCTC_SEND_COMMAND\n");
			booltemp2 = AEC_PCTC_SEND_COMMAND(&OneBW, &OneBR, &Addr);	//OK
			Sleep(1500);	// allow time for board to to boot
			TRACE("AEC_PCTC_CHECK_BOARD\n");
			CkType = AEC_PCTC_CHECK_BOARD (&Addr);
		}
	}
	//CkType = AEC_PCTC_CHECK_BOARD (&Addr);		
	if	(CkType != 0 )
	{
		AecBoard[i].Address = Addr;
		AecBoard[i].BrdCkType = CkType;
		booltemp2 = TRUE;
	}
	else booltemp2 = FALSE;
	return booltemp2;

}

// --------------------------------------------------------------------
BYTE CAec::Read1(WORD offset)
{
	if ((CkType == 1) && (offset > 0x0009))	//IOR (1) has only 9 byte read only memory
			offset = 0x0009;
	if ((CkType == 2) && (offset > 0x0009)) //MMR (2) has only 9 byte read only memory
		offset = 0x0009;
	if ((CkType == 3) && (offset > 0x03FF))	//ISA with DPRAM have 1k byte Read/Write memory
		offset = 0x03FF;
	if ((CkType == 4) && (offset > 0xFF)) //PCI models have 256 byte Read/Write memory, FFh not used
		offset = 0x0FE;
	if (CkType == 0)
		return 0x00;
TRACE("AEC_PCTC_READ_1BYTE\n");
	ok = AEC_PCTC_READ_1BYTE (&OneBR, &offset, &Addr);
	return OneBR;
	//return 	*(lpBrd + offset);	//if smart or MMR, read byte and return
}
// --------------------------------------------------------------------
//Make sure the address where write is going is OK
BOOL CAec::Write1(BYTE byte, WORD offset)
{

	if (CkType == 1)	//don't write to IOR (type 1)
		return FALSE;
	else if (CkType == 2)	//don't write to MMR (type 2)
		return FALSE;
	else if (CkType == 3)
	{
		if(offset > 0x03FF)
			return FALSE;		
		//ok = AEC_PCTC_WRITE_1BYTE (&byte, &offset, &Addr);
	}
	else if (CkType == 4)
	{
		if(offset > 0x0FF)
			return FALSE;
		//ok = AEC_PCTC_WRITE_1BYTE (&byte, &offset, &Addr);
	}
	else return FALSE;		//(CkType == ???)
	
	//Now write the byte at address that is "in bounds"
    intByteTrace = byte;
    stringByteTrace.Format( _T("%02X"), intByteTrace );
	stringWordTrace.Format( _T("%04X"), offset );
	TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
	ok = AEC_PCTC_WRITE_1BYTE (&byte, &offset, &Addr);
	//*(lpBrd + offset) = byte;
	return ok;
}
// --------------------------------------------------------------------
DWORD CAec::Read4()	//reads the standard default HHMMSSFF reader TIME data
{
	if (CkType != 0)
	{
		OffsetR = 0;
		if (CkType == 4)
			OffsetR = 0x10;	// The READER data is NOT at 0x00 like with
							// the other time code models
		
		TRACE("AEC_PCTC_READ_4BYTES\n");
		ok = AEC_PCTC_READ_4BYTES (&FourBR, &OffsetR, &Addr);
		return FourBR;
	}
	//return 	*((LPDWORD)lpBrd);
	//else... error value is returned
	return 0xFFFFFFFF;	//something that has no relative value????
}

// --------------------------------------------------------------------
DWORD CAec::Read4(WORD offset)
{
	if (CkType == 1)	// for IOR and MMR models the only read 4 is at 00h offset address)
			offset = 0x0000;
	if (CkType == 2)
		offset = 0x0000;
	if ((CkType == 3) && (offset > 0x03FC))
		offset = 0x03FC;
	if ((CkType == 4) && (offset > 0x0FC))
		offset = 0x00FC;
	TRACE("AEC_PCTC_READ_4BYTES\n");
	ok = AEC_PCTC_READ_4BYTES (&FourBR, &offset, &Addr);
	return FourBR;
}
// --------------------------------------------------------------------
BOOL CAec::Write4(DWORD dwDat, WORD offset)
{
	if (CkType <= 2)	//less than or equal (none, IOR & MMR)
		return FALSE;
	if (CkType == 3)	//SMART ISA
	{
		if (offset > 0x03FC)
			return FALSE;
	}
	if (CkType == 4)	//PCI
	{
		if (offset > 0x00FC)
			return FALSE;
	}
	TRACE("AEC_PCTC_WRITE_4BYTES\n");
	ok = AEC_PCTC_WRITE_4BYTES (&dwDat, &offset, &Addr);	
	return ok;
}

// --------------------------------------------------------------------
BOOL	CAec::SetComparatorTime(DWORD dwDat)	//+ write the comparator time to catch
{
	if (CkType <= 2)	//less than or equal, NOT available for these models
		return FALSE;
	else if (CkType == 3)
	{
		OffsetW = 0x0090;	//fixed address for the comparator time value input
	}
	else if (CkType == 4)
	{
		OffsetW = 0x0030;	//fixed address for the comparator time value input
	}
	else return FALSE;
	TRACE("AEC_PCTC_WRITE_4BYTES\n");
	ok = AEC_PCTC_WRITE_4BYTES (&dwDat, &OffsetW, &Addr);	
	return ok;
}

// --------------------------------------------------------------------
BYTE CAec::GetCmpStatus()
{
	//if (CkType <= 2)	//less than or equal (not available)
	//	return 0x00;
	if (CkType == 3)
	{
		//Read from offset 95h 
		OffsetW = 0x0095;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetW, &Addr);
	}
	else if (CkType == 4)	//PCI
	{
		//Read from offset 1Bh 
		OffsetW = 0x001B;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetW, &Addr);
	}
	else OneBR = 0x00;
	
	return OneBR;
}


// --------------------------------------------------------------------
BOOL	CAec::StartComparator(BYTE Onebyte)	//+ write the comparator time to catch
{
	if (CkType <= 2)	//less than or equal (not available)
		return FALSE;
	else if (CkType == 3)
	{
		OffsetW = 0x0094;

	intByteTrace = Onebyte;
    stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
	TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE (&Onebyte, &OffsetW, &Addr);
		//must set 3F0.5 (enable cmp ints) bit
		OneBR = 0x20;	//set bit 5
		OrIntEnables(OneBR);
	}
	else if (CkType == 4)	//PCI
	{
		//must set 2E.5 (enable cmp ints) bit
		OneBR = 0x20;	//set bit 5
		OrIntEnables(OneBR);
		//Read from offset 2Dh and toggle bit4.
		OffsetW = 0x002D;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetW, &Addr);
		if ((OneBR & 0x10) != 0)	//if BIT4 is currently set
			OneBR = 0x01;			//clear bit4
		else OneBR = 0x11;			//else set bit4 
intByteTrace = OneBR;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE (&OneBR, &OffsetW, &Addr);
	}
	else ok = FALSE;

	return ok;
}

// --------------------------------------------------------------------
BOOL	CAec::StopComparator()	//+ disable the comparator
{
	if (CkType <= 2)	//less than or equal
		return FALSE;
	else if (CkType == 3)
	{
		OneBR = 0x00;	//clear all compare enable "on" bits
		OffsetW = 0x0094;
	}
	else if (CkType == 4)
	{
		//clear the bit at 2E.5 (clr "enable cmp int"
		OffsetW = 0x002E;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetW, &Addr);
		OneBR = (OneBR & 0xDF);	//clr bit5
intByteTrace = OneBR;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE (&OneBR, &OffsetW, &Addr);

		OffsetW = 0x002D;
	}
	else return FALSE;
	OneBR = 0x00;
intByteTrace = OneBR;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
	ok = AEC_PCTC_WRITE_1BYTE (&OneBR, &OffsetW, &Addr);

	return ok;
}


// --------------------------------------------------------------------
WORD CAec::BrdAddr()		//address used with DLL calls
{
	return Addr;
}
// --------------------------------------------------------------------
int	CAec::BrdType()		//1=IOR,2=MMR,3=SMART,4=PCI
{
	return CkType;
}
// --------------------------------------------------------------------
BYTE CAec::BrdModel()		//offset 3EF (VLTC=50h,VITC=93h,LTC=98h)
{							//
	return Model;
}
// --------------------------------------------------------------------
BOOL CAec::ReadsLtc()
{
	return LRdr;		//True if board reads LTC
}
// --------------------------------------------------------------------
BOOL CAec::ReadsVitc()
{
	return VRdr;		//True if board reads VITC
}
// --------------------------------------------------------------------
BOOL CAec::GensLtc()
{
	return LGen;	//True if board gens LTC
}
// --------------------------------------------------------------------
BOOL CAec::GensVitc()
{
	return VGen;		//True if board gens VITC
}
// --------------------------------------------------------------------
BOOL CAec::HasSerial()
{
	return Serial;		//does board have serial option (no/yes (FALSE/TRUE)
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::HasL21()
{
	if (CkType == 4)
		return ((Read1(0x0008) & BIT2) ? TRUE : FALSE );
	else return FALSE;
		
}

// --------------------------------------------------------------------
BYTE CAec::ModelType()
{
	return ModType;	//'3'=RDR, '5'=RG1, '6'=RG2, '7'=RG3, '8'=GEN
}
// --------------------------------------------------------------------
BOOL CAec::Select(int i)	//public function
{
	BYTE Reg08 = 0;
	
	if (i >= FoundCnt)	// do not try to select a board that is not here
		return FALSE;
	selection = i;
/*
	WORD	Addr;		//Value to be used in address field when calling DLL functions
	int		CkType;		//Value from "CheckBoard (DLL)1=IOR,2=MMR,3=SMART (0 not saved)
	BYTE	Model;		//Holds data from offset 3EF (VLTC=50h,VITC=93h,LTC=98h)
	BYTE	Id0;		//Data Byte from 3E0 First letter of ID
	BYTE	Id1;		//Data Byte from 3E1 Second letter of ID
	BYTE	Id2;		//Data Byte from 3E2 Third letter of ID
	BYTE	SLtr;		//Data Byte from 3E3 Board Software Revision letter
	BYTE	SNum;		//Data Byte from 3E4 Board Software Revision number
	BYTE	VerUp;		//Data Byte from 3E5 Upper byte of EPROM version
	BYTE	VerLow;		//Data Byte from 3E6 Lower byte of EPROM version
	BOOL	Serial;		//does time code board have serial option (no/yes)
	PVOID	PhysAddr;	//value of pointer to board
*/	

	Addr = AecBoard[i].Address;
	CkType = AecBoard[i].BrdCkType;

	if (CkType == 3)
	{
		Offset3Ex = 0x03E6;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&VerLow, &Offset3Ex, &Addr);
		Offset3Ex = 0x03E5;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&VerUp, &Offset3Ex, &Addr);	
		Offset3Ex = 0x03E4;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&SNum, &Offset3Ex, &Addr);	
		Offset3Ex = 0x03E3;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&SLtr, &Offset3Ex, &Addr);	
		// read the smart board type id byte ( 0x50 VLTC, 0x93 VITC, 0x98 LTC)
		Offset3Ex = 0x03EF;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&Model, &Offset3Ex, &Addr);
		// read the board id bytes to see if this board reads tc.
		Offset3Ex = 0x03E0;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&Id0, &Offset3Ex, &Addr);
		Offset3Ex = 0x03E1;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&Id1, &Offset3Ex, &Addr);	
		Offset3Ex = 0x03E2;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&Id2, &Offset3Ex, &Addr);	

		LRdr = FALSE;		//True if board reads LTC
		LGen = FALSE;		//True if board gens LTC
		VRdr = FALSE;		//True if board reads VITC
		VGen = FALSE;		//True if board gens VITC
		//ModType;			//'3'=RDR, '5'=RG1, '6'=RG2, '7'=RG3, '8'=GEN

		if ((Id0 == 'R' ) && (Id1 == 'D' ) && (Id2 == 'R' ))
			ModType = 3;
	
		else if ((Id0 == 'R' ) && (Id1 == 'G' ) && (Id2 == '1' ))
			ModType = 5;
	
		else if ((Id0 == 'R' ) && (Id1 == 'G' ) && (Id2 == '2' ))
			ModType = 6;

		else if ((Id0 == 'R' ) && (Id1 == 'G' ) && (Id2 == '3' ))
			ModType = 7;

		else if ((Id0 == 'G' ) && (Id1 == 'E' ) && (Id2 == 'N' ))
			ModType = 8;

		else if (Id0 == 'L')
		{
			if (Id2 == 'D')
				ModType = 10;
			else if (Id2 == 'G')
				ModType = 11;
			else //(Id2 == 'N')
				ModType = 12;
		}
		else if (Id0 == 'V')
		{
			if (Id2 == 'D')
				ModType = 13;
			else if (Id2 == 'G')
				ModType = 14;
			else //(Id2 == 'N')
				ModType = 15;
		}

		else	// unknown
			ModType = 0;

	// set the ability values (LRdr, LGen, VRdr, VGen)
		switch (Model) 
		{
			case 0x50:
				switch (ModType)
				{
					case 3: //RDR
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;

						//Model specific
						autoread = 0x23;	
						autogen = 0x00;	
						ltcjam = 0x00;		
						ltcread = 0x21;	
						vitcread = 0x22;	
						ltcgen = 0x00;		
						ltcrg = 0x00;		
						vtol = 0x00;		
						vitcgen = 0x00;	
						ltov = 0x00;		
						jamgenall = 0x00;	
						jamgentb = 0x00;	
						jamgenub = 0x00;	
						genstart = 0x00;	
						genstop = 0x00;	
						break;			

					case 5:  //RG1
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;
			
						//Model specific
						autoread = 0x23;	
						autogen = 0x2C;	
						ltcjam = 0x1A;		
						ltcread = 0x21;	 
						vitcread = 0x22;	 
						ltcgen = 0x24;		 
						ltcrg = 0x25;		 
						vtol = 0x26;		 
						vitcgen = 0x28;	 
						ltov = 0x29;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;
			
					case 6:  //RG2 (RDR + LGEN)
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;
			
						//Model specific
						autoread = 0x23;	 
						autogen = 0x24;	 
						ltcjam = 0x1A;		 
						ltcread = 0x21;	 
						vitcread = 0x22;	 
						ltcgen = 0x24;		 
						ltcrg = 0x25;		 
						vtol = 0x26;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;
			
					case 7:  //RG3 (RDR+VGEN)
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;

						//Model specific
						autoread = 0x23;	 
						autogen = 0x28;	 
						ltcjam = 0x1A;		 
						ltcread = 0x21;	 
						vitcread = 0x22;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x28;	 
						ltov = 0x29;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;

					case 8:  //GEN
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;
			
						//Model specific
						autoread = 0x00;	 
						autogen = 0x2C;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x00;	 
						ltcgen = 0x24;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x28;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;
			
					case 10: //LRD
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;
			
						//Model specific
						autoread = 0x21;	 
						autogen = 0x00;	 
						ltcjam = 0x00;		 
						ltcread = 0x21;	 
						vitcread = 0x00;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x00;	 
						jamgentb = 0x00;	 
						jamgenub = 0x00;	 
						genstart = 0x00;	 
						genstop = 0x00;	 
						break;
			
					case 11: //LRG
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;
			
						//Model specific
						autoread = 0x21;	 
						autogen = 0x24;	 
						ltcjam = 0x1A;		 
						ltcread = 0x21;	 
						vitcread = 0x00;	 
						ltcgen = 0x24;		 
						ltcrg = 0x25;		 
						vtol = 0x00;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;
			
					case 12: //LGN
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;
			
						//Model specific
						autoread = 0x00;	 
						autogen = 0x24;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x00;	 
						ltcgen = 0x24;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;

					case 13: //VRD
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;

						//Model specific
						autoread = 0x22;	 
						autogen = 0x00;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x22;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x00;	 
						jamgentb = 0x00;	 
						jamgenub = 0x00;	 
						genstart = 0x00;	 
						genstop = 0x00;	 
						break;
	
					case 14: //VRG
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;
			
						//Model specific
						autoread = 0x22;	 
						autogen = 0x28;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x22;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x28;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;

					case 15: //VGN
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;

						//Model specific
						autoread = 0x00;	 
						autogen = 0x28;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x00;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x28;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;
					//default: 
				}
				break;
			
			case 0x93: //VITC
				switch (ModType)
				{
					case 3:  //RDR
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;
			
						//Model specific
						autoread = 0x10;	 
						autogen = 0x00;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x10;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x00;	 
						jamgentb = 0x00;	 
						jamgenub = 0x00;	 
						genstart = 0x00;	 
						genstop = 0x00;	 
						break;

					case 5:  //RG1
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;
			
						//Model specific
						autoread = 0x10;	 
						autogen = 0x18;	 
						ltcjam = 0x00;	
						ltcread = 0x00;	 
						vitcread = 0x10;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x18;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;

					case 8:  //GEN
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;

						//Model specific
						autoread = 0x00;	 
						autogen = 0x18;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x00;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x18;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;
					//default:
				}
				break;

			case 0x98: //LTC
				switch (ModType){
					case 3:  //RDR
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;
			
						//Model specific
						autoread = 0x10;	 
						autogen = 0x00;	 
						ltcjam = 0x00;		 
						ltcread = 0x10;	 
						vitcread = 0x00;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x00;	 
						jamgentb = 0x00;	 
						jamgenub = 0x00;	 
						genstart = 0x00;	 
						genstop = 0x00;	 
						break;

					case 5:  //RG1
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;
			
						//Model specific
						autoread = 0x10;	 
						autogen = 0x18;	 
						ltcjam = 0x1A;		 
						ltcread = 0x10;	 
						vitcread = 0x00;	 
						ltcgen = 0x18;		 
						ltcrg = 0x18;		  //*** Set other Bits ***
						vtol = 0x00;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;

					case 8:  //GEN
						//ALL
						intack = 0x00;
						reset = 0x02;
						smpte = 0x03;
						ebu = 0x04;
						idle = 0x16;

						//Model specific
						autoread = 0x00;	 
						autogen = 0x18;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x00;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x18;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;
					//default:
				}
				break;

			//default:	//no good options for default
		}

		Serial = CheckForSerial(); //BOOL yes/no Serial option
		TRACE("AEC_PCTC_GET_BOARD_POINTER\n");
		PhysAddr = AEC_PCTC_GET_BOARD_POINTER (&Addr); 
				//value of pointer (PVOID) to board
		if ((LONG)PhysAddr != 0xFFFFFFFF)
		{
			lpBrd = (LPBYTE)PhysAddr;
			pointer = TRUE;
		}
		else
		{
			pointer = FALSE;
		}

		if (ltcread != 0x00)
			LRdr = TRUE;		//True if board reads LTC
		if (ltcgen != 0x00)
			LGen = TRUE;		//True if board gens LTC
		if (vitcread != 0x00)
			VRdr = TRUE;		//True if board reads VITC
		if (vitcgen != 0x00)
			VGen = TRUE;		//True if board gens VITC

		strcpy( strId, "PC-" );
		if (Model == 0x50)
			strcat( strId, "VLTC/" );
		else if (Model == 0x93)
			strcat( strId, "VITC/" );
		else if (Model == 0x98)
			strcat( strId, "LTC/" );
		strncat( strId, (char*)&Id0, 1 );
		strncat( strId, (char*)&Id1, 1 );
		strncat( strId, (char*)&Id2, 1 );
		strcat( strId, " Rev: " );

		strncat( strId, (char*)&SLtr, 1);
		strncat( strId, (char*)&SNum, 1);
		strncat( strId, (char*)&VerUp, 1);
		strncat( strId, (char*)&VerLow, 1);
		ok = TRUE;

	}


	else if (CkType == 4)
	{
		LRdr = FALSE;		//init flags
		LGen = FALSE;		//
		VRdr = FALSE;		//
		VGen = FALSE;		//

		Offset3Ex = 0x0007;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&SNum, &Offset3Ex, &Addr);	
		Offset3Ex = 0x0006;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&SLtr, &Offset3Ex, &Addr);
		Offset3Ex = 0x0008;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &Offset3Ex, &Addr);
		Reg08 = OneBR;
		//OneBR now holds capabilities code...
		if (OneBR & 0x10)
			LRdr = TRUE;		//True if board reads LTC
		if (OneBR & 0x20)
			LGen = TRUE;		//True if board gens LTC
		if (OneBR & 0x40)
			VRdr = TRUE;		//True if board reads VITC
		if (OneBR & 0x04)
			VRdr = TRUE;		//True if board reads L21 (08.2)
		if (OneBR & 0x80)
			VGen = TRUE;		//True if board gens VITC

		if (OneBR & 0x02)		//Serial option (BIT 1)			
		{
			Serial = TRUE;
			inituart = 0x80;	// SERIAL
			initrx = 0x81;		// SERIAL
//  ?		readrx = 0x82;		// SERIAL	
//	?		txstat = 0x90;		// SERIAL 
//	?		tx422en = 0x91;		// SERIAL
//	?		tx422dis = 0x92;	// SERIAL
			readrx = 0x00;		// SERIAL	N/A
			txstat = 0x00;		// SERIAL 	N/A
			tx422en = 0x00;		// SERIAL	N/A
			tx422dis = 0x00;	// SERIAL	N/A

			txbreak = 0xA0;		// SERIAL
			txbyte = 0xA0;		// SERIAL
			txstr1 = 0xA1;		//SERIAL
			txstr2 = 0xA2;		//SERIAL
			txstr3 = 0xA3;		//SERIAL
			txstr4 = 0xA4;		//SERIAL
			txstr5 = 0xA5;		//SERIAL
			txstr6 = 0xA6;		//SERIAL
			txstr7 = 0xA7;		//SERIAL
			txstr8 = 0xA8;		//SERIAL
			txstr9 = 0xA9;		//SERIAL
			txstrA = 0xAA;		//SERIAL
			txstrB = 0xAB;		//SERIAL
			txstrC = 0xAC;		//SERIAL
			txstrD = 0xAD;		//SERIAL
			txstrE = 0xAE;		//SERIAL
			txstrF = 0xAF;		//SERIAL
		}

		else
		{
			Serial = FALSE;
			inituart = 0x00;	// SERIAL
			initrx = 0x00;		// SERIAL
			readrx = 0x00;		// SERIAL
			txstat = 0x00;		// SERIAL 
			tx422en = 0x00;		// SERIAL
			tx422dis = 0x00;	// SERIAL
			txbreak = 0x00;		// SERIAL
			txbyte = 0x00;		// SERIAL
			txstr1 = 0x00;		// SERIAL
			txstr2 = 0x00;		// SERIAL
			txstr3 = 0x00;		// SERIAL
			txstr4 = 0x00;		// SERIAL
			txstr5 = 0x00;		// SERIAL
			txstr6 = 0x00;		// SERIAL
			txstr7 = 0x00;		// SERIAL
			txstr8 = 0x00;		// SERIAL
			txstr9 = 0x00;		// SERIAL
			txstrA = 0x00;		// SERIAL
			txstrB = 0x00;		// SERIAL
			txstrC = 0x00;		// SERIAL
			txstrD = 0x00;		// SERIAL
			txstrE = 0x00;		// SERIAL
			txstrF = 0x00;		// SERIAL
		}
		//ok = CheckForSerial(); //BOOL yes/no Serial option - variables set above
		//DO NOT USE here FOR PCI, not needed as we already have the 08.1 register bit!


		//0x03E6 --> VerLow
		VerLow = ((OneBR & 0x0F) + 0x30);	//offset the SERIAL (bit1) to ASCII char 0-9
		VerUp =	OneBR;		//holds board capablilites (version) code (offset 08h)			

		if ((OneBR & 0xF0) == 0x10)			//LTC/RDR
		{
			ModType = 3;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp = '3';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x98;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = 'R';
			Id1 = 'D';
			Id2 = 'R';
			if (OneBR & 0x01)			//LTC/RDV (reader+video sync)
				Id2 = 'V';
		}

		else if ((OneBR & 0xF0) == 0x20)	//LTC/GEN
		{
			ModType = 8;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'8';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x98;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = 'G';
			Id1 = 'E';
			Id2 = 'N';
		}

		else if ((OneBR & 0xF0) == 0x30)	//LTC/RG1
		{
			ModType = 5;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'5';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x98;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = 'R';
			Id1 = 'G';
			Id2 = '1';
		}

		else if ((OneBR & 0xF0) == 0x40)	//VITC/RDR
		{
			ModType = 3;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'3';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x93;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = 'R';
			Id1 = 'D';
			Id2 = 'R';
		}

		else if ((OneBR & 0xF0) == 0x50)	//VLTC/RDR
		{
			ModType = 3;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'3';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x50;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = 'R';
			Id1 = 'D';
			Id2 = 'R';
		}

//		else if ((OneBR & 0xF0) == 0x60)	//????
//		{
//			ModType = 3;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
//			//VerUp =			//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
//			Model =	0x98;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
//			Id0 = 'R';
//			Id1 = 'R';
//			Id2 = 'R';
//		}

		else if ((OneBR & 0xF0) == 0x70)	//VLTC/RG2
		{
			ModType = 6;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'6';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x50;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = 'R';
			Id1 = 'G';
			Id2 = '2';
		}

		else if ((OneBR & 0xF0) == 0x80)	//VITC/GEN
		{
			ModType = 8;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'8';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x93;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = 'G';
			Id1 = 'E';
			Id2 = 'N';
		}

//		else if ((OneBR & 0xF0) == 0x90)	//????
//		{
//			ModType = 3;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
//			//VerUp =			//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
//			Model =	0x98;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
//			Id0 = 'R';
//			Id1 = 'R';
//			Id2 = 'R';
//		}

		else if ((OneBR & 0xF0) == 0xA0)	//VLTC/GEN
		{
			ModType = 8;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'8';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x50;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = 'G';
			Id1 = 'E';
			Id2 = 'N';
		}

//		else if ((OneBR & 0xF0) == 0xB0)	//????
//		{
//			ModType = 3;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
//			//VerUp =			//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
//			Model =	0x98;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
//			Id0 = 'R';
//			Id1 = 'R';
//			Id2 = 'R';
//		}

		else if ((OneBR & 0xF0) == 0xC0)	//VITC/RG1
		{
			ModType = 5;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'5';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x93;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = 'R';
			Id1 = 'G';
			Id2 = '1';
		}

		else if ((OneBR & 0xF0) == 0xD0)	//VLTC/RG3
		{
			ModType = 7;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'7';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x50;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = 'R';
			Id1 = 'G';
			Id2 = '3';
		}

//		else if ((OneBR & 0xF0) == 0xE0)	//????
//		{
//			ModType = 3;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
//			//VerUp =			//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
//			Model =	0x98;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
//			Id0 = 'R';
//			Id1 = 'R';
//			Id2 = 'R';
//		}


		else if ((OneBR & 0xF0) == 0xF0)		//VLTC/RG1
		{
			ModType = 5;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'5';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x50;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = 'R';
			Id1 = 'G';
			Id2 = '1';
		}

		else if ((OneBR & 0xF4) == 0x04)	//21/RDR (0x08 address has 04h)
		{
			ModType = 3;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'8';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			//Model =	0x93;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Model =	0x90;	//0x50 VLTC, 0x93 VITC, 0x98 LTC, 0x90 L21
			Id0 = 'R';
			Id1 = 'D';
			Id2 = 'R';
		}

		else	// unknown
		{
			ModType = 0;	//3=RDR, 5=RG1, 6=RG2, 7=RG3, 8=GEN
			//VerUp =	'0';		//'3'(RDR), '5'(RG1), '6'(RG2), '7'(RG3), '8'(GEN)
			Model =	0x00;	//0x50 VLTC, 0x93 VITC, 0x98 LTC
			Id0 = '?';
			Id1 = '?';
			Id2 = '?';
		}


	// set the ability values (LRdr, LGen, VRdr, VGen)
		autoall = 0x2F;		//All PCI boards can have this value
							//sent as mode control command and
							//EVERY time code mode the board has
							//will be enabled.
		//The 2xh commands work on a bit mapping to enable the
		//function/mode. The low nibble of the command has 4 bits.
		//The bits are 3:VITC GEN, 2:LTC GEN, 1:VITC READ,  0:LTC READ
		//If a command is sent in which the feature is NOT available,
		//the response will mask out the bit in the response that is NOT valid
		//for the current mode. (IE: When the 2Fh command is sent to a
		//   "PCI-LTC/RG1" (can read/gen LTC only) the reply will be 0x25h.(bits 2/0))								

		//Load and save all of the other commands that each model can handle
		switch (Model) 
		{
			case 0x50:
				//ALL
				intack = 0x00;
				reset = 0x02;
				smpte = 0x03;
				ebu = 0x04;
				idle = 0x20;

				switch (ModType)
				{
					case 3: //RDR
						//Model specific
						autoread = 0x23;	
						autogen = 0x00;	
						ltcjam = 0x00;		
						ltcread = 0x21;	
						vitcread = 0x22;	
						ltcgen = 0x00;		
						ltcrg = 0x00;		
						vtol = 0x00;		
						vitcgen = 0x00;	
						ltov = 0x00;		
						jamgenall = 0x00;	
						jamgentb = 0x00;	
						jamgenub = 0x00;	
						genstart = 0x00;	
						genstop = 0x00;	
						break;			

					case 5:  //RG1
						//Model specific
						autoread = 0x23;	
						autogen = 0x2C;	
						ltcjam = 0x1A;		
						ltcread = 0x21;	 
						vitcread = 0x22;	 
						ltcgen = 0x24;		 
						ltcrg = 0x25;		 
						vtol = 0x26;		 
						vitcgen = 0x28;	 
						ltov = 0x29;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;
			
					case 6:  //RG2 (RDR + LGEN)		
						//Model specific
						autoread = 0x23;	 
						autogen = 0x24;	 
						ltcjam = 0x1A;		 
						ltcread = 0x21;	 
						vitcread = 0x22;	 
						ltcgen = 0x24;		 
						ltcrg = 0x25;		 
						vtol = 0x26;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;
			
					case 7:  //RG3 (RDR+VGEN)
						//Model specific
						autoread = 0x23;	 
						autogen = 0x28;	 
						ltcjam = 0x1A;		 
						ltcread = 0x21;	 
						vitcread = 0x22;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x28;	 
						ltov = 0x29;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;

					case 8:  //GEN
						//Model specific
						autoread = 0x00;	 
						autogen = 0x2C;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x00;	 
						ltcgen = 0x24;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x28;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;

					//default: 
				}
				break;
			
			case 0x93: //VITC
			case 0x90: //21
				//ALL
				intack = 0x00;
				reset = 0x02;
				smpte = 0x03;
				ebu = 0x04;
				idle = 0x20;
				switch (ModType)
				{
					case 3:  //RDR
						//Model specific
						autoread = 0x22;	 
						autogen = 0x00;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x22;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x00;	 
						jamgentb = 0x00;	 
						jamgenub = 0x00;	 
						genstart = 0x00;	 
						genstop = 0x00;	 
						break;

					case 5:  //RG1
						//Model specific
						autoread = 0x22;	 
						autogen = 0x28;	 
						ltcjam = 0x1A;		//this board has reader+gen at same time	 
						ltcread = 0x00;	 
						vitcread = 0x22;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x28;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;

					case 8:  //GEN
						//Model specific
						autoread = 0x00;	 
						autogen = 0x28;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x00;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x28;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;
					//default:
				}
				break;

			case 0x98: //LTC
				//ALL
				intack = 0x00;
				reset = 0x02;
				smpte = 0x03;
				ebu = 0x04;
				idle = 0x20;

				switch (ModType){
					case 3:  //RDR
						//Model specific
						autoread = 0x21;	 
						autogen = 0x00;	 
						ltcjam = 0x00;		 
						ltcread = 0x21;	 
						vitcread = 0x00;	 
						ltcgen = 0x00;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x00;	 
						jamgentb = 0x00;	 
						jamgenub = 0x00;	 
						genstart = 0x00;	 
						genstop = 0x00;	 
						break;

					case 5:  //RG1
						//Model specific
						autoread = 0x21;	 
						autogen = 0x24;	 
						ltcjam = 0x1A;	//this board has reader+gen at same time		 
						ltcread = 0x21;	 
						vitcread = 0x00;	 
						ltcgen = 0x24;		 
						ltcrg = 0x25;		  //*** Set other Bits ***
						vtol = 0x00;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;

					case 8:  //GEN
						//Model specific
						autoread = 0x00;	 
						autogen = 0x24;	 
						ltcjam = 0x00;		 
						ltcread = 0x00;	 
						vitcread = 0x00;	 
						ltcgen = 0x24;		 
						ltcrg = 0x00;		 
						vtol = 0x00;		 
						vitcgen = 0x00;	 
						ltov = 0x00;		 
						jamgenall = 0x40;	 
						jamgentb = 0x41;	 
						jamgenub = 0x42;	 
						genstart = 0x48;	 
						genstop = 0x49;	 
						break;
					//default:
				}
				break;

			//default:	//no good options for default
		}

		//The PCI devices do NOT have "pointer" available
		//since they are IO space devices.
//		PhysAddr = AEC_PCTC_GET_BOARD_POINTER (&Addr); 
//				//value of pointer (PVOID) to board
//Make -1 to
//??		PhysAddr = 0xFFFFFFFF;
//		if ((LONG)PhysAddr != 0xFFFFFFFF)
//		{
//			lpBrd = (LPBYTE)PhysAddr;
//			pointer = TRUE;
//		}
//		else
//		{
			pointer = FALSE;
//		}
//

		strcpy( strId, "PCI-" );
		if (Model == 0x50)
		{
			if (Reg08 & 0x04)	//if L21
				strcat( strId, "21VL/" );
			else
				strcat( strId, "VLTC/" );
		}
		else if (Model == 0x93)
		{
			if (Reg08 & 0x04)	//if L21
				strcat( strId, "21V/" );
			else
				strcat( strId, "VITC/" );
		}
		else if (Model == 0x98)
		{
			if (Reg08 & 0x04)	//if L21
				strcat( strId, "21L/" );
			else
				strcat( strId, "LTC/" );
		}
		else if (Model == 0x90)
		{
			strcat( strId, "21/" );
			Model = 0x93;
		}

		strncat( strId, (char*)&Id0, 1 );
		strncat( strId, (char*)&Id1, 1 );
		strncat( strId, (char*)&Id2, 1 );

		if (Reg08 & 0x08)	//if OSD
				strcat( strId, " w/OSD" );
		if (Reg08 & 0x02)	//if Serial
				strcat( strId, " w/SERIAL" );



		strcat( strId, " Rev: " );

		strncat( strId, (char*)&SLtr, 1);
		strncat( strId, (char*)&SNum, 1);
		//VerUp holds cap. code --> convert to ascii chars
		wsprintf (str2,"%2.2X",VerUp);
		strncat( strId, str2, 2);
		//strncat( strId, (char*)&VerUp, 1);
		//strncat( strId, (char*)&VerLow, 1);
		ok = TRUE;

	}

	// must be an IOR or MMR
	else if (CkType == 2) //MMR
	{
		strcpy( strId, "PC-LTC/MMR" );
		LRdr = TRUE;		//True if board reads LTC
		Serial = FALSE;
		TRACE("AEC_PCTC_GET_BOARD_POINTER\n");
		PhysAddr = AEC_PCTC_GET_BOARD_POINTER (&Addr); 
			//value of pointer (PVOID) to board
		ok = TRUE;
	}
	else if (CkType == 1) //IOR
	{
		strcpy( strId, "PC-LTC/IOR" );
		LRdr = TRUE;		//True if board reads LTC
		Serial = FALSE;
		ok = TRUE;
	}

	else ok = FALSE;
	return (ok);
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Set any of the bits in the interrupt enable register that are set in
// the byte data that is passed into the funciton.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BOOL	CAec::OrIntEnables(BYTE byte)	
{
	if (CkType == 1)
		return FALSE;
	else if (CkType == 2)
		return FALSE;
	else if (CkType == 3)
	{
		OffsetR = 0x3F0;
	}
	else if (CkType == 4)
	{
		OffsetR = 0x02E;
	}
	else return FALSE;		//(CkType == ???)

	// Logical OR the current setting and the byte data that is passed 
TRACE("AEC_PCTC_READ_1BYTE\n");
	ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
	OneBR = ( OneBR | byte );
	//Write back the ORed byte
intByteTrace = OneBR;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetR );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
	ok = AEC_PCTC_WRITE_1BYTE (&OneBR, &OffsetR, &Addr);

	return ok;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Clear any of the bits in the interrupt enable register that are NOT set in
// the byte data that is passed into the funciton.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BOOL	CAec::AndIntEnables(BYTE byte)	
{
	if (CkType == 1)
		return FALSE;
	else if (CkType == 2)
		return FALSE;
	else if (CkType == 3)
	{
		OffsetR = 0x3F0;
	}
	else if (CkType == 4)
	{
		OffsetR = 0x02E;
	}
	else return FALSE;		//(CkType == ???)

	// Logical OR the current setting and the byte data that is passed 
TRACE("AEC_PCTC_READ_1BYTE\n");
	ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
	OneBR = ( OneBR & byte );
	//Write back the ORed byte
intByteTrace = OneBR;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetR );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
	ok = AEC_PCTC_WRITE_1BYTE (&OneBR, &OffsetR, &Addr);

	return ok;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Set any of the bits in the interrupt enable register that are set in
// the byte data that is passed into the funciton.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BYTE	CAec::GetIntEnables()			//+ get the interrupt enable flag bits 
{
	if (CkType == 1)
		return 0x01;
	else if (CkType == 2)
		return 0x01;
	else if (CkType == 3)
	{
		OffsetR = 0x3F0;
	}
	else if (CkType == 4)
	{
		OffsetR = 0x02E;
	}
	else return 0x00;		//(CkType == ???)

	// Logical OR the current setting and the byte data that is passed 
TRACE("AEC_PCTC_READ_1BYTE\n");
	ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
	return OneBR;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::PendingIntBuffered()
{
	WORD OffPend, OffEnabled;
	BYTE bPend, bEnabled;
	if (CkType == 1)
		return false;
	else if (CkType == 2)
		return false;
	else if (CkType == 3)
	{
		OffPend = 0x03F2;
		OffEnabled = 0x03F0;
	}
	else if (CkType == 4)
	{
		OffPend = 0x000E;
		OffEnabled = 0x002E;
	}
	else return false;		//(CkType == ???)

TRACE("AEC_PCTC_READ_1BYTE\n");
	ok = AEC_PCTC_READ_1BYTE (&bPend, &OffPend, &Addr);
TRACE("AEC_PCTC_READ_1BYTE\n");
	ok = AEC_PCTC_READ_1BYTE (&bEnabled, &OffEnabled, &Addr);
	bEnabled = bEnabled | 0x80;	//set bit7
	if (bPend & bEnabled)	//if something is pending that is also enabled !!!
		return true;
	else return false;
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//Read the Gen Sync sources byte
BYTE CAec::GetGenSync()
{
	if (CkType == 1)
		return FALSE;
	else if (CkType == 2)
		return FALSE;
	else if (CkType == 3)
	{
		OffsetR = 0x0048;
	}
	else if (CkType == 4)
	{
		OffsetR = 0x06A;
	}
	else return FALSE;		//(CkType == ???)

	// Logical OR the current setting and the byte data that is passed 
TRACE("AEC_PCTC_READ_1BYTE\n");
	ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
	return OneBR;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Write the BYTE to control the generator sync sources
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BOOL	CAec::SetGenSync(BYTE bByte)		//
{
	if (CkType == 1)
		return FALSE;
	else if (CkType == 2)
		return FALSE;
	else if (CkType == 3)
	{
		OffsetW = 0x0048;
	}
	else if (CkType == 4)
	{
		OffsetW = 0x06A;
	}
	else return FALSE;		//(CkType == ???)

	OneBR = bByte;
	// Logical OR the current setting and the byte data that is passed 
intByteTrace = OneBR;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
	ok = AEC_PCTC_WRITE_1BYTE (&OneBR, &OffsetW, &Addr);
	return ok;
}



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// clear the software interrupt pending flag if it is set, enable next int.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BOOL	CAec::ResetSoftwareIntFlag()	//+ clear the software interrupt pending flag if it is set, 
										// and enable next int.
{
	BYTE intcd;

	if (CkType == 1)
		return TRUE;
	else if (CkType == 2)
		return TRUE;
	else if (CkType == 3)
	{
		//OffsetR = 0x3FD;
		//ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		//if (OneBR != 0x00)
		//{
		//	OffsetR = 0x3FE;
		//	ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);	//clear int
		//	//Process this intcode!
		//
		if ((intcd = ReadIntCode()) != 0)
		{
			CProcessIntCode(intcd);
		}

		//the next few lines are handled by the ReadIntCode() above.
		//OffsetW = 0x3FD;
		//OneBR = 0x00;
		//ok = AEC_PCTC_WRITE_1BYTE (&OneBR, &OffsetW, &Addr);
		if (!ISRRun)
		{
			OffsetW = 0x3FF;
			OneBR = 0x00;
intByteTrace = OneBR;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
			ok = AEC_PCTC_WRITE_1BYTE (&OneBR, &OffsetW, &Addr);
		}
		
	}

	//For the PCI cards, if the int flag (FE.0 has been set by the on board
	//micro and cleared by some read action at 0Fh, then the board will need
	//to have a 00h value written to 2Fh to enable further operations of the
	//interrupt notification. This means that the flag will NOT be set again
	//if it had been set and the byte at 0Fh was read, but the "enable next"
	//action of writing 00h to offset address 2Fh was never completed, the
	//board would be in a "lock up" mode. The entire process must be completed
	//for each event! It is safe to write a 00h value to 2Fh offset to make
	//sure that no "lock up" is in process.
	else if (CkType == 4)
	{
		//OffsetR = 0x0FE;
		//ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		//if ((OneBR & 0x01)!= 0x00)	//if bit0 is '1')
		//{
		//	OffsetR = 0x0F;
		//	ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);	//read INTCODE/clear flag
		//	//process data depending upon this value or data could be
		//	//lost!  wait for NOT BUSY?   SRXTX
		//}
		if ((intcd = ReadIntCode()) != 0)
		{
			CProcessIntCode(intcd);
		}
		if (!ISRRun)	//do NOT allow this to occur if using ISR. The ISR "next_int"
						//does this.
		{
			OffsetW = 0x2F;
			OneBW = 0x00;
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
			ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); //enable next int.
		}
		else ok = TRUE;
		
	}
	else return FALSE;		

	return ok;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// clear the software interrupt pending flag if it is set, enable next int.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BOOL	CAec::ResetSoftwareIntFlag(BOOL doit)	//+ clear the software interrupt pending flag if it is set, 
										// and enable next int.
{
	BYTE intcd;

	if (CkType == 1)
		return TRUE;
	else if (CkType == 2)
		return TRUE;
	else if (CkType == 3)
	{
		//OffsetR = 0x3FD;
		//ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		//if (OneBR != 0x00)
		//{
		//	OffsetR = 0x3FE;
		//	ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);	//clear int
		//	//Process this intcode!
		//
		if (doit)
		{
			if ((intcd = ReadIntCode()) != 0)
			{
				CProcessIntCode(intcd);
			}
		}

		//the next few lines are handled by the ReadIntCode() above.
		//OffsetW = 0x3FD;
		//OneBR = 0x00;
		//ok = AEC_PCTC_WRITE_1BYTE (&OneBR, &OffsetW, &Addr);
		if (!ISRRun)
		{
			OffsetW = 0x3FF;
			OneBR = 0x00;
intByteTrace = OneBR;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
			ok = AEC_PCTC_WRITE_1BYTE (&OneBR, &OffsetW, &Addr);
		}
		
	}

	//For the PCI cards, if the int flag (FE.0 has been set by the on board
	//micro and cleared by some read action at 0Fh, then the board will need
	//to have a 00h value written to 2Fh to enable further operations of the
	//interrupt notification. This means that the flag will NOT be set again
	//if it had been set and the byte at 0Fh was read, but the "enable next"
	//action of writing 00h to offset address 2Fh was never completed, the
	//board would be in a "lock up" mode. The entire process must be completed
	//for each event! It is safe to write a 00h value to 2Fh offset to make
	//sure that no "lock up" is in process.
	else if (CkType == 4)
	{
		//OffsetR = 0x0FE;
		//ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		//if ((OneBR & 0x01)!= 0x00)	//if bit0 is '1')
		//{
		//	OffsetR = 0x0F;
		//	ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);	//read INTCODE/clear flag
		//	//process data depending upon this value or data could be
		//	//lost!  wait for NOT BUSY?   SRXTX
		//}
		if (doit)	//keeps code from being called in nested loop back upon itself
		{
			if ((intcd = ReadIntCode()) != 0)
			{
				CProcessIntCode(intcd);
			}
		}
		if (!ISRRun)	//do NOT allow this to occur if using ISR. The ISR "next_int"
						//does this.
		{
			OffsetW = 0x2F;
			OneBW = 0x00;
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
			ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); //enable next int.
		}
		else ok = TRUE;
		
	}
	else ok = FALSE;		

	return ok;
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Read the software interrupt pending flag 
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BYTE	CAec::GetSoftwareIntFlagAtBit0()		//+ read the flag that notifies of software interrupt pending
{
	if (CkType == 1)
	{
		OffsetR = 0x004;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		if ((OneBR & 0x80) != 0) //see if bit 7 is set
			return 0x01;
		else return 0x00;
	}
	else if (CkType == 2)
	{
		OffsetR = 0x004;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		if ((OneBR & 0x80) != 0) //see if bit 7 is set
			return 0x01;
		else return 0x00;
	}
	else if (CkType == 3)
	{
		OffsetR = 0x3FD;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		return OneBR;
	}
	else if (CkType == 4)
	{
		OffsetR = 0x0FE;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		return OneBR;
	}
	else return 0x00;		//(CkType == ???)

	//return ok;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Set the "BrdFE" bit 4 to '1'/TRUE, '0'/FALSE.
// This will not do much if you are using the PCI boards, as
// this will be overwritten at every call to 'ReadIntCode' below.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BOOL	CAec::SetISRinUse(BOOL bit)
{
	if (bit)
		BrdFE = (BYTE)0x10;
	else
		BrdFE = (BYTE)0x00;
	ISRRun = bit;
	return TRUE;

}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BYTE CAec::ReadIntCodeISR()
{
	if (CkType == 1)
	{
		OffsetR = 0x004;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		if ((OneBR & 0x80) != 0) //see if bit 7 is set
			return 0x13;			//pass back a FAKE value for IOR to match smart/pci "READ" code
		else return 0x00;
	}
	else if (CkType == 2)
	{
		OffsetR = 0x004;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		if ((OneBR & 0x80) != 0) //see if bit 7 is set
			return 0x13;			//pass back a FAKE value for MMR to match smart/pci "READ" code
		else return 0x00;
	}
	else if (CkType == 3)
	{
		OffsetR = 0x03FD;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		if (OneBR != 0x00)
		{
			// BrdFE = OneBR;	//Save for status of busy/ISR enabled ....
			// You will need to add method to set this value for use with
			//  ISA boards WHEN there is ISR application use!
			// The value should be set to 0x10 (set bit4, which means that
			// ISR is in use!
			//clear the "3FD" flag here as it is NOT cleared automatically


			OffsetR = 0x3FE;
TRACE("AEC_PCTC_READ_1BYTE\n");
			ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);

			OffsetW = 0x3FD;
			OneBW = 0x00;
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
			ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr);
			return OneBR;
		}
		else return 0x00;
	}
	else if (CkType == 4)
	{
		OffsetR = 0x0FE;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		BrdFE = OneBR;	//Save for status of busy/(int/ISR) drive enabled ....
		if (BrdFE & 0x10)	//Keep the "ISRRun" status up to date
			ISRRun = TRUE;
		else ISRRun = FALSE;
		if (!ISRRun)
		{
			if ((OneBR & 0x01) != 0x00)
			{
				OffsetR = 0x00F;
TRACE("AEC_PCTC_READ_1BYTE\n");
				ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
				return OneBR;
			}
			else return 0x00;
		}
		else return 0x00;
	}
	else return 0x00;		//(CkType == ???)

}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Read the software interrupt CODE and return (if pending) 
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BYTE	CAec::ReadIntCode()				//+ Read the interrupt code at register (fake for IOR/MMR)
{
	if (ISRpending)
		Sleep(300);
	
	if (CkType == 1)
	{
		OffsetR = 0x004;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		if ((OneBR & 0x80) != 0) //see if bit 7 is set
			return 0x13;			//pass back a FAKE value for IOR to match smart/pci "READ" code
		else return 0x00;
	}
	else if (CkType == 2)
	{
		OffsetR = 0x004;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		if ((OneBR & 0x80) != 0) //see if bit 7 is set
			return 0x13;			//pass back a FAKE value for MMR to match smart/pci "READ" code
		else return 0x00;
	}
	else if (CkType == 3)
	{
		OffsetR = 0x03FD;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		if (OneBR != 0x00)
		{
			// BrdFE = OneBR;	//Save for status of busy/ISR enabled ....
			// You will need to add method to set this value for use with
			//  ISA boards WHEN there is ISR application use!
			// The value should be set to 0x10 (set bit4, which means that
			// ISR is in use!
			//clear the "3FD" flag here as it is NOT cleared automatically


			OffsetR = 0x3FE;
TRACE("AEC_PCTC_READ_1BYTE\n");
			ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);

			OffsetW = 0x3FD;
			OneBW = 0x00;
intByteTrace = OneBR;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
			ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr);
			return OneBR;
		}
		else return 0x00;
	}
	else if (CkType == 4)
	{
		OffsetR = 0x0FE;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		BrdFE = OneBR;	//Save for status of busy/(int/ISR) drive enabled ....
		if (BrdFE & 0x10)	//Keep the "ISRRun" status up to date
			ISRRun = TRUE;
		else ISRRun = FALSE;
		if (!ISRRun)
		{
			if ((OneBR & 0x01) != 0x00)
			{
				OffsetR = 0x00F;
TRACE("AEC_PCTC_READ_1BYTE\n");
				ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
				return OneBR;
			}
			else return 0x00;
		}
		else return 0x00;
	}
	else return 0x00;
}



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
DWORD	CAec::GetTimeRead()	//+ reads Seleted time bits
{
	if ((CkType == 1) || (CkType == 2) || (CkType == 3) || (CkType == 4))
	{
		TRACE("AEC_PCTC_READ_TB\n");
		ok = AEC_PCTC_READ_TB (&FourBR, &Addr);
		FourBR = FourBR & 0x3F7F7F3F;	//mask embedded bits if present
		return FourBR;
	}
	else return 0xFFFFFFFF;		//(CkType == ???)
}



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
DWORD	CAec::GetUserRead()	//+ reads Selected user bits
{
	if ((CkType == 1) || (CkType == 2) || (CkType == 3) || (CkType == 4))
	{
		TRACE("AEC_PCTC_READ_UB\n");
		ok = AEC_PCTC_READ_UB (&FourBR, &Addr);
		return FourBR;
	}
	else return 0xFFFFFFFF;		//(CkType == ???)
}



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BYTE	CAec::GetEBRead()				//+ reads Selected embedded bits
{
	if ((CkType == 1) || (CkType == 2))
	{
		TRACE("AEC_PCTC_READ_TBE\n");
		ok = AEC_PCTC_READ_TBE (&FourBR, &Addr);
		OneBR = 0x00;	//init
		if ((FourBR & 0x00000040) != 0x00000000)	//0.6--> bit7
			OneBR = (OneBR | 0x80);
		if ((FourBR & 0x00000080) != 0x00000000)	//0.7--> bit6
			OneBR = (OneBR | 0x40);
		if ((FourBR & 0x00008000) != 0x00000000)	//1.7--> bit3
			OneBR = (OneBR | 0x08);
		if ((FourBR & 0x00800000) != 0x00000000)	//2.7--> bit0
			OneBR = (OneBR | 0x01);
		if ((FourBR & 0x40000000) != 0x00000000)	//3.6--> bit1
			OneBR = (OneBR | 0x02);
		if ((FourBR & 0x80000000) != 0x00000000)	//3.7--> bit2
			OneBR = (OneBR | 0x04);
		//pack the EB bits into a byte and pass back
		return OneBR;
	}
	else if (CkType == 3)
	{
		OffsetR = 0x000C;
		if (Model == 0x50)
			OffsetR = 0x0008;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		return OneBR;
	}
	else if (CkType == 4)
	{
		OffsetR = 0x018;
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		return OneBR;
	}
	else return 0x00;		//(CkType == ???)
}



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get the time code Generator TIME
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
DWORD	CAec::GetTimeGen()				//+ reads Gen. time bits
{
	if ((CkType == 1) || (CkType == 2))
	{
		return 0xFFFFFFFF;
	}
	else if (CkType == 3)
	{
		OffsetR = 0x0050;	//60=user
		TRACE("AEC_PCTC_READ_4BYTES\n");
		ok = AEC_PCTC_READ_4BYTES (&FourBR, &OffsetR, &Addr);
		FourBR = FourBR & 0x3F7F7F3F;	//mask embedded bits if present
		return FourBR;
	}
	else if (CkType == 4)
	{
		OffsetR = 0x0040;	//44=user
		TRACE("AEC_PCTC_READ_4BYTES\n");
		ok = AEC_PCTC_READ_4BYTES (&FourBR, &OffsetR, &Addr);
		FourBR = FourBR & 0x3F7F7F3F;	//mask embedded bits if present
		return FourBR;
	}
	else return 0xFFFFFFFF;		//(CkType == ???)
}



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get the time code Generator USER
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
DWORD	CAec::GetUserGen()				//+ reads Gen. user bits
{
	if ((CkType == 1) || (CkType == 2))
	{
		return 0xFFFFFFFF;
	}
	else if (CkType == 3)
	{
		OffsetR = 0x0060;				//
		TRACE("AEC_PCTC_READ_4BYTES\n");
		ok = AEC_PCTC_READ_4BYTES (&FourBR, &OffsetR, &Addr);
		return FourBR;
	}
	else if (CkType == 4)
	{
		OffsetR = 0x0044;  //
		TRACE("AEC_PCTC_READ_4BYTES\n");
		ok = AEC_PCTC_READ_4BYTES (&FourBR, &OffsetR, &Addr);
		return FourBR;
	}
	else return 0xFFFFFFFF;				//(CkType == ???)
}



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get the Generator EB bits
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BYTE	CAec::GetEBGen()					//+ reads Gen. Embedded bits
{
	if ((CkType == 1) || (CkType == 2))
	{
		return 0x00;
	}
	else if (CkType == 3)
	{
		OffsetR = 0x004C;				//
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		return OneBR;
	}
	else if (CkType == 4)
	{
		OffsetR = 0x0048;				//
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);
		return OneBR;
	}
	else return 0x00;				//(CkType == ???)
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Checks for 'Serial' option on Smart&PCI Boards by analyzing the return code
// from sending a 'serial' option specific command to a Smart time code
// board. The return code will be a '0xF0' if no serial option is present.
// If the serial option is present, the return code should be the same as
// the command.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BOOL	CAec::CheckForSerial()
{

			inituart = 0x00;	// SERIAL
			initrx = 0x00;		// SERIAL
			readrx = 0x00;		// SERIAL
			txstat = 0x00;		// SERIAL 
			tx422en = 0x00;		// SERIAL
			tx422dis = 0x00;	// SERIAL
			txbreak = 0x00;		// SERIAL
			txbyte = 0x00;		// SERIAL
			txstr1 = 0x00;		//SERIAL
			txstr2 = 0x00;		//SERIAL
			txstr3 = 0x00;		//SERIAL
			txstr4 = 0x00;		//SERIAL
			txstr5 = 0x00;		//SERIAL
			txstr6 = 0x00;		//SERIAL
			txstr7 = 0x00;		//SERIAL
			txstr8 = 0x00;		//SERIAL
			txstr9 = 0x00;		//SERIAL
			txstrA = 0x00;		//SERIAL
			txstrB = 0x00;		//SERIAL
			txstrC = 0x00;		//SERIAL
			txstrD = 0x00;		//SERIAL
			txstrE = 0x00;		//SERIAL
			txstrF = 0x00;		//SERIAL

	if (CkType == 4)
	{

		//if register 8.1 is set, then SERIAL is installed
		OffsetR = 0x0008;				//
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE (&OneBR, &OffsetR, &Addr);

		ok2 = FALSE;
		if (OneBR & 0x02)	//check bit 1 
		{
			ok2 = TRUE;
			inituart = 0x80;	// SERIAL	
			initrx = 0x81;		// SERIAL
//			readrx = 0x82;		// SERIAL
//			txstat = 0x90;		// SERIAL 
//			tx422en = 0x91;		// SERIAL
//			tx422dis = 0x92;	// SERIAL
//nochange	readrx = 0x00;		// SERIAL	n/a
//		"	txstat = 0x00;		// SERIAL 	n/a
//		"	tx422en = 0x00;		// SERIAL	n/a
//		"	tx422dis = 0x00;	// SERIAL	n/a

			txbreak = 0xA0;		// SERIAL
			txbyte = 0xA0;		// SERIAL
			txstr1 = 0xA1;		//SERIAL
			txstr2 = 0xA2;		//SERIAL
			txstr3 = 0xA3;		//SERIAL
			txstr4 = 0xA4;		//SERIAL
			txstr5 = 0xA5;		//SERIAL
			txstr6 = 0xA6;		//SERIAL
			txstr7 = 0xA7;		//SERIAL
			txstr8 = 0xA8;		//SERIAL
			txstr9 = 0xA9;		//SERIAL
			txstrA = 0xAA;		//SERIAL
			txstrB = 0xAB;		//SERIAL
			txstrC = 0xAC;		//SERIAL
			txstrD = 0xAD;		//SERIAL
			txstrE = 0xAE;		//SERIAL
			txstrF = 0xAF;		//SERIAL
		}
	}

	else if (CkType == 3)
	{
		OneBW = 0x80; // Initialize the UART & data buffers
		//ok = AEC_PCTC_SEND_COMMAND(&OneBW, &OneBR, &Addr);
		ok2 = SendCom(OneBW);
		//ok2 = (OneBW == OneBR);	// see if return value is same!
		//if ((OneBR == 0xF0) || (OneBR == 0xF1))
		//	ok2 = FALSE;

		//OneBW = 0xA0; // transmit the 'txdata' byte
		//ok = AEC_PCTC_SEND_COMMAND(&OneBW, &OneBR, &Addr);
		//ok2 = ((OneBW == OneBR) && ok2);	//
		//if (OneBR == 0xF0)
		//	ok2 = FALSE;
		if (ok2)
		{
			inituart = 0x80;	// SERIAL
			initrx = 0x81;		// SERIAL
			readrx = 0x82;		// SERIAL
			txstat = 0x90;		// SERIAL 
			tx422en = 0x91;		// SERIAL
			tx422dis = 0x92;	// SERIAL
			txbreak = 0x93;		// SERIAL
			txbyte = 0xA0;		// SERIAL
			txstr1 = 0xA1;		//SERIAL
			txstr2 = 0xA2;		//SERIAL
			txstr3 = 0xA3;		//SERIAL
			txstr4 = 0xA4;		//SERIAL
			txstr5 = 0xA5;		//SERIAL
			txstr6 = 0xA6;		//SERIAL
			txstr7 = 0xA7;		//SERIAL
			txstr8 = 0xA8;		//SERIAL
			txstr9 = 0xA9;		//SERIAL
			txstrA = 0xAA;		//SERIAL
			txstrB = 0xAB;		//SERIAL
			txstrC = 0xAC;		//SERIAL
			txstrD = 0xAD;		//SERIAL
			txstrE = 0xAE;		//SERIAL
			txstrF = 0xAF;		//SERIAL
		}
	}

	else 
		(ok2 = FALSE);

	return (ok2);

}


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Call the 'Check_board' function for each of the possible addresses
//	that a time code board could be at and then store the board Type and
//	determine if the board has reading ability (some Smart boards are
//	generate only).  
// Returns the number of boards that where found.
//
//	PC-LTC/IOR BOARDS HAVE STANDARD ADDRESS JUMPER SETTINGS OF...
//	(port mapped)	200h, 220h, 280h, 2A0h, 300, 320h, 380h, & 3A0h
//	PC-LTC/MMR ... C0(00)h, C4(00)h, C8(00)h, CC(00)h, D0(00)h, D4(00)h
//	(memory mapped)		D8(00)h, & DC(00)h.
//	PC-LTC/(RDR, GEN, RG1) & ALL PC-VITC/XXX & ALL PC-VLTC/XXX HAVE
//		ADDRESS... CC00h, CD00h, CE00h, CF00h, DC00h, DD00h, DE00h, & DF00h
// The 'actual' address that the memory mapped boards are 'physically' 
//	mapped to is four bits higher than the jumper's lable. 
//	(ie: CC00 -> CC000h address
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//save the address and type of each board that is found in a structure
//default is to 'Select(0)' as default
void CAec::Find(void)
{

	FoundCnt = 0;
	TRACE("AEC_PCTC_GET_NUMBER_OF_DEVICES\n");
	RegCnt = AEC_PCTC_GET_NUMBER_OF_DEVICES ();	// returns number of boards registered.
	if (RegCnt == 0)
		return;	// no sense in going on if the DLL does not find any boards registered


//look for PCI return value at the possible memory map addresses

	Addr = 0x1000;			//PCI
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0x1100;			//PCI
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0x1200;			//PCI
	if (check(FoundCnt))
		FoundCnt++;

//look for MMR/Smart return value at the possible memory map addresses

	Addr = 0xC000;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xC400;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xC800;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xCC00;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xD000;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xD400;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xD800;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xDC00;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xCD00;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xCE00;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xCF00;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xDD00;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xDE00;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0xDF00;
	if (check(FoundCnt))
		FoundCnt++;

//look for and IOR return value at the possible IOR addresses
	Addr = 0x200;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0x220;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0x280;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0x2A0;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0x300;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0x320;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0x380;
	if (check(FoundCnt))
		FoundCnt++;
	Addr = 0x3A0;
	if (check(FoundCnt))
		FoundCnt++;

	if (FoundCnt != 0)
		//Select(0);	// save the first board found as currently Selected (0 based array_
		Select(selection);	// save the first board found as currently Selected
						//selection is set to '0' in CAec() constructor
		
	return;
	
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
int CAec::GetCountFound()	//
{	
	  return FoundCnt;
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
int CAec::GetCountRegistered()	//
{	
	  return RegCnt;
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::AutoRead() //autoread
{

	if ((CkType == 4) && (autoread != 0))	//PCI
	{
		//check status to see if currently in reader mode (ALL)
		//if read ltc and vitc, make sure both status bits are set
		//if the bits are not set, write the 'autoread' byte to 2F

		//Read byte from 0x0D
		//OneBR = *(lpBrd + 0x3E8);
		OffsetR = 0x000D;	//base address of PCI Board operating mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		if (!ok)
			return FALSE;

		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x03))	//vltc
			ok = TRUE;

		else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x02)) //vitc
			ok = TRUE;

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x01)) //ltc
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(autoread)) && ( i < 1  ))
				i++;
		}
	}

	else if ((CkType == 3) && (autoread != 0))
	{
		//check status to see if currently in reader mode (ALL)
		//if read ltc and vitc, make sure both status bits are set
		//if the bits are not set, write the 'autoread' byte to 3FF

		OneBR = *(lpBrd + 0x3E8);
		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x03))	//vltc
			ok = TRUE;

		else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x02)) //vitc
			ok = TRUE;

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x01)) //ltc
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(autoread)) && ( i < 1  ))
				i++;
		}
	}
	else if ((CkType == 2) || (CkType == 1))
		ok = TRUE;
	else ok = FALSE;
	return (ok);

}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::AutoGen() //autogen
{
	
	if ((CkType == 4) && (autogen != 0))	//PCI
	{
		//check status to see if currently in reader mode (ALL)
		//if read ltc and vitc, make sure both status bits are set
		//if the bits are not set, write the 'autoread' byte to 3FF

		//Read byte from 0x0D
		OffsetR = 0x000D;	//base address of PCI Board operating mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		if (!ok)
			return FALSE;

		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x0C))	//vltc
			ok = TRUE;

		else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x08)) //vitc
			ok = TRUE;

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x04)) //ltc
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(autogen)) && ( i < 1  ))
				i++;
		}
	}

	else if ((CkType == 3) && (autogen != 0))
	{

		OneBR = *(lpBrd + 0x3E8);
		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x0C))	//vltc
			ok = TRUE;

		else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x08)) //vitc
			ok = TRUE;

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x04)) //ltc
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(autogen)) && ( i < 1  ))
				i++;
		}
	}
	else ok = FALSE;
	return (ok);

}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::GenModeStat() //gen mode status check
{
	//check status to see if currently in gen mode 
	//if gen ltc or vitc, make sure both status bits are set
	if (CkType == 3)
	{
		if ((*(lpBrd + 0x3E8) & 0x0C) != 0x00)	//
			return TRUE;
		else return FALSE;
	}	
	else if (CkType == 4)
	{
		OffsetR = 0x000D;	//base address of PCI Board operating mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		if ((OneBR & 0x0C) != 0x00)	//
			return TRUE;
		else return FALSE;
	}
	else return FALSE;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::LJam()	//ltcjam	jam reader to generator "one time"	
	//was LJam() prior, but PCI boards can also jam to both VITCandLTCgen outputs
{

	if ((CkType == 3) && (ltcjam != 0))
	{

		i = 0;
		while (!(ok = SendCom(ltcjam)) && ( i < 1  ))
			i++;
	}

	//comes here is there is a PCI board with READER+GENERATOR
	if ((CkType == 4) && (ltcjam != 0))	//Set 6A.3 to jam reader data to
										//the generator continuously, and
										//send "ltcjam command "1Ah" to
										//do a one time jam.
	{	
		i = 0;
		while (!(ok = SendCom(ltcjam)) && ( i < 1  ))
			i++;
	}
	else ok = FALSE;
	return (ok);
	

}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::LReadMode() //ltcread
{
		//check status to see if currently in reader mode (LTC)
		//if read ltc and vitc, make sure only LTC status bit is set
		//if the bit is not set, write the 'ltcread' byte to 3FF
	if ((CkType == 3) && (ltcread != 0))
	{
		OneBR = *(lpBrd + 0x3E8);
		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x01))	//vltc
			ok = TRUE;

		//else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x02)) //vitc
		//	ok = TRUE;

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x01)) //ltc
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(ltcread)) && ( i < 1  ))
				i++;
		}
	}
	else if ((CkType == 4) && (ltcread != 0))
	{
		OffsetR = 0x000D;	//base address of PCI Board operating mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x01))	//vltc
			ok = TRUE;

		//else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x02)) //vitc
		//	ok = TRUE;

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x01)) //ltc
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(ltcread)) && ( i < 1  ))
				i++;
		}
	}
	else if ((CkType == 2) || (CkType == 1))
		ok = TRUE;
	else ok = FALSE;
	return (ok);
	

}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::VReadMode() //vitcread
{
		//check status to see if currently in reader mode (VITC)
		//if read ltc and vitc, make sure only vitc status bit is set
		//if the bit is not set, write the 'vitcread' byte to 3FF

	if ((CkType == 3) && (vitcread != 0))
	{
		OneBR = *(lpBrd + 0x3E8);
		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x02))	//vltc
			ok = TRUE;

		else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x02)) //vitc
			ok = TRUE;

		//else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x01)) //ltc
		//	ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(vitcread)) && ( i < 1  ))
				i++;
		}
	}
	else if ((CkType == 4) && (vitcread != 0))
	{
		OffsetR = 0x000D;	//base address of PCI Board operating mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x02))	//vltc
			ok = TRUE;

		else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x02)) //vitc
			ok = TRUE;

		//else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x01)) //ltc
		//	ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(vitcread)) && ( i < 1  ))
				i++;
		}
	}
	else ok = FALSE;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::LGenMode() //ltcgen
{
		//check status to see if currently in gen mode (LTC)
		//if read ltc and vitc, make sure only ltc status bit is set
		//if the bit is not set, write the 'ltcgen' byte to 3FF

	if ((CkType == 3) && (ltcgen != 0))
	{
		OneBR = *(lpBrd + 0x3E8);
		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x04))	//vltc
			ok = TRUE;

		//else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x04)) //vitc
		//	ok = TRUE;

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x04)) //ltc
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(ltcgen)) && ( i < 1  ))
				i++;
		}
	}
	else if ((CkType == 4) && (ltcgen != 0))
	{
		OffsetR = 0x000D;	//base address of PCI Board operating mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x04))	//vltc
			ok = TRUE;

		//else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x04)) //vitc
		//	ok = TRUE;

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x04)) //ltc
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(ltcgen)) && ( i < 1  ))
				i++;
		}
	}
	else ok = FALSE;
	return (ok);
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::LRnGMode() //ltcrg
{
		//check status to see if currently in reader/gen mode (LTC)
		//if read and gen ltc, make sure only LTC status bits are set
		//if the bit is not set, write the 'ltcrg' byte to 3FF

	if ((CkType == 3) && (ltcrg != 0))
	{
		OneBR = *(lpBrd + 0x3E8);
		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x05))	//vltc
			ok = TRUE;

		//else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x04)) //vitc
		//	ok = TRUE;	// ltcrg is 0 if VITC board

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x05)) //ltc
			ok = TRUE;
		
		else
		{
			if (Model == 0x98)
			{
				OneBR = *(lpBrd + 0x045);
				*(lpBrd + 0x045) = (OneBR | 0x01);	//only alter bit0
			}
			i = 0;
			while (!(ok = SendCom(ltcrg)) && ( i < 1  ))
				i++;
		}
	}
	else if ((CkType == 4) && (ltcrg != 0))
	{
		OffsetR = 0x000D;	//base address of PCI Board operating mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		if ((OneBR & 0x0F) == 0x05)	//vltc
			ok = TRUE;	
		else
		{
			i = 0;
			while (!(ok = SendCom(ltcrg)) && ( i < 1  ))
				i++;
		}
	}
	else ok = FALSE;
	return (ok);
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::VtoLMode() //vtol
{
	if ((CkType == 3) && (Model == 0x50) && (vtol != 0))
	{
		BYTE d;
			/*
			write 19h to offset 48h
			load generator default data
			send MODE command
			send RUN command
			*/
		if (!Idle())
			d =bDbug;
		Write1(0x19, 0x0048);	//force continuous jamming, Synced to video
		Write4(0x00000000, 0x0060);	//defualt time
		Write4(0x00000000, 0x0064);	//default user

		i = 0;
		while (!(ok = SendCom(vtol)) && ( i < 1  ))
			i++;
		i = 0;
		while (!(ok = SendCom(jamgenall)) && ( i < 1  ))
			i++;
		i = 0;
		while (!(ok = SendCom(genstart)) && ( i < 1  ))
			i++;
	}

	else if ((CkType == 4) && (Model == 0x50) && (vtol != 0))
	{	//Set 6A.3 bit then send the command
		OffsetR = 0x006A;	//base address of gen sync mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		OneBR = OneBR | 0x08;	//set bit 3 (jam reader data)(continuously)
intByteTrace = OneBR;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetR );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE(&OneBR,  &OffsetR, &Addr);
		i = 0;
		while (!(ok = SendCom(vtol)) && ( i < 1  ))
			i++;
		i = 0;
		while (!(ok = SendCom(genstart)) && ( i < 1  ))
			i++;
	}
	else ok = FALSE;
	return (ok);
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::VGenMode() //vitcgen
{
		//check status to see if currently in gen mode (VITC)
		//make sure only VITC status bit is set
		//if the bit is not set, write the 'vitcgen' byte to 3FF

	if ((CkType == 3) && (vitcgen != 0))
	{
		OneBR = *(lpBrd + 0x3E8);
		if ((Model == 0x50) && ((OneBR & 0x0F) == 0x08))	//vltc
			ok = TRUE;

		else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x08)) //vitc
			ok = TRUE;
		//else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x05)) //ltc
		//	ok = TRUE;		
		else
		{
			i = 0;
			while (!(ok = SendCom(vitcgen)) && ( i < 1  ))
				i++;
		}
	}
	if ((CkType == 4) && (vitcgen != 0))
	{
		//check status to see if currently in gen mode (VITC)
		//make sure only VITC status bit is set
		//if the bit is not set, write the 'vitcgen' byte to 3FF

		OffsetR = 0x000D;	//base address of PCI Board operating mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		if ((OneBR & 0x0F) == 0x08)	
			ok = TRUE;		
		else
		{
			i = 0;
			while (!(ok = SendCom(vitcgen)) && ( i < 1  ))
				i++;
		}
	}
	else ok = FALSE;
	return (ok);
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::LtoVMode() //ltov
{
	BYTE d;
	if ((CkType == 3) && (Model == 0x50) && (ltov != 0))
	{
	/*
	write 19h to offset 48h
	load generator default data
	send MODE command
	send RUN command
	*/
		if (!Idle())
			d =bDbug;
		Write1(0x19, 0x0048);	//force continuous jamming
		Write4(0x00000000, 0x0040);	//defualt time
		Write4(0x00000000, 0x0060);	//default user

		i = 0;
		while (!(ok = SendCom(ltov)) && ( i < 1  ))
			i++;
		if (!ok)
			d =bDbug;
		i = 0;
		while (!(ok = SendCom(jamgenall)) && ( i < 1  ))
			i++;
		if (!ok)
			d =bDbug;

		i = 0;
		while (!(ok = SendCom(genstart)) && ( i < 1  ))
			i++;
		if (!ok)
			d =bDbug;

	}

	else if ((CkType == 4) && (ltov != 0))
	{	//Set 6A.3 bit then send the command
		OffsetR = 0x006A;	//base address of gen sync mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		OneBR = OneBR | 0x08;	//set bit 3 (jam reader data)
intByteTrace = OneBR;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetR );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE(&OneBR,  &OffsetR, &Addr);
		i = 0;
		while (!(ok = SendCom(ltov)) && ( i < 1  ))
			i++;
		i = 0;
		while (!(ok = SendCom(genstart)) && ( i < 1  ))
			i++;
	}


	else ok = FALSE;
	return (ok);
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BYTE CAec::GetGenModeControl()
{
	BYTE b;
	if (CkType == 3)
		b = Read1(0x0045);
	else if (CkType == 4)
		b = Read1(0x0069);
	else b = 0;
	return b;

}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
void CAec::SetGenModeControl(BYTE b)
{
	if (CkType == 3)
		Write1(b, 0x0045);
	else if (CkType == 4)
		Write1(b, 0x0069);
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// TODO: Add function to allow parameter to be passed
//jam the time and user data into the generator
BOOL CAec::JamTU() //jamgenall
{
/*	if ((CkType == 3) && (jamgenall != 0))
	{
		i = 0;
		while (!(ok = SendCom(jamgenall)) && ( i < 1  ))
			i++;
	}
	else if ((CkType == 4) && (jamgenall != 0))
	{
		i = 0;
		while (!(ok = SendCom(jamgenall)) && ( i < 1  ))
			i++;
	}
*/
	if (jamgenall != 0)
	{
		i = 0;
		while (!(ok = SendCom(jamgenall)) && ( i < 1  ))
			i++;
	}

	else ok = FALSE;
	return (ok);

}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//If TRUE, write the DWORD to the Time/User/Embedded bit input register(s)
BOOL CAec::WriteGenTUE(BOOL bt, DWORD tb, BOOL bu, DWORD ub, BOOL be, BYTE eb)
{
	if (CkType == 3)	//ISA
	{
		if (bt)	//write TB input data 0x40
			Write4(tb, 0x0040);
		if (bu)	//write UB input data 0x60
			Write4(ub, 0x0060);
		if (be)	//wrtie EB input data 0x4C
			Write1(eb, 0x004C);
	}
	else// if (CkType == 4) //PCI
	{
		if (bt)	//write TB input data 0x60
			Write4(tb, 0x0060);
		if (bu)	//write UB input data 0x64
			Write4(ub, 0x0064);
		if (be)	//wrtie EB input data 0x68
			Write1(eb, 0x0068);
	}

	ok = ((ltcgen || vitcgen) ? TRUE : FALSE );	//if has VITC or LTC gen TRUE
	return (ok);
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// TODO: Add function to allow parameter to be passed
//jam the time data into the generator
BOOL CAec::JamTB() //jamgentb
{
/*	if ((CkType == 3) && (jamgentb != 0))
	{
		i = 0;
		while (!(ok = SendCom(jamgentb)) && ( i < 1  ))
			i++;
	}
	else if ((CkType == 4) && (jamgentb != 0))
	{
		i = 0;
		while (!(ok = SendCom(jamgentb)) && ( i < 1  ))
			i++;
	}
*/
	if (jamgentb != 0)
	{
		i = 0;
		while (!(ok = SendCom(jamgentb)) && ( i < 1  ))
			i++;
	}
	else ok = FALSE;
	return (ok);
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// TODO: Add function to allow parameter to be passed
//jam the user data into the generator
BOOL CAec::JamUB() //jamgenub
{
/*	if ((CkType == 3) && (jamgenub != 0))
	{
		i = 0;
		while (!(ok = SendCom(jamgenub)) && ( i < 1  ))
			i++;
	}
	else if ((CkType == 4) && (jamgenub != 0))
	{
		i = 0;
		while (!(ok = SendCom(jamgenub)) && ( i < 1  ))
			i++;
	}
*/

	if (jamgenub != 0)
	{
		i = 0;
		while (!(ok = SendCom(jamgenub)) && ( i < 1  ))
			i++;
	}
	else ok = FALSE;
	return (ok);	
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::JamEB()
{
	i=0;
	if ((CkType == 3) && (jamgenall != 0))
	{
		while (!(ok = SendCom(jamgenall)) && ( i < 1  ))
			i++;
	}
	else if ((CkType == 4) && (jamgenall != 0))
	{
		//while (!(ok = SendCom(jamgenall)) && ( i < 1  ))
		while (!(ok = SendCom(0x43)) && ( i < 1  ))
			i++;
	}

	else ok = FALSE;
	return (ok);
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Start() //genstart
{
		//check status to see if currently in gen mode (any)
		//if gen ltc or vitc bits are set, do not change,
		//if a gen bit is not set, write the 'autogen' byte to 3FF

	if ((CkType == 3) && (genstart != 0))
	{
		OneBR = *(lpBrd + 0x3E8);
		if ((Model == 0x50) && (((OneBR & 0x0C) == 0x08) || 
		  ((OneBR & 0x0C) == 0x04) || ((OneBR & 0x0C) == 0x0C)))	//vltc
			ok = TRUE;

		else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x08)) //vitc
			ok = TRUE;

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x04)) //ltc
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(autogen)) && ( i < 1  ))
				i++;
		}

		i = 0;
		if (ok)
		{
			while (!(ok = SendCom(genstart)) && ( i < 1  ))	// start
				i++;
		}
	}
	else if ((CkType == 4) && (genstart != 0))
	{
		OffsetR = 0x000D;	//base address of PCI Board operating mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		if ((OneBR & 0x0C) != 0)
			ok = TRUE;

		else
		{
			i = 0;
			while (!(ok = SendCom(autogen)) && ( i < 1  ))
				i++;
		}

		if (ok)
		{
			i = 0;
			while (!(ok = SendCom(genstart)) && ( i < 1  ))	// start
				i++;
		}

	}
	else ok = FALSE;
	return (ok);	

}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Start(DWORD tb) //genstart
{
		//check status to see if currently in gen mode (any)
		//if gen ltc or vitc bits are set, do not change,
		//if a gen bit is not set, write the 'autogen' byte to 3FF


	//JOSNER LAST Comente todo esto
	/*
	if ((CkType == 3) && (genstart != 0))
	{

		OneBR = *(lpBrd + 0x3E8);
		if ((Model == 0x50) && (((OneBR & 0x0C) == 0x08) || 
		  ((OneBR & 0x0C) == 0x04) || ((OneBR & 0x0C) == 0x0C)))	//vltc
			ok = TRUE;

		else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x08)) //vitc
			ok = TRUE;

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x04)) //ltc
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(autogen)) && ( i < 1  ))
				i++;
		}

		*((LPDWORD)(lpBrd + 0x040)) = tb;	// write time data to gen input
		i = 0;
		while (!(ok = SendCom(jamgentb)) && ( i < 1  ))	// jam time
			i++;		
		
		if (ok)
			{
				i = 0;
				while (!(ok = SendCom(genstart)) && ( i < 1  ))	// start
					i++;
			}
	}
	else if ((CkType == 4) && (genstart != 0))
	{
	*/
		//check status to see if currently in gen mode (any)
		//if gen ltc or vitc bits are set, do not change,
		//if a gen bit is not set, send the 'autogen' byte command

		//JOSNER LAST DECLARE ESTO
		int i;
		BOOL ok;
	
		/*
		WORD OffsetRW;
		BYTE bId;
		BYTE bCom, bRet;
		DWORD dwIE;
*/
		printDebugStr( "\nStartGen:\n");
	
		OffsetR = 0x000D;	//base address of PCI Board operating mode info
		//TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		if ((OneBR & 0x0C) != 0){
			ok = TRUE;
			printDebugStr( "\nok = TRUE\n");
		}
		else
		{
			i = 0;
			printDebugStr( "\nSendCom(autogen) bf\n");
			while (!(ok = SendCom(autogen)) && ( i < 5  )){
				printDebugStr( "\nSendCom(autogen)\n");
				i++;
			}
		}
	

		int j=0;

		
		OffsetW = 0x0060;
		//		TRACE("AEC_PCTC_WRITE_4BYTES\n");
		ok = AEC_PCTC_WRITE_4BYTES (&tb, &OffsetW, &Addr); // write time data to gen input
		

		bool startReset = TRUE;
		i = 0;
		printDebugStr( "\nSendCom(jamgentb) bf\n");
		while (!(ok = SendCom(jamgentb)) && ( i < 10  )){	// jam time
			printDebugStr( "\nSendCom(jamgentb)\n");
			i++;
			if ((i>6) && startReset){

				printDebugStr( "\nstartReset\n");
				/////////////////////////////////
				SendCom(0x49);
				SendCom(0x4D); //PCI
				SendCom(0x4A); //PCI

				//DoISR(false);
				//SendCom(0x5B);	// will generate an int (PCI ok, NAK reply for ISA)
						//Choose any Command wanted ie: 0x5B = MDOP status
				//DoISR(true);

				//////JOSNER UNLOAD CARD//////////
				closeAdrienne();
				/////JOSNER RELOAD CARD///////////
				initAdrienne();

				j = 0;
				while (!(ok = SendCom(autogen)) && ( j < 5  )){
					printDebugStr( "\nSendCom(autogen) 2\n");
					j++;
				}
				ok = AEC_PCTC_WRITE_4BYTES (&tb, &OffsetW, &Addr); // write time data to gen input
				startReset = FALSE;
			}
		}
		
		
		if (ok)
		{
			i = 0;
			printDebugStr( "\nSendCom(genstart) bf\n");
			while (!(ok = SendCom(genstart)) && ( i < 10  )){	// start
				printDebugStr( "\nSendCom(genstart)\n");
				i++;
				if ((i>6) && startReset){
					j = 0;
					while (!(ok = SendCom(autogen)) && ( j < 5  )){
						printDebugStr( "\nSendCom(autogen) 2\n");
						j++;
					}
					ok = AEC_PCTC_WRITE_4BYTES (&tb, &OffsetW, &Addr); // write time data to gen input
					j = 0;
					while (!(ok = SendCom(jamgentb)) && ( j < 5  )){	// jam time
						printDebugStr( "\nSendCom(jamgentb) 2\n");
						j++;		
					}
					startReset = FALSE;
				}
			}
		}




/*
	}
	else ok = FALSE;
*/
	
	return (ok);	
	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Start(DWORD tb, DWORD ub) //genstart
{
	


	if ((CkType == 3) && (genstart != 0))
	{
		//check status to see if currently in gen mode (any)
		//if gen ltc or vitc bits are set, do not change,
		//if a gen bit is not set, write the 'autogen' byte to 3FF

		OneBR = *(lpBrd + 0x3E8);
		if ((Model == 0x50) && (((OneBR & 0x0F) == 0x08) || 
		  ((OneBR & 0x0F) == 0x04) || ((OneBR & 0x0F) == 0x0C)))	//vltc
			ok = TRUE;

		else if ((Model == 0x93) && ((OneBR & 0x0F) == 0x08)) //vitc
			ok = TRUE;

		else if ((Model == 0x98) && ((OneBR & 0x0F) == 0x04)) //ltc
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(autogen)) && ( i < 1  ))
				i++;
		}

		*((LPDWORD)(lpBrd + 0x040)) = tb;	// write time data to gen input
		*((LPDWORD)(lpBrd + 0x060)) = ub;	// write user data to gen input
		i = 0;
		while (!(ok = SendCom(jamgenall)) && ( i < 1  ))	// jam time/user
			i++;		
		i = 0;
		if (ok)
			{
				while (!(ok = SendCom(genstart)) && ( i < 1  ))	// start
					i++;
			}
	}
	else if ((CkType == 4) && (genstart != 0))
	{
		//check status to see if currently in gen mode (any)
		//if gen ltc or vitc bits are set, do not change,
		//if a gen bit is not set, send the 'autogen' byte command

		OffsetR = 0x000D;	//base address of PCI Board operating mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		if ((OneBR & 0x0C) != 0)
			ok = TRUE;
		
		else
		{
			i = 0;
			while (!(ok = SendCom(autogen)) && ( i < 1  ))
				i++;
		}
		OffsetW = 0x0060;
		TRACE("AEC_PCTC_WRITE_4BYTES\n");
		ok = AEC_PCTC_WRITE_4BYTES (&tb, &OffsetW, &Addr); // write time data to gen input
		OffsetW = 0x0064;
		TRACE("AEC_PCTC_WRITE_4BYTES\n");
		ok = AEC_PCTC_WRITE_4BYTES (&ub, &OffsetW, &Addr); // write time data to gen input

		i = 0;
		while (!(ok = SendCom(jamgenall)) && ( i < 1  ))	// jam time
			i++;		
		
		if (ok)
			{
				i = 0;
				while (!(ok = SendCom(genstart)) && ( i < 1  ))	// start
					i++;
			}
	}
	else ok = FALSE;
	return (ok);		

}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::StopGen() //genstop
{
/*	if ((CkType == 3) && (genstop != 0))
	{
		i = 0;
		while (!(ok = SendCom(genstop)) && ( i < 1  ))
			i++;
	}
	else if ((CkType == 4) && (genstop != 0))
	{
		i = 0;
		while (!(ok = SendCom(genstop)) && ( i < 1  ))
			i++;
	}
*/

	BOOL ok;
	int i;

	printDebugStr( "\nStopGen:\n");

	if (genstop != 0)
	{
		i = 0;

		printDebugStr( "\nSendCom(genstop) bf:\n");
		while (!(ok = SendCom(genstop)) && ( i < 5  )){
			printDebugStr( "\nSendCom(genstop):\n");
			i++;
		}
	}
	else
	{ 
		printDebugStr( "\nok = FALSE\n");
		ok = FALSE;
	}

	return (ok);		

}


void CAec::initAdrienne()
{
	BOOL ok;
	WORD OffsetRW;
	BYTE bId;
	BYTE bCom, bRet;
	DWORD dwIE;
	 	//disable INTERRUPT enable		
	dwIE = 0x00000000;
	OffsetRW = 0xFC;
	ok = AEC_PCTC_WRITE_4BYTES (&dwIE, &OffsetRW, &Addr);

	//disable all automatic interrupts (Read/Gen/field...)
	//Clear all bits at 2Eh
	bId = 0x00;
	OffsetRW = 0x2E;
	ok = AEC_PCTC_WRITE_1BYTE (&bId, &OffsetRW, &Addr);

	//This can be done now or later with reference to
	// setting up the board to be ready for ISR/interrupt
	// handling/generation

	//Start the Generator and the Reader to run
	//simultaneously. 
	bCom = 0x2F; // dual reader mode command vltc board
	ok = AEC_PCTC_SEND_COMMAND(&bCom, &bRet, &Addr);				

	Sleep(50);	// not technically required, but not a bad
			// idea to make sure that all signals
			// have some time to sync.

	//if (AecBoard[Cnt].GeneratorAvailable == TRUE)
	//{
	bCom = 0xB; // If Genavailable, start it!
	ok = AEC_PCTC_SEND_COMMAND(&bCom, &bRet, &Addr);
	//}

	Sleep(50);

	//Get Board to generate an interrupt (software only) now.
	//This will leave the interrpt pending!
	bId = 0xFF;	//Dummy "command" value, to cause interrupt 
			// response at 0Fh.
	OffsetRW = 0x2F;
	ok = AEC_PCTC_WRITE_1BYTE (&bId, &OffsetRW, &Addr);

	Sleep(25);	//allow time for the board to process the
				//"command" and write ACK/NAK to 0x0F

	//Clear the interrpt. This will leave the board waiting
	// for a write of a 0x00 value to 0x2F offset that will
	// re-enable the NEXT interrupt. The Writing of 0x00 to
	// 0x2F offset is done BY the ISR upon entry into the
	// ISR call ('NextInt'). This allows the ISR to NOT MISS ANY INTS
	// or allow any Interrupts that are NOT ready to be handled!!!!!
	// Read the interrupt response at 0Fh and throw it away. I know
	// that this is an invalid/error response. 
	// This read should technically not be done until after verifing
	// that there is an "interrupt pending" by reading at FEh bit 0.
	// It is quite safe to do this (at 0Fh) but add the verification
	// read to check at FE.0 before is you want to be more sure.
	// you can even loop on waiting for this bit to set once you
	// write the value FFh to offset 2Fh. Be sure not to have a
	// loop that will run forever.
	//bId = 0x00;
	OffsetRW = 0x0F;
	ok = AEC_PCTC_READ_1BYTE (&bId, &OffsetRW, &Addr);


	// This operation can be done NOW or later. It does
	// not mater, and this operation can be changed
	// to meet any specific requirements that your
	// software may have. The reason that it does NOT
	// matter is that nothing will happen until AFTER\
	// a 00h value is written to offset 2Fh (by entry
	// into 'NextInt' call).
	//enable all automatic interrupts (Read/Gen/field)
	bId = 0x07;
	OffsetRW = 0x2E;
	ok = AEC_PCTC_WRITE_1BYTE (&bId, &OffsetRW, &Addr);

	//This is very IMPORTANT to be done NOW. This is the
	// KEY that UNLOCKS the IRQ assertion. This operation
	// will result in bit FE.4 being set, and then when
	// and interrupt occurs, bit FE.1 will be '1' until
	// the ISR reads the interrupt code from offset 0Fh.
	//enable INTERRUPT enable		
	dwIE = 0x00000010;
	OffsetRW = 0xFC;
	ok = AEC_PCTC_WRITE_4BYTES (&dwIE, &OffsetRW, &Addr);
	//At this point, when the "next" interrupt is ENABLED
	// by writing a 00h value byte to offset 2Fh, if and when
	// and interrupt event occurs, it will generate an IRQ.
	// The AEC_NTTC.DLL call AEC_PCTC_ISR_1 does this AFTER
	// if has prepared the OS to handle the interrupt vector.
	// When the call returns, it passes the interrupt ID code
	// to the application for processing. See "TcISR1" below.
	// The direct driver call "NextInt" also does the same
	// thing as "TcISR1"...

	///////////////////////////////////////////////////////
}


void CAec::closeAdrienne()
{
	BOOL ok;
	WORD OffsetRW;
	BYTE bId;
	DWORD dwIE;

	bId = 0xF0;
	OffsetRW = 0x2F;
	ok = AEC_PCTC_WRITE_1BYTE (&bId, &OffsetRW, &Addr);

	Sleep(25);	//ALLOW TIME FOR BOARD TO RESPOND BEFORE
	//CLEARING THE ENABLES!
	//Clear the interrupt enable
	//This will STOP the board from asserting any more IRQs.
	dwIE = 0x00000000;
	OffsetRW = 0xFC;
	ok = AEC_PCTC_WRITE_4BYTES (&dwIE, &OffsetRW, &Addr);

	//NOT required upon exit but can be done!
	//clear all int ENABLE flags
	//			bId = 0x00;
	//			OffsetRW = 0x2E;
	//			ok = AEC_PCTC_WRITE_1BYTE (&bId, &OffsetRW, &Addr);

	//Read (do second half of command) from command response port
	//bId = 0x20;
	OffsetRW = 0x0F;
	ok = AEC_PCTC_READ_1BYTE (&bId, &OffsetRW, &Addr);
	Sleep(1);
	bId = 0x00;
	OffsetRW = 0x2F;
	ok = AEC_PCTC_WRITE_1BYTE (&bId, &OffsetRW, &Addr);

	bId = 0x00;			//disable interrupt "enable" flags bits
	OffsetRW = 0x2E;
	ok = AEC_PCTC_WRITE_1BYTE (&bId, &OffsetRW, &Addr);
}


void CAec::printDebugStr(char* debstr)
{

	 Sleep(2);
	 //fprintf(traceDecryptPlayer, debstr);
	 Sleep(2);

}

void CAec::initTraceFile()
{
	char szProgramFilename[100];
	char *lpszName;
	char szFullPathProgram[999];
	char *szPathProgram;
	int lenFullPathProgram;
	char szTempStringConcat[100];
	lenFullPathProgram = 0;
	szPathProgram = "";
	GetModuleFileNameA(NULL, szProgramFilename, sizeof(szProgramFilename)); 
	szFullPathProgram[0] = 0;
	GetFullPathNameA(szProgramFilename, sizeof(szFullPathProgram), szFullPathProgram, &lpszName);
	lenFullPathProgram = strlen(szFullPathProgram);
	szTempStringConcat[0] = 0;
	szPathProgram = strncat(szTempStringConcat, szFullPathProgram, lenFullPathProgram - 14/*strlen(szProgramFilename)*/);//CAMBIAR ESTO SEGUN SISTEMA 13:QC, 15:trans, 14:dubstation
	strcat(szPathProgram, "traceAdrienneTC.txt");  
	//traceDecryptPlayer = fopen(szPathProgram, "a");
}


void CAec::closeTraceFile()
{
	//fclose(traceDecryptPlayer);
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::ResetBrd() //reset
{
	if (CkType == 3)
	{
		//i = 0;
		//while (!(ok = SendCom(reset)) && ( i < 1  ))
		//	i++;
		ok = SendCom(reset);	//Does NOT get a RETURN response!
		ok = TRUE;
	}
	else if (CkType == 4)
	{
		ok = SendCom(reset);	//Does NOT get a RETURN response!
		ok = TRUE;
	}
	else ok = FALSE;
	return (ok);		
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::EnableNext() //intack
//Writes a 00h to 3FDh (ISA) or 2Fh (PCI)
{
	if (CkType == 3)
	{
		//i = 0;
		//while (!(ok = SendCom(intack)) && ( i < 1  ))
		//	i++;
		ok = SendCom(intack);	//Does NOT get a RETURN response!
		ok = TRUE;
	}
	else if (CkType == 4)
	{
		ok = SendCom(intack);	//Does NOT get a RETURN response!
		ok = TRUE;
	}
	else ok = FALSE;
	return (ok);
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Smpte() //smpte
{
	if (CkType == 3)
	{
		i = 0;
		while (!(ok = SendCom(smpte)) && ( i < 1  ))
			i++;
	}
	else if (CkType == 4)
	{
		i = 0;
		while (!(ok = SendCom(smpte)) && ( i < 1  ))
			i++;
	}
	else ok = FALSE;
	return (ok);
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Ebu() //ebu
{
	if (CkType == 3)
	{
		i = 0;
		while (!(ok = SendCom(ebu)) && ( i < 1  ))
			i++;
	}
	else if (CkType == 4)
	{
		i = 0;
		while (!(ok = SendCom(ebu)) && ( i < 1  ))
			i++;
	}
	else ok = FALSE;
	return (ok);
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//put board into Film/HD/24fps mode (rev. 'B2' or later, PCI only)
BOOL CAec::FilmHD()	
{
	if (CkType == 4)
	{
		i = 0;
		while (!(ok = SendCom(0x05)) && ( i < 1  ))
			i++;
	}
	else ok = FALSE;
	return (ok);
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Idle() //idle
{
	if (CkType == 3)
	{
		i = 0;
		while (!(ok = SendCom(idle)) && ( i < 1  ))
			i++;
	}
	if (CkType == 4)
	{
		i = 0;
		while (!(ok = SendCom(idle)) && ( i < 1  ))
			i++;
	}
	else ok = FALSE;
	return (ok);
}




// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// See if this time code board is PCI AND has rev B2 firmware or later.
// That is the version that started support for 24fps LTC generator.
BOOL CAec::FilmAble()
{
	BOOL ok = FALSE;
	BYTE vl, vn;
	if (CkType == 4)
	{
		vl = Read1(0x0006);
		vn = Read1(0x0007);
		if (vl > 'B')
			ok = TRUE;
		else if (vl == 'B')
		{
			if (vn >= '2')
				ok = TRUE;
		}
	}
	return (ok);

}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::InitSonySerial()	//inituart 38400/8/o/1/RS422 TX enabled
{
	if (!Serial)
		return FALSE;
	if (CkType == 3)
	{
		*(lpBrd + 0x0103) = 0xA0;	//  8/ODD
		*(lpBrd + 0x0102) = 8;		//  38400 baud
		*(lpBrd + 0x0100) = 4;		//  RS422
		*(lpBrd + 0x010D) = 0x01;	//  Set bit0 to leave TX enabled
		i = 0;
		while (!(ok = SendCom(inituart)) && ( i < 1  ))
			i++;
		SonySetup = ok;	//will flag commands to call this function if not set.
		return (ok);	
	}
	else	// (CkType == 4)
	{ 
		//May need to change timeout and int enables
		//OffsetR = 0x006A;	//base address of gen sync mode info
		//ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		//OneBR = OneBR | 0x08;	//set bit 3 (jam reader data)
		OffsetW = 0x003C;
		OneBW = 0x0A;	//38400 baud code
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE(&OneBW,  &OffsetW, &Addr);

		OffsetW = 0x003D;
		OneBW = 0xA0;	//8bit/odd code
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE(&OneBW,  &OffsetW, &Addr);

		OffsetW = 0x003E;	//timeout setting
		OneBW = 0x2A;	//for 14ms timeout (14d/(1/3) = 2Ah, Sony has 10ms MINIMUM allowed!!
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE(&OneBW,  &OffsetW, &Addr);

		//set bit 2E.4 to receive RX interrupt messages (88h = data, 8Ah=BREAK received).
		OrIntEnables(0x18);	//sets bit4(RX), bit3(TX)

		i = 0;
		while (!(ok = SendCom(inituart)) && ( i < 1  ))
			i++;
		SonySetup = ok;	//will flag commands to call this function if not set.
		return (ok);
		//return FALSE; //(ok);
	}	
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::InitSerial()	//inituart, Both PCI and ISA use same command!
{
	if (!Serial)
		return FALSE;	
	i = 0;
	while (!(ok = SendCom(inituart)) && ( i < 1  ))
		i++;
	return (ok);
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// Baud = 38400, 19200, 9600, 4800, 2400, 1200, 600, 300 or 150
// Bits = 7 or 8
// P = o, O, e, E, n or N	(parity is ODD, EVEN or NONE)
BOOL CAec::InitSerial(int Baud, int Bits, char P)	//inituart
{
	if (!Serial)
		return FALSE;

	if (CkType == 3)
	{
		if ((P == 'e') || (P == 'E'))
			OneBW = 0x00;
		else if ((P == 'n') || (P == 'N'))
			OneBW = 0x40;
		else //((P == 'o') || (P == 'O'))
			OneBW = 0x80;

		if ((Bits == 7) && ((P == 'n') || (P == 'N')))
			return FALSE;	//cannot have 7bits no Parity
		else if (Bits == 7)
			OneBW = (OneBW & 0xDF);	//clears bit 5
		else OneBW = (OneBW | 0x20);	//sets bit 5
		*(lpBrd + 0x0103) = OneBW;

		if (Baud >= 38400)
			OneBW = 8;
		else if (Baud >= 19200)
			OneBW = 7;
		else if (Baud >= 9600)
			OneBW = 6;
		else if (Baud >= 4800)
			OneBW = 5;
		else if (Baud >= 2400)
			OneBW = 4;
		else if (Baud >= 1200)
			OneBW = 3;
		else if (Baud >= 600)
			OneBW = 2;
		else if (Baud >= 300)
			OneBW = 1;
		else if (Baud >= 300)
			OneBW = 0;
		else OneBW = 8;	//38400 baud default
		*(lpBrd + 0x0102) = OneBW;

		i = 0;
		while (!(ok = SendCom(inituart)) && ( i < 1  ))
			i++;
		return (ok);
	}
	else //CkType == 4			//PCI
	{	
		if ((P == 'e') || (P == 'E'))
			OneBW = 0x00;
		else if ((P == 'n') || (P == 'N'))
			OneBW = 0x40;
		else //((P == 'o') || (P == 'O'))
			OneBW = 0x80;

		if ((Bits == 7) && ((P == 'n') || (P == 'N')))
			return FALSE;	//cannot have 7bits no Parity
		else if (Bits == 7)
			OneBW = (OneBW & 0xDF);	//clears bit 5
		else OneBW = (OneBW | 0x20);	//sets bit 5

		OffsetW = 0x003D;
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE(&OneBW,  &OffsetW, &Addr);

		// Baud rate is equal to 384000/OneBW. Therefore, OneBW = 384k/Baud
		// Make allowed choices here be at only some of the available values
		//76800->5, 64000->6, 54857->7, 48000->8, 42667->9, 
		//38400->10, 34909->11, 32000->12, 29538->13,
		//27428->14, 25600->15, 24000->16, 22588->17, 21333->18
		//20210->19, 19200->20, 9600->40, 4800->80, 2400->160
		//Note: 5 is the smallest number allowed and will internally round up
		// to 5 if set at lower number.
		if (Baud >= 42667)
			OneBW = 5;			//make jump from >38.4k to 76.8k be set to 76.8k
		else if (Baud >= 38400)
			OneBW = 10;
		else if (Baud >= 19200)
			OneBW = 20;
		else if (Baud >= 9600)
			OneBW = 40;
		else if (Baud >= 4800)
			OneBW = 80;
		else if (Baud >= 2400)
			OneBW = 160;
//		else if (Baud >= 1200)
//			OneBW = 3;
//		else if (Baud >= 600)
//			OneBW = 2;
//		else if (Baud >= 300)
//			OneBW = 1;
//		else if (Baud >= 300)
//			OneBW = 0;
		else OneBW = 10;	//38400 baud default
		OffsetW = 0x003C;
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE(&OneBW,  &OffsetW, &Addr);


		//Do NOT set a timeout here. Set prior to entry to this method.

		i = 0;
		while (!(ok = SendCom(inituart)) && ( i < 1  ))
			i++;
		return (ok);
	}
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// Baud = 38400, 19200, 9600, 4800, 2400, 1200, 600, 300 or 150
// Bits = 7 or 8
// P = o, O, e, E, n or N	(parity is ODD, EVEN or NONE)
// M = 0, 2, 4 or 5 (ESbus, RS232, RS422, RS485)
BOOL CAec::InitSerial(int Baud, int Bits, char P, int M)	//inituart
{
	if (!Serial)
		return FALSE;
	if (CkType == 3)
	{
		if ((P == 'e') || (P == 'E'))
			OneBW = 0x00;
		else if ((P == 'n') || (P == 'N'))
			OneBW = 0x40;
		else //((P == 'o') || (P == 'O'))
			OneBW = 0x80;

		if ((Bits == 7) && ((P == 'n') || (P == 'N')))
			return FALSE;	//cannot have 7bits no Parity
		else if (Bits == 7)
			OneBW = (OneBW & 0xDF);	//clears bit 5
		else OneBW = (OneBW | 0x20);	//sets bit 5
		*(lpBrd + 0x0103) = OneBW;

		if (Baud >= 38400)
			OneBW = 8;
		else if (Baud >= 19200)
			OneBW = 7;
		else if (Baud >= 9600)
			OneBW = 6;
		else if (Baud >= 4800)
			OneBW = 5;
		else if (Baud >= 2400)
			OneBW = 4;
		else if (Baud >= 1200)
			OneBW = 3;
		else if (Baud >= 600)
			OneBW = 2;
		else if (Baud >= 300)
			OneBW = 1;
		else if (Baud >= 300)
			OneBW = 0;
		else OneBW = 8;	//38400 baud default
		*(lpBrd + 0x0102) = OneBW;

		if ((M == 0) || (M == 2) || (M == 4) || (M == 5))
			*(lpBrd + 0x0100) = (BYTE)M;


		i = 0;
		while (!(ok = SendCom(inituart)) && ( i < 1  ))
			i++;
		return (ok);	
	}
	else //CkType == 4	//NOTE: The PCI serial boards do NOT support 'M'
	{						//SRXTX ok
		if ((P == 'e') || (P == 'E'))
			OneBW = 0x00;
		else if ((P == 'n') || (P == 'N'))
			OneBW = 0x40;
		else //((P == 'o') || (P == 'O'))
			OneBW = 0x80;

		if ((Bits == 7) && ((P == 'n') || (P == 'N')))
			return FALSE;	//cannot have 7bits no Parity
		else if (Bits == 7)
			OneBW = (OneBW & 0xDF);	//clears bit 5
		else OneBW = (OneBW | 0x20);	//sets bit 5

		OffsetW = 0x003D;
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE(&OneBW,  &OffsetW, &Addr);

		// Baud rate is equal to 384000/OneBW. Therefore, OneBW = 384k/Baud
		// Make allowed choices here be at only some of the available values
		//76800->5, 64000->6, 54857->7, 48000->8, 42667->9, 
		//38400->10, 34909->11, 32000->12, 29538->13,
		//27428->14, 25600->15, 24000->16, 22588->17, 21333->18
		//20210->19, 19200->20, 9600->40, 4800->80, 2400->160
		//Note: 5 is the smallest number allowed and will internally round up
		// to 5 if set at lower number.
		if (Baud >= 42667)
			OneBW = 5;			//make jump from >38.4k to 76.8k be set to 76.8k
		else if (Baud >= 38400)
			OneBW = 10;
		else if (Baud >= 19200)
			OneBW = 20;
		else if (Baud >= 9600)
			OneBW = 40;
		else if (Baud >= 4800)
			OneBW = 80;
		else if (Baud >= 2400)
			OneBW = 160;
//		else if (Baud >= 1200)
//			OneBW = 3;
//		else if (Baud >= 600)
//			OneBW = 2;
//		else if (Baud >= 300)
//			OneBW = 1;
//		else if (Baud >= 300)
//			OneBW = 0;
		else OneBW = 10;	//38400 baud default
		OffsetW = 0x003C;
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE(&OneBW,  &OffsetW, &Addr);


		//Do NOT set a timeout here. Set prior to entry to this method.

		i = 0;
		while (!(ok = SendCom(inituart)) && ( i < 1  ))
			i++;
		return (ok);
	}
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//BYTE CAec::TxStatus()	//txstat
BOOL CAec::TxBusy()	//txstat
{	//TxBusy
	if (!Serial)
		return FALSE;
	if (CkType == 4)
	{	//PCI data at reg 4Dh. .7=echo of 3D.7, .6=echo of 3D.6, .5=echo of 3D.5,
		// .0 = TX busy?
		OffsetR = 0x004D;	//address of PCI Board serial status
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
		//return OneBR;
		if ((OneBR & 0x01) == 0x01)
			return TRUE;
		else return FALSE;
	}
	else //CkType ==3
	{
		i = 0;
		while (!(ok = SendCom(txstat)) && ( i < 1  ))
			i++;
		//return *(lpBrd + 0x010C);
		OneBR = *(lpBrd + 0x010C);
		if ((OneBR & 0x40) == 0x40)
			return TRUE;
		else return FALSE;

		//.7=RS422 Enabled, .6= TXbusy, .4-0 = bytes in TXbuffer (0-31)
		// These bits are updated in response to 90h command (ISA)
	}
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxEn()	//tx422en
{
	if (!Serial)
		return FALSE;
	if (CkType == 4)
		return TRUE;	//PCI 422 is always enabled
	//else ISA
	i = 0;
	while (!(ok = SendCom(tx422en)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxDis()	//tx422dis
{
	if (!Serial)
		return FALSE;
	if (CkType == 4)
		return FALSE;	//PCI 422 is always enabled, cannot disable.
	//else ISA
	i = 0;
	while (!(ok = SendCom(tx422dis)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// casue the TC card serial option port to send a BREAK!
BOOL CAec::TxBreak()	//txbreak
{
	if (!Serial)
		return FALSE;

	if (CkType == 4)	//For PCI, copy the string (DWORD) "000000FF"h to 70h
						// and then use command A0h to "send" the break
	{	
		OffsetW = 0x0070;
		FourBW = 0x000000FF;	//FF is the special "Break" code and NONE bytes to follow
		TRACE("AEC_PCTC_WRITE_4BYTES\n");
		ok = AEC_PCTC_WRITE_4BYTES (&FourBW, &OffsetW, &Addr); // write time data to gen input
		while (!(ok = SendCom(txbreak)) && ( i < 1  ))
			i++;
		return (ok);				
	}
	else //ISA
	{
		i = 0;
		while (!(ok = SendCom(txbreak)) && ( i < 1  ))
			i++;
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxByte(BYTE txOne)	//txbyte
{
	if (!Serial)
		return FALSE;
	if (CkType == 4)
	{	
		OffsetW = 0x0070;
		OneBW = 0x01;	//write BYTES "txONE-01"
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); // write time data to gen input
		OffsetW = 0x0071;
		OneBW = txOne;	//write BYTE "txONE"
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); // write time data to gen input

		while (!(ok = SendCom(txbyte)) && ( i < 1  ))
			i++;
		return (ok);
	}
	else //CkType ==3
	{
		*(lpBrd + 0x010E) = txOne;	// store the byte to be transmitted
		i = 0;
		while (!(ok = SendCom(txbyte)) && ( i < 1  ))
			i++;
		return (ok);	
	}
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS1()	//txstr1
{
	if (!Serial)
		return FALSE;
	i = 0;
	while (!(ok = SendCom(txstr1)) && ( i < 1  ))	//PCI & ISA are the same
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS2()	//txstr2
{
	if (!Serial)
		return FALSE;
	i = 0;
	while (!(ok = SendCom(txstr2)) && ( i < 1  ))	//PCI & ISA are the same
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS3()	//txstr3
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstr3)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS4()	//txstr4
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstr4)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS5()	//txstr5
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstr5)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS6()	//txstr6
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstr6)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS7()	//txstr7
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstr7)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS8()	//txstr8
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstr8)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS9()	//txstr9
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstr9)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS10()	//txstrA
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstrA)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS11()	//txstrB
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstrB)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS12()	//txstrC
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstrC)) && ( i < 1  ))
		i++;
	return (ok);		
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS13()	//txstrD
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstrD)) && ( i < 1  ))
		i++;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS14()	//txstrE
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstrE)) && ( i < 1  ))
		i++;
	return (ok);		
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TxS15()	//txstrF
{
	if (!Serial)
		return FALSE;
	//PCI & ISA are the same
	i = 0;
	while (!(ok = SendCom(txstrF)) && ( i < 1  ))
		i++;
	return (ok);	
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// !*!*!*!*!*!  WRITE FUNCTION FOR ENHANCED SERIAL MODE TOO !*!*!*!*!*!
BOOL CAec::InitRx()	//initrx
{
	if (!Serial)
		return FALSE;
	i = 0;
	while (!(ok = SendCom(initrx)) && ( i < 1  ))
		i++;
	//initialize the RX buffer too;
	RXs.ptrIN = 0;
	RXs.ptrOUT = 0;
	RXs.rollover = 0;
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// Passes back the TWO bytes as a WORD, low byte is status
//							high byte is the byte that was received.
//The PCI serial RX data is sent to MODP area, with the lower byte
// as the data and the Status as the upper. Deal with it.
WORD CAec::RxByte()	//readrx
{
	int diff;
	if (!Serial)
		return 0x00FF;
	if (CkType == 3)
	{
		//This may now not be needed as the PCI buffer will also
		//work for the ISA board too. (testing still needs to be done for
		// ISA models.
		i = 0;
		while (!(ok = SendCom(readrx)) && ( i < 1  ))
			i++;
		//108 holds status (bit7=data valid,  2=OVR, 1= BRK, 0=PAR
		//109 holds DATA byte
		//Pass back a WORD with the DATA in the LOW byte, status in HIGH
		RX = (WORD)((*(lpBrd + 0x0108) * 0x100) + *(lpBrd + 0x0109));
		//return RX;	
	}
	else //CkType == 4
	{	
		diff = ( (RXs.rollover * MAXBUFFER) + RXs.ptrIN - RXs.ptrOUT );
		if (diff > 0)
		{
			RX =  RXs.buf[RXs.ptrOUT];
			RXs.ptrOUT++;			//allow the next read at next location
			if (RXs.ptrOUT == MAXBUFFER)	//is it time to loop to the begining?
			{
				RXs.ptrOUT = 0;	//reset pointer to loop back to begining.
				RXs.rollover--;	//decrement rollover
			}
		}
		else RX = 0x0000;	//if no data, clear bit 7 (status & data are (NOT) valid)
		//return RX;
	}
	return RX;
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// The byte that is returned will be 0x00 if no errors occured.
// The return value will be NON-ZERO IF ERROR occurs with the error
//  being flaged in a bitwise encoding.
//	 bit7 = data vaild, (will only be set if bit 0, 1, or 2 are also set
//	 bit6 = for TIMEOUT			(0x40)
//	 bit5 = NAK					(0x20)
//	 bit2 = buffer overflow		(0x8x)
//	 bit1 = break character rxed	"
//	 bit0 = parity error			"
// The string 'S' will be loaded with the received data, without null termination
BYTE CAec::RxSony(char* S)	
{
	int ii, i, iCnt;
	//LONG toc;
	CTimer to;

	if (!Serial)
		return FALSE;

	if (CkType == 4)	//SRXTXtodo
	{	//PCI FIX when defined ????
		return 0x00;
	}
	else if (CkType ==3)
	{
		iCnt = 1;
		to.Zero();		//zero timer, Start of timeout routine
		for (i=0; (i<iCnt); i++)
		{
			ii = 0;
			while (!(ok = SendCom(readrx)) && ( to.msT() <= 10))  //(ii<5))
				ii++;
			if (ok)
			{
				if ( *(lpBrd + 0x0108) == 0x80 )	// command and RX are error free
				{
					to.Zero();		//zero timer, re-start timeout routine
					*(S+i) = (char) *(lpBrd + 0x0109);	//save rx byte
					if (i == 0)
						iCnt = (int)*S + 3;	// Save the number of bytes to expect						
				}
				else return *(lpBrd + 0x0108);	// Command ok, but RX error
												// status byte
			}	
			else return 0x40;	// bit6 for TIMEOUT
		}
		if ((*(S+0) == 0x11) && (*(S+1) == 0x12))
		{
			//rx_nak++;		// count of NAK errors
			return 0x20;	// bit5 for NAK
		}
		else return 0x00;	//????
	}
	else return 0x00;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// This function is passed a pointer to a string received from "sony" device.
// This code checks to see if this string is ok and if it is a NAK.
// The byte that is returned will be 0x00 if no errors occured.
// The return value will be NON-ZERO IF ERROR occurs with the error
//  codes as follows:
//		OK = TRUE;
//		nak or other = FALSE;
BOOL CAec::CheckSonyRX(LPSTR lpStr)		
{
	int i, iCnt;
	BYTE cmd1, cmd2, cks, cksByte;

	cks = 0;	//start with zero
	cmd1 = lpStr[0];		//Should check to make sure this byte has ODD high nibble
							//value too! All Sony REPLY messages have this!
							//SRXTXtodo. ie: 1xh, 3xh, 5xh, 7xh... (ie: bit4=1)
	cmd2 = lpStr[1];
	iCnt = (int)((lpStr[0] & 0x0F) + 2);	//do not include checksum
	for (i=0; (i<iCnt); i++)
	{
		cks += lpStr[i];
	}
	//if (cks != lpStr[iCnt + 1])
	cksByte = lpStr[iCnt];
	if ( cksByte != cks)
		return FALSE;	//undefined, bad
	else 
	{
		if ( (cmd1 == 0x11) && (cmd2 == 0x12) )
			return FALSE;
		else return TRUE;
	}
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// If some error occurs in the RX of data, see if it is a NAK response, and if
// it is, get the nak data byte.
// This function is passed a pointer to a string received from "sony" device.
// This code checks to see if this string is ok and if it is a NAK.
// The byte that is returned will be 0x00 if not a NAK.
// The return value will be NON-ZERO IF ERROR occurs with the error
//  codes as follows:
//		unknown error = 00h;
//		NAK = Nak data byte;
// This function should be called only if a FALSE is received from "CheckSonyRX" above
BYTE CAec::SonyNAK(LPSTR lpStr)		
{
	int i, iCnt;
	BYTE cmd1, cmd2, cks, cksByte;

	cks = 0;	//start with zero
	cmd1 = lpStr[0];
	cmd2 = lpStr[1];
	iCnt = (int)((lpStr[0] & 0x0F) + 2);	//do not include checksum
	for (i=0; (i<iCnt); i++)
	{
		cks += lpStr[i];
	}
	//if (cks != lpStr[iCnt + 1])
	cksByte = lpStr[iCnt];
	if ( cksByte != cks)
		return 0x00;	//undefined, bad
	else 
	{
		if ( (cmd1 == 0x11) && (cmd2 == 0x12) )
			return (lpStr[2]);
		else return 0x00;	//string ok, but not a NAK
	}
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// For ISA, the value 'j' is overridden to be 15 if is is sent as '0'.
// Will Load and Transmit Sony command String
BOOL CAec::TxSony(int j, char* B)	//txstr1-F  j=1-F
{
	BYTE cks;
	int i;

	if (!Serial)
		return FALSE;

	//This call will have problems if the LEN is greater than 15 (go past 16 byte MIDP)
	// That is not ever done with this protocol however in this programers experience
	// even though it is possible to have 18 byte long TX strings (cmd1,cmd2,data0-f,cks)
	// No calls here ever have dataX over 8 byte
	if (CkType == 4)	
	{	
		if (j > 0x0F)	//0-F are ok values
			return FALSE;

		OneDummy = (BYTE)((B[0] & 0x0F) + 3);	// calculate first byte (length)
		// write the string length to first byte position
		OffsetW = 0x70;	//(0x0100 + (j * 0x10));
		OneBW = OneDummy;	//write BYTE "LENGTH"
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); // write time data to gen input

		cks = 0;	// initialize checksum
		for (i = 0; i < (OneDummy - 1); i++)
		{
			OffsetW = 0x71 + i;	//(0x0101 + (j * 0x10) + i);
			if (OffsetW > 0x7E)	//take into account that at 
				return FALSE;	//		least one more byte is required - cks
			OneBW = (BYTE)B[i];	//write BYTE "B[i]"
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
			ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); // write time data to gen input
			cks = cks + (BYTE)B[i];
		}
		// Write the checksum byte to the string
		OffsetW = (0x70 + OneDummy);
		OneBW = cks;
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); // write time data to gen input

		i = 0;
		//get this string loaded if it is NOT string 0, Send command 0x9jh
		//Load for j!=0, as the load will occur, but the A0h command will
		// pull data directly from the 7xh registers, and not the internally loaded
		// ones.
		if (j != 0)
		{
			OneBW = (0x90 + (BYTE)j);
			while (!(ok = SendCom(OneBW)) && ( i < 1  ))
				i++;
		}

		//now send the command that will transmit this string
		//Code could be put here to delay the TX until the TX is NOT busy
		//		or don't call this method until its ok to do so.
		i = 0;
		OneBW = (0xA0 + (BYTE)j);
		while (!(ok = SendCom(OneBW)) && ( i < 1  ))
			i++;
		return (ok);
	}
	else //CkType ==3
	{
		if (j == 0x00)
			j=0x0F;	//set to be string 15 if trying to send string 0.

		if (j > 0x0F)
			return FALSE;
		OneDummy = (BYTE)((B[0] & 0x0F) + 3);	// calculate first byte (length)
		// write the string length to first byte position
		OffsetW = (0x0100 + (j * 0x10));
		*(lpBrd + OffsetW) = OneDummy;
		cks = 0;	// initialize checksum
		for (i = 0; i < (OneDummy - 1); i++)
		{
			OffsetW = (0x0101 + (j * 0x10) + i);
			*(lpBrd + OffsetW) = (BYTE)B[i];
			cks = cks + (BYTE)B[i];
		}
		// Write the checksum byte to the string
		OffsetW = (0x0100 + (j * 0x10) + OneDummy);
		*(lpBrd + OffsetW) = cks;
		i = 0;
		OneBW = (0xA0 + (BYTE)j);
		while (!(ok = SendCom(OneBW)) && ( i < 1  ))
			i++;
		return (ok);			
	}
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// For ISA, the value 'j' is overridden to be 15 if is is sent as '0'.
BOOL CAec::TxSony(int j)	//txstr1-F  i=1-F
{
	if (!Serial)
		return FALSE;
	if (j > 0x0F)
		return FALSE;
	if (CkType == 4)	
	{
		i = 0;
		OneBW = (0xA0 + (BYTE)j);	//command is the same for PCI & ISA
		while (!(ok = SendCom(OneBW)) && ( i < 1  ))
			i++;
	}
	if (CkType == 3)	
	{
		if (j == 0x00)
			j=0x0F;	//set to be string 15 if trying to send string 0.		i = 0;
		OneBW = (0xA0 + (BYTE)j);	//command is the same for PCI & ISA
		while (!(ok = SendCom(OneBW)) && ( i < 1  ))
			i++;
	}
	return (ok);		
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// Transfer byte data from string B into TX buffer i at offset address 
//  0xAi of Board at Address.
// determines the length byte [0] and the checksum on the fly and
// sets those values in the tx string given the cmd1, cmd2 and data bytes.
BOOL CAec::LoadSonyStr(int j, char *B)	//
{
	BYTE cks;
	int i;
	if (!Serial)
		return FALSE;
	if ((j < 0x01) || (j > 0x0F))
		return FALSE;

	if (CkType == 4)	
	{	
		//if ((j < 0x01) || (j > 0x0F))
		//	return FALSE;
		OneDummy = (BYTE)((B[0] & 0x0F) + 3);	// calculate first byte (length)
		// write the string length to first byte position
		OffsetW = 0x70;	//(0x0100 + (j * 0x10));
		OneBW = OneDummy;	//write BYTE "LENGTH"
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); // write time data to gen input

		cks = 0;	// initialize checksum
		for (i = 0; i < (OneDummy - 1); i++)
		{
			OffsetW = 0x71 + i;	//(0x0101 + (j * 0x10) + i);
			if (OffsetW > 0x7E)	//take into account that at 
				return FALSE;	//		least one more byte is required - cks
			OneBW = (BYTE)B[i];	//write BYTE "B[i]"
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
			ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); // write time data to gen input
			cks = cks + (BYTE)B[i];
		}
		// Write the checksum byte to the string
		OffsetW = (0x70 + OneDummy);
		OneBW = cks;
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); // write time data to gen input

		i = 0;
		//get this string loaded if it is NOT string 0, Send command 0x9j
		OneBW = (0x90 + (BYTE)j);
		while (!(ok = SendCom(OneBW)) && ( i < 1  ))

		return ok;
	}
	else //CkType ==3
	{
		//if ((j < 0x01) || (j > 0x0F))
		//	return FALSE;
		OneDummy = (BYTE)((B[0] & 0x0F) + 3);	// calculate first byte (length)
		// write the string length to first byte position
		OffsetW = (0x0100 + (j * 0x10));
		*(lpBrd + OffsetW) = OneDummy;
		cks = 0;	// initialize checksum
		for (i = 0; i < (OneDummy - 1); i++)
		{
			OffsetW = (0x0101 + (j * 0x10) + i);
			*(lpBrd + OffsetW) = (BYTE)B[i];
			cks = cks + (BYTE)B[i];
		}
		// Write the checksum byte to the string
		OffsetW = (0x0100 + (j * 0x10) + OneDummy);
		*(lpBrd + OffsetW) = cks;
		return TRUE;
	}
	return TRUE;
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BYTE CAec::ModeStatus()	//reads from offset 3E8h
{
	if (CkType == 3)
		OneBR = *(lpBrd + 0x3E8);
	else if (CkType == 4)
	{
		OffsetR = 0x000D;	//base address of PCI Board operating mode info
TRACE("AEC_PCTC_READ_1BYTE\n");
		ok = AEC_PCTC_READ_1BYTE(&OneBR,  &OffsetR, &Addr);
	}
	else if ((CkType == 1) || (CkType == 2))
		OneBR = 0x01;	//ltc reader if IOR or MMR
	else OneBR = 0x00;
	return OneBR;		

}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
int CAec::Refresh()
{
	Find();
	return (Select(selection));

}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//process what the current MODP use is set for. read 20h-23h
void CAec::Process_MODPin() 
{
	modp_settings = Read4(0x0020);
	Set_MODP_flags();	//set all of the modp group flags
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//process what the current MODP use is set for. read 1Ch-1Fh
void CAec::Process_MODPout() 
{
	modp_settings = Read4(0x001C);
	Set_MODP_flags();	//set all of the modp group flags
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//process what the current MODP use and set each mode byte
void CAec::Set_MODP_flags()	//set all of the modp group flags
{
	DWBYTES db;
	db.d = modp_settings;
	modp_gp1 = db.b.f;
	modp_gp2 = db.b.s;
	modp_gp3 = db.b.m;
	modp_gp4 = db.b.h;
}



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::PutRxWStr()		//internal class handler for Rx event.
{
	DWBYTES dwx;
	//set the "inprocess" flag
	RXs.val = (RXs.val | 0x8000);	//set bit 15 HIGH

	if (CkType == 4)
	{
		//===========
		//Start PCI putRX
		if (modp_gp1 == RXDATA)		//defined on App_Note_PCI_MODP doc.
		{
			//ptrIN		//rollover
			dwx.d = Read4(0x0050);
			if (dwx.b.s & 0x80)	//if bit 7 of status#1 is set (vailid data!)
			{
				RXs.buf[RXs.ptrIN] = dwx.w.sf;
				RXs.ptrIN++;	
				if (RXs.ptrIN == MAXBUFFER)
				{
					RXs.ptrIN = 0;	//start stuffing at beginning of buffer next time
					RXs.rollover++;	//let the "get" know that we have rolled back to begining.
				}
			}
			if (dwx.b.h & 0x80)	//if bit 7 of status#2 is set (vailid data!)
			{
				RXs.buf[RXs.ptrIN] = dwx.w.hm;
				RXs.ptrIN++;	
				if (RXs.ptrIN == MAXBUFFER)
				{
					RXs.ptrIN = 0;	//start stuffing at beginning of buffer next time
					RXs.rollover++;	//let the "get" know that we have rolled back to begining.
				}
			}
		}
		if (modp_gp2 == RXDATA)		//
		{
			dwx.d = Read4(0x0054);
			if (dwx.b.s & 0x80)	//if bit 7 of status#1 is set (vailid data!)
			{
				RXs.buf[RXs.ptrIN] = dwx.w.sf;
				RXs.ptrIN++;	
				if (RXs.ptrIN == MAXBUFFER)
				{
					RXs.ptrIN = 0;	//start stuffing at beginning of buffer next time
					RXs.rollover++;	//let the "get" know that we have rolled back to begining.
				}
			}
			if (dwx.b.h & 0x80)	//if bit 7 of status#2 is set (vailid data!)
			{
				RXs.buf[RXs.ptrIN] = dwx.w.hm;
				RXs.ptrIN++;	
				if (RXs.ptrIN == MAXBUFFER)
				{
					RXs.ptrIN = 0;	//start stuffing at beginning of buffer next time
					RXs.rollover++;	//let the "get" know that we have rolled back to begining.
				}
			}
		}
		if (modp_gp3 == RXDATA)		//
		{
			dwx.d = Read4(0x0058);
			if (dwx.b.s & 0x80)	//if bit 7 of status#1 is set (vailid data!)
			{
				RXs.buf[RXs.ptrIN] = dwx.w.sf;
				RXs.ptrIN++;	
				if (RXs.ptrIN == MAXBUFFER)
				{
					RXs.ptrIN = 0;	//start stuffing at beginning of buffer next time
					RXs.rollover++;	//let the "get" know that we have rolled back to begining.
				}
			}
			if (dwx.b.h & 0x80)	//if bit 7 of status#2 is set (vailid data!)
			{
				RXs.buf[RXs.ptrIN] = dwx.w.hm;
				RXs.ptrIN++;	
				if (RXs.ptrIN == MAXBUFFER)
				{
					RXs.ptrIN = 0;	//start stuffing at beginning of buffer next time
					RXs.rollover++;	//let the "get" know that we have rolled back to begining.
				}
			}
		}
		if (modp_gp4 == RXDATA)		//
		{
			dwx.d = Read4(0x005C);
			if (dwx.b.s & 0x80)	//if bit 7 of status#1 is set (vailid data!)
			{
				RXs.buf[RXs.ptrIN] = dwx.w.sf;
				RXs.ptrIN++;	
				if (RXs.ptrIN == MAXBUFFER)
				{
					RXs.ptrIN = 0;	//start stuffing at beginning of buffer next time
					RXs.rollover++;	//let the "get" know that we have rolled back to begining.
				}
			}
			if (dwx.b.h & 0x80)	//if bit 7 of status#2 is set (vailid data!)
			{
				RXs.buf[RXs.ptrIN] = dwx.w.hm;
				RXs.ptrIN++;	
				if (RXs.ptrIN == MAXBUFFER)
				{
					RXs.ptrIN = 0;	//start stuffing at beginning of buffer next time
					RXs.rollover++;	//let the "get" know that we have rolled back to begining.
				}
			}
		}
		//end PCI putRX
		//==================================================
	}
	else //ISA
	{
		//SendCom(readrx)
			RXs.buf[RXs.ptrIN] = (WORD)((*(lpBrd + 0x0108) * 0x100) + *(lpBrd + 0x0109));
			RXs.ptrIN++;	
			if (RXs.ptrIN == MAXBUFFER)
			{
				RXs.ptrIN = 0;	//start stuffing at beginning of buffer next time
				RXs.rollover++;	//let the "get" know that we have rolled back to begining.
			}
	}



	if (RXs.rollover > 1)
		RXoverrun = TRUE;
	else if ((RXs.ptrIN > RXs.ptrOUT) && (RXs.rollover == 1))
		RXoverrun = TRUE;
	else RXoverrun = FALSE;

	//clear the "flag"
	RXs.val++;						//increment
	RXs.val = (RXs.val & 0x7FFF);	//clear only bit 15



	return TRUE;
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//Method to find out how much data there is in class buffer.
int CAec::GetRxWCnt()		
{
	int i;
	i = (RXs.rollover * MAXBUFFER);
	return ( i + RXs.ptrIN - RXs.ptrOUT );
	//return RXs.cnt;
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//Use this type of arguments to call this method.
//	WORD buf[10];
//	int i;
//	i = GetRxWStr(&buf[0], 10);
//
//
//Have class put string data into LPSTR up to max data (int) length.  
//This method will work the same for either ISA or PCI
int CAec::GetRxWStr(LPWORD buffer, int len)	
{					//This Length is in WORDS (ie: 1/2th actual byte length)
					//We have WORD packet data to return in an array (string) ?????
	//copy all of the words into the string a word at a time till all bytes that are
	//currently in the ??s.buf are loaded OR until  we have loaded "len" data (ie: 'buffer' is full).
	int i = 0;	//current count of actions
	int diff;
	int j;
	WORD val;

	if (len == 0)
		return 0;
	rx_event = FALSE;	//clear this when we begin to process
						//this will be set to TRUE if INTERRUPT (if using IRQ)
						//occurs after this point or if the buffer is NOT
						//completely emptied.
	do
	{
		val = RXs.val;
		diff = ( (RXs.rollover * MAXBUFFER) + RXs.ptrIN - RXs.ptrOUT );

		//loop till all of the data is transferred OR till break;
		for (j = 0; j<diff; j++)
		{
			if (i == len)
				break;	//out of this for loop

			//if diff > MAXBUFFER, we have an overrun!
	//TODO: fix the 'buffer' indexing (ie: dword to byte)
			//buffer[i] = RXs.buf[RXs.ptrOUT];
			*buffer = RXs.buf[RXs.ptrOUT];
			RXs.ptrOUT++;
			buffer++;
			i++;
			if (RXs.ptrOUT == MAXBUFFER)	//is it time to loop to the begining?
			{
				RXs.ptrOUT = 0;	//reset pointer to loop back to begining.
				RXs.rollover--;	//decrement rollover
			}
		}
		if (i == len)
			break;	//out of this while loop
	}	while ((diff != 0) || (RXs.val != val) || ((val & 0x8000) != 0));
			//while more data in buffer OR while val has changed OR till not change durring

	if (diff != 0)
		rx_event = TRUE;	//keep the flag set till the buffer is cleared

	return i;	//i is incremented IF data is transfered!
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::PutL21DwStr()		//internal class handler for L21 event.
{
	//set the "inprocess" flag
	L21s.val = (L21s.val | 0x8000);	//set bit 15 HIGH

	if (modp_gp1 == L21DATA)		//defined on App_Note_PCI_MODP doc.
	{
		//ptrIN		//rollover
		L21s.buf[L21s.ptrIN] = Read4(0x050);
		if (L21s.buf[L21s.ptrIN] & 0x80000000)	//increment index ONLY if data is valid!!!
			L21s.ptrIN++;	
		if (L21s.ptrIN == MAXBUFFER)
		{
			L21s.ptrIN = 0;	//start stuffing at beginning of buffer next time
			L21s.rollover++;	//let the "get" know that we have rolled back to begining.
		}
	}
	if (modp_gp2 == L21DATA)		//
	{
		L21s.buf[L21s.ptrIN] = Read4(0x054);
		if (L21s.buf[L21s.ptrIN] & 0x80000000)
			L21s.ptrIN++;	
		if (L21s.ptrIN == MAXBUFFER)
		{
			L21s.ptrIN = 0;	//start stuffing at beginning of buffer next time
			L21s.rollover++;	//let the "get" know that we have rolled back to begining.
		}
	}
	if (modp_gp3 == L21DATA)		//
	{
		L21s.buf[L21s.ptrIN] = Read4(0x058);
		if (L21s.buf[L21s.ptrIN] & 0x80000000)
			L21s.ptrIN++;	
		if (L21s.ptrIN == MAXBUFFER)
		{
			L21s.ptrIN = 0;	//start stuffing at beginning of buffer next time
			L21s.rollover++;	//let the "get" know that we have rolled back to begining.
		}
	}
	if (modp_gp4 == L21DATA)		//
	{
		L21s.buf[L21s.ptrIN] = Read4(0x05C);
		if (L21s.buf[L21s.ptrIN] & 0x80000000)
			L21s.ptrIN++;	
		if (L21s.ptrIN == MAXBUFFER)
		{
			L21s.ptrIN = 0;	//start stuffing at beginning of buffer next time
			L21s.rollover++;	//let the "get" know that we have rolled back to begining.
		}
	}

	if (L21s.rollover > 1)
		L21overrun = TRUE;
	else if ((L21s.ptrIN > L21s.ptrOUT) && (L21s.rollover == 1))
		L21overrun = TRUE;
	else L21overrun = FALSE;

	//clear the "flag"
	L21s.val++;						//increment
	L21s.val = (L21s.val & 0x7FFF);	//clear only bit 15



	return TRUE;
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//Method to find out how much data there is in class buffer.
int CAec::GetL21DwCnt()		
{
	int i;
	i = (L21s.rollover * MAXBUFFER);
	return ( i + L21s.ptrIN - L21s.ptrOUT );
	//return L21s.cnt;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
void CAec::ResetL21Buffer()
{
	L21s.ptrIN = 0;	//start stuffing at beginning of buffer next time
	L21s.rollover = 0;
	L21s.ptrOUT = 0;
	L21s.val = 0;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//Have class put string data into LPSTR up to max data (int) length.  
int CAec::GetL21DwStr(LPDWORD buffer, int len)	
{					//This Length is in DWORDS (ie: 1/4th actual byte length)
					//We have DWORD packet data to return in an array (string)
	//copy all of the dwords into the string a dword at a time till all bytes that are
	//currently in the ??s.buf are loaded OR until  we have loaded "len" data (ie: 'buffer' is full).
	int i = 0;	//current count of actions
	int diff;
	int j;
	WORD val;

	if (len == 0)
		return 0;
	L21_event = FALSE;	//clear this when we begin to process
						//this will be set to TRUE if INTERRUPT (if using IRQ)
						//occurs after this point or if the buffer is NOT
						//completely emptied.
	do
	{
		val = L21s.val;
		diff = ( (L21s.rollover * MAXBUFFER) + L21s.ptrIN - L21s.ptrOUT );

		//loop till all of the data is transferred OR till break;
		for (j = 0; j<diff; j++)
		{
			if (i == len)
				break;	//out of this for loop

			//if diff > MAXBUFFER, we have an overrun!
		//TODO: fix the 'buffer' indexing (ie: dword to byte)
			//buffer[i] = L21s.buf[L21s.ptrOUT];
			*buffer = L21s.buf[L21s.ptrOUT];
			buffer++;
			L21s.ptrOUT++;
			i++;
			if (L21s.ptrOUT == MAXBUFFER)	//is it time to loop to the begining?
			{
				L21s.ptrOUT = 0;	//reset pointer to loop back to begining.
				L21s.rollover--;	//decrement rollover
			}
		}
		if (i == len)
			break;	//out of this while loop
	}	while ((diff != 0) || (L21s.val != val) || ((val & 0x8000) != 0));
			//while more data in buffer OR while val has changed OR till not change durring

	if (diff != 0)
		L21_event = TRUE;	//keep the flag set till the buffer is cleared

	return i;	//i is incremented IF data is transfered!
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	




/*
//Have class put string data into LPSTR up to max data (int) length. 
int CAec::GetL21DwStr(LPSTR buffer, int len) 
{

	return L21s.cnt;	//this needs to be changed. (return count of stuffed units (up to max)).
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::PutL21DwStr()	//internal class handler for L21 event.
{
	//set the "inprocess" flag
	L21s.val = (L21s.val | 0x8000);	//set bit 15 HIGH
	L21overrun = FALSE;
	if (L21.cnt > (MAXBUFFER -4))
		//overrun
		L21overrun = TRUE;
	if (modp_gp1 == L21DATA)		//defined on App_Note_PCI_MODP doc.
	{
		L21s.buf[L21.cnt] = Read4(0x050);
		L21s.cnt++;	
	}
	if (modp_gp2 == L21DATA)		//
	{
		L21s.buf[L21.cnt] = Read4(0x054);
		L21s.cnt++;	
	}
	if (modp_gp3 == L21DATA)		//
	{
		L21s.buf[L21.cnt] = Read4(0x058);
		L21s.cnt++;	
	}
	if (modp_gp4 == L21DATA)		//
	{
		L21s.buf[L21.cnt] = Read4(0x05C);
		L21.cnt++;	
	}	if (modp_gp1 == L21DATA)	//defined on App_Note_PCI_MODP doc.
	{
		L21s.cnt++;	
	}
	//do for all 4 modp...

	//clear the "flag"
	L21s.val++;						//increment
	L21s.val = (L21s.val & 0x7FFF);	//clear only bit 15

	return TRUE;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
int CAec::GetL21DwCnt()		//Method to find out how much data there is in class buffer.
{
	return L21s.cnt;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
*/

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::SetupPci(BOOL StartStop)
{
	//WORD		Addr, Offset08, OffsetEF;
	WORD		OffsetRW;
	BYTE		bId; // bytes from 3E0, 3E1, 3E2, 3EF.
	//BYTE		bType
	BYTE		intcd, intEnables;
	BOOL		ok;
	DWORD		dwIE;
	

	if (StartStop)
	{
		//++
		
		//====================================================================
 		//Make sure that the interrupt "enable" is NOT currently set. If
		//it is, then we don't want to cause a problem for another application
		//that is already using the interrupts. Check bit FE.4 to see if set
		//#INT_A line driving enabled (ie: IRQ line drive upon interrupt is SET)
		OffsetRW = 0xFE;
		//josner comente provisional
		//bRW = Read1(OffsetRW);
		//if (bRW & 0x10)	//if bit4	(ie: if "ISRRun" is true!)
		//	return FALSE;	//sets "exiting" to true!
		
		//====================================================================
			

 		//Make sure that no INTERRUPTS will be generated during initializtion
		//if the board was left in an "active" state from a prior
		//application 

		//disable INTERRUPT enable but save for restoring later	
		dwIE = 0x00000000;
		OffsetRW = 0xFC;
		ok = Write4(dwIE, OffsetRW);

		//disable all automatic interrupts (Read/Gen/field/L21...)
		intEnables = Read1(0x002E);
		//Clear all bits at 2Eh
		ok = Write1(0x00, 0x002E);

		if ((intcd = ReadIntCodeISR()) != 0)
			CProcessIntCode(intcd);
		Sleep(10);	//allow current command to finish if there is one

		if ((intcd = ReadIntCodeISR()) != 0)
			CProcessIntCode(intcd);
		Sleep(1);	

		if ((intcd = ReadIntCodeISR()) != 0)
			CProcessIntCode(intcd);
		Sleep(1);

		if ((intcd = ReadIntCodeISR()) != 0)
			CProcessIntCode(intcd);

		ISRpending = true;
		SetISRinUse(true);

		//Get Board to generate an interrupt (software only) now.
		//This will leave the interrpt pending!
		bId = 0x5B;	//MODPoutput	//Dummy "command" value, to cause interrupt 
				// response at 0Fh.
		OffsetRW = 0x2F;
		ok = Write1(bId, OffsetRW);
		Sleep(10);	//allow time for the board to process the
					//"command" and write ACK/NAK to 0x0F

		//Clear the interrpt. This will leave the board waiting
		// for a write of a 0x00 value to 0x2F offset that will
		// re-enable the NEXT interrupt. The Writing of 0x00 to
		// 0x2F offset is done BY the ISR upon entry into the
		// ISR call ('NextInt'). This allows the ISR to NOT MISS ANY INTS
		// or allow any Interrupts that are NOT ready to be handled!!!!!
		// Read the interrupt response at 0Fh and throw it away. I know
		// that this is an invalid/error response. 
		// This read should technically not be done until after verifing
		// that there is an "interrupt pending" by reading at FEh bit 0.
		// It is quite safe to do this (at 0Fh) but add the verification
		// read to check at FE.0 before is you want to be more sure.
		// you can even loop on waiting for this bit to set once you
		// write the value FFh to offset 2Fh. Be sure not to have a
		// loop that will run forever.
		//bId = 0x00;
	//	OffsetRW = 0x0F;
	//	bId = Read1(OffsetRW);

		intcd = ReadIntCodeISR();
		//no need to process this interrupt as it is "garbage"


		//This is very IMPORTANT to be done NOW. This is the
		// KEY that UNLOCKS the IRQ assertion. This operation
		// will result in bit FE.4 being set, and then when
		// and interrupt occurs, bit FE.1 will be '1' until
		// the ISR reads the interrupt code from offset 0Fh.
		// enable INTERRUPT enable		
		dwIE = 0x00000010;
		OffsetRW = 0xFC;
		ok = Write4(dwIE, OffsetRW);

		Sleep(1);
			
		ok = Write1(intEnables, 0x002E);	//restore the interrupt enables

		ISRpending = false;
		ISRRun = true;


		//At this point, when the "next" interrupt is ENABLED
		// by writing a 00h value byte to offset 2Fh, if and when
		// and interrupt event occurs, it will generate an IRQ.
		// The AEC_NTTC.DLL call AEC_PCTC_ISR_1 does this AFTER
		// if has prepared the OS to handle the interrupt vector.
		// When the call returns, it passes the interrupt ID code
		// to the application for processing. See "TcISR1" below.
		// The direct driver call "NextInt" also does the same
		// thing as "TcISR1"...

		//--
	}
	else	//false
	{
		ISRpending = true;

		//Clear the interrupt enable
		//This will STOP the board from asserting any more IRQs.
		dwIE = 0x00000000;
		OffsetRW = 0x00FC;
		ok = Write4(dwIE, OffsetRW);
		Sleep(20);
		SetISRinUse(false);
		ISRpending = false;
		ISRRun = false;
	}

	return ok;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
UINT CAec::ISRthread()
{
	//WORD		OffsetRW; //, OffsetU, OffsetT;
	//BYTE		bRW;
	BOOL		ok;
	HANDLE	hAecDevice;
	int IntIndex;
	//DWORD	procDW;
	//DWORD	dw;
	//DW_4B	dwChar;
	BYTE	rIntCode;
	//int i, j;

//	LARGE_INTEGER now;
//	LARGE_INTEGER frequency;
//	QueryPerformanceFrequency ( &frequency );

	if (FoundCnt > 0)
	{
		exiting = false;
		if (CkType == 4)	//PCI
			exiting = (!SetupPci(true));	//a "false" SetupPci will cause NOT to run ISR!
		else if (CkType == 3)
		{
			exiting = false;
			SetISRinUse(true);
		}
		else if (CkType == 2)
		{
			SetISRinUse(true);
			exiting = false;
		}
		else if (CkType == 1)
		{
			SetISRinUse(true);
			exiting = false;
		}
		else exiting = true;
	}
	else exiting = true;


	TRACE("AEC_PCTC_INIT_BRD_INT\n");
	ok = AEC_PCTC_INIT_BRD_INT (&hAecDevice, &IntIndex, &Addr);
	

			//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   			//THIS 'WHILE' LOOP IS THE ISR FOR THIS PCI BOARD (at "Addr"h). 
			//THE ISR WILL LOOP INDEFINITLY. IT WILL BE STOPPED WHEN THE
			//THE "exiting" FLAG BECOMES TRUE AND WHEN THE "ISR_1" RETURNS.
			//THE MAIN PROCESS MUST BE SURE TO SET "exiting" TO TRUE AND 
			//WRITE A COMMAND BYTE TO OFFSET 2Fh TO FORCE A RETURN IF BOARD
			//IS WAITING FOR RETURN FROM "ISR_1"


	while ( ! exiting )
    {  
		TRACE("AEC_PCTC_ISR_1\n");
		rIntCode = AEC_PCTC_ISR_1 (&Addr);		// wait for interrupt			
		//rIntCode = 0x13;
		CProcessIntCode(rIntCode);
		//Sleep(33);
    }

	

	if (CkType == 4)	//PCI
		SetupPci(false);	
	else if (CkType == 3)
	{
		SetISRinUse(false);
	}
	else if (CkType == 2)
	{
		SetISRinUse(false);
	}
	else if (CkType == 1)
	{
		SetISRinUse(false);
	}
	exiting = true;	//redundant

//	Sleep(10);	//allow time for "command" (write1) from "DoISR(false)" to process
//				//if it has not done so already

	//Now if we have bit at FE.0 '1', then we have to finish processing the
	// command, else, just do the "enable next" (ie: write1 0x00 to offset 0x2F)

	ResetSoftwareIntFlag(false);

	MessageBeep(-1);
	//Sleep(30000);
	Sleep(1000);
	//MessageBeep(-1);
	//Sleep(500);

	return 0;
}
//=======================================================================
//UINT CAec::IsrThreadProc(LPVOID pParam)
UINT IsrThreadProc(LPVOID pParam)
{
	UINT i;
	CAec* pAec = (CAec*)pParam;
	i = pAec->ISRthread();
	AfxEndThread(0, true);
	//return pAec->ISRthread();
	return i;
}
/*
You can use either the AfxEndThread function or a return statement. 
Typically, 0 signifies successful completion, but that is up to you. 
*/

//=======================================================================

// Set the "ISRRun" variable to TRUE when "start" is true and after setup
// else set to false.....
BOOL CAec::DoISR(BOOL start)
{
	WORD OffsetRW;
	BYTE bId;
	BOOL	ok;

	if (start)
	{
		// Begin the worker thread.  It is ok to fill in the CThreadInfo
		// structure after the thread has started, because the thread
		// waits for the "start recalc" event before referring to the structure.
		m_pIsrWorkerThread =
			AfxBeginThread(IsrThreadProc, 
				(PVOID)this, //(PVOID)&m_isrThreadInfo, 
				THREAD_PRIORITY_TIME_CRITICAL, 
				0,
				CREATE_SUSPENDED, //0, 
				NULL);

			/*
			CWinThread* AfxBeginThread( AFX_THREADPROC pfnThreadProc, 
							LPVOID pParam, 
							int nPriority = THREAD_PRIORITY_NORMAL, 
							UINT nStackSize = 0, DWORD dwCreateFlags = 0, 
							LPSECURITY_ATTRIBUTES lpSecurityAttrs = NULL 
							);
			*/
		if (m_pIsrWorkerThread)
		{
			//m_pIsrWorkerThread->m_bAutoDelete = true;
			//m_pIsrWorkerThread->m_bAutoDelete = false;
			m_pIsrWorkerThread->m_bAutoDelete = true;
			m_pIsrWorkerThread->ResumeThread();
			//ResumeThread
			return true;
		}
		//if (m_pIsrWorkerThread != NULL)
		//	return true;
		else return false;

	}
	else
	{

		exiting = true;	//will keep ISR from looping BACK into DRIVER interrupt que.
		Sleep(100);
		if (ISRRun)	//has not exited with another int yet
		{
			//This will force an Interrupt event IF the ISR is PARKED (in the ISR call)
			//Write (send first half of command) to command port
			//this 'bId' value causes a "0xF?" value to be returned as comand response
			//but this is a "don't" care situation as we are shutting down.
			bId = 0x5B;	//MODPoutput	
			//OffsetRW = 0x2F;

			if (CkType == 4)	//PCI
			{
				OffsetRW = 0x2F;
				ok = Write1(bId, OffsetRW);
			}
			else if (CkType == 3)
			{
				OffsetRW = 0x3FF;
				ok = Write1(bId, OffsetRW);
			}
			else ok = true;	//type 1/2
		}
		else ok = true;

		//The rest of the cleanup is done as the ISR Thread "IsrThreadProc" exits
		return ok;
	}
}


	/*
		//the following is called in the "constructor" CAec::CAec()...
		DWORD dw = GetPriorityClass(GetCurrentProcess());
		dw = REALTIME_PRIORITY_CLASS;
		SetPriorityClass(GetCurrentProcess(), dw);	


volatile BOOL exiting;					// allows for safe thread exiting
volatile BOOL IntPending;				// Flag set when sending commands under ISR
volatile BOOL ISRRun;						// FLAG variable to alter operations if
BOOL	SetISRinUse(BOOL bit);		// Make this call to set the "BrdFE" bit 4.
  */

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// this function will handle ALL processing of data from the 0Fh "intcode" 
// register. NOTE: **** Users will need to make changes to this method to
// implement custom features. ****
// ISR processing of command response interrupts NOT used if using polling method!
//This function effectively is an "ISR" and could be called from within
// the "ISR thread" to handle all ints. You will also want to implement
// additional processing once this method returns in order to "get the
// read/generated timecode, serial data or L21 data from the class buffer.
//The class buffer may overflow if you do not clean out this data.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::CProcessIntCode(BYTE ic)
{
	//cmd_event = FALSE;
	//cmd_ret = 0;
	switch (ic)
	{
		case 0x00:
			break;	//do NOTHING
		case 0x11:	// LTC time code reader (PCI - if 2C.6 = '1')
		case 0x12:	// VITC time code reader (PCI - if 28.6 = '1')
		case 0x13:	//time code reader ID / AUTO (PCI & smart ISA)
			tcR.t = GetTimeRead();
			tcR.u = GetUserRead();
			tcR.e = GetEBRead();
			read_event = TRUE;
			//write method to pass back all of the time/user/eb data in a structure
			//and clear the "read_event" flag

			break;
		case 0x1E:	//Line 21 reader ID (VITC rdr mode & have 2E.6 = '1' 
			if (PutL21DwStr())			//internal class handler for L21 event.
				L21_event = TRUE;
			//code here to determine what MODP dword bytes to save and
			//append to string. increment the dword count of L21 data
			//write method that allows the public access of the L21 dwords
			//and that will pass back and manage the strings and the "event flag"
			break;
		case 0x4C:	//time code generator ID / frame rate interrupt		
			tcG.t = GetTimeGen();
			tcG.u = GetUserGen();
			tcG.e = GetEBGen();
			gen_event = TRUE;
			//write method to pass back all of the time/user/eb data in a structure
			//and clear the "gen_event" flag
			break;
		case 0x44:	//video field ID (50 (EBU) or 60 (SMPTE) / second counter
		case 0x45:	//video SUB field interrupt ID (custom firmware: PCI only)
			vidCounter++;
			vid_event = TRUE;
			//write method to pass back the count and clear the "vid_event" flag

			break;

		case 0x50:	//time code compare MATCH ID /comparator interrupt
				//set up for next compare...
			cmp_event = TRUE;
			//write method to clear the "cmp_event" flag

			break;

		case 0x8A:	//RX BREAK byte ID / received break character interrupt
			brk_event = TRUE;
			//todo:...
			break;		
		case 0x88:	//RX data byte ID / received data interrupt (SERIAL option)
			if (CkType == 4)
			{
				if (PutRxWStr())			//internal class handler for RX event.
					rx_event = TRUE;
			}
			else
			{
				//Write a value of 'readrx' to 3FF;
				Write1(readrx, 0x3FF);
				//ResetSoftwareIntFlag();	//clear int flag for next time / enable next
				//SendCom(readrx);
			}
			//code here to determine what MODP dword bytes to save and
			//append to string. increment the dword count of RX data
			//write method that allows the public access of the RX dwords
			//and that will pass back and manage the strings & flag

				//check for 10ms timeout
				//flag error if timeout
				//Put command in Que to read byte (0x82)
				//reset 10ms timer
//			if (iTimeOutEvents > 0)
//				iTimeOutEvents--;
//
//			tmrSIO.Zero();		//reset timer
//			if (*lpRxBusy) //*lpRxDone || 
//				RXready = TRUE;
			break;



		case 0x89:	//TX event ID / transmit complete interrupt (SERIAL option)
			tx_event = TRUE;
			//write method to clear the flag
//			iTimeOutEvents++;
//			if (iTimeOutEvents > 5) 
//			{
//				MessageBox(hwnd, "The VTR is NOT responding."
//					"\nCheck cable","Serial IO", MB_OK);
//				// send a message to the SIO dialog box to close it
//				PostMessage(hwndSIO, WM_COMMAND, IDCANCEL, 0);//close dialog if errors
//			}
//
//
//
//			rxIndex = 0;
//			//inititialize/reset 10ms timer
//			tmrSIO.Zero(); 
//			if (*lpRxBusy && (rx_mode == OPTIONAL_RX))	// if not using rx interrupt modes
//				RXready = TRUE;

			break;
	


		//=================================================================
			//The following are command response codes for PCI/ISA models.
			//note: ISA only noted#, PCI only noted^

					// 0xFx = NAK  error of some sort(0xFx)
		case 0xF0:	
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4:
		case 0xF5:
		case 0xF6:
		case 0xF7:
		case 0xF8:		//VITC generator write error interrupt (ISA)
		case 0xF9:
		case 0xFA:
		case 0xFB:
		case 0xFC:
		case 0xFD:
		case 0xFE:
		case 0xFF:
			nak_event = TRUE;
			cmd_ret = ic;
			//code here to set "nak_event"
			//write method to clear this flag
			break;

		//No response to process for the next two commands
		//case 0x00:	//acknowledge an interrupt, and enable the next one
		//case 0x02:	//software reset command (no response; takes 0.5sec)
		case 0x03:	// set to SMPTE/NTSC time code (30fps) mode
		case 0x04:	// set to EBU/PAL time code (25fps) mode
		case 0x05:	// set to Film/HD time code mode (24fps) //PCI, rev B2+.

		case 0x10:	//# start LTC reader mode  (PC-LTC, PC-VITC)
		case 0x16:	//# start the idle mode   (PC-LTC, PC-VITC)
		case 0x18:	//# start LTC generator mode  (PC-LTC, PC-VITC)
		case 0x1A:	//? one-time LTC jam sync   (PC-LTC, PC-VLTC)

	//case 2x below will put the time code board into the selected MODE(s).
	//for PCI the LOW nibble bit coding is: bit3=Vgen, bit2=Lgen, bit1=V&21rdr, Bit0=Lrdr
		case 0x20:	//  start Idle mode (PC-VLTC&PCI-TC) 
		case 0x21:	//  start LTC Reader mode (PC-VLTC&PCI-TC)
		case 0x22:	//  start VITC Reader mode (PC-VLTC&PCI-TC)/Start L21 reader mode (PCI-21)
		case 0x23:	//  start Automatic LTC/VITC Reader mode (PC-VLTC&PCI-TC)
		case 0x24:	//  start LTC Generator mode (PC-VLTC&PCI-TC)
		case 0x25:	//  start LTC reader AND LTC generator mode (PC-VLTC&PCI-TC)
		case 0x26:	//  start VITC-to-LTC Translator mode (PC-VLTC&PCI-TC)
		case 0x27:	//^ start Lgen+Vrdr+Lrdr
		case 0x28:	//  start VITC Generator mode (PC-VLTC&PCI-TC)
		case 0x29:	//  start LTC-to-VITC Translator mode (PC-VLTC&PCI-TC)
		case 0x2A:	//^ start Vgen+Vrdr (Generate and read VITC simultaneously)
		case 0x2B:	//^ start Vgen+Vrdr+Lrdr (Gen.VITC and read LTC&VITC simultaneously)
		case 0x2C:	//  start Combination LTC/VITC Generator mode (PC-VLTC&PCI-TC)
		case 0x2D:	//^ start Vgen+Lgen+Lrdr (LTC reader + LTC&VITC generator)
		case 0x2E:	//^ start Vgen+Lgen+Vrdr (VITC reader + LTC&VITC generator)
		case 0x2F:	//^ start LTC&VITC reader AND LTC&VITC generator  (all simultaneously)
			cmd_event = TRUE;
			cmd_ret = ic;
			break;


			//Case 3x are diagnostic routines. All 3x commands are reserved unless otherwise documented.
		case 0x30:	//Serial Option - analog loopback diagnostic
		case 0x31:	//Serial Option - digital loopback diagnostic
		case 0x32:	//Serial Option - transmit Z's diagnostic
		case 0x33:	//Serial Option - transmit breaks diagnostic
		case 0x34:	//# PC-TC "do nothing" diagnostic
		case 0x35:	//# PC-LTC, PC-VITC fixed LTC/VITC generator output diagnostic
		case 0x36:	//# PC-TC transfer all uC RAM registers to DPRAM diagnostic
		case 0x37:	//# PC-TC LTC/VITC generator counting verification diagnostic
			cmd_event = TRUE;
			cmd_ret = ic;
			break;

			// case 0x4x: these are all time code generator commands or are implemented above
		case 0x40:	// load time code generator - time code/user bits AND EB  (PC-TC&PCI-TC)
		case 0x41:	// load time code generator - time code only  (PC-TC&PCI-TC)
		case 0x42:	// load time code generator - user bits only  (PC-TC&PCI-TC)
		case 0x43:	//^load time code generator - EB (embedded) bits only  (PC-TC&PCI-TC) 
		//case 0x44:	//Video int. (see above)
		//case 0x45:	//custom video int (see above)
		//case 0x46:	//reserved
		//case 0x47:	//reserved
		case 0x48:	// start(run) time code generator  (PC-TC&PCI-TC)
			//Sets values of offset 4Ah (generator status output) 
			//			(output enabled) bit 1 = 1,(Count is running) bit 0 = 1.
		case 0x49:	// stop(pause/hold) time code generator (PC-TC&PCI-TC)
			//Sets values of offset 4Ah (generator status output) 
			//			(output enabled) bit 1 = 0,(Count is running) bit 0 = 0.
		case 0x4A:	//^Disable the time code generator output (ie: '0' "volume"(LTC) & vitc keying OFF)
			//Sets values of offset 4Ah (generator status output) 
			//			(output enabled) bit 1 = 0,(Count is running) bit 0 = UNCHANGED.
		case 0x4B:	//^Enable the time code generator output (ie: normal "volume"(LTC) and vitc keying ON) 
			//Sets values of offset 4Ah (generator status output) 
			//			(output enabled) bit 1 = 1,(Count is running) bit 0 = UNCHANGED.
		//case 0x4C:// this is handled above (generator int, see above)
		case 0x4D:	//^ Freeze generator count (time code to be generated does NOT change (repeats!))
			//Sets values of offset 4Ah (generator status output) 
			//			(output enabled) bit 1 = UNCHANGED,(Count is running) bit 0 = 0.
		case 0x4E:	//^ Unfreeze generator count (frozen time code will now increment normally)
			//Sets values of offset 4Ah (generator status output) 
			//			(output enabled) bit 1 = UNCHANGED,(Count is running) bit 0 = 1.
		//case 0x4F:	//reserved
			cmd_event = TRUE;
			cmd_ret = ic;
			break;

		//case 0x5x:
		case 0x5A:	//^board will read the 20h-23h registers and setup the MODP
			Process_MODPin();
			cmd_event = TRUE;
			cmd_ret = ic;
			break;
		case 0x5B:	//^have board put MODP setting info at registers 1Ch-1Fh
			Process_MODPout();
			cmd_event = TRUE;
			cmd_ret = ic;
			break;

			//case 0x8x&9x&Ax: // PC-TC&PCI-TC reserved for SERIAL option
		case 0x80:	//  initialize the UART
			RXs.val = 0;
			RXs.ptrIN = 0;		//index to stuff into
			RXs.ptrOUT = 0;		//index to read out
			RXs.rollover = 0;	//circular buffer input has looped
			cmd_event = TRUE;
			cmd_ret = ic;
			break;
		case 0x81:	//  initialize the receiver
			RXs.val = 0;
			RXs.ptrIN = 0;		//index to stuff into
			RXs.ptrOUT = 0;		//index to read out
			RXs.rollover = 0;	//circular buffer input has looped
			cmd_event = TRUE;
			cmd_ret = ic;
			break;
		case 0x82:	//  read a byte/read RX data (ISA ONLY)
			if (PutRxWStr())			//internal class handler for RX event.
				rx_event = TRUE;
			cmd_event = TRUE;
			cmd_ret = ic;
			break;
		case 0x90:	//  get transmitter status
					//(PCI)loaded TX string into buffer 0 (reply)
			//break;
		case 0x91:	//#  enable the RS422 transmitter
			//break;
		case 0x92:	//#  disable the RS422 transmitter
			//break;
		case 0x93:	//#  transmit a BREAK character
			//break;
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
					//(PCI)loaded TX string into buffer X (0x9X) (reply)
			cmd_event = TRUE;
			cmd_ret = ic;
			break;

			//case 0xAx:	// transmit the "txstring-x" data string (x = 1 to F)
		case 0xA0:	// PC-TC transmit the "txdata" byte/(string, PCI)
		case 0xA1:	// transmit the data string 1
		case 0xA2:	// transmit the data string 2
		case 0xA3:	// transmit the data string 3
		case 0xA4:	// transmit the data string 4
		case 0xA5:	// transmit the data string 5
		case 0xA6:	// transmit the data string 6
		case 0xA7:	// transmit the data string 7
		case 0xA8:	// transmit the data string 8
		case 0xA9:	// transmit the data string 9
		case 0xAA:	// transmit the data string A
		case 0xAB:	// transmit the data string B
		case 0xAC:	// transmit the data string C
		case 0xAD:	// transmit the data string D
		case 0xAE:	// transmit the data string E
		case 0xAF:	// transmit the data string F
			//set flag for "cmd_event" and save "command value" ( = ic;)
			//write method to get command and clear the flag
			cmd_event = TRUE;
			cmd_ret = ic;
			break;

			
		default:
			break;

	} //END of Interrupt ID cases
	//last thing,
	ResetSoftwareIntFlag(FALSE);//doit	//clear int flag for next time / enable next
				//possible loop back to CProcessIntCode (this function) IF TRUE
	return TRUE;
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//SendCom...
//	This function takes a command byte as its parameter and will return 
//	a TRUE if the command that is sent is read (ID) at offset 3FE before a
//	a timeout has occured. If the ID does not ever equal the command
//	before a timeout occurs, a FALSE is returned. 
//	Special cases: If the command is 0 or 2, then the value is written
//	and a TRUE is returned. This is because these command values do not
//	return an ACK.  If a TRUE is returned, it can be assumed that the
//	ComAck value is the same as the command, if FALSE is returned, then
//	read the ComAck value upon return and see what happened. If ComAck is
//	a 0xFx value, then there was a NAK.
// ----------------------------------------------------------------------
BYTE CAec::SendCom(BYTE combyte)
{

	CString s;
    int n = combyte;
    s.Format( _T("%02X"), n );
    TRACE("SendCom = %s\n",s);

	BOOL ok;
	BYTE ret;
	LONG toc;
	CTimer tmSC;
	BYTE B_return = 0x00;
//	BYTE B_return1 = 0x00;
//	BYTE B_return2 = 0x00;
//	BYTE B_return3 = 0x00;
//	BYTE B_return4 = 0x00;
	//===========================================================
	
	if (ISRpending)
	{
		while (ISRpending)
			Sleep(1);
		Sleep(100);
	}

	if (CkType == 4)	//Start PCI command processing
	{		
		CmdPending = true;	//keeps other threads from interfering
//		//this also does NOT allow for a variable time out and is fixed to the
//		//time out of the DLL

		//JOSNER LAST descomente estas dos lineas
		//ok = AEC_PCTC_SEND_COMMAND(&combyte, &B_return, &Addr);
		//OffsetW = 0x2F;
		//ok = AEC_PCTC_WRITE_1BYTE (&combyte, &OffsetW, &Addr); // write command byte	
		//return 0x01;

		cmd_event = FALSE;
		cmd_ret = 0;
		tmSC.Zero();		//zero timer, Start of timeout routine
		ok = FALSE;
		do	//wait for FE.2 = 0
		{
			if ((ret = ReadIntCode()) != 0)	//this call will initialize "BrdFE"
				CProcessIntCode(ret);
			if ((BrdFE & 0x02) == 0)	//if NOT busy
			{
				ok = TRUE;
				break;	//out of do-while loop
			}
		} while (tmSC.msT() < ComTimeout);

		if (!ok)	//we have had a timeout!, BAD!
		{
			CmdPending = false;
			return 0x00;
		}

		// Writing 0x00 to 2Fh under ISR conditions
		// is NOT done by anything except the "ISR_x" func.
		// The ISR_n function of the .DLL file does this when it
		// is qued and ready to handle the next interrupt.
		if (!((combyte == 0x00) && ISRRun))	// if NOT(0 AND ISR) skip the "write command". ISR does this!
		{
			// Write the command byte to 2Fh
			OffsetW = 0x2F;
			OneBW = combyte;
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
			ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); // write command byte		  
		}
		// these values do not get ACKed, so do not wait around for ACK.
		if (combyte == 0x00)	
		{
			//Sleep(1);
			CmdPending = false;
			return 0x01;
		}
		if (combyte == 0x02)	//The caller must then reinitialize the board setups!
		{
			Sleep(200);	//wait for board to come "back" but don't check for response
			CmdPending = false;
			return 0x02;
		}

		if (ISRRun)
				goto isr_ack_PCI;	//JUMP 
				
			// wait for interrupt pending flag to be set (get the ACK)
			// or wait till timeout (waiting too long) 
			// (Default timeout value is 50ms)
		ok = FALSE;
		do	
		{
			if ((ret = ReadIntCode()) != 0)	//this call will initialize "BrdFE"
			{				
				if (ret == combyte)	//does ret = combyte?
				{
					CProcessIntCode(ret);	//keep everything up to date/enable next
					ok = TRUE;
					break;	//we got what we wanted
				}
				else if ((combyte & 0xF0) == 0x20)	//we have a 2xh command reply to a 2xh command that 
				{					//may be different than the command based upon the features of the current
									// model, but that is still valid as only the available feature low nibble
									// bits can be set in the return value.
					CProcessIntCode(ret);	//keep everything up to date/enable next
					if ((ret & 0xF0) == 0x20)
					{
						ok = TRUE;
						break;
					}
				}
				else if ((ret & 0xF0) == 0xF0)	//we have an ERROR code response 
				{
					CProcessIntCode(ret);	//keep everything up to date/enable next
					ok = TRUE;
					break;	//out of do-while loop
				}

				else 
					CProcessIntCode(ret);	//keep everything up to date/enable next
			}
		} while (tmSC.msT() < ComTimeout);


		if (ok)	//this is a timeout error		
		{
			CmdPending = false;
			return(ret);				// this is what we wanted
		}
		else
		{
			//MessageBeep(0xFFFFFFFF);
			CmdPending = false;
			//return 0x00;			
			return cmd_ret;	//may hold an error code
		}
				
	//skip to here if an ISR is running. It will cause the "ReadIntCode()" to run differently.
	isr_ack_PCI:

		ok = FALSE;
		do	
		{
			if (cmd_event)	
			{				
				if (cmd_ret == combyte)	//does ret = combyte?
				{
					ok = TRUE;
					break;	//out of do-while loop, we got what we wanted
				}
				else if ((combyte & 0xF0) == 0x20)	//we have a 2xh command reply to a 2xh command that 
				{					//may be different than the command based upon the features of the current
									// model, but that is still valid as only the available feature low nibble
									// bits can be set in the return value.
					if ((cmd_ret & 0xF0) == 0x20)
					{
						ok = TRUE;
						break;	//out of do-while loop
					}
				}
				else if ((cmd_ret & 0xF0) == 0xF0)	//we have an ERROR code response 
				{
					ok = TRUE;
					break;	//out of do-while loop
				}
			}
			else Sleep(1);	//allow the ISR to have processing time.
		} while (tmSC.msT() < ComTimeout);
		
		ret = cmd_ret;
		//cmd_ret = 0x00;		//clean up for next time;
		//cmd_event = FALSE;	//clean up flags

		if (ok)	//this is a timeout error		
		{
			CmdPending = false;
			return(ret);	// this is what we wanted
		}
		else
		{
			//MessageBeep(0xFFFFFFFF);
			CmdPending = false;
			return 0x00;			
		}
		CmdPending = false;
	
	}	//END type 4 (PCI)
	//===========================================================
	else if ((CkType == 1) || (CkType == 2))	//IOR or MMR
	{		
		return 0x01;
	}	//END type 1/2
	//===========================================================
	else	//Start TYPE 3 - SMART ISA models
	{	//todo: fix this command and make like the PCI above.

		if (!pointer)
			return 0x00;
		if (ISRRun)
			goto isr_ack;	//JUMP 
		  
		// SET INTERRUPT is COMING FLAG if Applicable
		//IntPending = FALSE;
		//if ((combyte != 0x02) || (combyte != 0x00))	  //if NOT (ACK or Reset) ==> TRUE
		//	IntPending = TRUE;
			
		//wait for 'FF'
		toc = 0x00000000;
		while (( *(lpBrd + 0x3FF) != 0xFF) && (toc < 0x3FFFF))
			++toc;
		if (toc >= 0x3FFFF)
		{
			MessageBeep(0xFFFFFFFF);	//FOR DEBUG
			return 0x00;
		}

		ComAck = 0x00;					// DEFAULT Ack value (FALSE)
		OneDummy = *(lpBrd + 0x3FF);	// read again, for timing
		//*(lpBrd + 0x3FD) = 0x00;		// clear intPendingFlag
		*(lpBrd + 0x3FF) = combyte;		// send command
		  
		// these values do not get ACKed, so do not wait around for ACK.
		if ((combyte == 0x00) || (combyte == 0x02))	
			return 0x01;			

		tmSC.Zero();		//zero timer, Start of timeout routine
				
	sc_lp: 
			// wait for interrupt pending flag to be set (get the ACK)
			// or wait till timeout (waiting too long) 
			// (Default timeout value is 50ms)
		do {
			OneVol = *(lpBrd + 0x3FD);
		}
		while ((OneVol == 0x00) && ( (tmrVol = tmSC.msT()) < ComTimeout));


		if ( OneVol == 0x00 )	//this is a timeout error
		{
			bDbug = *(lpBrd + 0x3FE);	//temp debugging!
			//OneDum2 = *(lpBrd + 0x3F0);	//temp debugging!
			MessageBeep(0xFFFFFFFF);
			return 0x00;			
		}
		
		else 
		{
			ComAck = *(lpBrd + 0x3FE);	// get the Interupt Code
			// Reset the command input and clear the interrupt pending
			// byte

				//Wait for 'FF' or timeout
			//toc = 0x00000000;
			while (( *(lpBrd + 0x3FF) != 0xFF) && ( (tmrVol = tmSC.msT()) < ComTimeout))
				++toc; //dummy operation

			*(lpBrd + 0x3FD) = 0x00;	//clear int flag
			*(lpBrd + 0x3FF) = 0x00;	//enable next interrupt
			if (ComAck != combyte)		//if current int is not equal to command	
				goto sc_lp;				// then loop until match or timeout (MAX)
			return(ComAck);				// this is what we wanted
		}

	isr_ack:
		if (combyte == 0x00)
			return 0x01;		// Writing 0x00 to 3FF under ISR conditions
								// does nothing, The ISR must always leave
								// the board in a ready state anyway
								// The ISR_n function of the .DLL file does this!
	 //NOTE----
	  // The .dll function that handles interrupts does not currently handle
	  // this case well. The interrupt can be cued and return to the Main thread
	  // prior to 3FF being FF (can return with it just having been written with 00)
	  // There is currently no way that I know to flag this. 

		  // SET INTERRUPT is COMING FLAG if Applicable
		IntPending = FALSE;
		if (combyte != 0x02)	  //if NOT (Reset) ==> TRUE
			IntPending = TRUE;

			//wait for 'FF'
		toc = 0x00000000;
		while (( *(lpBrd + 0x3FF) != 0xFF) && (toc < 0x3FFFF))
			++toc;
		// ************ Critical from here for the next several lines if ISR hits!
		// If ISR thread is called here, it may be possible to try and write the
		// command byte ('combyte') to 3FF without 3FF = 0xFF.
		// If ISR thread is in use, make sure that the ISR sets the  'ComAck' value
		// when a command response ISR is handled. When ISRRUN is true, the line of
		// code that calls this function needs to wait for ComAck to be set or try
		// to send the command again if a timeout period has elapsed
		// The return value will be false if the ComAck value does not equal the 
		// command before the timeout period has elapsed. Try to send command again
		if (toc >= 0x3FFFF)
		{
			IntPending = FALSE;
			return 0x00;
		}
		ComAck = 0x00;					// default Ack value
		OneDummy = *(lpBrd + 0x3FF);	// read again, for timing
		//*(lpBrd + 0x3FD) = 0x00;		// clear intPendingFlag
		*(lpBrd + 0x3FF) = combyte;		// send command
		// ************ Critical above here

		tmSC.Zero();
		while ((ComAck != combyte) && ((tmrVol = tmSC.msT()) < IntTimeout ))
			++toc;	//dummy operation

		if (ComAck == combyte)	// This is what we wanted
		{
			IntPending = FALSE;
			return ComAck;
		}
		else 
		{
			IntPending = FALSE;
			return 0x00;	//  this indicates a timeout, The ISR did not set
							//  this value before the timout period!!
		}
	}	//END type 3
	//===========================================================
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
char* CAec::GetStrId(char* str)  // pass back the string with board ID
{
	return strcpy( str, strId );
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
char* CAec::Get3ExIDBytes(char* str)
{
	str[0] = (char)Id0;
	str[1] = (char)Id1;
	str[2] = (char)Id2;
	str[3] = (char)SLtr;
	str[4] = (char)SNum;
	str[5] = (char)VerUp;
	str[6] = (char)VerLow;
	str[7] = ' ';
	str[8] = ' ';
	str[9] = ' ';
	str[10] = ' ';
	str[11] = ' ';
	str[12] = ' ';
	str[13] = ' ';
	str[14] = ' ';
	str[15] = (char)Model;	//
	str[16] = 0;	//null
	return str;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::SerialOp()
{
	return (Serial);
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Play()			//play
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	//char SonyStr[] = {0x20, 0x01};
	if (ok)
	{
		char SonyStr[] = {0x20, 0x01};
		ok = TxSony(0, SonyStr);		////SRXTX for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Stop()			//stop
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x20, 0x04};
		ok = TxSony(0, SonyStr);  //for ISA, str0 will transfer to str15.	
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Pause()			//pause
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x20, 0x00};
		ok = TxSony(0, SonyStr);	//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Record()		//record
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x20, 0x02};
		ok = TxSony(0, SonyStr);	//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::FastForward()	//fast_forward
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x20, 0x10};
		ok = TxSony(0, SonyStr);	//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Rewind()		//rewind_tape
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x20, 0x20};
		ok = TxSony(0, SonyStr);	//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Eject()			//eject
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x20, 0x0F};
		ok = TxSony(0, SonyStr);	//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Tmr1_reset()	//timer1 reset
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x40, 0x08};
		ok = TxSony(0, SonyStr);//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Tmr1()			//ctl/timer1 time sense
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x61, 0x0C, 0x04};
		ok = TxSony(0, SonyStr);	//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::LTCc()			//ltc time sense
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x61, 0x0C, 0x01};
		ok = TxSony(0, SonyStr);//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::VITCc()			//vitc time sense
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x61, 0x0C, 0x02};
		ok = TxSony(0, SonyStr);//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Status()		//vtr status sense
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x61, 0x20, 0x09};
		ok = TxSony(0, SonyStr);//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
//
BOOL CAec::Status(BYTE stat)	//vtr status sense
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x61, 0x20, stat};
		ok = TxSony(0, SonyStr);//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// TODO: create additional function to accept ascii and int data
BOOL CAec::Cue(BYTE hh, BYTE mm, BYTE ss, BYTE ff)	//cue/goto HH:MM:SS:FF
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x24, 0x31, ff, ss, mm , hh};
		ok = TxSony(0, SonyStr);//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::ShtlF(BYTE speed)	//shuttle forward at 'speed'
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x21, 0x13, speed};
		ok = TxSony(0, SonyStr);//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::ShtlR(BYTE speed)	//shuttle reverse at 'speed'
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x21, 0x23, speed};
		ok = TxSony(0, SonyStr);//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::UseTC()			//set to use Timecode (not CTL) mode
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x41, 0x36, 0x00};
		ok = TxSony(0, SonyStr);//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::UseCtl()		//set to use Timer1/CTL (not timecode) mode
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x41, 0x36, 0x01};
		ok = TxSony(0, SonyStr);//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::TMS()			//request time mode sense (currently in use)
{
	if (!SonySetup)
		ok = InitSonySerial();	// will also check for 'Serial'
	if (ok)
	{
		char SonyStr[] = {0x60, 0x36};
		ok = TxSony(0, SonyStr);	//for ISA, str0 will transfer to str15.
		SonySetup = ok;	//causes re-init of serial next time if error
	}
	return (ok);	
}



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
int CAec::GetDll_info(LPSTR s)
{
	TRACE("AEC_PCTC_GET_DLL_INFO\n");
	return AEC_PCTC_GET_DLL_INFO(s);
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// transfer string 'chS' of 'Len' length to TX buffer 'j'
BOOL CAec::LoadTxString(int j, int Len, char* chS)
{
	int i, LenMax;
	BYTE bCurrentBuffer, z, y;

	if (!Serial)		//don't go on if the selected board does NOT have SERIAL option!
		return FALSE;

	if (CkType == 4)	//PCI!, Strings can be loaded that are up to the end
						// of the buffer. The max length will depend upon
						// where the string starts. 
						//This is based upon the documentation
						// "PCI-TC Board RS232/422 SERIAL INTERFACE OPERATIONS"
						//  pdf file from AEC.
	{
		if (j > 0x0F)	//must select TX string buffer that is allowed (0-F hex) (0-15 dec)
			return FALSE;
		LenMax = 255 - (16 * j);	//length
		//if ((Len > 0x0F))	//must have length less than 255 bytes
		if ((Len > LenMax))	//max length is 255 bytes less bytes before first used in buf.
			return FALSE;
		if ((Len > 0xFE))	//except for the 0xFF length case that is NOT allowed (BREAK).
			return FALSE;

		// write the string length to first byte position
		OffsetW = 0x70;	
		OneBW = (BYTE)Len;	//write BYTE "LENGTH"
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
		ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); // write time data to gen input
		z = 0x01;	//keep track of how many bytes have been written to the 16byte buffer

		//for each 16 bytes, the "transfer to internal buffer command must be sent
		// If the Len if greater than 15, then the transfer command will be sent
		// for each internal buffer that receives data

		bCurrentBuffer = 0x90 + (BYTE)j; //(j=0-F), set to put in the "9xh" 16 byte TX buffer
		for (i = 0; i < Len; i++)
		{
			y = (z & 0x0F);	//mask out the rollover (high) nibble
			if (y == 0x00) //ie: 0x10+	we have a "MIDP" buffer full, stuff and reset for next
			{				
				ok = SendCom(bCurrentBuffer);
				bCurrentBuffer++;
			}
			OffsetW = (WORD)(0x70 + y);	//
			OneBW = (BYTE)chS[i];	//write BYTE "B[i]"
intByteTrace = OneBW;
stringByteTrace.Format( _T("%02X"), intByteTrace );
stringWordTrace.Format( _T("%04X"), OffsetW );
TRACE("AEC_PCTC_WRITE_1BYTE %s %s\n",stringByteTrace, stringWordTrace);
			ok = AEC_PCTC_WRITE_1BYTE (&OneBW, &OffsetW, &Addr); // write time data to gen input
			z++;
		}
		ok = SendCom(bCurrentBuffer);			//send the final "stuff to buffer" command

		return ok;	//todo: DEBUG this function just to make sure it works as planned!
	}

	else	//type 3
	{

		if ((j < 0x01) || (j > 0x0F))	//must select string buffer 1-F
			return FALSE;
		if ((Len > 0x0F))	//must have length less than 255 bytes
			return FALSE;

		// write the string length to first byte position
		OffsetW = (0x0100 + (j * 0x10));
		*(lpBrd + OffsetW) = (BYTE)Len;
		OffsetW++;	//add one to offset
		for (i = 0; i <= Len; i++)
		{
			*(lpBrd + OffsetW + i) = (BYTE)chS[i];	//write string to tx buffer
		}
		return TRUE;
	}
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// Bit field that passes Lrdr/gen & Vrdr/gen capability bits
// similar to byte at offset 3E8 (mode status) low nibble
int CAec::TCmodes()					
{
	int k = 0;
	if	(LRdr)				//True if board reads LTC
		k = (k | 0x0001);	// set bit0
	if	(LGen)				//True if board gens LTC
		k = (k | 0x0002);	// set bit1
	if	(VRdr)				//True if board reads VITC
		k = (k | 0x0004);	// set bit2
	if	(VGen)				//True if board gens VITC
		k = (k | 0x0008);	// set bit3
	return k;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
BOOL CAec::Any_event()
{
	//BOOL ok;
	BYTE ret;

//	if (!ISRpending)
	if ((!ISRpending) && (!CmdPending))
	{
		if ((ret = ReadIntCode()) != 0)	//this call will initialize "BrdFE" and set event flags!
					CProcessIntCode(ret);
	}
	if (read_event || L21_event || gen_event || vid_event || cmp_event || rx_event || brk_event || tx_event || nak_event || cmd_event)
		return TRUE;
	else return FALSE;
}
/*
	Any_event();
 	brk_event;
 	tx_event;
 	nak_event;
 	cmd_event;
	cmp_event;
 	rx_event;
 	gen_event;
 	vid_event;
 	L21_event;
 	read_event;
  */

/*
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
CAec::
{
	
	DWSTR	L21s;				//data struct packet to hold L21 dwords
	int		GetL21DwCnt();			//Method to find out how much data there is in class buffer.
	int		GetL21DwStr(LPSTR, int); //Have class put string data into LPSTR up to max data (int) length. (return len).
	DWSTR	RXs;				//data struct packet to hold rx dwords
	int		GetRxWCnt();			//Method to find out how much data there is in class buffer.
	int		GetRxWStr(LPSTR, int); //Have class put string data into LPSTR up to max data (int) length.  (return len).
					// holds a copy of a "command response" code that was processed.

}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
*/


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
CTimer::CTimer()
{
//	ok = FALSE;
	ok = QueryPerformanceFrequency(&lpFq);
			// counts/sec		// address of current frequency
			// lpFq.LowPart can handle up to 4 GHz in the 32 bits.
	ok = QueryPerformanceCounter(&lpCnt1);
	lpCnt1.LowPart = (lpCnt1.LowPart & 0x7FFFFFFF); //Mask high bit for rollover
}
// ----------------------------------------------
BOOL CTimer::Zero()
{
	ok = QueryPerformanceCounter(&lpCnt1);
	lpCnt1.LowPart = (lpCnt1.LowPart & 0x7FFFFFFF); //Mask high bit for rollover
	return (ok);
}
// ----------------------------------------------
int CTimer::msT()
{
	ok = QueryPerformanceCounter(&lpCnt2);
	lpCnt2.LowPart = (lpCnt2.LowPart & 0x7FFFFFFF); //Mask high bit for rollover
	if ( lpCnt2.LowPart < lpCnt1.LowPart )			// handle the rollover case			
		lpCnt2.LowPart = (lpCnt2.LowPart | 0x80000000);					
	return (int)((lpCnt2.LowPart - lpCnt1.LowPart) / (lpFq.LowPart/1000));
}
// ----------------------------------------------
DWORD CTimer::SysTime(int frames)
{
	CStrHex bcd;
	SYSTEMTIME	pcTime;	//time/date structure used to read from and pass
	BYTE	bHr, bMn, bSec, bFrm;

	GetSystemTime(&pcTime);
	//GetLocalTime(&pcTime);	// get the current local (pc) time

	bHr = bcd.WordBCD(pcTime.wHour);
	bMn = bcd.WordBCD(pcTime.wMinute);
	bSec = bcd.WordBCD(pcTime.wMilliseconds);
	bFrm = bcd.WordBCD(pcTime.wMilliseconds / (1000/(WORD)frames));

	return (DWORD)((bHr * 0x1000000) + (bMn * 0x10000) + (bSec * 0x100) + bFrm );
}
// ----------------------------------------------
DWORD CTimer::LocalTime(int frames)
{
	CStrHex bcd;
	SYSTEMTIME	pcTime;	//time/date structure used to read from and pass
	BYTE	bHr, bMn, bSec, bFrm;

	//GetSystemTime(&pcTime);
	GetLocalTime(&pcTime);	// get the current local (pc) time

	bHr = bcd.WordBCD(pcTime.wHour);
	bMn = bcd.WordBCD(pcTime.wMinute);
	bSec = bcd.WordBCD(pcTime.wMilliseconds);
	bFrm = bcd.WordBCD(pcTime.wMilliseconds / (1000/(WORD)frames));

	return (DWORD)((bHr * 0x1000000) + (bMn * 0x10000) + (bSec * 0x100) + bFrm );
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	

//	String / Character translation class functions
// -----------------------------------------------
CStrHex::CStrHex()
{
	i = 0;
}
// -----------------------------------------------
//receive each string and check each character for a '0'-'F' value
// if character is "out of range" low set to '0', else 'F'
DWORD CStrHex::ToHex(char *Ath)
{
	i = strlen(Ath);
	if (i == 1)	//convert to hex BYTE
	{
		by[3] = 0;
		by[2] = 0;
		by[1] = 0;
		by[0] = CHex(*Ath);
		//return (VOID*)(&B);					
	}
	else if (i == 2)	//convert to hex BYTE
	{
		by[3] = 0;
		by[2] = 0;
		by[1] = 0;
		by[0] = ((CHex(*(Ath+0)) * 0x10) + (CHex(*(Ath+1))));
		//return (VOID*)(&B);					
	}
	else if (i == 3)	//convert to hex BYTE
	{
		by[3] = 0;
		by[2] = 0;
		by[1] = CHex(*(Ath + 0));
		by[0] = ((CHex(*(Ath+1)) * 0x10) + (CHex(*(Ath+2))));
		//return (VOID*)(&B);					
	}
	else if (i == 4)	//convert to hex BYTE
	{
		by[3] = 0;
		by[2] = 0;
		by[1] = ((CHex(*(Ath+0)) * 0x10) + (CHex(*(Ath+1))));
		by[0] = ((CHex(*(Ath+2)) * 0x10) + (CHex(*(Ath+3))));
		//return (VOID*)(&B);					
	}
	else if (i == 5) //assume that there are 8 'hex' chars only
	{
		by[3] = 0;
		by[2] = CHex(*Ath);
		by[1] = ((CHex(*(Ath+1)) * 0x10) + (CHex(*(Ath+2))));
		by[0] = ((CHex(*(Ath+3)) * 0x10) + (CHex(*(Ath+4))));
		//return (VOID*)(&B);					
	}
	else if (i == 6) //assume that there are 8 'hex' chars only
	{
		by[3] = 0;
		by[2] = ((CHex(*(Ath+0)) * 0x10) + (CHex(*(Ath+1))));
		by[1] = ((CHex(*(Ath+2)) * 0x10) + (CHex(*(Ath+3))));
		by[0] = ((CHex(*(Ath+4)) * 0x10) + (CHex(*(Ath+5))));
		//return (VOID*)(&B);					
	}
	else if (i == 7) //assume that there are 8 'hex' chars only
	{
		by[3] = CHex(*(Ath+0));
		by[2] = ((CHex(*(Ath+1)) * 0x10) + (CHex(*(Ath+2))));
		by[1] = ((CHex(*(Ath+3)) * 0x10) + (CHex(*(Ath+4))));
		by[0] = ((CHex(*(Ath+5)) * 0x10) + (CHex(*(Ath+6))));
		//return (VOID*)(&B);					
	}

	else if ((i >= 8) && (i < 11)) //assume that there are 8 'hex' chars only
	{
		by[3] = ((CHex(*(Ath+0)) * 0x10) + (CHex(*(Ath+1))));
		by[2] = ((CHex(*(Ath+2)) * 0x10) + (CHex(*(Ath+3))));
		by[1] = ((CHex(*(Ath+4)) * 0x10) + (CHex(*(Ath+5))));
		by[0] = ((CHex(*(Ath+6)) * 0x10) + (CHex(*(Ath+7))));
		//return (VOID*)(&B);					
	}
	else //if (i >=11 )	//work with first 8 'hex' characters 
	{				// ie: hh:mm:ss:ff ==> (DWORD)0xhhmmssff
		by[3] = ((CHex(*(Ath+0)) * 0x10) + (CHex(*(Ath+1))));
		by[2] = ((CHex(*(Ath+3)) * 0x10) + (CHex(*(Ath+4))));
		by[1] = ((CHex(*(Ath+6)) * 0x10) + (CHex(*(Ath+7))));
		by[0] = ((CHex(*(Ath+9)) * 0x10) + (CHex(*(Ath+10))));
		//return (VOID*)(&B);			
	}
	return (DWORD)((by[3] * 0x1000000) + (by[2] * 0x10000) + (by[1] * 0x100) + by[0]);
}
// -----------------------------------------------
BYTE CStrHex::CHex(char c)
{
	//if (c > 'F')
	c = toupper(c);
	if (c > 'F')
		return 0x0F;
	else if (c >= 'A')
		return (BYTE)((c - 0x41) + 10);	// 'A' = 0x41 ==> 0x0A = 10
	else if ((c >= '0') && (c <= '9'))
		return (BYTE)(c - 0x30);
	else return 0x00;
}
// -----------------------------------------------
DWORD CStrHex::IntBCD(int i)
{
	iw = (DWORD)i;
	for (j = 0; (((iw / 10) != 0) && (j < 8)); j++)
	{
		by[j] = (BYTE)(iw % 10);// save each decimal value of int in separate byte
		iw /= 10;				// drop 1's digit (Assignment Operator)
	}
	for (k = j; k != 0; k--);
	{
		dw = (dw * 0x10) + (DWORD)by[k - 1];	// mix bytes back into packed HEX DWORD

	}
	return dw;
}
// -----------------------------------------------
int CStrHex::TotalFrames(DWORD wDat, int frm)
{
	int i;
	for (i=0; i<8; i++)
	{
		by[i] = (BYTE)(wDat % 0x10);
		wDat /= 0x10;
	}
					//ff0 + ff10*10   + (ss1 + ss10*10)*frames
	return ( (int)( by[0] + (by[1] * 10) + ((by[2] + (by[3] * 10)) * frm)
		+ ((by[4] + (by[5]*10)) * frm * 60)	//mm * 60sec * frames/sec
		+ ((by[6] + (by[7]*10)) * frm * 3600)) ); //hh * 3600sec * frames/sec
}
// -----------------------------------------------
BYTE CStrHex::IntBcdByte(int iDat)
{
	return (((iDat / 10) * 16 ) + (iDat % 10));
}

// -----------------------------------------------
BYTE CStrHex::WordBCD(WORD wDat)
{
	return (((wDat / 10) * 16 ) + (wDat % 10));
}
// -----------------------------------------------
BYTE CStrHex::PackHex(char high, char low)
{
	return ((CHex(high) * 0x10) + CHex(low));
}
// -----------------------------------------------
// subtract the second packed BCD from the first. Return +- value as int
int CStrHex::FramesDiff(DWORD dw1, DWORD dw2, int frames)
{
	//int i1, i2; //i1 = TotalFrames(dw1, frames); //i2 = TotalFrames(dw2, frames);
	return 	( TotalFrames(dw1, frames) - TotalFrames(dw2, frames));
}
// -----------------------------------------------
char* CStrHex::BStr(BYTE bt, char *chs)
{
	wsprintf (chs,"%2.2X",bt);
	return chs;
}
// -----------------------------------------------
char* CStrHex::WStr(WORD wd, char *chs)
{
	wsprintf (chs,"%4.4X",wd);
	return chs;
}
// -----------------------------------------------
char* CStrHex::DWStr(DWORD dw, char *chs)
{
	wsprintf (chs,"%8.8X",dw);
	return chs;
}
// -----------------------------------------------
char* CStrHex::DWStrTm(DWORD dw, char *chs)
{
	wsprintf (chs,"%8.8X",dw);
	chs[11] = 0;	//EOL
	chs[10] = chs[7];
	chs[9] = chs[6];
	chs[8] = ':';
	chs[7] = chs[5];
	chs[6] = chs[4];
	chs[5] = ':';
	chs[4] = chs[3];
	chs[3] = chs[2];
	chs[2] = ':';
	return chs;
}

// -----------------------------------------------
char CStrHex::NibChar(BYTE bt)
{
	char c;
	switch (bt){
	case 0x00:
		c = '0';
		break;
	case 0x01:
		c = '1';
		break;
	case 0x02:
		c = '2';
		break;
	case 0x03:
		c = '3';
		break;
	case 0x04:
		c = '4';
		break;
	case 0x05:
		c = '5';
		break;
	case 0x06:
		c = '6';
		break;
	case 0x07:
		c = '7';
		break;
	case 0x08:
		c = '8';
		break;
	case 0x09:
		c = '9';
		break;
	case 0x0A:
		c = 'A';
		break;
	case 0x0B:
		c = 'B';
		break;
	case 0x0C:
		c = 'C';
		break;
	case 0x0D:
		c = 'D';
		break;
	case 0x0E:
		c = 'E';
		break;
	default:
		c = 'F';
		break;
	}
	return c;	
}

/*
// -----------------------------------------------
CStrHex::
{

}
// -----------------------------------------------
*/
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	





int CAec::GetFoundCount()
{
	return FoundCnt;
}

