Attribute VB_Name = "Module5"
Option Explicit
' net config workstation

' from NB30.h

'#define NCBNAMSZ        16    /* absolute length of a net name           */
'#define MAX_LANA       254    /* lana's in range 0 to MAX_LANA inclusive */
'#define NCBENUM         0x37            /* NCB ENUMERATE LANA NUMBERS         */

Private Const NCBNAMSZ = 16
Private Const MAX_LANA = 254
 
Private Const NCBRESET = &H32
Private Const NCBASTAT = &H33
Private Const NCBENUM = &H37
 
Private Type NCB
    ncb_command As Byte ' APIViewer defines this incorrectly as Integer
    ncb_retcode As Byte ' APIViewer defines this incorrectly as Integer
    ncb_lsn As Byte ' APIViewer defines this incorrectly as Integer
    ncb_num As Byte ' APIViewer defines this incorrectly as Integer
    ncb_buffer As Long ' APIViewer defines this incorrectly as String
    ncb_length As Integer
    ncb_callname As String * NCBNAMSZ
    ncb_name As String * NCBNAMSZ
    ncb_rto As Byte ' APIViewer defines this incorrectly as Integer
    ncb_sto As Byte ' APIViewer defines this incorrectly as Integer
    ncb_post As Long
    ncb_lana_num As Byte ' APIViewer defines this incorrectly as Integer
    ncb_cmd_cplt As Byte  ' APIViewer defines this incorrectly as Integer
    ncb_reserve(0 To 9) As Byte ' Reserved, must be 0, ' APIViewer defines this incorrectly as (10)
    ncb_event As Long
End Type
 
Private Type LANA_ENUM
        Length As Integer
        Lana(0 To MAX_LANA) As Integer
End Type
 
'#define NRC_GOODRET     0x00    /* good return                                */
Private Const NRC_GOODRET = 0
 
Private Declare Function Netbios Lib "netapi32.dll" (pncb As NCB) As Byte
 
Private Type ADAPTER_STATUS
    adapter_address(0 To 5) As Byte             'As String * 6
    rev_major As Byte           ' APIViewer defines this incorrectly as Integer
    reserved0 As Byte           ' APIViewer defines this incorrectly as Integer
    adapter_type As Byte         ' APIViewer defines this incorrectly as Integer
    rev_minor As Byte           ' APIViewer defines this incorrectly as Integer
    duration As Integer
    frmr_recv As Integer
    frmr_xmit As Integer
    iframe_recv_err As Integer
    xmit_aborts As Integer
    xmit_success As Long
    recv_success As Long
    iframe_xmit_err As Integer
    recv_buff_unavail As Integer
    t1_timeouts As Integer
    ti_timeouts As Integer
    Reserved1 As Long
    free_ncbs As Integer
    max_cfg_ncbs As Integer
    max_ncbs As Integer
    xmit_buf_unavail As Integer
    max_dgram_size As Integer
    pending_sess As Integer
    max_cfg_sess As Integer
    max_sess As Integer
    max_sess_pkt_size As Integer
    name_count As Integer
End Type
   
Private Type NAME_BUFFER
    name As String * NCBNAMSZ
    name_num As Integer
    name_flags As Integer
End Type
 
Private Type ASTAT
     adapt As ADAPTER_STATUS
     NameBuff(30) As NAME_BUFFER        ' ?? 30 or 0 to 29 aod
End Type
 
   
 
' From MSDN Q118623 HOWTO: Get the MAC Address for an Ethernet Adapter

Public Function LANA_List() As Variant
    Dim NCB As NCB
    Dim LANA_ENUM As LANA_ENUM
 
'      Ncb.ncb_command = NCBENUM;
    NCB.ncb_command = NCBENUM
    
'      Ncb.ncb_buffer = (UCHAR *)&lenum;
    NCB.ncb_buffer = VarPtr(LANA_ENUM)
'      Ncb.ncb_length = sizeof(lenum);
    NCB.ncb_length = Len(LANA_ENUM)
    
'      uRetCode = Netbios( &Ncb );
    Dim Ret As Byte
    Ret = Netbios(NCB)
    If Ret <> NRC_GOODRET Then
        Err.Raise 5, , "LANA_lst: Error from Netbios, return code = " & Ret
    End If
    
    ' copy array to a nice variant array. VB Style
    If LANA_ENUM.Length > 0 Then
        ReDim List(LANA_ENUM.Length - 1)
    
        Dim Index As Long
        For Index = 0 To LANA_ENUM.Length - 1
           List(Index) = LANA_ENUM.Lana(Index)
        Next Index
        LANA_List = List
    Else
        LANA_List = Array()
    End If
End Function
 

Public Function MacAddress(ByVal LANA_Number_IN As Long) As String
    Dim NCB As NCB
    Dim Ret As Byte
    Dim strMAC0 As String
    Dim strMAC1 As String
    Dim strMAC2 As String
    Dim strMAC3 As String
    Dim strMAC4 As String
    Dim strMAC5 As String
    
    NCB.ncb_command = NCBRESET
    Ret = Netbios(NCB)
    If Ret <> NRC_GOODRET Then
        Err.Raise 5, , "MacAddress: Error from Netbios, return code = " & Ret
    End If
    
    NCB.ncb_command = NCBASTAT
    NCB.ncb_lana_num = LANA_Number_IN
    NCB.ncb_callname = "*"
    Debug.Assert NCB.ncb_callname = "*               "
    
    Dim ASTAT As ASTAT
    NCB.ncb_length = Len(ASTAT)
    Debug.Assert NCB.ncb_length = 680
    NCB.ncb_buffer = VarPtr(ASTAT)
    Ret = Netbios(NCB)
    If Ret <> NRC_GOODRET Then
        Err.Raise 5, , "MacAddress: Error from Netbios, return code = " & Ret
    End If
    
    ' this should be returned as an array of bytes someday

    strMAC0 = Hex(ASTAT.adapt.adapter_address(0))
    If Len(strMAC0) = 1 Then strMAC0 = "0" & strMAC0
    strMAC1 = Hex(ASTAT.adapt.adapter_address(1))
    If Len(strMAC1) = 1 Then strMAC1 = "0" & strMAC1
    strMAC2 = Hex(ASTAT.adapt.adapter_address(2))
    If Len(strMAC2) = 1 Then strMAC2 = "0" & strMAC2
    strMAC3 = Hex(ASTAT.adapt.adapter_address(3))
    If Len(strMAC3) = 1 Then strMAC3 = "0" & strMAC3
    strMAC4 = Hex(ASTAT.adapt.adapter_address(4))
    If Len(strMAC4) = 1 Then strMAC4 = "0" & strMAC4
    strMAC5 = Hex(ASTAT.adapt.adapter_address(5))
    If Len(strMAC5) = 1 Then strMAC5 = "0" & strMAC5

    MacAddress = strMAC0 & strMAC1 & strMAC2 & strMAC3 & strMAC4 & strMAC5
    'Debug.Print MacAddress
End Function
 

Public Function getChkAct(ByVal inputd As String) As String

    If (inputd = "P183") Then
        getChkAct = "A"
    ElseIf (inputd = "N722") Then
        getChkAct = "B"
    ElseIf (inputd = "T256") Then
        getChkAct = "C"
    ElseIf (inputd = "A396") Then
        getChkAct = "D"
    ElseIf (inputd = "M531") Then
        getChkAct = "E"
    ElseIf (inputd = "U236") Then
        getChkAct = "F"
    ElseIf (inputd = "I103") Then
        getChkAct = "0"
    ElseIf (inputd = "X582") Then
        getChkAct = "1"
    ElseIf (inputd = "Z741") Then
        getChkAct = "2"
    ElseIf (inputd = "Y270") Then
        getChkAct = "3"
    ElseIf (inputd = "W083") Then
        getChkAct = "4"
    ElseIf (inputd = "H568") Then
        getChkAct = "5"
    ElseIf (inputd = "L021") Then
        getChkAct = "6"
    ElseIf (inputd = "G347") Then
        getChkAct = "7"
    ElseIf (inputd = "J320") Then
        getChkAct = "8"
    ElseIf (inputd = "B753") Then
        getChkAct = "9"
    End If
    
End Function


Public Function parsedCode(ByVal inCode As String) As String
    Dim chk1, chk2, chk3, chk4, chk5, chk6, chk7, chk8, chk9, chk10, chk11, chk12 As String
    chk1 = Mid(inCode, 1, 4)
    chk2 = Mid(inCode, 5, 4)
    chk3 = Mid(inCode, 9, 4)
    chk4 = Mid(inCode, 13, 4)
    chk5 = Mid(inCode, 17, 4)
    chk6 = Mid(inCode, 21, 4)
    chk7 = Mid(inCode, 25, 4)
    chk8 = Mid(inCode, 29, 4)
    chk9 = Mid(inCode, 33, 4)
    chk10 = Mid(inCode, 37, 4)
    chk11 = Mid(inCode, 41, 4)
    chk12 = Mid(inCode, 45, 4)
    parsedCode = getChkAct(chk1) & _
    getChkAct(chk2) & _
    getChkAct(chk3) & _
    getChkAct(chk4) & _
    getChkAct(chk5) & _
    getChkAct(chk6) & _
    getChkAct(chk7) & _
    getChkAct(chk8) & _
    getChkAct(chk9) & _
    getChkAct(chk10) & _
    getChkAct(chk11) & _
    getChkAct(chk12)
End Function



