#ifndef WaveForm_H
#define WaveForm_H

#ifdef WaveForm_EXPORTS
    #define WaveForm_API __declspec(dllexport)
#else
    #pragma message("automatic link to WaveForm.LIB")
    #pragma comment(lib, "WaveForm.lib")
    #define WaveForm_API __declspec(dllimport)
#endif

#define PATHSTRINGSIZE 256

#include <stdio.h>
#include <stdlib.h> 

///////////////////////////////////////////////////////////////////////////////
// This class is exported from WaveForm.dll
class WaveForm_API CWaveForm 
{
public:
    CWaveForm();
	void initWaveFile(const wchar_t *inFilepath);
    void closeWaveFile();
	void read();
	long numSamplesData();
	short formatBitsPerSample(); 
	void drawData(long m_SamplesPerPixel,long offsetLectura,long scale,long onlyRChanD, HDC hdcI,long lpdI,long tpdI,long wpdI,long hpdI);
private:
	void readRiff();
	void readFormat();
	void readData();

private:
	char waveFilePath[PATHSTRINGSIZE];
	FILE *streamWaveFile;
	char riffId[4];
	char riffFormat[4];
	unsigned int riffSize;
	char formatId[4];
	unsigned int formatSize;
	unsigned short formatTag;
	unsigned short channels;
	unsigned int samplesPerSecond;
	unsigned int averageBytesPerSec;
	unsigned short blockAlign;
	unsigned short bitsPerSample;
	char dataId[4];
	unsigned int dataSize;
	unsigned long numSamples;
	bool isreadable;
};


void * __stdcall CreateWaveForm();
long __stdcall DestroyWaveForm(void * objptr);
long __stdcall InitWaveFile(void * objptr, const wchar_t *inFilepath);
long __stdcall CloseWaveFile(void * objptr);
long __stdcall ReadWave(void * objptr);
long __stdcall NumSamplesData(void * objptr);
//short __stdcall FormatBitsPerSample(void * objptr); 
long __stdcall DrawData(void * objptr, long m_SamplesPerPixel,long offsetLectura,long scale,long onlyRChanD, HDC ohdc,long lpd,long tpd,long wpd,long hpd);
	

#endif //WaveForm_H