#include "stdafx.h"
#define WaveForm_EXPORTS
#include "WaveFormMedula.h"

BOOL APIENTRY DllMain( HINSTANCE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
                     )
{
    switch (ul_reason_for_call)
    {
        case DLL_PROCESS_ATTACH:
        case DLL_THREAD_ATTACH:
        case DLL_THREAD_DETACH:
        case DLL_PROCESS_DETACH:
            break;
    }
    return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
// Class wrapper functions
///////////////////////////////////////////////////////////////////////////////

void * __stdcall CreateWaveForm()
{
    return new CWaveForm;
}

long __stdcall DestroyWaveForm(void * objptr)
{
    CWaveForm *WaveForm = (CWaveForm *) objptr;
    if (WaveForm)
    {    
		delete WaveForm;
		return 1;
	}
	else
	{
		return 0;
	}
}

long __stdcall InitWaveFile(void * objptr, const wchar_t *inFilepath)
{
    CWaveForm *WaveForm = (CWaveForm *) objptr;
    if (WaveForm)
	{
		WaveForm->initWaveFile(inFilepath);
		return 1;
	}
	else
	{
		return 0;
	}
}

long __stdcall CloseWaveFile(void * objptr)
{
    CWaveForm *WaveForm = (CWaveForm *) objptr;
    if (WaveForm)
	{
		WaveForm->closeWaveFile();
		return 1;
	}
	else
	{
		return 0;
	}
}

long __stdcall ReadWave(void * objptr)
{
    CWaveForm *WaveForm = (CWaveForm *) objptr;
    if (WaveForm)
	{
		WaveForm->read();
		return 1;
	}
	else
	{
		return 0;
	}
}

long __stdcall NumSamplesData(void * objptr)
{
	CWaveForm *WaveForm = (CWaveForm *) objptr;
    if (WaveForm)
        return WaveForm->numSamplesData();
    else
        return 0;
}

/*
short __stdcall FormatBitsPerSample(void * objptr)
{
	CWaveForm *WaveForm = (CWaveForm *) objptr;
    if (WaveForm)
        return WaveForm->formatBitsPerSample();
    else
        return 0;
}
*/

long __stdcall DrawData(void * objptr,long m_SamplesPerPixel,long offsetLectura,long scale,long onlyRChanD, HDC hdcI,long lpdI,long tpdI,long wpdI,long hpdI)
{
    CWaveForm *WaveForm = (CWaveForm *) objptr;
	

    if (WaveForm)
	{
		WaveForm->drawData(m_SamplesPerPixel,offsetLectura,scale,onlyRChanD,hdcI,lpdI,tpdI,wpdI,hpdI);
		return 1;
	}
	else
	{
		return 0;
	}
}	


////////////////////////////////////////////////////////
//CWaveForm class///////////////////////////////////////
////////////////////////////////////////////////////////

CWaveForm::CWaveForm()
{ 
}

void CWaveForm::initWaveFile(const wchar_t *inFilepath)
{
    WideCharToMultiByte( CP_ACP, 0, inFilepath, -1, waveFilePath, PATHSTRINGSIZE, NULL, NULL );
    streamWaveFile = fopen(waveFilePath, "rb");
	isreadable = true;
} 


void CWaveForm::closeWaveFile()
{
	isreadable = false;
	fclose(streamWaveFile);
}


void CWaveForm::readRiff()
{	
    fread(riffId, 4, 1, streamWaveFile);
	if (riffId[0]!=82) 
	{
		MessageBoxA(NULL,"Riff ID Not Valid","Error", MB_OK | MB_ICONEXCLAMATION);
	}
    fread(&riffSize, sizeof(riffSize), 1, streamWaveFile);
	fread(riffFormat, 4, 1, streamWaveFile);
}


void CWaveForm::readFormat()
{
	fread(formatId,4,1,streamWaveFile);
	if (formatId[0]!=102) 
	{
		MessageBoxA(NULL,"Format ID Not Valid","Error", MB_OK | MB_ICONEXCLAMATION);
	}

	fread(&formatSize, sizeof(formatSize), 1, streamWaveFile);
	fread(&formatTag, sizeof(formatTag), 1, streamWaveFile);
	fread(&channels, sizeof(channels), 1, streamWaveFile);
	fread(&samplesPerSecond, sizeof(samplesPerSecond), 1, streamWaveFile);
	fread(&averageBytesPerSec, sizeof(averageBytesPerSec), 1, streamWaveFile);
	fread(&blockAlign, sizeof(blockAlign), 1, streamWaveFile);
	fread(&bitsPerSample, sizeof(bitsPerSample), 1, streamWaveFile);
	// This accounts for the differents format header size 
	fseek(streamWaveFile,20+formatSize,SEEK_SET);

}


void CWaveForm::readData()
{	
	fread(dataId,4,1,streamWaveFile);
	if (dataId[0]!=100) 
	{
		MessageBoxA(NULL,"Data ID Not Valid","Error", MB_OK | MB_ICONEXCLAMATION);
	}

	fread(&dataSize,sizeof(dataSize),1,streamWaveFile);
    fseek(streamWaveFile,40,SEEK_SET);

	//2010
	numSamples = (long) (dataSize / (bitsPerSample/8));
   
/*	char bufImp[8];
	itoa(numSamples,bufImp,10);
	MessageBoxA(NULL,bufImp,"", MB_OK | MB_ICONEXCLAMATION);*/

}


void CWaveForm::read()
{
	this->readRiff();
	this->readFormat();
	this->readData();
}

long CWaveForm::numSamplesData()
{
	return numSamples; 
}

short CWaveForm::formatBitsPerSample()
{
	return 0;
}
	
void CWaveForm::drawData(long m_SamplesPerPixel,long offsetLectura,long scale,long onlyRChanD, HDC ohdc,long lpd,long tpd,long wpd,long hpd)
{
 if (isreadable)
 {
	short maxVal,minVal;
	int maxValInt,minValInt;
	int scaledMinVal,scaledMaxVal;
	short dataPoint=0,dataPointL=0;
	int prevX = 0;
	int prevY = 0;
	int j = 0;    
	int index = 0; 
	int stepOffsetQC;
    int numSamplesQC;
	char charDP[64];
	HPEN hPen;
	
	HDC waveOff;

	waveOff = ohdc;

	  
	if (onlyRChanD==0)
	{
		//2010 - Asi funciona con los AVI, en estereo, 16 bit, 48.000 khz
		stepOffsetQC=offsetLectura*4;
		numSamplesQC=numSamples/2;
		//stepOffsetQC=offsetLectura*2;
		//numSamplesQC=numSamples;
	}
	else
	{ 
		stepOffsetQC=offsetLectura*2;
		numSamplesQC=numSamples;
	}


	fseek(streamWaveFile,40 + stepOffsetQC,SEEK_SET);

	int maxSampleToShow = (int) (( m_SamplesPerPixel * wpd ));

	if (numSamplesQC<maxSampleToShow)
		maxSampleToShow=numSamplesQC;

	
	hPen = CreatePen(PS_SOLID, 1, RGB(0, 255, 255));
	SelectObject(waveOff, hPen);

	
	while ((index < maxSampleToShow) && (index<(numSamplesQC-offsetLectura)) )
	{
		maxVal = -32767;
		minVal = 32767;

		for ( int x = 0; x < m_SamplesPerPixel; x++ )
		{
			fread(&dataPoint,sizeof(dataPoint),1,streamWaveFile);
			
			if (onlyRChanD==0)
			{
				fread(&dataPointL,sizeof(dataPointL),1,streamWaveFile);
			}
			
			if (dataPoint>maxVal)
				maxVal=dataPoint;
			if (dataPoint<minVal)
				minVal=dataPoint;

			index++;
		}

		minValInt = (int)(minVal*scale);
		maxValInt = (int)(maxVal*scale);

		scaledMinVal = (int) (( (minValInt + 32768) * hpd ) /65536 );
		scaledMaxVal = (int) (( (maxValInt + 32768) * hpd ) /65536 );
	
	
		if ( m_SamplesPerPixel > 0.0000000001 )
		{
			
			MoveToEx(waveOff, prevX, prevY, NULL);
			LineTo(waveOff, j, (scaledMaxVal+scaledMinVal)/2);
			prevY = (scaledMaxVal+scaledMinVal)/2;

		}
		else
		{
			return;
		}

		prevX = j;
		j++;                                   
		
	}

	DeleteDC(waveOff);
	DeleteObject(hPen);
 }
	
}


