#include "stdafx.h"
#define DLL3_EXPORTS
#include "WaveFormMedula.h"

BOOL APIENTRY DllMain( HANDLE /*hModule*/, 
                       DWORD  ul_reason_for_call, 
                       LPVOID /*lpReserved*/
                     )
{
    switch (ul_reason_for_call)
    {
        case DLL_PROCESS_ATTACH:
        case DLL_THREAD_ATTACH:
        case DLL_THREAD_DETACH:
        case DLL_PROCESS_DETACH:
            break;
    }
    return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
// GetCycleCount - private function of DLL3.cpp.  The static keyword ensures
//                 that this function name is not visible outside DLL3.cpp.
static inline unsigned __int64 GetCycleCount()
{
    unsigned int timehi, timelo;

    // Use the assembly instruction rdtsc, which gets the current
    // cycle count (since the process started) and puts it in edx:eax.
    __asm
    {
        rdtsc
        mov timehi, edx;
        mov timelo, eax;
    }

    return ((unsigned __int64)timehi << 32) + (unsigned __int64)timelo;
}


///////////////////////////////////////////////////////////////////////////////
// Example of an exported class
///////////////////////////////////////////////////////////////////////////////
// This is the constructor of class CDLL3 that has been exported;
// see DLL3.h for the class definition
CDLL3::CDLL3()
{ 
}

int CDLL3::GetCpuSpeed()
{
    const unsigned __int64 ui64StartCycle = GetCycleCount();
    Sleep(1000);
    return static_cast<int>((GetCycleCount() - ui64StartCycle) / 1000000);
}

///////////////////////////////////////////////////////////////////////////////
// Class wrapper functions
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// CreateDLL3 - create an instance of the class CDLL3
void * __stdcall CreateDll3()
{
    return new CDLL3;
}

///////////////////////////////////////////////////////////////////////////////
// DestroyDLL3 - free the memory for the class instance 
void __stdcall DestroyDll3(void * objptr)
{
    CDLL3 *dll3 = (CDLL3 *) objptr;
    if (dll3)
        delete dll3;
}

///////////////////////////////////////////////////////////////////////////////
// GetCpuSpeed - returns CPU speed in MHz;  for example, ~2193 will be 
//               returned for a 2.2 GHz CPU.
int __stdcall GetCpuSpeedDll3(void * objptr)
{
    CDLL3 *dll3 = (CDLL3 *) objptr;
    if (dll3)
        return dll3->GetCpuSpeed();
    else
        return 0;

}









