Attribute VB_Name = "UnicodeModule"
Option Compare Binary
Option Explicit

Private m_acpSys As Long
Private m_lcidSys As Long


'--------------------------------
'   AToW
'
'   ANSI to UNICODE conversion, via a given codepage.
'--------------------------------
Public Function AToW(ByVal st As String, Optional ByVal cpg As Long = -1, Optional lFlags As Long = 0) As String
    Dim stBuffer        As String
    Dim cwch            As Long
    Dim pwz             As Long
    Dim pwzBuffer       As Long
        
    If cpg = -1 Then cpg = AcpSys()
    pwz = StrPtr(st)
    cwch = MultiByteToWideChar(cpg, lFlags, pwz, -1, 0&, 0&)
    stBuffer = String$(cwch + 1, vbNullChar)
    pwzBuffer = StrPtr(stBuffer)
    cwch = MultiByteToWideChar(cpg, lFlags, pwz, -1, pwzBuffer, Len(stBuffer))
    AToW = Left$(stBuffer, cwch - 1)
End Function

'--------------------------------
'   AToWEx
'
'   ANSI to UNICODE conversion, via a given an lcid.
'--------------------------------
Public Function AToWEx(ByVal st As String, Optional ByVal lcid As Long = -1, Optional lFlags As Long = 0) As String
    Dim cpg                 As Long
    Dim lpUsedDefaultChar   As Long
    
    ' If no codepage is specified, use the default system codepage
    If lcid = -1 Then lcid = LcidSys()
    cpg = ChsFromLocale(lcid)

    AToWEx = AToW(st, cpg, lFlags)
End Function

'--------------------------------
'   WToA
'
'   UNICODE to ANSI conversion, via a given codepage
'--------------------------------
Public Function WToA(ByVal st As String, Optional ByVal cpg As Long = -1, Optional lFlags As Long = 0) As String
    Dim stBuffer            As String
    Dim cwch                As Long
    Dim pwz                 As Long
    Dim pwzBuffer           As Long
    Dim lpUsedDefaultChar   As Long
    
    If cpg = -1 Then cpg = AcpSys()
    pwz = StrPtr(st)
    cwch = WideCharToMultiByte(cpg, lFlags, pwz, -1, 0&, 0&, ByVal 0&, ByVal 0&)
    stBuffer = String$(cwch + 1, vbNullChar)
    pwzBuffer = StrPtr(stBuffer)
    cwch = WideCharToMultiByte(cpg, lFlags, pwz, -1, pwzBuffer, Len(stBuffer), ByVal 0&, ByVal 0&)
    WToA = Left$(stBuffer, cwch - 1)
End Function

'--------------------------------
'   WToAEx
'
'   UNICODE to ANSI conversion, via a given an lcid.
'--------------------------------
Public Function WToAEx(ByVal st As String, Optional ByVal lcid As Long = -1, Optional lFlags As Long = 0) As String
    Dim cpg                 As Long
    Dim lpUsedDefaultChar   As Long
    
    ' If no codepage is specified, use the default system codepage
    If lcid = -1 Then lcid = LcidSys()
    cpg = ChsFromLocale(lcid)

    WToAEx = WToA(st, cpg, lFlags)
End Function

'--------------------------------
'   FStringInCpg
'
'   Tests whether a particular string fits within a given codepage,
'   given the string and a codepage.
'--------------------------------
Public Function FStringInCpg(ByVal st As String, Optional ByVal cpg As Long = -1) As Boolean
    Dim cwch                As Long
    Dim lpUsedDefaultChar   As Long
    
    ' If no codepage is specified, use the default system codepage
    If cpg = -1 Then cpg = AcpSys()
    
    ' We are not converting, simply determining if the system plans
    ' on using the default char at all (which it does when it cannot
    ' map a char in the string)
    cwch = WideCharToMultiByte(cpg, 0&, StrPtr(st), -1, 0&, 0&, ByVal 0&, lpUsedDefaultChar)
    FStringInCpg = (CBool(lpUsedDefaultChar) = False)
End Function

'--------------------------------
'   FStringInLcid
'
'   Tests whether a particular string fits within a given codepage,
'   given the string and an LCID.
'--------------------------------
Public Function FStringInLcid(ByVal st As String, Optional ByVal lcid As Long = -1) As Boolean
    Dim cwch        As Long
    Dim cpg         As Long
    Dim lpUsedDefaultChar As Long
    
    ' If no codepage is specified, use the default system LCID
    If lcid = -1 Then lcid = LcidSys()
    cpg = ChsFromLocale(lcid)
    
    FStringInLcid = FStringInCpg(st, cpg)
End Function

'--------------------------------
'   ChsFromLocale
'--------------------------------
Public Function ChsFromLocale(lcid As Long) As Long
    Dim cwc         As Long
    Dim cpg         As Long
    Dim stBuffer    As String
    Dim cs          As CHARSETINFO
    
    stBuffer = String$(10, vbNullChar)
    cwc = GetLocaleInfoA(lcid, LOCALE_IDEFAULTANSICODEPAGE, _
     stBuffer, Len(stBuffer))

    If cwc > 0 Then
        cpg = val(Left$(stBuffer, cwc - 1))
        
        ChsFromLocale = ChsFromCpg(cpg)
    End If
End Function

'--------------------------------
'   ChsFromCpg
'--------------------------------
Public Function ChsFromCpg(cpg As Long) As KnownCharset
    Dim cs  As CHARSETINFO
    
    If TranslateCharsetInfo(ByVal cpg, cs, _
     TCI_SRCCODEPAGE) Then
        ChsFromCpg = cs.ciCharset
    End If
End Function

'--------------------------------
'   AcpSys
'
'   Wrapper around GetACP since Kernel calls are expensive.
'--------------------------------
Public Property Get AcpSys() As Long
    If (m_acpSys = 0) Then
        m_acpSys = GetACP()
    End If
    
    AcpSys = m_acpSys
End Property

'--------------------------------
'   LcidSys
'
'   Wrapper around GetSystemDefaultLCID since Kernel calls are expensive
'--------------------------------
Public Property Get LcidSys() As Long
    If m_lcidSys = 0 Then
        m_lcidSys = GetSystemDefaultLCID()
    End If
    LcidSys = m_lcidSys
End Property

Public Sub ltob(lVal As Long)
   If lVal < 0 Then
      lVal = 0
   ElseIf lVal > 255 Then
      lVal = 255
   End If
End Sub

Function icp(S As String, CP As Long)
    On Error Resume Next
    icp = Asc(WToA(S, CP))
End Function

Public Function EncodeUTF8(ByVal cnvUni As String) As String
    If cnvUni = vbNullString Then Exit Function
    EncodeUTF8 = StrConv(WToA(cnvUni, 1200, 0), vbUnicode)
End Function

Public Function DecodeUTF8(ByVal cnvUni As String, sCodePage As Integer) As String
    Dim cnvUni2     As String
    
    If cnvUni = vbNullString Then Exit Function
    cnvUni2 = WToA(cnvUni, CP_ACP)
    DecodeUTF8 = AToW(cnvUni2, sCodePage)
End Function

Public Function toUnicode(text As String) As String
    Dim cont        As Integer
    Dim characters       As String
    
    characters = ""
    If CP = JAPANESE Or CP = KOREAN Or CP = CHINESESIMPLIFIED Or CP = CHINESEBIG Then
        For cont = 0 To Len(text) - 1
            characters = characters & ChrW$(AscW(Mid(text, cont + 1, 1)))
        Next
    Else
        For cont = 0 To Len(text) - 1
            characters = characters & ChrW$(transformfont(Hex(AscW(Mid(text, cont + 1, 1)))))
        Next
    End If
            
    toUnicode = characters
End Function

Public Function transformfont(C As String) As String
    Dim i       As Integer
    Dim l       As Integer
    Dim auxs    As String
    
                    auxs = ""
                    If C = Chr(92) Then
                        auxs = auxs & Chr(128)
                    ElseIf C >= Chr(32) And C <= Chr(122) Then
                        auxs = auxs & C
                    ElseIf C = "" Or C = Chr(149) Or C = Chr(160) Then
                        auxs = auxs & " "                                   'Space
                    ElseIf C = Chr(150) Or C = Chr(151) Then
                        auxs = auxs & "-"                                   'Dash
                    ElseIf C = "'" Then
                        auxs = auxs & Chr(39)                               'Single apostrophe
                    ElseIf C = ChrW(&H2026) Then                            'ELLIPSIS
                        auxs = auxs & Chr(166)
                    ElseIf C = Chr(145) Or C = ChrW(&H2018) Then            'SINGLE LEFT QUOTATION
                        auxs = auxs & Chr(176)
                    ElseIf C = Chr(146) Or C = ChrW(&H2019) Then            'SINGLE RIGHT QUOTATION
                        auxs = auxs & Chr(178)
                    ElseIf C = Chr(147) Or C = ChrW(&H201C) Then            'LEFT DOUBLE QUOTATION MARK
                        auxs = auxs & Chr(179)
                    ElseIf C = Chr(148) Or C = ChrW(&H201D) Then            'RIGHT DOUBLE QUOTATION MARK
                        auxs = auxs & Chr(188)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(152)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(153)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(154)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(157)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(158)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(159)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(162)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(164)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(165)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(169)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(171)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(173)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(175)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(183)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(187)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(191)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(129)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(130)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(131)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(134)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(135)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(136)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(139)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(140)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(143)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(144)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(146)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(147)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(148)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(149)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(29)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(28)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(12)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(11)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(155)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(174)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(4)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(5)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(6)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(7)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(1)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(2)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(3)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(8)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(16)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(18)
                                                                '+Julio 2002
                    ElseIf C = "" Then
                        auxs = auxs & Chr(15)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(20)
                    ElseIf C = Chr(171) Then
                        auxs = auxs & Chr(21)                   'LEFT POINTING DOUBLE ARROW (171 = &HAB)
                    ElseIf C = Chr(187) Then
                        auxs = auxs & Chr(22)                   'RIGHT POINTING DOUBLE ARROW (187 = &HBB)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(23)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(24)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(30)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(31)
                    ElseIf C = "{" Then
                        auxs = auxs & Chr(123)
                    ElseIf C = "|" Then
                        auxs = auxs & Chr(124)
                    ElseIf C = "}" Then
                        auxs = auxs & Chr(125)
                    ElseIf C = "~" Then
                        auxs = auxs & Chr(126)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(132)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(132)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(133)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(137)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(138)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(141)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(142)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(145)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(150)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(151)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(156)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(160)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(161)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(163)
                    ElseIf C = "" Then                             'Previously: ElseIf c = "" Then
                        auxs = auxs & Chr(167)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(168)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(170)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(172)
                                                                    'ElseIf c = "" Then
                                                                    'auxs = auxs & Chr(176)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(180)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(181)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(182)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(184)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(185)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(186)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(189)
                    ElseIf C = "" Then
                        auxs = auxs & Chr(190)
        End If
    
    transformfont = "&H" & auxs
End Function

Public Function EnumFontFamExProc(ByVal lpelfe As Long, ByVal lpntme As Long, ByVal FontType As Long, ByVal lParam As Long) As Long
    Dim elfx As ENUMLOGFONTEX  ' receives information about the font
    Dim ntmx As NEWTEXTMETRICEX  ' receives text metrics for TrueType fonts
    Dim tm As TEXTMETRIC  ' receives text metrics for non-TrueType fonts
    
    CopyMemory elfx, ByVal lpelfe, Len(elfx)
    
    If (FontType And TRUETYPE_FONTTYPE) = TRUETYPE_FONTTYPE Then
        CopyMemory ntmx, ByVal lpntme, Len(ntmx)
        fonts(contfonts).name = Left(elfx.elfLogFont.lfFaceName, InStr(elfx.elfLogFont.lfFaceName, vbNullChar) - 1)
        If contcharset = 0 Then
            fonts(contfonts).style = Left(elfx.elfStyle, InStr(elfx.elfStyle, vbNullChar) - 1)
        End If
        With fonts(contfonts).Charsets(contcharset)
            If fonts(contfonts).style = Left(elfx.elfStyle, InStr(elfx.elfStyle, vbNullChar) - 1) Then
                .id = elfx.elfLogFont.lfCharSet
                Select Case elfx.elfLogFont.lfCharSet
                    Case 0:
                        .name = "Western"
                    Case 1:
                        .name = "DEFAULT_CHARSET"
                    Case 2:
                        .name = "Symbol"
                    Case 77:
                        .name = "Mac"
                    Case 128:
                        .name = "Japanese"
                    Case 129:
                        .name = "Hangeul"
                    Case 130:
                        .name = "Johab"
                    Case 134:
                        .name = "Chinese_GB2312"
                    Case 136:
                        .name = "Chinese_BIG5"
                    Case 161:
                        .name = "Greek"
                    Case 162:
                        .name = "Turkish"
                    Case 163:
                        .name = "Vietnamese"
                    Case 177:
                        .name = "Hebrew"
                    Case 178:
                        .name = "Arabic"
                    Case 186:
                        .name = "Baltic"
                    Case 204:
                        .name = "Cyrillic"
                    Case 222:
                        .name = "Thai"
                    Case 238:
                        .name = "East Europe"
                    Case 255:
                        .name = "OEM"
                    Case Else
                        .name = "DEFAULT_CHARSET"
                End Select
                       
                contcharset = contcharset + 1
                End If
                CP = .CP
            End With
        End If
        EnumFontFamExProc = 1
End Function
