// adrienneTCController.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include <windows.h>
#include <stdio.h>
#include <streams.h>
#include <string.h>
#include <initguid.h>
#include "dllutil.h"

#include "Aec_Variables.h"


void InitGenStatusAll()
{
	BYTE temp;
	int frz, able;
	BYTE b = tc1.GetGenModeControl();

	strcpy(TCGenRet, "InitGen 0 // ");
	if (tc1.GensLtc() || tc1.GensVitc())
	{
		strcat(TCGenRet, "InitGen 1 // ");

		if (b & BIT0){
			//CheckRadioButton(IDC_RADIO_CMPREAD, IDC_RADIO_CMPGEN, IDC_RADIO_CMPREAD);
			BYTE b = tc1.GetGenModeControl();
			tc1.SetGenModeControl(b | BIT1);
			strcat(TCGenRet, "InitGen 2 // ");
		}
		else{
			//CheckRadioButton(IDC_RADIO_CMPREAD, IDC_RADIO_CMPGEN, IDC_RADIO_CMPGEN);
			BYTE b = tc1.GetGenModeControl();
			tc1.SetGenModeControl(b & NOTBIT1);
			strcat(TCGenRet, "InitGen 3 // ");
		}
		
		//Gen output operating mode status (4A/45h)========================
		if (tc1.BrdType() == 4)	//PCI
		{
			temp = tc1.Read1(0x004A);	//pci
			if (temp & 0x01)
				frz = 1;
			else frz = 0;
			if (temp & 0x02)
				able = 1;
			else able = 0;


			wsprintf (statusInf," FRZ: %d  ABLE: %d", frz, able);

			strcat(TCGenRet, "InitGen 4 // ");
			strcat(TCGenRet, statusInf);
		}
		else 
		{
			temp = tc1.Read1(0x0045);   //isa
			if (temp & 0x40)
				frz = 0;		//UNFrozen = 0
			else frz = 1;
			if (temp & 0x80)
				able = 0;		//DISabled =0
			else able = 1;

			strcat(TCGenRet, "InitGen 5 // ");
		}
		if (frz && able)	//gen is active normal
		{
			//SetDlgItemText(IDC_CHECK_GEN_RUNUNCHANGEDSTOP, "STOP");
			//CheckDlgButton(IDC_CHECK_GEN_RUNUNCHANGEDSTOP, 1);
			//SetDlgItemText(IDC_CHECK_GEN_PAUSE_GO, "Freeze Time");
			//CheckDlgButton(IDC_CHECK_GEN_PAUSE_GO, 0);
			//SetDlgItemText(IDC_CHECK_GEN_DIS_ENABLE, "Disable Output");
			//CheckDlgButton(IDC_CHECK_GEN_DIS_ENABLE, 0);
			
			
			//tc1.Start();
			tc1.SendCom(0x4E); //PCI
			tc1.SendCom(0x4B); //PCI
			strcat(TCGenRet, "InitGen 6 // ");

			return;
		}

		//tc1.Start();
		//tc1.SendCom(0x4E); //PCI
		//tc1.SendCom(0x4B); //PCI
		//tc1.SendCom(0x4D); //PCI
		//tc1.SendCom(0x4A); //PCI

		tc1.StopGen();
		tc1.SendCom(0x4D); //PCI
		tc1.SendCom(0x4A); //PCI

		strcat(TCGenRet, "InitGen 7 // ");

	}
}


long __declspec(dllexport) CALLBACK setDFAdrienneTCCard(long isDF)
{

	BYTE BTemp = tc1.GetEBGen();


	if (isDF == 1)
		BTemp = BTemp | 0x80;	//setbit
	else BTemp = BTemp & 0x7F;	//clear bit
	
	tc1.WriteGenTUE(0,0,0,0, 1, BTemp);

	tc1.JamEB();	//jam embedded
	return 0;

}


long __declspec(dllexport) CALLBACK closeAdrienneTCCard()
{

	tc1.exiting = TRUE;
	// TODO: Force an interrupt to make sure ISR loop ends.
	// --> For 'Smart' boards, just send a command to 3FF
	//		this will cause an interrupt
	//Purpose: This will allow the ISR thread to exit cleanly
	//			without leaving residual effects 

//
	tc1.StopGen();
	tc1.SendCom(0x49);
	tc1.SendCom(0x4D); //PCI
	tc1.SendCom(0x4A); //PCI

	tc1.DoISR(false);

	tc1.SendCom(0x5B);	// will generate an int (PCI ok, NAK reply for ISA)
						//Choose any Command wanted ie: 0x5B = MDOP status

	//JOSNER LAST
	tc1.closeTraceFile();

	tc1.closeAdrienne();
	
	return 0;
}


long __declspec(dllexport) CALLBACK startGenAdrienneTCCard(long TC)
{
	bool retval;

	retval = tc1.Start(TC);   

	//tc1.Write4(TC,0x0060);
	//tc1.SendCom(0x41);
	//tc1.SendCom(0x48);

	//tc1.SendCom(0x4E); //PCI
	//tc1.SendCom(0x4B); //PCI
	if (retval) 
		return 1;
	else
		return 0;

}


long __declspec(dllexport) CALLBACK stopGenAdrienneTCCard(char * inArr)
{
	bool retval;
	
	retval = tc1.StopGen();

	//tc1.SendCom(0x49);
	//tc1.SendCom(0x4D); //PCI
	//tc1.SendCom(0x4A); //PCI

	DWORD dwTemp1 = tc1.Read4(0x0040);
	sh1.DWStrTm(dwTemp1, inArr);

	if (retval) 
		return 1;
	else
		return 0;
}


long __declspec(dllexport) CALLBACK timerExternalCallAdrienneTCCard(char * inArr)
//long __declspec(dllexport) CALLBACK initializeAdrienneTCCard(const wchar_t *adrienneInitStr)
{
	BOOL papRet;
	long LoopArr;
	int i = 0;
	BOOL bGotInt = false;

	DWORD dwTemp1 = tc1.Read4(0x0040);
	sh1.DWStrTm(dwTemp1, inArr);

	return 0;
}



long __declspec(dllexport) CALLBACK initializeAdrienneTCCard(char * inArr, long ArrSize)
//long __declspec(dllexport) CALLBACK initializeAdrienneTCCard(const wchar_t *adrienneInitStr)
{
	static char title_id[60];
	char AddrStr[10];
	long retvalue;


	//JOSNER LAST
	tc1.initTraceFile();



	boardNum = tc1.GetCountRegistered();	//
	if (tc1.GetCountFound() != 0)
	{
		iSelected = 0;	//the CAec class sets this program to use the FIRST board
						//that is FOUND by search (0 based index)
		strcpy(title_str, title_strBase);
		strcat(title_str, tc1.GetStrId(title_id));
		strcat(title_str, "h1h (Address ");
		strcat(title_str, sh1.WStr(tc1.BrdAddr(), AddrStr));
		strcat(title_str, ")");
		retvalue = 1;
	}
	else{ 	
		strcat(title_str, "(no board found)");
		retvalue = 0;
	}

    lpPassToAECDLLrev = (LPSTR) &rev;
	aecint = tc1.GetDll_info(lpPassToAECDLLrev);
	

	// **NEW**
	// This is important!! Make this program has the Priority that you
	// want it to have. I have decided that I want this program to run
	// as close as possible to REAL_TIME (highest Priority)
	// or interrupts will not be processed quickly enough



	//JOSNER LAST
	SetPriorityClass( GetCurrentProcess(), REALTIME_PRIORITY_CLASS );



	//11-25-02 ADD NEXT BACK
	tc1.OrIntEnables(0x3F);	//set all bits of int enables - bits 0-6	


	InitGenStatusAll();
	

	tc1.initAdrienne();


	bool retvalSetupPci;
	retvalSetupPci = tc1.SetupPci(true);
	char setuppcinfo[16];
	if (retvalSetupPci)
		wsprintf (setuppcinfo,"/SetupPci T/");
	else 
		wsprintf (setuppcinfo,"/SetupPci F/");


	bool retvalDoISR;
	Sleep(50);
	//tc1.ISRthread();
	retvalDoISR = tc1.DoISR(true);		
	Sleep(50);
	
	char doisrinfo[10];
	if (retvalDoISR)
		wsprintf (doisrinfo,"/DoISR T/");
	else 
		wsprintf (doisrinfo,"/DoISR F/");


	if (tc1.exiting) 
		wsprintf (dllinfo," (NOT ISR) AEC_NTTC.DLL '%c%c'", rev[0], rev[1]);
	else
		wsprintf (dllinfo," (ISR) AEC_NTTC.DLL '%c%c'", rev[0], rev[1]);


	char cktypeinfo[10];
	wsprintf (cktypeinfo," CKTYPE: %d", tc1.CkType);

	strcat(title_str, setuppcinfo);
	strcat(title_str, doisrinfo);
	strcat(title_str, cktypeinfo);
	strcat(title_str, dllinfo);

	long LoopArr; // Loop variable
    // Make sure they didn't pass anything silly
    if (ArrSize < 1) return 0;
    // Fill the array
    for (LoopArr = 0; LoopArr < ArrSize; LoopArr++) {
        inArr[LoopArr] = title_str[LoopArr];
    }

	return retvalue;	
}

long __declspec(dllexport) CALLBACK doPalAdrienneTCCard()
{

	// Get the current state settings and then send command 0x04
	//and then restore to the state upon return;	
	BYTE cmd;
	int frz, able;
	frz = 0;
	able = 0;

	cmd = (cmp0D & 0x0F) + 0x20;	//command 2xh (PCI ALL and ISA PC-VLTC)

	tc1.Ebu();	//put in the desired mode.
	tc1.SendCom(cmd);

	return 300;	
}

long __declspec(dllexport) CALLBACK doNTSCAdrienneTCCard()
{
	
	// Get the current state settings and then send command 0x03
	//and then restore to the state upon return;
	BYTE cmd;
	int frz, able;
	frz = 0;
	able = 0;
	
	cmd = (cmp0D & 0x0F) + 0x20;	//command 2xh (PCI ALL and ISA PC-VLTC)

	tc1.Smpte();	//put in the desired mode.
	Sleep(1);	//temp10_02
	tc1.SendCom(cmd);
	Sleep(1);	//temp10_02


	return 200;	
}

long __declspec(dllexport) CALLBACK doCinemaAdrienneTCCard()
{
	
	// Get the current state settings and then send command 0x03
	//and then restore to the state upon return;
	BYTE cmd;
	int frz, able;
	frz = 0;
	able = 0;
	
	cmd = (cmp0D & 0x0F) + 0x20;	//command 2xh (PCI ALL and ISA PC-VLTC)

	tc1.FilmHD();	//put in the desired mode.
	tc1.SendCom(cmd);


	return 400;	
}





