// CAec.h: interface for the CAec class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CAEC_H__DC1E002C_A39D_4E90_B56C_60C35385CFBB__INCLUDED_)
#define AFX_CAEC_H__DC1E002C_A39D_4E90_B56C_60C35385CFBB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//class CAec  
//{
//public:
//	CAec();
//	virtual ~CAec();
//
//};

//
// CAec.h header file
//
//
//#include "Aec_nttc.h"	// make sure that the aec_nttc.lib file
						// is in the link path
						// This can be done either by putting in link
						// path (Build / settings.../Link/Module)
						// OR directly inserting the file into
						// the project (Insert / File into Proj...).

#define		true	1
#define		false	0
#define		TRUE	1
#define		FALSE	0
#define		NONE	0x0000
#define		IOR		0x0095
#define		MMR		0x0090
#define		SMART	0x0050
#define		VLTC	0x0050
#define		LTC		0x0098
#define		VITC	0x0093
#define		BIT_7	0x80
#define		BIT_6	0x40
#define		BIT_5	0x20
#define		BIT_4	0x10
#define		BIT_3	0x08
#define		BIT_2	0x04
#define		BIT_1	0x02
#define		BIT_0	0x01
#define		L21DATA 0x80
#define		RXDATA  0x40
#define BIT7	0x80
#define BIT6	0x40
#define BIT5	0x20
#define BIT4	0x10
#define BIT3	0x08
#define BIT2	0x04

#define		MAXBUFFER 12000	//12000 bytes+status (at 38400 baud, will hold 2.5sec of RX (minimum))
//#define		MAXBUFFER 6000		//(60/sec x 100 sec) enough space for over 100 seconds of L21/XDS data


#include "unions.h"

struct CIsrThreadInfo
{
	int m_nInt1;
	int m_nInt2;
	int m_nSum;
	HWND m_pMainFrame;
	HWND m_hwndNotifyRecalcDone;
	HANDLE m_hEventStartRecalc;
	HANDLE m_hEventRecalcDone;
	HANDLE m_hEventKillRecalcThread;
	HANDLE m_hEventRecalcThreadKilled;
	int m_nRecalcSpeedSeconds;
	HWND m_hwndNotifyProgress;
};

// ###############################################################################
class CTimer
{
private:
	LARGE_INTEGER	lpFq, lpCnt1, lpCnt2;
	//LARGE_INTEGER  *lpFq, *lpCnt1, *lpCnt2;
	BOOL ok;
public:
	CTimer();
	BOOL Zero();
	int msT();
	DWORD SysTime(int frames);
	DWORD LocalTime(int frames);
};

// ###############################################################################
//	String / Character translation class functions
class CStrHex 
{
private:
	BYTE by[10];
	int i, j, k;
	DWORD dw, iw;
	int TotalFrames(DWORD wDat, int frm); //+
	char	NibChar(BYTE bt);
public:
	CStrHex();
	DWORD	ToHex(char *Ath);	//+
	BYTE	CHex(char c);		//+
	DWORD	IntBCD(int i);		//+
	BYTE	IntBcdByte(int iDat);	//+
	BYTE	WordBCD(WORD wDat);	//+
	BYTE	PackHex(char high, char low);	//+
	int		FramesDiff(DWORD dw1, DWORD dw2, int frames);
	char*	BStr(BYTE bt, char *chs);
	char*	WStr(WORD wd, char *chs);
	char*	DWStr(DWORD dw, char *chs);
	char*	DWStrTm(DWORD dw, char *chs);

};
// ###############################################################################
typedef struct _AECBrdFnd
	{
		WORD	Address;	
					//Value to be used in address field when calling DLL functions
		int		BrdCkType;	
					//Value from "CheckBoard (DLL)1=IOR,2=MMR,3=SMART (0 not saved)
	} AECBrdFnd, *PAECBrdFnd;

// ###############################################################################
class CAec {

private:
	CWinThread* m_pIsrWorkerThread;
	CIsrThreadInfo m_isrThreadInfo;
	BYTE ReadIntCodeISR();
	
	//josner comente aqui y puse public
	//BOOL SetupPci(BOOL StartStop);

	//UINT IsrThreadProc(LPVOID pParam /* CIsrThreadInfo ptr */);
	BOOL ResetSoftwareIntFlag(BOOL doit);
	//		~CAec();
	BYTE	autoall;
	BOOL	RXoverrun;
	BOOL	L21overrun;

	AECBrdFnd	AecBoard[16];	// hold data for up to 16 time code boards
							// that are found (if they are installed & registered).
							//AecBoard[x].Address
							//AecBoard[x].BrdCkType

	WORD	Addr;		//Value to be used in address field when calling DLL functions

	//josner comente aqui y puse public
	//int		CkType;		//Value from "CheckBoard (DLL)1=IOR,2=MMR,3=SMART (0 not saved)
	
	
	BYTE	Model;		//Holds data from offset 3EF (VLTC=50h,VITC=93h,LTC=98h)
	BYTE	BrdFE;		//set each time there is a read of register FEh of PCI board.
	BYTE	Id0;		//Data Byte from 3E0 First letter of ID
	BYTE	Id1;		//Data Byte from 3E1 Second letter of ID
	BYTE	Id2;		//Data Byte from 3E2 Third letter of ID
	BYTE	SLtr;		//Data Byte from 3E3 Board Software Revision letter
	BYTE	SNum;		//Data Byte from 3E4 Board Software Revision number
	BYTE	VerUp;		//Data Byte from 3E5 Upper byte of EPROM version
	BYTE	VerLow;		//Data Byte from 3E6 Lower byte of EPROM version
	BOOL	LRdr;		//True if board reads LTC
	BOOL	LGen;		//True if board gens LTC
	BOOL	VRdr;		//True if board reads VITC
	BOOL	VGen;		//True if board gens VITC
	BYTE	ModType;	//'3'=RDR, '5'=RG1, '6'=RG2, '7'=RG3, '8'=GEN
	BOOL	Serial;		//does time code board have serial option (no/yes)
	PVOID	PhysAddr;	//value of VOID pointer to board
	LPBYTE  lpBrd;		//value of BYTE pointer to board
	BOOL	pointer;	//Status (true/false) of lpBrd pointer
	int		selection;	//currently selected board
	int		backup;		//holds any int value as backup for restore

	char	strId[80];	//holds id string for each board Model and rev...
	char	str2[3];	//holds id byte (in ascii from 8h, PCI) for each PCI

		// bytes that hold command constants for the selected board
	BYTE intack, reset, smpte, ebu, idle, autoread, autogen, ltcjam;
	BYTE ltcread, vitcread, ltcgen, ltcrg, vtol, vitcgen, ltov;
	BYTE jamgenall, jamgentb, jamgenub, genstart, genstop;

		 // SERIAL option command constants 
	BYTE inituart, initrx, readrx, txstat, tx422en, tx422dis, txbreak;
	BYTE txbyte, txstr1, txstr2, txstr3, txstr4, txstr5 ,txstr6;
	BYTE txstr7, txstr8, txstr9, txstrA,  txstrB, txstrC, txstrD;
	BYTE txstrE, txstrF;
	BOOL SonySetup;
	char SonyStr[20];


	int		FoundCnt;	//number returned by 'Find()'
	int		RegCnt;		//value returned from DLL
	int		i;			//count variable
	BOOL	booltemp1, booltemp2, ok, ok2;
	WORD	Offset3Ex, RX, Offset0;
	WORD	OffsetR, OffsetW, OffsetRi, OffsetWi; // use 'i' for isr functions
//	WORD	OffsetIntEnables, OffsetIntPrePending, OffsetIntPending, OffsetIntCode, OffsetCommand;
	BYTE	OneBR, OneBW, OneBRi, OneBWi, OneDummy;//, 1;
	BYTE	modp_gp1; //PCI MODP group settings
	BYTE	modp_gp2; //PCI MODP group settings
	BYTE	modp_gp3; //PCI MODP group settings
	BYTE	modp_gp4; //PCI MODP group settings

	DWORD	FourBR, FourBW, FourBRi, FourBWi;
	DWORD	modp_settings;				//keeps a copy of the data used to set up the MODP

	volatile BYTE OneVol;
	volatile int tmrVol;
	volatile BOOL ISRpending;
	volatile BOOL CmdPending;

	BOOL	check(int i);	//+
	BOOL	CheckForSerial();//+		//Checks for 'Serial' option on Smart Boards
	void	Find(void);//+				// queries through all address for board
										// sets first board found as Selected
	void	Process_MODPin(); //process what the current MODP use is set for. read 20h-23h
	void	Process_MODPout(); //process what the current MODP use is set for. read 1Ch-1Fh
	void	Set_MODP_flags();

	BOOL	PutRxWStr();		//internal class handler for Rx event.
	BOOL	PutL21DwStr();		//internal class handler for L21 event.
	WSTR	RXs;				//data struct packet to hold rx dwords
	DWSTR	L21s;				//data struct packet to hold L21 dwords

    //josner
	CFile cfile_object;
	FILE *traceDecryptPlayer;



	CString stringByteTrace;
	CString stringWordTrace;
    int intByteTrace;

//----------------------------------//
public:

	//josner puse public 
	BOOL SetupPci(BOOL StartStop);
	int		CkType;		//Value from "CheckBoard (DLL)1=IOR,2=MMR,3=SMART (0 not saved)


	UINT ISRthread();
	int GetFoundCount();
	BOOL DoISR(BOOL start);
	BOOL PendingIntBuffered();
	void ResetL21Buffer();
	BOOL HasL21();
	BYTE GetCmpStatus();
	void SetGenModeControl(BYTE b);
	BYTE GetGenModeControl();
	BYTE GetGenSync();
	BOOL FilmHD();
	BOOL FilmAble();
	BOOL JamEB();
	BOOL WriteGenTUE(BOOL bt, DWORD tb, BOOL bu, DWORD ub, BOOL be,  BYTE eb);
	int GetDll_info(LPSTR s);
	int		ComTimeout;					// holds command ms timeout value
	int		IntTimeout;					// holds command ISR timout (ms)
	int		TCmodes();					// Bit field that passes Lrdr/gen & Vrdr/gen
										// similar to offset 3E8 mode status low nibble
	BYTE	bDbug;
volatile BYTE	ComAck;					// ACK value set after a command is sent
										//  This byte can be changed by ISR thread
volatile BOOL exiting;					// allows for safe thread exiting
volatile BOOL IntPending;				// Flag set when sending commands under ISR
volatile BOOL ISRRun;						// FLAG variable to alter operations if
										// running under ISR conditions
										// signals that ISR thread is running

			CAec();						//+
			~CAec();
	BOOL	CProcessIntCode(BYTE);		//this function will handle ALL processing of data
										//from the 0Fh "intcode" register.
										//Users will need to make changes to this method to
										//to implement custom features.

	BOOL	SetISRinUse(BOOL bit);		// Make this call to set the "BrdFE" bit 4.
	
										// This is automatically set with the PCI boards
										// when any command/poll/isr is done.
	BYTE	Read1(WORD offset);			//+ Read a byte from memory
	BOOL	Write1(BYTE byte, WORD offset); //+ Write a byte to given offset
	DWORD	Read4();					//+ reads dword (4 bytes) from offset 0
	DWORD	Read4(WORD offset);			//+ reads dword from offset
	BOOL	Write4(DWORD dwDat, WORD offset);//+ writes dword to offset
	DWORD	GetTimeRead();				//+ reads Seleted time bits
	DWORD	GetUserRead();				//+ reads Selected user bits
	BYTE	GetEBRead();				//+ reads Selected embedded bits
	DWORD	GetTimeGen();				//+ reads Gen. time bits
	DWORD	GetUserGen();				//+ reads Gen. user bits
	BYTE	GetEBGen();					//+ reads Gen. Embedded bits
	BOOL	SetComparatorTime(DWORD dwDat);	//+ write the comparator time to catch
	BOOL	StartComparator(BYTE Onebyte);	//+ start the comparator to catch time as requested
	BOOL	StopComparator();			//+ disable the comparator


	WORD	BrdAddr();					//+ address used with DLL calls
	int		BrdType();					//+ 1=IOR,2=MMR,3=SMART 
	BYTE	BrdModel();					//+ offset 3EF (VLTC=50h,VITC=93h,LTC=98h)
	BOOL	ReadsLtc();					//+	return LRdr
	BOOL	ReadsVitc();				//+	return VRdr
	BOOL	GensLtc();					//+	return LGen
	BOOL	GensVitc();					//+	return VGen
	BOOL	HasSerial();				//+	return Serial
	BYTE	ModelType();				//+	return ModType
	BOOL	Select(int i);				//+ selects the board in the structure as
										//+ current board in USE, RecordsSmart...
	BYTE	GetIntEnables();			//+ get the interrupt enable flag bits 
	BOOL	OrIntEnables(BYTE byte);	//+ set any of the interrupt enable flag bits that are set in the BYTE
	BOOL	AndIntEnables(BYTE byte);	//+ clear any of the interrupt enable flag bits that are NOT set int the BYTE
	BOOL	SetGenSync(BYTE byte);		//+ write byte to sync refernce control register
	BOOL	ResetSoftwareIntFlag();		//+ clear the software interrupt pending flag if it is set, enable next int.
	BYTE	GetSoftwareIntFlagAtBit0();	//+ read the flag that notifies of software interrupt pending
	BYTE	ReadIntCode();				//+ Read the interrupt code at register (fake for IOR/MMR)
	BOOL	GenModeStat();					//+ gen mode status check
	int		GetCountFound();			//+ Returns number of boards Found
	int		GetCountRegistered();		//+ Returns number of boards in the Registry
	BOOL	AutoRead();					//+ get reading board into reader mode
	BOOL	AutoGen();					//+ get gen board into gen mode
	BOOL	LJam();						//+ send jam reader data into gen
	BOOL	LReadMode();				//+ ltc reader mode only
	BOOL	VReadMode();				//+ vitc only read mode
	BOOL	LGenMode();					//+ gen ltc only
	BOOL	LRnGMode();					//+ read and gen ltc simultaneously
	BOOL	VtoLMode();					//+ vitc to ltc translate
	BOOL	VGenMode();					//+ vitc only gen mode
	BOOL	LtoVMode();					//+ ltc to vitc translate
	BOOL	JamTU();					//+ jam time and user

	BOOL	JamTB();					//+ jam time only

	BOOL	JamUB();					//+ jam user only


	void initAdrienne();
	void closeAdrienne();
	void printDebugStr(char* debstr);
	void initTraceFile();
	void closeTraceFile();


	BOOL	Start();					//+ make sure in gen mode and start generator 
	BOOL	Start(DWORD tb);			//+ make sure in gen mode, jam TB & start gen 
	BOOL	Start(DWORD tb, DWORD ub);	//+ make sure gen mode, jam all and start gen
	BOOL	StopGen();					//+ stop tc gen
	BOOL	ResetBrd();					//+ write reset to smart board
	BOOL	EnableNext();				//+ writes 00 to offset 3FF with waits ...
	BOOL	Smpte();					//+ put smart board into SMPTE/NTSC mode
	BOOL	Ebu();						//+ put smart board into EBU/PAL mode
	BOOL	Idle();						//+ put board into idle mode

	BYTE	ModeStatus();				//+ get byte from offset 3E8(current mode info)
	int		Refresh();//+				//+ returns the currently selected board index
	BYTE	SendCom(BYTE combyte);		//+ send command to offset 3FF
	char*	GetStrId(char* str);		//+ pass back the string with board ID
											//  char str[80];
	char*	Get3ExIDBytes(char* str);	//+ pass back all ID bytes from Offset 3Ex (0-F)
											//  char str[20];
		
	BOOL	SerialOp();					//+ Pass back the 'Serial' value
		// SERIAL OPTION FUNCTIONS
	BOOL	InitSonySerial();			//+ inituart 38400/8/o/1/RS422 TX enabled
	BOOL	InitSerial();				//+ inituart command is sent
	BOOL	InitSerial(int Baud, int Bits, char P);	//+ with given parameters
	BOOL	InitSerial(int Baud, int Bits, char P, int M); //+ with given parameters
	BOOL	InitRx();					//+ init rx
	WORD	RxByte();					//+ rx (high) and status (low)bytes into Word
	//BYTE	TxStatus();					//+ tx status, see TxBusy
	BOOL	TxBusy();					//+ tx is busy
	BOOL	TxEn();						//+ tx422enable
	BOOL	TxDis();					//+ tx422disable
	BOOL	TxBreak();					//+ tx break character
	BOOL	TxByte(BYTE txOne);			//+ tx byte parameter
	BOOL	TxS1();						//+ tx str that is at position 1
	BOOL	TxS2();						//+ tx str that is at position 2
	BOOL	TxS3();						//+ tx str that is at position 3
	BOOL	TxS4();						//+ tx str that is at position 4
	BOOL	TxS5();						//+ tx str that is at position 5
	BOOL	TxS6();						//+ tx str that is at position 6
	BOOL	TxS7();						//+ tx str that is at position 7
	BOOL	TxS8();						//+ tx str that is at position 8
	BOOL	TxS9();						//+ tx str that is at position 9
	BOOL	TxS10();					//+ tx str that is at position 10
	BOOL	TxS11();					//+ tx str that is at position 11
	BOOL	TxS12();					//+ tx str that is at position 12
	BOOL	TxS13();					//+ tx str that is at position 13
	BOOL	TxS14();					//+ tx str that is at position 14
	BOOL	TxS15();					//+ tx str that is at position 15
	BYTE	RxSony(char* S);			//+ rx a Sony P2 protocol string, returns
											// a non-zero value if an error occured
											// will write the rx data into string S
	BYTE	SonyNAK(LPSTR);				//Returns non-zero with NAK data byte IF Nak
	BOOL	CheckSonyRX(LPSTR);			//Returns FALSE if Nak or error, Else TRUE

	BOOL	TxSony(int j, char* B);		//+ tx str 'B' from position j (1-F)
	BOOL	TxSony(int j);				//+ tx str loaded prior from position j (1-F)
	BOOL	LoadSonyStr(int j, char *B);//+ format string 'B' and save at position j
	BOOL	Play();						//+ send this 'Sony Protocol' Command
	BOOL	Stop();						//+ send this 'Sony Protocol' Command
	BOOL	Pause();					//+ send this 'Sony Protocol' Command
	BOOL	Record();					//+ send this 'Sony Protocol' Command
	BOOL	FastForward();				//+ send this 'Sony Protocol' Command
	BOOL	Rewind();					//+ send this 'Sony Protocol' Command
	BOOL	Eject();					//+ send this 'Sony Protocol' Command
	BOOL	Tmr1_reset();				//+ send this 'Sony Protocol' Command
	BOOL	Tmr1();						//+ send this 'Sony Protocol' Command
	BOOL	LTCc();						//+ send this 'Sony Protocol' Command
	BOOL	VITCc();					//+ send this 'Sony Protocol' Command
	BOOL	Status();					//+ send this 'Sony Protocol' Command 0-8

	BOOL	Status(BYTE stat);			//+ Status with start and length parameter 
	BOOL	Cue(BYTE hh, BYTE mm, BYTE ss, BYTE ff);
										//+ send this Command 'GoTo Time'
	BOOL	ShtlF(BYTE speed);			//+ shuttle forward at 'speed' Command
	BOOL	ShtlR(BYTE speed);			//+ shuttle reverse at 'speed' Command
	BOOL	UseTC();					//+ use Timecode (not CTL) mode Command
	BOOL	UseCtl();				//+ use Timer1/CTL (not timecode) mode Command
	BOOL	TMS();					//+ request time mode 'currently in use' Command

	BOOL    LoadTxString(int j, int Len, char* chS);//
							// transfer string 'chS' of 'Len' length to TX buffer 'j'


	BOOL	Any_event();			//will be true if any ?_event status is TRUE; (means there is stuff to update)
	TCDATA tcR;				//structure to hold the most current "reader" data
	int		GetL21DwCnt();			//Method to find out how much data there is in class buffer.
	//int		GetL21DwStr(LPSTR, int); //Have class put string data into LPSTR up to max data (int) length. (return len).
	int		GetL21DwStr(LPDWORD, int); //Have class put DWORD data into LPDWORD str. up to max data (int) length. (return len).
	TCDATA tcG;					//structure to hold the most current "gen" data
	int		vidCounter;				//count of video fields since last reset of count
	int		GetRxWCnt();			//Method to find out how much data there is in class buffer.
	int		GetRxWStr(LPWORD, int); //Have class put string data into LPSTR up to max data (int) length.  (return len).


volatile BOOL	brk_event;			//received intcode
volatile BOOL	tx_event;			//received intcode
volatile BOOL	nak_event;			//received intcode
volatile BOOL	cmd_event;		// processing of int code was for command.
volatile BYTE	cmd_ret;					// holds a copy of a "command response" code that was processed.
volatile BOOL	cmp_event;			//received intcode
volatile BOOL	rx_event;			//received intcode
volatile BOOL	gen_event;			//received intcode
volatile BOOL	vid_event;			//received intcode
volatile BOOL	L21_event;			//received intcode
volatile BOOL	read_event;			//received intcode
	


//	DWORD	AsciiToHex(LPSTR);			//Converst ascii string into 4byte PackedHex
//	DWORD	AsciiToHex(LPSTR);			//Converst ascii chars into 4byte PackedHex
//	DWORD	AsciiToHex(LPSTR);			//Converst ascii chars into 4byte PackedHex
//	DWORD	AsciiToHex(LPSTR);			//Converst ascii chars into 4byte PackedHex
//	int		CharToHex(BYTE);			//Converts ascii char into hex (0-F)

//	BOOL	SetVitcLines(void);			//Sets VITC generator board vitc lines 1&2
//	BOOL	SetSyncToVideo(void);		//Sets board to Gen synced to video
//	BOOL	JamUB(DWORD);				//Write UB dword and sends Jam command
//	BOOL	JamTB(DWORD);				//Write TB dword and sends Jam command
//	BOOL	GenRun(void);				//Starts the board generator
//	DWORD	GetTime(void);				//Reads the pc time and converts to dword (hex)
//	BYTE	WordToBCD(WORD);			//binary word to packed bcd
//	BOOL	CompareTime(DWORD, DWORD, int);	//Checks to see if 2 dword (hex) are same
//	void	UpdateGen(void);			//rejam the generator with new time data
//	void    SendReset(void);			//sends the reset command to primary board
//	int		RXs(PBYTESTR, WORD); 			//receive string
//	BOOL	TX(BYTE, WORD);				//send command byte to 3FF to TX string
//	BOOL	initRx(WORD);				//initialize RX buffer
//int		Slower(void);				//
//int		Faster(void);				//
//int		Shtl_fwd(void);				//
//int		Shtl_rev(void);				//
//int		CueTo(void);				//
//	BOOL	LookForGen(int);			//Checks board for Generation capability
//	int		FindOneGenBoard(int);		//Looks for a single board with Gen...
//	BOOL	InitBrdDataSet(int);		//initializes DPRAM of Gen board


};

// ###############################################################################


#endif // !defined(AFX_CAEC_H__DC1E002C_A39D_4E90_B56C_60C35385CFBB__INCLUDED_)
