#include "stdafx.h"
#include <dshow.h>
#include <atlbase.h>
#include <initguid.h>
#include <dvdmedia.h>
#include <iostream>
#include "resource.h"
#include "dshowutil.h"

#include <Qedit.h>
#include <stdio.h>
#include <stdlib.h>


#include <windows.h>
#include <stdio.h>
#include <streams.h>
#include <string.h>
#include <Vfw.h>
//2014
#include "dllutil.h"
#include <fstream.h>
using namespace std;
#include <Commdlg.h>
//2010
#include "QTSource.h"

#include "grabber.h"


CComModule _Module;
//CComModule

#define WM_GRAPHEVENT	WM_USER		
#define HELPER_RELEASE(x)   if (x != NULL) \
                            { \
                                x->Release(); \
                                x = NULL; \
                            }

#define INITGUID	
DEFINE_GUID(CLSID_GDCLMpeg4Demultiplexor,
0x025BE2E4, 0x1787, 0x4DA4, 0xA5, 0x85, 0xC5, 0xB2, 0xB9, 0xEE, 0xB5, 0x7C);

#define INITGUID	
DEFINE_GUID(CLSID_FFDShowVideoDecoder,
0x04FE9017, 0xF873, 0x410E, 0x87, 0x1E, 0xAB, 0x91, 0x66, 0x1A, 0x4E, 0xF7);

#define INITGUID	
DEFINE_GUID(CLSID_FFDShowAudioDecoder,
0x0F40E1E5, 0x4F79, 0x4988, 0xB1, 0xA9, 0xCC, 0x98, 0x79, 0x4E, 0x6B, 0x55);

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef DWORD COLORREF;
#define BGR(b,g,r) ((COLORREF)((((BYTE)(b)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(r))<<16))));
#define BGRA(b,g,r,a) ((COLORREF)((((BYTE)(b)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(r))<<16))|(((DWORD)(BYTE)(a))<<24)));
#define GetABValue(bgra) ((BYTE)(bgra));
#define GetAGValue(bgra) ((BYTE)((bgra)>> 8));
#define GetARValue(bgra) ((BYTE)((bgra)>>16));
#define GetAAValue(bgra) ((BYTE)((bgra)>>24));

#include <stdint.h>
typedef uint8_t uint8;
typedef uint64_t uint64;
#define UINT64_C(val) val##ui64


CComPtr<IGraphBuilder> g_pGraphBuilder;
CComPtr<ICaptureGraphBuilder2> pBuilder;
CComPtr<IBaseFilter> pFileSourceAsync;
CComPtr<IBaseFilter> pGDCLMpeg4Demultiplexor;
CComPtr<IBaseFilter> pffhshowVideoDecoder;
CComPtr<IBaseFilter> pSampleGrabberSubt;
CComPtr<IBaseFilter> pSampleGrabber;
CComPtr<IBaseFilter> pVideoMixingRenderer9;
CComPtr<IBaseFilter> pffhshowAudioDecoder;
CComPtr<IBaseFilter> pSampleGrabberAud;
CComPtr<IBaseFilter> pDirectSoundDevice;

IMediaSeeking*	g_pMediaSeeking = NULL;
IBasicAudio*	g_pBasicAudio = NULL;
IMediaControl*	g_pMediaControl;
IMediaEventEx*	g_pMediaEvent;
IVideoWindow* g_pVideoWindow;

ISampleGrabber* pGrabber2;

//IQTSource*  iQTFilter;


REFERENCE_TIME rtTotal=0;
REFERENCE_TIME rtNow=0;
HWND hWndMedula;
HRESULT hr;
long total,countSeek=6;
bool scramvideo;
bool isVideoEnc;
bool isAudioEnc;
LONGLONG dur;
long wpdGl;
long fpsVidGlob;

bool BitmapPresent,BitmapPresentPrev,changingSubtitle,useNewVideoMixing,keepPreviousFrame;

long buffSizeUsed;

HWND hwndApp;

int pixel1r,pixel2r,pixel3r,pixel4r,pixel5r,pixel1g,pixel2g,pixel3g,pixel4g,pixel5g,pixel1b,pixel2b,pixel3b,pixel4b,pixel5b;
INT * ptPixels;

int videoWidth,videoHeight;
bool esVideoMov;
double frameRate;

bool g_bUseMMX;

#define TRANSPARENCY_VALUE   (1.0f)
#define PURE_WHITE          RGB(255,255,255)
#define ALMOST_WHITE        RGB(250,250,250)
#define BLEND_TEXT          TEXT("This is a .\0")
#define DYNAMIC_TEXT_SIZE   255
#define DEFAULT_FONT_NAME   TEXT("Comic Sans MS\0")
#define DEFAULT_FONT_STYLE  TEXT("Bold\0")
#define DEFAULT_FONT_SIZE   12
#define DEFAULT_FONT_COLOR  RGB(255,255,255)
#define MAX_FONT_SIZE		25
HFONT g_hFont=0;
LONG g_lFontPointSize   = DEFAULT_FONT_SIZE;
COLORREF g_rgbColors    = DEFAULT_FONT_COLOR;
TCHAR g_szFontName[100] = {DEFAULT_FONT_NAME};
TCHAR g_szFontStyle[32] = {DEFAULT_FONT_STYLE};

//aqui
HBITMAP DirectBitmap;

const wchar_t *fontNameI;
long fontPointSizeI,edgeSizeI,fontBoldI,fontItalicI,fontColorRedI,fontColorGreenI,fontColorBlueI,edgeColorI,edgeColorRedI,edgeColorGreenI,edgeColorBlueI,fontCharSetI;

FILE *traceDecryptPlayer;
bool debugMode;
bool creatingNewFrame;

int QTTCFrames;
bool firstPause;
int offsetQT;
bool pasadaVideoBuffer;
double totalSecsStop;
double gCurrentSecsTC;
double gCurrentSampleTime;
bool filtersConnected;
bool firstTime;
bool isPlaying;

BOOL hrcheck(HRESULT hr, TCHAR* errtext)
{
	if (debugMode)
	{
	 fwprintf(traceDecryptPlayer, errtext);
	 fwprintf(traceDecryptPlayer, L"\n");
	}
	if (hr >= S_OK)
		return FALSE;
	TCHAR szErr[MAX_ERROR_TEXT_LEN];
	DWORD res = AMGetErrorText(hr, szErr, MAX_ERROR_TEXT_LEN);
	if (res)
		printf("Error %x: %s\n%s\n", hr, errtext, szErr);
	else
		printf("Error %x: %s\n", hr, errtext);
	return TRUE;
}

#define CHECK_HR(hr,msg) if(hrcheck(hr, msg)) return hr;


void printDebugStr(char* debstr)
{
	if (debugMode)
	{
	 fprintf(traceDecryptPlayer, debstr);
	 fprintf(traceDecryptPlayer, "\n");
	}
}

																																																					//BOOL bSetItalic, BOOL bSetBold
HFONT SetTextFont(const wchar_t *fontName, long fontPointSize, long edgeSize, long fontBold, long fontItalic, long fontColorRed, long fontColorGreen, long fontColorBlue, long edgeColorRed, long edgeColorGreen, long edgeColorBlue, long fontCharSet)
{
	CHOOSEFONT cf={0}; 
    LOGFONT lf={0}; 
    HFONT hfont; 
    HDC hdc;
    LONG fontHeight;

	//font name
	lstrcpyn(lf.lfFaceName, fontName,32);

	//font size
    hdc = GetDC( hwndApp );
    fontHeight = -MulDiv( fontPointSize, GetDeviceCaps(hdc, LOGPIXELSY), 72 );
    ReleaseDC( hwndApp, hdc );
	lf.lfHeight = fontHeight;      
	
	//font quality
	lf.lfQuality = ANTIALIASED_QUALITY;

	//font charset         
	lf.lfCharSet = fontCharSet;

	// Initialize members of the CHOOSEFONT structure. 
    cf.lStructSize = sizeof(CHOOSEFONT); 
    cf.hwndOwner   = hwndApp; 
    cf.hDC         = (HDC)NULL; 
    cf.lpLogFont   = &lf; 
    cf.iPointSize  = fontPointSize * 10;  
    cf.lCustData   = 0L; 
    cf.lpfnHook    = (LPCFHOOKPROC)NULL; 
    cf.hInstance   = (HINSTANCE) NULL; 
    cf.nFontType   = SCREEN_FONTTYPE; 
    cf.nSizeMin    = 0; 
    cf.lpTemplateName = NULL; 
    cf.Flags = CF_SCREENFONTS | CF_SCALABLEONLY | CF_INITTOLOGFONTSTRUCT | CF_EFFECTS     | CF_USESTYLE     | CF_LIMITSIZE; 

	if (fontBold==1)
		cf.lpLogFont->lfWeight = FW_BOLD;
	else if (fontBold==2)
		cf.lpLogFont->lfWeight = FW_SEMIBOLD;
	else
		cf.lpLogFont->lfWeight = FW_REGULAR;

	if (fontItalic==1)
		cf.lpLogFont->lfItalic = TRUE;
	else
		cf.lpLogFont->lfItalic = FALSE;
	
    // Create a logical font based on the user's selection   
    hfont = CreateFontIndirect(cf.lpLogFont);
	return (hfont); 
	
}

long _cdecl ChangeFont(const wchar_t *fontNameP, long fontPointSizeP, long edgeSizeP, long fontBoldP, long fontItalicP, long fontColorRedP, long fontColorGreenP, long fontColorBlueP, long edgeColorRedP, long edgeColorGreenP, long edgeColorBlueP, long fontCharSetP)
{
	fontNameI = fontNameP;
	fontPointSizeI=fontPointSizeP;
	edgeSizeI=edgeSizeP;
	fontBoldI=fontBoldP;
	fontItalicI=fontItalicP;
	
	fontColorRedI=fontColorRedP;
	fontColorGreenI=fontColorGreenP;
	fontColorBlueI=fontColorBlueP;

	edgeColorRedI=edgeColorRedP;
	edgeColorGreenI=edgeColorGreenP;
	edgeColorBlueI=edgeColorBlueP;

	fontCharSetI=fontCharSetP;

	return 1;
}

long __cdecl ChangeSubtitle(const wchar_t *firstString,long fsx,long fsy,long fsi,const wchar_t *secondString,long ssx,long ssy,long ssi, long alignment)
{
	
	if (creatingNewFrame)
	{
		while(creatingNewFrame)
		{
			Sleep(1);
		}
	}

	changingSubtitle = true;
    printDebugStr( "ChangeSubtitle called_____________");

	BitmapPresentPrev = BitmapPresent;
	BitmapPresent=false;

	if(DirectBitmap)
	DeleteObject(DirectBitmap);

	const TCHAR *szText;  
	szText = firstString;

	const TCHAR *szText1;    
	szText1 = secondString;

	HDC hdc = GetDC(hwndApp);
	HDC hdcBmp = CreateCompatibleDC(hdc);

    printDebugStr( "1__Compatible DC created.");

	int nLength,nLength1; 
	int nTextBmpHeight,nTextBmpWidth;
	SIZE sz={0};
	nLength = (int) _tcslen(szText);
	nLength1 = (int) _tcslen(szText1);
	GetTextExtentPoint32(hdcBmp, szText, nLength, &sz);
	
	//2010
	nTextBmpHeight = videoHeight;//sz.cy;
	nTextBmpWidth  = videoWidth;//sz.cx;

	// Create and Select our bitmap into the device context and save the old
	HBITMAP hbm = CreateCompatibleBitmap(hdc, nTextBmpWidth, nTextBmpHeight);
	BITMAP bm;
	HBITMAP hbmOld;
	GetObject(hbm, sizeof(bm), &bm);
	hbmOld = (HBITMAP)SelectObject(hdcBmp, hbm);

	printDebugStr( "2__Bitmap into the device.");

	// Set initial bitmap settings
	SetBkColor(hdcBmp, RGB(192, 192, 192)); 
    int newColorText;
	newColorText = BGR(fontColorRedI,fontColorGreenI,fontColorBlueI);
	SetTextColor(hdcBmp, newColorText);   

	HBRUSH hbrBackground;
	hbrBackground = CreateSolidBrush(RGB(192, 192, 192));
	SelectObject(hdcBmp, hbrBackground); 
	ExtFloodFill(hdcBmp,0,0,RGB(0, 0, 0),FLOODFILLSURFACE);
	SetBkMode(hdcBmp,TRANSPARENT);

	HPEN hpen, hpenOld;
    static int  iEnd[] = { PS_ENDCAP_ROUND, PS_ENDCAP_SQUARE, PS_ENDCAP_FLAT };
    static int  iJoin[]= { PS_JOIN_ROUND,   PS_JOIN_BEVEL,    PS_JOIN_MITER } ;
	LOGBRUSH lb;

	printDebugStr( "3__Bitmaps settings setted.\n");

	//Text Aligment General
	if (alignment == 0)
		SetTextAlign(hdcBmp,TA_CENTER);
	else if (alignment == 1)
		SetTextAlign(hdcBmp,TA_LEFT);
	else
		SetTextAlign(hdcBmp,TA_RIGHT);

	printDebugStr( "4__Text aligned.\n");
	
	///First Line
	g_hFont = SetTextFont((const wchar_t *)fontNameI,fontPointSizeI,edgeSizeI,fontBoldI,fsi,fontColorRedI,fontColorGreenI,fontColorBlueI,edgeColorRedI,edgeColorGreenI,edgeColorBlueI,fontCharSetI);
	HFONT hOldFont = (HFONT) SelectObject(hdcBmp, g_hFont);
	
    printDebugStr( "5__FIRST LINE: font setted.\n");

	////Smooth Zone
	lb.lbStyle = BS_SOLID ;
    lb.lbColor = RGB (0, 255, 0) ;
    lb.lbHatch = 0 ;
	hpen = ExtCreatePen (PS_SOLID | PS_GEOMETRIC | iEnd [0] | iJoin [0], edgeSizeI + 3, &lb, 0, NULL) ;
    hpenOld = (HPEN)SelectObject(hdcBmp, hpen);	
	BeginPath(hdcBmp);
	TextOut(hdcBmp, fsx, fsy, szText, nLength);
	EndPath(hdcBmp);
	StrokePath(hdcBmp);
	DeleteObject(hpen);

    printDebugStr( "6__FIRST LINE: smoothing zone.\n");

	////Borde
	lb.lbStyle = BS_SOLID ;
    lb.lbColor = RGB (edgeColorRedI, edgeColorGreenI, edgeColorBlueI) ; 
    lb.lbHatch = 0 ;
	hpen = ExtCreatePen (PS_SOLID | PS_GEOMETRIC  | iEnd [0] | iJoin [0], edgeSizeI, &lb, 0, NULL) ;
    hpenOld = (HPEN)SelectObject(hdcBmp, hpen);	
	BeginPath(hdcBmp);
	TextOut(hdcBmp, fsx, fsy, szText, nLength);
	EndPath(hdcBmp);
	StrokePath(hdcBmp);
	DeleteObject(hpen);

	printDebugStr( "7__FIRST LINE: border maked.\n");
	
	////Texto
	TextOut(hdcBmp, fsx, fsy, szText, nLength); 
	
	printDebugStr( "8__FIRST LINE: printed.\n");

    ///Second Line
	g_hFont = SetTextFont((const wchar_t *)fontNameI,fontPointSizeI,edgeSizeI,fontBoldI,ssi,fontColorRedI,fontColorGreenI,fontColorBlueI,edgeColorRedI,edgeColorGreenI,edgeColorBlueI,fontCharSetI);
	hOldFont = (HFONT) SelectObject(hdcBmp, g_hFont);

    printDebugStr( "9__SECOND LINE: font setted.\n");

	////Smooth Zone
	lb.lbStyle = BS_SOLID ;
    lb.lbColor = RGB (0, 255, 0) ;
    lb.lbHatch = 0 ;
	hpen = ExtCreatePen (PS_SOLID | PS_GEOMETRIC | iEnd [0] | iJoin [0], edgeSizeI + 3, &lb, 0, NULL) ;
    hpenOld = (HPEN)SelectObject(hdcBmp, hpen);	
	BeginPath(hdcBmp);
	TextOut(hdcBmp, ssx, ssy, szText1, nLength1);
	EndPath(hdcBmp);
	StrokePath(hdcBmp);
	DeleteObject(hpen);
	
	printDebugStr( "10__SECOND LINE: smoothing zone.\n");

	////Borde
	lb.lbStyle = BS_SOLID ;
    lb.lbColor = RGB (edgeColorRedI, edgeColorGreenI, edgeColorBlueI) ; 
    lb.lbHatch = 0 ;
	hpen = ExtCreatePen (PS_SOLID | PS_GEOMETRIC  | iEnd [0] | iJoin [0], edgeSizeI, &lb, 0, NULL) ;
    hpenOld = (HPEN)SelectObject(hdcBmp, hpen);	
	BeginPath(hdcBmp);
	TextOut(hdcBmp, ssx, ssy, szText1, nLength1);
	EndPath(hdcBmp);
	StrokePath(hdcBmp);
	DeleteObject(hpen);

	printDebugStr( "11__SECOND LINE: border maked.\n");

	////Text
	TextOut(hdcBmp, ssx, ssy, szText1, nLength1);

	printDebugStr( "12__SECOND LINE: printed.\n");

    //Subtitle Buffer Instance
	HBITMAP RetBmp=NULL;
	if (hbm)
	{	
		HDC BufferDC=CreateCompatibleDC(NULL);	// DC for Source Bitmap
		if (BufferDC)
		{
			HBITMAP hTmpBitmap = (HBITMAP) NULL;
			if (hdcBmp && hbm == (HBITMAP)GetCurrentObject(hdcBmp, OBJ_BITMAP))
			{
				hTmpBitmap = CreateBitmap(1, 1, 1, 1, NULL);
				SelectObject(hdcBmp, hTmpBitmap);
			}
			HGDIOBJ PreviousBufferObject=SelectObject(BufferDC,hbm);
			// here BufferDC contains the bitmap				
			HDC DirectDC=CreateCompatibleDC(NULL); // DC for working

			printDebugStr( "13__Buffer filled with subtitle bitmap.\n");

			if (DirectDC)
			{
				// Get bitmap size
				BITMAP bm;
				GetObject(hbm, sizeof(bm), &bm);	
				// create a BITMAPINFO with minimal initilisation for the CreateDIBSection
				BITMAPINFO RGB32BitsBITMAPINFO; 
				ZeroMemory(&RGB32BitsBITMAPINFO,sizeof(BITMAPINFO));
				RGB32BitsBITMAPINFO.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
				RGB32BitsBITMAPINFO.bmiHeader.biWidth=bm.bmWidth;
				RGB32BitsBITMAPINFO.bmiHeader.biHeight=bm.bmHeight;
				RGB32BitsBITMAPINFO.bmiHeader.biPlanes=1;
				RGB32BitsBITMAPINFO.bmiHeader.biBitCount=32;

                printDebugStr( "14__Filling bitmap info for createDIBSection.\n");

				// pointer used for direct Bitmap pixels access				
				DirectBitmap = CreateDIBSection(DirectDC, (BITMAPINFO *)&RGB32BitsBITMAPINFO, DIB_RGB_COLORS,(void **)&ptPixels, NULL, 0);		
				if (DirectBitmap)
				{
					HGDIOBJ PreviousObject=SelectObject(DirectDC, DirectBitmap);
					BitBlt(DirectDC,0,0,bm.bmWidth,bm.bmHeight,BufferDC,0,0,SRCCOPY);
                    
                    printDebugStr( "15__Filling callback buffer with the data.\n");

					SelectObject(DirectDC,PreviousObject);		
					RetBmp=DirectBitmap;
				}
				if (DirectDC)
					DeleteDC(DirectDC);	
			}		
			SelectObject(BufferDC,PreviousBufferObject);
			
			//new
			if (BufferDC)
				DeleteDC(BufferDC);

			if (hTmpBitmap)
			{
				SelectObject(hdcBmp, RetBmp);
				DeleteObject(hTmpBitmap);
			}

			printDebugStr( "16__Returning to previous hdc and hbm.\n");
		}
	}

	if(DirectBitmap)
		BitmapPresent=BitmapPresentPrev;

	SelectObject(hdcBmp, hbmOld);
	//new
	if (hbm)
		DeleteObject(hbm);
    //new
	if (hdc)
		DeleteDC(hdc);
	//new
	if (hdcBmp)
		DeleteDC(hdcBmp);

	printDebugStr( "Exiting ChangeSubtitle____________\n");
	changingSubtitle = false;
	return 1;
}

long _stdcall ChangeFontCall(const wchar_t *fontNameP, long fontPointSizeP, long edgeSizeP, long fontBoldP, long fontItalicP, long fontColorRedP, long fontColorGreenP, long fontColorBlueP, long edgeColorRedP, long edgeColorGreenP, long edgeColorBlueP, long fontCharSetP)
{
	return ChangeFont(fontNameP,fontPointSizeP, edgeSizeP, fontBoldP,fontItalicP,fontColorRedP,fontColorGreenP,fontColorBlueP,edgeColorRedP,edgeColorGreenP,edgeColorBlueP,fontCharSetP);
}

long _stdcall ChangeSubtitleCall(const wchar_t *firstString,long fsx,long fsy,long fsi,const wchar_t *secondString,long ssx,long ssy,long ssi, long alignment)
{
	long csr;
	printDebugStr( "Entering ChangeSubtitleCall____________\n");
	csr = ChangeSubtitle(firstString,fsx,fsy,fsi,secondString,ssx,ssy,ssi,alignment);
	printDebugStr( "Exiting ChangeSubtitleCall____________\n");
	return csr;
}


class CSampleGrabberCB2 : public ISampleGrabberCB 
{
 public:
	long Width;
    long Height;
	long count;
	char *bufsizechar;
	bool firstBool; 
	int firstIndSub,lastIndSub;
	int bufferBitmSize;
	QT_TIMECODE qttimecode;
	BYTE onePixelBuffer[3];
	int pixel_index;
	int other_pixel_index;
	bool firsttime;

    STDMETHODIMP_(ULONG) AddRef() { return 2; }
    STDMETHODIMP_(ULONG) Release() { return 1; }

    STDMETHODIMP QueryInterface(REFIID riid, void ** ppv)
    {

		printDebugStr( "BufferCB Video");
        CheckPointer(ppv,E_POINTER);
        
        if( riid == IID_ISampleGrabberCB || riid == IID_IUnknown ) 
        {
            *ppv = (void *) static_cast<ISampleGrabberCB*> ( this );
            return NOERROR;
        }    
		firstBool = true;

        return E_NOINTERFACE;

	}
  
    STDMETHODIMP SampleCB( double SampleTime, IMediaSample * pSample )
    {
    
		return 0;
    }
 
    STDMETHODIMP BufferCB( double SampleTime, BYTE * pBuffer, long BufferSize )
    { 
		
		bufferBitmSize=Width*Height;

		if (!changingSubtitle)
        {
		creatingNewFrame=true;
		if (BitmapPresent) 
		{
			int pixelref = ptPixels[0];
			int color1= GetARValue(pixelref);
			int color2= GetAGValue(pixelref);
			int color3= GetABValue(pixelref);

			printDebugStr( "BufferCB BitmapPresent**");

			for (int i=0;i<=(bufferBitmSize-2);i++)
			{
					int pixel1;
					unsigned int acolor,rcolor,gcolor,bcolor; 				
					pixel1 = ptPixels[i];
					acolor =GetAAValue(pixel1);
					rcolor=GetARValue(pixel1);
					gcolor=GetAGValue(pixel1);
					bcolor=GetABValue(pixel1);
					
					if (!(rcolor==color1 && gcolor==color2 && bcolor==color3)&&!(rcolor==0 && gcolor==255 && bcolor==0))//(rcolor!=192 && gcolor!=192 && bcolor!=192)
					{
						pBuffer[(i*3)]=rcolor;
						pBuffer[(i*3)+1]=gcolor;
						pBuffer[(i*3)+2]=bcolor;
					}
			}

            printDebugStr( "BufferCB ptPixels copied in frame**");

			for (i=0;i<=(bufferBitmSize-2);i++)
			{
				INT pixel1;
				unsigned int acolor,rcolor,gcolor,bcolor; 
				pixel1 = ptPixels[i];	
				acolor =GetAAValue(pixel1);
				rcolor=GetARValue(pixel1);
				gcolor=GetAGValue(pixel1);
				bcolor=GetABValue(pixel1);
					
				if (!(rcolor==192 && gcolor==192 && bcolor==192))
				{
					pixel1r = pixel2r = pixel3r = pixel4r = pixel5r = pBuffer[(i*3)];
					pixel1g = pixel2g = pixel3g = pixel4g = pixel5g = pBuffer[(i*3)+1];
					pixel1b = pixel2b = pixel3b = pixel4b = pixel5b = pBuffer[(i*3)+2];
					
					if (i <= (buffSizeUsed/3)-1-1)
					{
						pixel2r = pBuffer[((i*3))+3];
						pixel2g = pBuffer[((i*3)+1)+3];
						pixel2b = pBuffer[((i*3)+2)+3];
					}
					if (i <= (buffSizeUsed/3) - (Width*3/3)-1)
					{
						pixel3r = pBuffer[((i*3))+(Width*3)];
						pixel3g = pBuffer[((i*3)+1)+(Width*3)];
						pixel3b = pBuffer[((i*3)+2)+(Width*3)];
					}
					if (i >= Width*3/3)
					{
						pixel4r = pBuffer[((i*3))-(Width*3)];
						pixel4g = pBuffer[((i*3)+1)-(Width*3)];
						pixel4b = pBuffer[((i*3)+2)-(Width*3)];
					}
					if (i >= 3/3)
					{
						pixel5r = pBuffer[((i*3))-3];
						pixel5g = pBuffer[((i*3)+1)-3];
						pixel5b = pBuffer[((i*3)+2)-3];
					}
		
					if ((rcolor==0 && gcolor==255 && bcolor==0))
					{
						pBuffer[(i*3)]= (pixel2r+pixel3r+pixel4r+pixel5r)/4;
						pBuffer[(i*3)+1]= (pixel2g+pixel3g+pixel4g+pixel5g)/4;
						pBuffer[(i*3)+2]= (pixel2b+pixel3b+pixel4b+pixel5b)/4;
					}
					else
					{
						pBuffer[(i*3)]= ((pixel1r*20)+pixel2r+pixel3r+pixel4r+pixel5r)/24;
						pBuffer[(i*3)+1]= ((pixel1g*20)+pixel2g+pixel3g+pixel4g+pixel5g)/24;
						pBuffer[(i*3)+2]= ((pixel1b*20)+pixel2b+pixel3b+pixel4b+pixel5b)/24;
					}

				}
			}

			printDebugStr( "BufferCB frame antialiased**\n");

		}

		creatingNewFrame=false;
		}

		if (esVideoMov){
			gCurrentSampleTime = SampleTime;
			if (pasadaVideoBuffer){
				//iQTFilter->GetLastTimecode(&qttimecode);
				totalSecsStop = 0;//((qttimecode.btHours * 3600) + (qttimecode.btMinutes * 60) + qttimecode.btSeconds + ((qttimecode.btFrames - offsetQT)/frameRate));
				pasadaVideoBuffer = false;
			}
			else{

			}
		}

		return 0;
    }
};

CSampleGrabberCB2 CB2;


CComPtr<IPin> GetPin(IBaseFilter *pFilter, LPCOLESTR pinname){
	CComPtr<IEnumPins> pEnum;
	CComPtr<IPin> pPin;

	HRESULT hr = pFilter->EnumPins (&pEnum);
	if (hrcheck(hr,L"enumerate pins."))
		return NULL;

	while(pEnum->Next(1,&pPin,0) == S_OK)
	{
		PIN_INFO pinfo;
		pPin->QueryPinInfo(&pinfo);
		BOOL found = !wcsicmp(pinname, pinfo.achName);
		if (found)
			return pPin;
		pPin.Release();
	}
	printf("Pin not found!\n");
	return NULL;
}



HRESULT ConnectFiltersA(IGraphBuilder *pGraph,IBaseFilter *pSou,int pinOutNum, IBaseFilter *pDest, int pinInNum)   
{
    if ((pGraph == NULL) || (pSou == NULL) || (pDest == NULL))
    {
        return E_POINTER;
    }

	HRESULT hr;

	CComPtr<IPin> pOut = GetOutPin(pSou,pinOutNum);
	CComPtr<IPin> pIn = GetInPin(pDest,pinInNum);

	hr = pGraph->Connect(pOut, pIn);
	
    return hr;
}

HRESULT DisconnectFiltersA(IGraphBuilder *pGraph,IBaseFilter *pSou,int pinOutNum, IBaseFilter *pDest, int pinInNum)   
{
    if ((pGraph == NULL) || (pSou == NULL) || (pDest == NULL))
    {
        return E_POINTER;
    }

	HRESULT hr;

	CComPtr<IPin> pOut = GetOutPin(pSou,pinOutNum);
	CComPtr<IPin> pIn = GetInPin(pDest,pinInNum);

	hr = pGraph->Disconnect(pIn);
	hr = pGraph->Disconnect(pOut);
		
    return hr;
}


HRESULT disconnectFilters(){ 

	HELPER_RELEASE(g_pMediaEvent);
    HELPER_RELEASE(g_pMediaControl);
	HELPER_RELEASE(g_pMediaSeeking);
	HELPER_RELEASE(g_pVideoWindow);
	HELPER_RELEASE(g_pBasicAudio);

	
	//DISCONNECT ffdshow Audio Decoder and Direct Sound Device Filters
	hr = g_pGraphBuilder->Disconnect(GetPin(pDirectSoundDevice,L"Audio Input pin (rendered)"));
	CHECK_HR(hr,L"Disconnect pDirectSoundDevice Audio");
	hr = g_pGraphBuilder->Disconnect(GetPin(pffhshowAudioDecoder,L"Out"));
	CHECK_HR(hr,L"Disconnect pffhshowAudioDecoder Out");

	if (isAudioEnc){
		//DISCONNECT SampleGrabber and ffdshow Audio Decoder Filters
		hr = g_pGraphBuilder->Disconnect(GetPin(pffhshowAudioDecoder,L"In"));
		CHECK_HR(hr,L"Disconnect pffhshowAudioDecoder In");
		hr = g_pGraphBuilder->Disconnect(GetPin(pSampleGrabberAud,L"Output"));
		CHECK_HR(hr,L"Disconnect pSampleGrabberAud Output");
		
		//DISCONNECT GDCL Mpeg-4 Demultiplexor and SampleGrabber Filters
		hr = g_pGraphBuilder->Disconnect(GetPin(pSampleGrabberAud,L"Input"));
		CHECK_HR(hr,L"Disconnect pSampleGrabberAud Input");
		hr = g_pGraphBuilder->Disconnect(GetPin(pGDCLMpeg4Demultiplexor,L"AAC Audio 2"));
		CHECK_HR(hr,L"Disconnect pGDCLMpeg4Demultiplexor AAC");
			
	}
	else{
		//CONNECT GDCL Mpeg-4 Demultiplexor and ffdshow Audio Decoder Filters
		hr = g_pGraphBuilder->Disconnect(GetPin(pffhshowAudioDecoder,L"In"));
		CHECK_HR(hr,L"Disconnect pffhshowAudioDecoder In");

		hr = g_pGraphBuilder->Disconnect(GetPin(pGDCLMpeg4Demultiplexor,L"AAC Audio 2"));
		CHECK_HR(hr,L"Disconnect pGDCLMpeg4Demultiplexor AAC");	

	}

	
	//CONNECT pSampleGrabberSubt and Video Mixing Renderer 9 Filters
	hr = DisconnectFiltersA(g_pGraphBuilder, pSampleGrabberSubt, 0, pVideoMixingRenderer9,0);
	CHECK_HR(hr,L"Disconnect pSampleGrabberSubt pVideoMixingRenderer9");

	//CONNECT ffdshow Video Decoder and pSampleGrabberSubt Filters
	hr = g_pGraphBuilder->Disconnect(GetPin(pSampleGrabberSubt,L"Input"));
	CHECK_HR(hr,L"Disconnect pSampleGrabberSubt Input");

	hr = g_pGraphBuilder->Disconnect(GetPin(pffhshowVideoDecoder,L"Out"));
	CHECK_HR(hr,L"Disconnect pffhshowVideoDecoder Out");

	if (isVideoEnc){
	
		//CONNECT SampleGrabber and ffdshow video decoder Filters
		hr = g_pGraphBuilder->Disconnect(GetPin(pffhshowVideoDecoder,L"In"));
		CHECK_HR(hr,L"Disconnect pffhshowVideoDecoder In");
		
		hr = g_pGraphBuilder->Disconnect(GetPin(pSampleGrabber,L"Output"));
		CHECK_HR(hr,L"Disconnect pSampleGrabber Output");
		
		//CONNECT GDCL Mpeg-4 Demultiplexor and SampleGrabber Filters
		hr = g_pGraphBuilder->Disconnect(GetPin(pSampleGrabber,L"Input"));
		CHECK_HR(hr,L"Disconnect pSampleGrabber Input");

		hr = g_pGraphBuilder->Disconnect(GetPin(pGDCLMpeg4Demultiplexor,L"H264 Video 1"));
		CHECK_HR(hr,L"Disconnect pGDCLMpeg4Demultiplexor H264 Video 1");
				
	}
	else{
		//CONNECT GDCL Mpeg-4 Demultiplexor and ffdshow video decoder Filters
		hr = g_pGraphBuilder->Disconnect(GetPin(pffhshowVideoDecoder,L"In"));
		CHECK_HR(hr,L"Disconnect pffhshowVideoDecoder In");

		hr = g_pGraphBuilder->Disconnect(GetPin(pGDCLMpeg4Demultiplexor,L"H264 Video 1"));
		CHECK_HR(hr,L"Disconnect pGDCLMpeg4Demultiplexor H264");
		
	}

	
	//CONNECT File Source (Async.) and GDCL Mpeg-4 Demultiplexor
	hr = g_pGraphBuilder->Disconnect(GetPin(pGDCLMpeg4Demultiplexor,L"Input"));
	CHECK_HR(hr,L"Disconnect pGDCLMpeg4Demultiplexor Input");

	hr = g_pGraphBuilder->Disconnect(GetPin(pFileSourceAsync,L"Output"));
	CHECK_HR(hr,L"Disconnect pFileSourceAsync Output");	

	
	g_pGraphBuilder->RemoveFilter(pFileSourceAsync);
	g_pGraphBuilder->RemoveFilter(pGDCLMpeg4Demultiplexor);
	g_pGraphBuilder->RemoveFilter(pffhshowVideoDecoder);
	g_pGraphBuilder->RemoveFilter(pSampleGrabberSubt);
	
	g_pGraphBuilder->RemoveFilter(pSampleGrabber);
	//g_pGraphBuilder->RemoveFilter(pVideoMixingRenderer9);
	g_pGraphBuilder->RemoveFilter(pffhshowAudioDecoder);
	
	g_pGraphBuilder->RemoveFilter(pSampleGrabberAud);
	g_pGraphBuilder->RemoveFilter(pDirectSoundDevice);
	
	filtersConnected = false;

	return 0;
}

HRESULT connectFilters(){  

	//CONNECT File Source (Async.) and GDCL Mpeg-4 Demultiplexor
	hr = g_pGraphBuilder->ConnectDirect(GetPin(pFileSourceAsync,L"Output"),GetPin(pGDCLMpeg4Demultiplexor,L"Input"),NULL);
	CHECK_HR(hr,L"connect File Source (Async.) and GDCL Mpeg-4 Demultiplexor Filters");

	if (isVideoEnc){
		//CONNECT GDCL Mpeg-4 Demultiplexor and SampleGrabber Filters
		hr = g_pGraphBuilder->ConnectDirect(GetPin(pGDCLMpeg4Demultiplexor,L"H264 Video 1"),GetPin(pSampleGrabber,L"Input"),NULL);
		CHECK_HR(hr,L"connect GDCL Mpeg-4 Demultiplexor and SampleGrabber Filters");

		//CONNECT SampleGrabber and ffdshow video decoder Filters
		hr = g_pGraphBuilder->ConnectDirect(GetPin(pSampleGrabber,L"Output"),GetPin(pffhshowVideoDecoder,L"In"),NULL);
		CHECK_HR(hr,L"connect SampleGrabber and ffdshow video decoder Filters");
	}
	else{
		//CONNECT GDCL Mpeg-4 Demultiplexor and ffdshow video decoder Filters
		hr = g_pGraphBuilder->ConnectDirect(GetPin(pGDCLMpeg4Demultiplexor,L"H264 Video 1"),GetPin(pffhshowVideoDecoder,L"In"),NULL);
		CHECK_HR(hr,L"connect GDCL Mpeg-4 Demultiplexor and ffdshow video decoder Filters");
	}

	if (isAudioEnc){
		//CONNECT GDCL Mpeg-4 Demultiplexor and SampleGrabber Filters
		hr = g_pGraphBuilder->ConnectDirect(GetPin(pGDCLMpeg4Demultiplexor,L"AAC Audio 2"),GetPin(pSampleGrabberAud,L"Input"),NULL);
		CHECK_HR(hr,L"connect GDCL Mpeg-4 Demultiplexor and pSampleGrabberAud Filters");

		//CONNECT SampleGrabber and ffdshow Audio Decoder Filters
		hr = g_pGraphBuilder->ConnectDirect(GetPin(pSampleGrabberAud,L"Output"),GetPin(pffhshowAudioDecoder,L"In"),NULL);
		CHECK_HR(hr,L"connect SampleGrabber and ffdshow Audio Decoder Filters");
	}
	else{
		//CONNECT GDCL Mpeg-4 Demultiplexor and ffdshow Audio Decoder Filters
			//CONNECT pSampleGrabberSubt and Video Mixing Renderer 9 Filters
		hr = ConnectFiltersA(g_pGraphBuilder, pGDCLMpeg4Demultiplexor, 1, pffhshowAudioDecoder,0);
		CHECK_HR(hr,L"connect GDCL Mpeg-4 Demultiplexor and ffdshow Audio Decoder Filters");
		//hr = g_pGraphBuilder->ConnectDirect(GetPin(pGDCLMpeg4Demultiplexor,L"AAC Audio 2"),GetPin(pffhshowAudioDecoder,L"In"),NULL);
		//CHECK_HR(hr,L"connect GDCL Mpeg-4 Demultiplexor and ffdshow Audio Decoder Filters");
	}

	//CONNECT ffdshow Video Decoder and pSampleGrabberSubt Filters
	hr = g_pGraphBuilder->ConnectDirect(GetPin(pffhshowVideoDecoder,L"Out"),GetPin(pSampleGrabberSubt,L"Input"),NULL);
	CHECK_HR(hr,L"connect ffdshow Video Decoder and pSampleGrabberSubt Filters");

	//CONNECT pSampleGrabberSubt and Video Mixing Renderer 9 Filters
	hr = ConnectFiltersA(g_pGraphBuilder, pSampleGrabberSubt, 0, pVideoMixingRenderer9,0);
	CHECK_HR(hr,L"connect pSampleGrabberSubt and Video Mixing Renderer 9 Filters");

	AM_MEDIA_TYPE mt;
    hr = pGrabber2->GetConnectedMediaType( &mt );
    VIDEOINFOHEADER * vih = (VIDEOINFOHEADER*) mt.pbFormat;
    CB2.Width  = vih->bmiHeader.biWidth;
    CB2.Height = vih->bmiHeader.biHeight; 
    FreeMediaType( mt );

	//CONNECT ffdshow Audio Decoder and Direct Sound Device Filters
	hr = g_pGraphBuilder->ConnectDirect(GetPin(pffhshowAudioDecoder,L"Out"),GetPin(pDirectSoundDevice,L"Audio Input pin (rendered)"),NULL);
	CHECK_HR(hr,L"connect ffdshow Audio Decoder and Direct Sound Device Filters");

	filtersConnected = true;
}

HRESULT setSourceFile(const wchar_t *wfilename){  

	CComQIPtr<IFileSourceFilter,&IID_IFileSourceFilter> pFileSourceAsync_src(pFileSourceAsync);
	if (!pFileSourceAsync_src)
		CHECK_HR(E_NOINTERFACE,L"get IFileSourceFilter");
	hr = pFileSourceAsync_src->Load(wfilename,NULL);
	CHECK_HR(hr, L"load file");	
}

HRESULT CreateGraphAndFilters()
{
	
	printDebugStr( "CreateGraphAndFilters");
	HRESULT hr; 
	
	//ADD FilterGraph
	g_pGraphBuilder.CoCreateInstance(CLSID_FilterGraph);
	CHECK_HR(hr, L"Create CLSID_FilterGraph");
	
	hr = pBuilder.CoCreateInstance(CLSID_CaptureGraphBuilder2);	
	CHECK_HR(hr, L"Create Capture Graph Builder");
	
	hr = pBuilder->SetFiltergraph(g_pGraphBuilder);
	CHECK_HR(hr, L"SetFilterGraph");

	//ADD File Source (Async.) filter
	hr = pFileSourceAsync.CoCreateInstance(CLSID_AsyncReader);
	CHECK_HR(hr,L"create File Source (Async.)");
	hr = g_pGraphBuilder->AddFilter(pFileSourceAsync,L"File Source (Async.)");
	CHECK_HR(hr,L"add File Source (Async.) to the graph");

	//ADD GDCL Mpeg-4 Demultiplexor
	hr = pGDCLMpeg4Demultiplexor.CoCreateInstance(CLSID_GDCLMpeg4Demultiplexor);
	CHECK_HR(hr,L"GDCL Mpeg-4 Demultiplexor");
	hr = g_pGraphBuilder->AddFilter(pGDCLMpeg4Demultiplexor,L"GDCL Mpeg-4 Demultiplexor");
	CHECK_HR(hr,L"add GDCL Mpeg-4 Demultiplexor to the graph");

	//ADD ffdshow Video Decoder
	hr = pffhshowVideoDecoder.CoCreateInstance(CLSID_FFDShowVideoDecoder);
	CHECK_HR(hr,L"create ffdshow Video Decoder");
	hr = g_pGraphBuilder->AddFilter(pffhshowVideoDecoder,L"ffdshow Video Decoder");
	CHECK_HR(hr,L"add ffdshow Video Decoder to the graph");

	//ADD pSampleGrabberSubt
	hr = pSampleGrabberSubt.CoCreateInstance(CLSID_SampleGrabber);
	CHECK_HR(hr,L"Create Sample Grabber Subt");
	hr = g_pGraphBuilder->AddFilter(pSampleGrabberSubt,L"SampleGrabber");
	CHECK_HR(hr,L"Add pSampleGrabberSubt to the graph");
	pSampleGrabberSubt->QueryInterface(IID_ISampleGrabber, (void**)&pGrabber2);
	pGrabber2->SetBufferSamples( FALSE );
	pGrabber2->SetCallback(&CB2,1);
	CMediaType GrabType2;
    GrabType2.SetType( &MEDIATYPE_Video );
    GrabType2.SetSubtype( &MEDIASUBTYPE_RGB24 );
    hr = pGrabber2->SetMediaType( &GrabType2 );
	CHECK_HR(hr,L"SetMediaType pSampleGrabberSubt");

	//ADD SAMPLEGRABBER
	hr = pSampleGrabber.CoCreateInstance(CLSID_GrabberSample);
	CHECK_HR(hr,L"Create Sample Grabber");
	hr = g_pGraphBuilder->AddFilter(pSampleGrabber,L"SampleGrabber");
	CHECK_HR(hr,L"Add SampleGrabber to the graph");

	//ADD Video Renderer
	hr = pVideoMixingRenderer9.CoCreateInstance(CLSID_VideoMixingRenderer9);
	CHECK_HR(hr,L"create Video Mixing Renderer 9");
	hr = g_pGraphBuilder->AddFilter(pVideoMixingRenderer9,L"Video Mixing Renderer 9");
	CHECK_HR(hr,L"add Video Mixing Renderer 9 to the graph");

	//ADD ffdshow Audio Decoder filter
	hr = pffhshowAudioDecoder.CoCreateInstance(CLSID_FFDShowAudioDecoder);
	CHECK_HR(hr,L"create ffdshow Audio Decoder");
	hr = g_pGraphBuilder->AddFilter(pffhshowAudioDecoder,L"ffdshow Audio Decoder");
	CHECK_HR(hr,L"add ffdshow Audio Decoder to the graph");

	//ADD SAMPLEGRABBERAUD
	hr = pSampleGrabberAud.CoCreateInstance(CLSID_GrabberSample);
	CHECK_HR(hr,L"Create Sample Grabber");
	hr = g_pGraphBuilder->AddFilter(pSampleGrabberAud,L"SampleGrabber");
	CHECK_HR(hr,L"Add SampleGrabber aud to the graph");

	//ADD Direct Sound Device filter
	hr = pDirectSoundDevice.CoCreateInstance(CLSID_DSoundRender);
	CHECK_HR(hr,L"create Direct Sound Device");
	hr = g_pGraphBuilder->AddFilter(pDirectSoundDevice,L"Direct Sound Device");
	CHECK_HR(hr,L"add Direct Sound Device to the graph");

	return S_OK;
    
}


void CleanUpDirectShow()
{
	printDebugStr( "\CleanUpDirectShow");
	HELPER_RELEASE(g_pMediaEvent);
    HELPER_RELEASE(g_pMediaControl);
	HELPER_RELEASE(g_pVideoWindow);
	
	pFileSourceAsync.Release();
	pGDCLMpeg4Demultiplexor.Release();
	pffhshowVideoDecoder.Release();
	pSampleGrabberSubt.Release();
	pSampleGrabber.Release();
	pVideoMixingRenderer9.Release();
	pffhshowAudioDecoder.Release();
	pSampleGrabberAud.Release();
	pDirectSoundDevice.Release();
	g_pGraphBuilder.Release();
	pBuilder.Release();

	pFileSourceAsync=NULL;
	pGDCLMpeg4Demultiplexor=NULL;
	pffhshowVideoDecoder=NULL;
	pSampleGrabberSubt=NULL;
	pSampleGrabber=NULL;
	pVideoMixingRenderer9=NULL;
	pffhshowAudioDecoder=NULL;
	pSampleGrabberAud=NULL;
	pDirectSoundDevice=NULL;
	g_pGraphBuilder=NULL;
	pBuilder=NULL;
}





double __declspec(dllexport) CALLBACK StopPlayer()
{
	printDebugStr( "StopPlayer");
	
	if(g_pMediaControl)
	{
		g_pMediaControl->Stop();
	}

	double totalFrames;
	totalFrames = 0.0;

	return totalFrames;
}



long __declspec(dllexport) CALLBACK GetStatePlayer()
{
	printDebugStr( "PlayPlayer");
	HRESULT hr;
	OAFilterState fs;
	hr = g_pMediaControl->GetState(1000,(OAFilterState *)&fs);	
	switch(fs)
	{
	case State_Stopped:
		return 1;
	case State_Paused:
		return 2;
	case State_Running:
		return 3;
	}
	return 0;
}



double __declspec(dllexport) CALLBACK PausePlayer()
{
	QT_TIMECODE qttimecode;
	double totalFrames;
	totalFrames = 0.0;
	LONGLONG pos;

	g_pMediaControl->Pause();
	isPlaying = false;
	
	//josner 100218
	g_pMediaSeeking->GetCurrentPosition(&pos); 
	//pos = gCurrentSampleTime * 10000000;

	g_pMediaSeeking->SetPositions(&pos,AM_SEEKING_AbsolutePositioning,NULL,AM_SEEKING_NoPositioning);

	return totalFrames;

}


long __declspec(dllexport) CALLBACK PlayPlayer()
{
	printDebugStr( "PlayPlayer");

	HRESULT hr;
	
	hr = g_pMediaControl->Run();	
	if (FAILED(hr)){
		MessageBoxA(NULL,"Play fail.",NULL,NULL);
		isPlaying = false;
	}
	else{
		isPlaying = true;
	}

	return 1;
}
                              
double __declspec(dllexport) CALLBACK SeekPlayer(double pos)
{
	LONGLONG pStop;
	LONGLONG posh;
	
	printDebugStr( "SeekPlayer");

	g_pMediaControl->Pause();
	g_pMediaSeeking->GetStopPosition(&pStop);

	char strprint[48]={0};
	char str[16];
    sprintf(str, "%.8f", pos);
	strcat(strprint,"SeekPlayer pos:");
	strcat(strprint,str);
	printDebugStr(strprint);

    posh=(LONGLONG)(pos*10000000);
	
	double totalFrames;
	totalFrames = 0.0;

	g_pMediaSeeking->SetPositions(&posh,AM_SEEKING_AbsolutePositioning,NULL,AM_SEEKING_NoPositioning);

	if (isPlaying)
		g_pMediaControl->Run();

	return totalFrames;
}

double __declspec(dllexport) CALLBACK GetPositionPlayer()
{
	LONGLONG pos;
	g_pMediaSeeking->GetCurrentPosition(&pos);
	
	//josner 100217
	double num = /*gCurrentSampleTime;//*/(double)((double)pos/10000000);

/*	char strprint[48]={0};
	char str[16];
    sprintf(str, "%.8f", num);
	strcat(strprint,"\nGetPositionPlayer:");
	strcat(strprint,str);
	strcat(strprint,"\n");
	printDebugStr(strprint);
*/
	return num;
}

long __declspec(dllexport) CALLBACK RefreshPlayer(long leftP, long topP, long widthP, long heightP)
{
	printDebugStr( "RefreshPlayer");
	g_pVideoWindow->put_Left(leftP);
	g_pVideoWindow->put_Top(topP);
	g_pVideoWindow->put_Width(widthP);	
	g_pVideoWindow->put_Height(heightP);
	return widthP;
}

double __declspec(dllexport) CALLBACK GetDurationPlayer()
{
	printDebugStr( "GetDurationPlayer");

	double num = (double)((double)dur/10000000);

	char strprint[48]={0};
	char str[16];
    sprintf(str, "%.8f", num);
	strcat(strprint,"GetDurationPlayer:");
	strcat(strprint,str);
	printDebugStr(strprint);

	return num;
}


long __declspec(dllexport) CALLBACK GetHourTCQT(){
	//QT_TIMECODE qttimecode;
	//iQTFilter->GetLastTimecode(&qttimecode);
	return 0;//qttimecode.btHours;
}

long __declspec(dllexport) CALLBACK GetMinTCQT(){
	//QT_TIMECODE qttimecode;
	//iQTFilter->GetLastTimecode(&qttimecode);
	return 0;//qttimecode.btMinutes;
}

long __declspec(dllexport) CALLBACK GetSecTCQT(){
	//QT_TIMECODE qttimecode;
	//iQTFilter->GetLastTimecode(&qttimecode);
	return 0;//qttimecode.btSeconds;
}

long __declspec(dllexport) CALLBACK GetFramesTCQT(){
	//QT_TIMECODE qttimecode;
	//iQTFilter->GetLastTimecode(&qttimecode);
	return 0;//qttimecode.btFrames;
}

double __declspec(dllexport) CALLBACK GetTC()
{
	double totalFrames;
	char strconsttot[10];

	totalFrames = 0.0;
 	
	return totalFrames;
}

double __declspec(dllexport) CALLBACK GetTCStop()
{
	double totalFrames;

	char strconsttot[10];

	totalFrames = 0.0;

	if (esVideoMov){
		totalFrames = totalSecsStop;
	}
	else{
		totalFrames = 0.0;
	}
 	
	return totalFrames;
}



long __declspec(dllexport) CALLBACK SetVolume(long vol)
{
	printDebugStr( "SetVolume");
	g_pBasicAudio->put_Volume(vol);
    return vol;
}

long __declspec(dllexport) CALLBACK GetVolume()
{
	printDebugStr( "GetVolume");
	long volu;
	g_pBasicAudio->get_Volume (&volu);
    return volu;
}

long __declspec(dllexport) CALLBACK SetBalance(long bal)
{
	printDebugStr( "SetBalance");
	g_pBasicAudio->put_Balance (bal);
    return bal;
}

long __declspec(dllexport) CALLBACK CleanPlayer()
{
	printDebugStr( "CleanPlayer");
	if(g_pMediaControl)
	{
		g_pMediaControl->Stop();
		hwndApp = NULL;
		g_pVideoWindow->put_Owner(NULL);
		disconnectFilters();
		CleanUpDirectShow();
	}
	return 1;
}

double __declspec(dllexport) CALLBACK SeekPlayingPlayer(double pos, double offset)
{

	return 0;
}


long __declspec(dllexport) CALLBACK InitializePlayer(const wchar_t *wfilename,const wchar_t *wkeydec,long fpsVid,HWND g_hwnd,long lpd,long tpd,long wpd,long hpd,long debugModeParam,long videoExt)
{
	//&param: videoExt-> 0 Mov, 1 Avi
	
	if (wcscmp(wkeydec,L"Y")==0){
		printDebugStr( "////Video is encrypted");
		isVideoEnc = true;
		isAudioEnc = true;
	}
	else{
		printDebugStr( "////Video is not encrypted");
		isVideoEnc = false;
		isAudioEnc = false;
	}

    bool bComplete = false;
    bool checkitout = true;

	isPlaying = false;

	pasadaVideoBuffer = false;
	gCurrentSampleTime = 0.0;
    
	BYTE lpDataE[1];
	long cantDivX=4;
	long cantl=1;
	PAVISTREAM ppavi;
 
	char lpDataAVIH[16];
	cantl=18;

	fontColorRedI=250;
	fontColorGreenI=250;
	fontColorBlueI=250;
	edgeColorRedI=0;
	edgeColorGreenI=0;
	edgeColorBlueI=0;

	frameRate = 30.0;
    offsetQT = 0;   // o 5
	totalSecsStop = 0.0;

	
    if(videoExt==0){
		esVideoMov = true;
		videoWidth = 640; 
		videoHeight = 480;
		if (firstTime){
			CreateGraphAndFilters();
			setSourceFile(wfilename);
			connectFilters();
			firstTime = false;
		}else{
			disconnectFilters();
			CreateGraphAndFilters();
			setSourceFile(wfilename);
			connectFilters();
		}
	}
	
	if (!filtersConnected)
	{   
		printDebugStr( "InitializePlayer fail, connect filters fail (!ConnectFilters())_______");
			
		if(g_pMediaControl)
		{
			g_pMediaControl->Stop();
			g_pVideoWindow->put_Owner(NULL);
			disconnectFilters();
			CleanUpDirectShow();
		}

		return 2;
	}

	g_pGraphBuilder->QueryInterface(IID_IMediaControl, (void**)&g_pMediaControl);
	g_pGraphBuilder->QueryInterface(IID_IMediaEvent, (void**)&g_pMediaEvent);
	g_pGraphBuilder->QueryInterface(IID_IMediaSeeking, (void**)&g_pMediaSeeking);
	g_pGraphBuilder->QueryInterface(IID_IVideoWindow, (void**)&g_pVideoWindow);
	g_pGraphBuilder->QueryInterface(IID_IBasicAudio, (void**)&g_pBasicAudio);

	g_pMediaSeeking->GetDuration(&dur);	
    g_pVideoWindow->put_WindowStyle( WS_CHILD | WS_CLIPSIBLINGS);
    g_pVideoWindow->put_Height(hpd);
	g_pVideoWindow->put_Left(lpd);
	g_pVideoWindow->put_Top(tpd);
	g_pVideoWindow->put_Width(wpd);
	g_pVideoWindow->put_Owner((OAHWND)g_hwnd);

    hwndApp = g_hwnd;

	buffSizeUsed = videoWidth * videoHeight * 3;

	wpdGl=wpd;
	fpsVidGlob=fpsVid;

	printDebugStr( "InitializePlayer SUCCEDED!!_______");

	firstPause = true;

	return 0;							   
}


BOOL APIENTRY DllMain( HINSTANCE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	char strprint[48]={0};
	char str[16];

	switch(ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:

		debugMode = true;

		char szProgramFilename[100];
		char *lpszName;
		char szFullPathProgram[999];
		char *szPathProgram;
		int lenFullPathProgram;
		char szTempStringConcat[100];
		lenFullPathProgram = 0;
		szPathProgram = "";
		GetModuleFileNameA(NULL, szProgramFilename, sizeof(szProgramFilename)); 
		szFullPathProgram[0] = 0;
		GetFullPathNameA(szProgramFilename, sizeof(szFullPathProgram), szFullPathProgram, &lpszName);
		lenFullPathProgram = strlen(szFullPathProgram);
		szTempStringConcat[0] = 0;
		szPathProgram = strncat(szTempStringConcat, szFullPathProgram, lenFullPathProgram - 15);//CAMBIAR ESTO SEGUN SISTEMA 13:QC, 15:trans
		strcat(szPathProgram, "traceDecryptPlayer.txt");  
		traceDecryptPlayer = fopen(szPathProgram, "a");
		
		printDebugStr( "DLL_PROCESS_ATTACH");

		CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
		firstTime = true;

		break;

	case DLL_THREAD_ATTACH:
		break;

    case DLL_THREAD_DETACH:
		break;
	
	case DLL_PROCESS_DETACH:
		
		printDebugStr( "DLL_PROCESS_DETACH");

        if(_Module.GetLockCount() != 0)
        	printDebugStr( "DLLDETTACH _Module.GetLockCount() != 0");
		else
			printDebugStr( "DLLDETTACH _Module.GetLockCount() == 0");

        _Module.Term();
		
		CoUninitialize();

		fclose(traceDecryptPlayer);

		break;
	}
    return TRUE;
}


double __declspec(dllexport) CALLBACK ShowSubtitle(double cual) 
{
	if (cual==0)
		BitmapPresent=false;
	else
		BitmapPresent=true;
	
	return cual;
}