Attribute VB_Name = "UtilityModule"
Option Explicit

Public Function TCaSEG(stc As String) As Double
Dim H, m, s, F As Integer
Dim cont As Integer
Dim valorascii
    If Len(stc) <> 11 Then GoTo errores
    For cont = 1 To 11
        valorascii = Asc(Mid(stc, cont, 1))
        If valorascii < 44 Or valorascii > 59 Then GoTo errores '44=, - . / 0 1 2 3 4 5 6 7 8 9 : ;=59
    Next
        Err.Clear
        On Error Resume Next
        H = CByte(Mid(stc, 1, 2))
        m = CByte(Mid(stc, 4, 2))
        s = CByte(Mid(stc, 7, 2))
        F = CByte(Mid(stc, 10, 2))
        If Fps = "PAL" Then
            If (H < 0 Or H > 24) Or (m < 0 Or m > 59) Or (s < 0 Or s > 59) Or (F < 0 Or F > 24) Then GoTo errores
            TCaSEG = (H * 3600) + (m * 60) + (s) + (F / 25)
        Else
            If (H < 0 Or H > 24) Or (m < 0 Or m > 59) Or (s < 0 Or s > 59) Or (F < 0 Or F > 29) Then GoTo errores
            TCaSEG = (H * 3600) + (m * 60) + (s) + (F / 30)
        End If
        If Err.number = 0 Then Exit Function
errores:
    TCaSEG = -1
End Function

Function MakeTempFileName(Extension As String) As String

   Dim Isfile As Integer, FHandle As Integer, Cntr As Integer
   Dim WinTemp As String, TF As String

   Isfile = False
   FHandle = FreeFile

   WinTemp = Environ("TEMP") & "\Ren"
   For Cntr = 1 To 5
      WinTemp = WinTemp & Mid(LTrim(str(CInt(Rnd * 10))), 1, 1)
   Next Cntr

   TF = Trim(WinTemp$) & "\"
   MakeTempFileName = TF

End Function

Public Function ColorARGB(ByVal alpha As Byte, ByVal Red As Byte, ByVal Green As Byte, ByVal Blue As Byte) As Long
   Dim bytestruct As COLORBYTES
   Dim result As COLORLONG
   
   With bytestruct
      .AlphaByte = alpha
      .RedByte = Red
      .GreenByte = Green
      .BlueByte = Blue
   End With
   
   LSet result = bytestruct
   ColorARGB = result.longval
End Function

Public Function GetRGB_VB2GDIP(ByVal lColor As Long, Optional ByVal alpha As Byte = 255) As Long
   Dim rgbq As RGBQUAD
   CopyMemory rgbq, lColor, 4
   GetRGB_VB2GDIP = ColorARGB(alpha, rgbq.rgbBlue, rgbq.rgbGreen, rgbq.rgbRed)
End Function

Public Function GetRGB(ByVal lColor As Long) As String
    Dim rgbq As RGBQUAD
    CopyMemory rgbq, lColor, 4
    If rgbq.rgbBlue = 0 And rgbq.rgbGreen = 0 And rgbq.rgbRed = 255 Then
        pallete = 1
    ElseIf rgbq.rgbBlue = 255 And rgbq.rgbGreen = 0 And rgbq.rgbRed = 0 Then
        pallete = 2
    ElseIf rgbq.rgbBlue = 0 And rgbq.rgbGreen = 0 And rgbq.rgbRed = 0 Then
        pallete = 3
    ElseIf rgbq.rgbBlue = 255 And rgbq.rgbGreen = 255 And rgbq.rgbRed = 255 Then
        pallete = 4
    ElseIf rgbq.rgbBlue = 0 And rgbq.rgbGreen = 255 And rgbq.rgbRed = 0 Then
        pallete = 5
    ElseIf rgbq.rgbBlue = 255 And rgbq.rgbGreen = 0 And rgbq.rgbRed = 255 Then
        pallete = 6
    ElseIf rgbq.rgbBlue = 255 And rgbq.rgbGreen = 255 And rgbq.rgbRed = 0 Then
        pallete = 7
    ElseIf rgbq.rgbBlue = 0 And rgbq.rgbGreen = 125 And rgbq.rgbRed = 125 Then
        pallete = 8
    ElseIf rgbq.rgbBlue = 125 And rgbq.rgbGreen = 125 And rgbq.rgbRed = 125 Then
        pallete = 9
    ElseIf rgbq.rgbBlue = 225 And rgbq.rgbGreen = 225 And rgbq.rgbRed = 225 Then
        pallete = 10
    ElseIf rgbq.rgbBlue = 125 And rgbq.rgbGreen = 0 And rgbq.rgbRed = 0 Then
        pallete = 11
    ElseIf rgbq.rgbBlue = 0 And rgbq.rgbGreen = 125 And rgbq.rgbRed = 0 Then
        pallete = 12
    ElseIf rgbq.rgbBlue = 0 And rgbq.rgbGreen = 0 And rgbq.rgbRed = 125 Then
        pallete = 13
    ElseIf rgbq.rgbBlue = 222 And rgbq.rgbGreen = 0 And rgbq.rgbRed = 255 Then
        pallete = 14
    ElseIf rgbq.rgbBlue = 222 And rgbq.rgbGreen = 125 And rgbq.rgbRed = 0 Then
        pallete = 15
    ElseIf rgbq.rgbBlue = 125 And rgbq.rgbGreen = 0 And rgbq.rgbRed = 125 Then
        pallete = 16
    Else
        pallete = -1
    End If
    GetRGB = "(" & rgbq.rgbBlue & " " & rgbq.rgbGreen & " " & rgbq.rgbRed & " ===)"
End Function

Public Function makeName(numImageView As Integer, typeImage As String, fill As Boolean) As String
    If fill Then
        Select Case numImageView
            Case Is < 10:
                nameNumPic = namepic & "000"
            Case Is < 100:
                nameNumPic = namepic & "00"
            Case Is < 1000:
                nameNumPic = namepic & "0"
            Case Is < 10000:
                nameNumPic = namepic
        End Select
    Else
        nameNumPic = namepic
    End If
    makeName = dirpath & "\" & nameNumPic & numImageView & "." & typeImage
End Function

Public Function makeNameFile(numImageView As Integer, typeImage As String, fill As Boolean) As String
    If fill Then
        Select Case numImageView
            Case Is < 10:
                nameNumPic = namepic & "000"
            Case Is < 100:
                nameNumPic = namepic & "00"
            Case Is < 1000:
                nameNumPic = namepic & "0"
            Case Is < 10000:
                nameNumPic = namepic
        End Select
    Else
        nameNumPic = namepic
    End If
    makeNameFile = nameNumPic & numImageView & "." & typeImage
End Function

Public Function makeNameTemp(numImageView As Integer, typeImage As String, fill As Boolean) As String
    If fill Then
        Select Case numImageView
            Case Is < 10:
                nameNumPic = namepic & "000"
            Case Is < 100:
                nameNumPic = namepic & "00"
            Case Is < 1000:
                nameNumPic = namepic & "0"
            Case Is < 10000:
                nameNumPic = namepic
        End Select
    Else
        nameNumPic = namepic
    End If
    makeNameTemp = dirpath & "\Temp" & nameNumPic & numImageView & "." & typeImage
End Function


Public Function CreateDir(path As String) As Boolean
    Static start, pos As Integer
    Static directory As String
    Static result As Boolean
    
    result = True
    On Error GoTo errCreation ' initialize the error trap
    If path = "" Then Err.Raise vbObjectError + 1 ' if null string why bother....
    If start = Empty Then    ' start will always be null the first time through
        start = 1
    Else
         start = pos + 1
    End If
    pos = InStr(start, path, Chr$(92))    ' find "\"  if the char exists
    If (pos <> 0) Then
        directory = directory + Mid$(path, start, pos - start) + Chr$(92)        ' not at the last directory in the path string...
        If InStr(1, Mid$(path, start, pos - start), Chr$(58)) = 0 And Dir(directory, vbDirectory) = "" Then
           MkDir Mid$(directory, 1, Len(directory) - 1)
        End If
        result = CreateDir(path) ' call itself
    ElseIf (pos = 0) Then
        directory = directory + Mid$(path, start, Len(path) - start + 1)        ' the last directory or the only in the path string
        MkDir Mid$(directory, 1, Len(directory))
        directory = ""
    End If
    CreateDir = result ' success return true
Exit Function
errCreation:
    directory = ""
    Err.Clear ' if it gets here, an exception was thrown propogate the error to the calling function
    result = False
    CreateDir = result
End Function

