Attribute VB_Name = "Module2"
Option Compare Binary
Option Explicit

Private m_acpSys As Long
Private m_lcidSys As Long

Private Const LOCALE_IDEFAULTANSICODEPAGE = &H1004&        ' default ansi code page
Private Const TCI_SRCCODEPAGE = 2

'--------------------------------
'   AToW
'
'   ANSI to UNICODE conversion, via a given codepage.
'--------------------------------
Public Function AToW(ByVal st As String, Optional ByVal cpg As Long = -1, Optional lFlags As Long = 0) As String
    Dim stBuffer        As String
    Dim cwch            As Long
    Dim pwz             As Long
    Dim pwzBuffer       As Long
        
    If cpg = -1 Then cpg = AcpSys()
    pwz = StrPtr(st)
    cwch = MultiByteToWideChar(cpg, lFlags, pwz, -1, 0&, 0&)
    stBuffer = String$(cwch + 1, vbNullChar)
    pwzBuffer = StrPtr(stBuffer)
    cwch = MultiByteToWideChar(cpg, lFlags, pwz, -1, pwzBuffer, Len(stBuffer))
    AToW = left$(stBuffer, cwch - 1)
End Function

'--------------------------------
'   AToWEx
'
'   ANSI to UNICODE conversion, via a given an lcid.
'--------------------------------
Public Function AToWEx(ByVal st As String, Optional ByVal lcid As Long = -1, Optional lFlags As Long = 0) As String
    Dim cpg                 As Long
    Dim lpUsedDefaultChar   As Long
    
    ' If no codepage is specified, use the default system codepage
    If lcid = -1 Then lcid = LcidSys()
    cpg = ChsFromLocale(lcid)

    AToWEx = AToW(st, cpg, lFlags)
End Function

'--------------------------------
'   WToA
'
'   UNICODE to ANSI conversion, via a given codepage
'--------------------------------
Public Function WToA(ByVal st As String, Optional ByVal cpg As Long = -1, Optional lFlags As Long = 0) As String
    Dim stBuffer            As String
    Dim cwch                As Long
    Dim pwz                 As Long
    Dim pwzBuffer           As Long
    Dim lpUsedDefaultChar   As Long
    
    If cpg = -1 Then cpg = AcpSys()
    pwz = StrPtr(st)
    cwch = WideCharToMultiByte(cpg, lFlags, pwz, -1, 0&, 0&, ByVal 0&, ByVal 0&)
    stBuffer = String$(cwch + 1, vbNullChar)
    pwzBuffer = StrPtr(stBuffer)
    cwch = WideCharToMultiByte(cpg, lFlags, pwz, -1, pwzBuffer, Len(stBuffer), ByVal 0&, ByVal 0&)
    WToA = left$(stBuffer, cwch - 1)
End Function

'--------------------------------
'   WToAEx
'
'   UNICODE to ANSI conversion, via a given an lcid.
'--------------------------------
Public Function WToAEx(ByVal st As String, Optional ByVal lcid As Long = -1, Optional lFlags As Long = 0) As String
    Dim cpg                 As Long
    Dim lpUsedDefaultChar   As Long
    
    ' If no codepage is specified, use the default system codepage
    If lcid = -1 Then lcid = LcidSys()
    cpg = ChsFromLocale(lcid)

    WToAEx = WToA(st, cpg, lFlags)
End Function

'--------------------------------
'   FStringInCpg
'
'   Tests whether a particular string fits within a given codepage,
'   given the string and a codepage.
'--------------------------------
Public Function FStringInCpg(ByVal st As String, Optional ByVal cpg As Long = -1) As Boolean
    Dim cwch                As Long
    Dim lpUsedDefaultChar   As Long
    
    ' If no codepage is specified, use the default system codepage
    If cpg = -1 Then cpg = AcpSys()
    
    ' We are not converting, simply determining if the system plans
    ' on using the default char at all (which it does when it cannot
    ' map a char in the string)
    cwch = WideCharToMultiByte(cpg, 0&, StrPtr(st), -1, 0&, 0&, ByVal 0&, lpUsedDefaultChar)
    FStringInCpg = (CBool(lpUsedDefaultChar) = False)
End Function

'--------------------------------
'   FStringInLcid
'
'   Tests whether a particular string fits within a given codepage,
'   given the string and an LCID.
'--------------------------------
Public Function FStringInLcid(ByVal st As String, Optional ByVal lcid As Long = -1) As Boolean
    Dim cwch        As Long
    Dim cpg         As Long
    Dim lpUsedDefaultChar As Long
    
    ' If no codepage is specified, use the default system LCID
    If lcid = -1 Then lcid = LcidSys()
    cpg = ChsFromLocale(lcid)
    
    FStringInLcid = FStringInCpg(st, cpg)
End Function

'--------------------------------
'   ChsFromLocale
'--------------------------------
Public Function ChsFromLocale(lcid As Long) As Long
    Dim cwc         As Long
    Dim cpg         As Long
    Dim stBuffer    As String
    Dim cs          As CHARSETINFO
    
    stBuffer = String$(10, vbNullChar)
    cwc = GetLocaleInfoA(lcid, LOCALE_IDEFAULTANSICODEPAGE, _
     stBuffer, Len(stBuffer))

    If cwc > 0 Then
        cpg = val(left$(stBuffer, cwc - 1))
        
        ChsFromLocale = ChsFromCpg(cpg)
    End If
End Function

'--------------------------------
'   ChsFromCpg
'--------------------------------
Public Function ChsFromCpg(cpg As Long) As KnownCharset
    Dim cs  As CHARSETINFO
    
    If TranslateCharsetInfo(ByVal cpg, cs, _
     TCI_SRCCODEPAGE) Then
        ChsFromCpg = cs.ciCharset
    End If
End Function

'--------------------------------
'   AcpSys
'
'   Wrapper around GetACP since Kernel calls are expensive.
'--------------------------------
Public Property Get AcpSys() As Long
    If (m_acpSys = 0) Then
        m_acpSys = GetACP()
    End If
    
    AcpSys = m_acpSys
End Property

'--------------------------------
'   LcidSys
'
'   Wrapper around GetSystemDefaultLCID since Kernel calls are expensive
'--------------------------------
Public Property Get LcidSys() As Long
    If m_lcidSys = 0 Then
        m_lcidSys = GetSystemDefaultLCID()
    End If
    LcidSys = m_lcidSys
End Property

Public Sub ltob(lVal As Long)
   If lVal < 0 Then
      lVal = 0
   ElseIf lVal > 255 Then
      lVal = 255
   End If
End Sub

Function icp(s As String, cp As Long)
    On Error Resume Next
    icp = Asc(WToA(s, cp))
End Function

Public Function EncodeUTF8(ByVal cnvUni As String) As String
    If cnvUni = vbNullString Then Exit Function
    EncodeUTF8 = StrConv(WToA(cnvUni, 1200, 0), vbUnicode)
End Function

Public Function DecodeUTF8(ByVal cnvUni As String, sCodePage As Integer) As String
    Dim cnvUni2     As String
    
    If cnvUni = vbNullString Then Exit Function
    cnvUni2 = WToA(cnvUni, CP_ACP)
    DecodeUTF8 = AToW(cnvUni2, sCodePage)
End Function

Public Function toUnicode(text As String) As String
    Dim cont        As Integer
    Dim chars       As String
    
    
    chars = ""
    If cp = JAPANESE Or cp = KOREAN Or cp = CHINESESIMPLIFIED Or cp = CHINESEBIG Then
        For cont = 0 To Len(text) - 1
            chars = chars & ChrW$(AscW(Mid(text, cont + 1, 1)))
        Next
    Else
        For cont = 0 To Len(text) - 1
            chars = chars & ChrW$(transformfont(Hex(AscW(Mid(text, cont + 1, 1)))))
        Next
    End If
    toUnicode = chars
End Function
Public Sub DrawText(hdc As Long, text As String, ByVal x As Long, ByVal Y As Long, isEdge As Boolean)
    If isEdge Then
        SetTextColor hdc, Form8.CommonDialog1.color
    Else
        SetTextColor hdc, Form8.CommonDialog2.color
    End If
    TextOutW hdc, x, Y, StrPtr(text), Len(text)
End Sub


Public Function transformfont(c As String) As String
    Dim i       As Integer
    Dim l       As Integer
    Dim auxs    As String
    
                    auxs = ""
                    If c = Chr(92) Then
                        auxs = auxs & Chr(128)
                    ElseIf c >= Chr(32) And c <= Chr(122) Then
                        auxs = auxs & c
                    ElseIf c = "" Or c = Chr(149) Or c = Chr(160) Then
                        auxs = auxs & " "                                   'Space
                    ElseIf c = Chr(150) Or c = Chr(151) Then
                        auxs = auxs & "-"                                   'Dash
                    ElseIf c = "'" Then
                        auxs = auxs & Chr(39)                               'Single apostrophe
                    ElseIf c = ChrW(&H2026) Then                            'ELLIPSIS
                        auxs = auxs & Chr(166)
                    ElseIf c = Chr(145) Or c = ChrW(&H2018) Then            'SINGLE LEFT QUOTATION
                        auxs = auxs & Chr(176)
                    ElseIf c = Chr(146) Or c = ChrW(&H2019) Then            'SINGLE RIGHT QUOTATION
                        auxs = auxs & Chr(178)
                    ElseIf c = Chr(147) Or c = ChrW(&H201C) Then            'LEFT DOUBLE QUOTATION MARK
                        auxs = auxs & Chr(179)
                    ElseIf c = Chr(148) Or c = ChrW(&H201D) Then            'RIGHT DOUBLE QUOTATION MARK
                        auxs = auxs & Chr(188)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(152)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(153)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(154)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(157)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(158)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(159)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(162)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(164)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(165)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(169)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(171)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(173)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(175)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(183)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(187)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(191)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(129)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(130)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(131)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(134)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(135)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(136)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(139)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(140)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(143)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(144)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(146)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(147)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(148)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(149)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(29)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(28)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(12)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(11)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(155)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(174)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(4)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(5)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(6)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(7)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(1)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(2)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(3)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(8)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(16)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(18)
                                                                '+Julio 2002
                    ElseIf c = "" Then
                        auxs = auxs & Chr(15)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(20)
                    ElseIf c = Chr(171) Then
                        auxs = auxs & Chr(21)                   'LEFT POINTING DOUBLE ARROW (171 = &HAB)
                    ElseIf c = Chr(187) Then
                        auxs = auxs & Chr(22)                   'RIGHT POINTING DOUBLE ARROW (187 = &HBB)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(23)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(24)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(30)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(31)
                    ElseIf c = "{" Then
                        auxs = auxs & Chr(123)
                    ElseIf c = "|" Then
                        auxs = auxs & Chr(124)
                    ElseIf c = "}" Then
                        auxs = auxs & Chr(125)
                    ElseIf c = "~" Then
                        auxs = auxs & Chr(126)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(132)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(132)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(133)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(137)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(138)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(141)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(142)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(145)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(150)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(151)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(156)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(160)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(161)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(163)
                    ElseIf c = "" Then                             'Previously: ElseIf c = "" Then
                        auxs = auxs & Chr(167)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(168)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(170)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(172)
                                                                    'ElseIf c = "" Then
                                                                    'auxs = auxs & Chr(176)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(180)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(181)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(182)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(184)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(185)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(186)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(189)
                    ElseIf c = "" Then
                        auxs = auxs & Chr(190)
        End If
    
    transformfont = "&H" & auxs
End Function

Public Function CreateDir(path As String) As Boolean
    Static start, pos As Integer
    Static directory As String
    Static result As Boolean
    
    result = True
    On Error GoTo errCreation ' initialize the error trap
    If path = "" Then Err.Raise vbObjectError + 1 ' if null string why bother....
    If start = Empty Then    ' start will always be null the first time through
        start = 1
    Else
         start = pos + 1
    End If
    pos = InStr(start, path, Chr$(92))    ' find "\"  if the char exists
    If (pos <> 0) Then
        directory = directory + Mid$(path, start, pos - start) + Chr$(92)        ' not at the last directory in the path string...
        If InStr(1, Mid$(path, start, pos - start), Chr$(58)) = 0 And Dir(directory, vbDirectory) = "" Then
           MkDir Mid$(directory, 1, Len(directory) - 1)
        End If
        result = CreateDir(path) ' call itself
    ElseIf (pos = 0) Then
        directory = directory + Mid$(path, start, Len(path) - start + 1)        ' the last directory or the only in the path string
        MkDir Mid$(directory, 1, Len(directory))
        directory = ""
    End If
    CreateDir = result ' success return true
Exit Function
errCreation:
    directory = ""
    Err.Clear ' if it gets here, an exception was thrown propogate the error to the calling function
    result = False
    CreateDir = result
End Function

Public Function EnumFontFamExProc(ByVal lpelfe As Long, ByVal lpntme As Long, ByVal FontType As Long, ByVal lParam As Long) As Long
    Dim elfx As ENUMLOGFONTEX  ' receives information about the font
    Dim ntmx As NEWTEXTMETRICEX  ' receives text metrics for TrueType fonts
    Dim tm As TEXTMETRIC  ' receives text metrics for non-TrueType fonts
    
    CopyMemory elfx, ByVal lpelfe, Len(elfx)
    
    If (FontType And TRUETYPE_FONTTYPE) = TRUETYPE_FONTTYPE Then
        CopyMemory ntmx, ByVal lpntme, Len(ntmx)
        fonts(contfonts).name = left(elfx.elfLogFont.lfFaceName, InStr(elfx.elfLogFont.lfFaceName, vbNullChar) - 1)
        If contcharset = 0 Then
            fonts(contfonts).style = left(elfx.elfStyle, InStr(elfx.elfStyle, vbNullChar) - 1)
        End If
        With fonts(contfonts).Charsets(contcharset)
            If fonts(contfonts).style = left(elfx.elfStyle, InStr(elfx.elfStyle, vbNullChar) - 1) Then
                .id = elfx.elfLogFont.lfCharSet
                Select Case elfx.elfLogFont.lfCharSet
                    Case 0:
                        .name = "Western"
                    Case 1:
                        .name = "DEFAULT_CHARSET"
                    Case 2:
                        .name = "Symbol"
                    Case 77:
                        .name = "Mac"
                    Case 128:
                        .name = "Japanese"
                    Case 129:
                        .name = "Hangeul"
                    Case 130:
                        .name = "Johab"
                    Case 134:
                        .name = "Chinese_GB2312"
                    Case 136:
                        .name = "Chinese_BIG5"
                    Case 161:
                        .name = "Greek"
                    Case 162:
                        .name = "Turkish"
                    Case 163:
                        .name = "Vietnamese"
                    Case 177:
                        .name = "Hebrew"
                    Case 178:
                        .name = "Arabic"
                    Case 186:
                        .name = "Baltic"
                    Case 204:
                        .name = "Cyrillic"
                    Case 222:
                        .name = "Thai"
                    Case 238:
                        .name = "East Europe"
                    Case 255:
                        .name = "OEM"
                    Case Else
                        .name = "DEFAULT_CHARSET"
                End Select
                       
                contcharset = contcharset + 1
                End If
                cp = .cp
            End With
        End If
        EnumFontFamExProc = 1
End Function

Public Function makeName(numImageView As Integer, typeImage As String, fill As Boolean) As String
    If fill Then
        Select Case numImageView
            Case Is < 10:
                nameNumPic = namepic & "000"
            Case Is < 100:
                nameNumPic = namepic & "00"
            Case Is < 1000:
                nameNumPic = namepic & "0"
            Case Is < 10000:
                nameNumPic = namepic
        End Select
    Else
        nameNumPic = namepic
    End If
    makeName = dirpath & "\" & nameNumPic & numImageView & "." & typeImage
End Function



Public Function makeNameFile(numImageView As Integer, typeImage As String, fill As Boolean) As String
    If fill Then
        Select Case numImageView
            Case Is < 10:
                nameNumPic = namepic & "000"
            Case Is < 100:
                nameNumPic = namepic & "00"
            Case Is < 1000:
                nameNumPic = namepic & "0"
            Case Is < 10000:
                nameNumPic = namepic
        End Select
    Else
        nameNumPic = namepic
    End If
    makeNameFile = nameNumPic & numImageView & "." & typeImage
End Function

