#include "stdafx.h"

#include <windows.h>
#include <stdio.h>
#include "resource.h"
#include <streams.h>
#include <string.h>
#include <Vfw.h>

#include <initguid.h>
#include "dllutil.h"

#include "dshowutil.h"

#include <dshow.h>

#include <iostream>
#include <fstream.h>

using namespace std;

#include <Qedit.h>

#include <Commdlg.h>

//2010
#include "QTSource.h"


#define WM_GRAPHEVENT	WM_USER		
#define HELPER_RELEASE(x)   if (x != NULL) \
                            { \
                                x->Release(); \
                                x = NULL; \
                            }

#define INITGUID	
DEFINE_GUID(CLSID_DivXDecoder,
0x78766964, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

#define INITGUID	
DEFINE_GUID(CLSID_MPEG3Decoder,
0x38BE3000, 0xDBF4, 0x11D0, 0x86, 0x0E, 0x00, 0xA0, 0x24, 0xCF, 0xEF, 0x6D);

#define INITGUID	
DEFINE_GUID(CLSID_MediaLooksQT,
0x7CE55CCC, 0x403E, 0x4A29, 0x82, 0x81, 0xBF, 0x85, 0x42, 0xA0, 0xC3, 0x7D);

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef DWORD COLORREF;
#define BGR(b,g,r) ((COLORREF)((((BYTE)(b)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(r))<<16))));
#define BGRA(b,g,r,a) ((COLORREF)((((BYTE)(b)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(r))<<16))|(((DWORD)(BYTE)(a))<<24)));
#define GetABValue(bgra) ((BYTE)(bgra));
#define GetAGValue(bgra) ((BYTE)((bgra)>> 8));
#define GetARValue(bgra) ((BYTE)((bgra)>>16));
#define GetAAValue(bgra) ((BYTE)((bgra)>>24));

IGraphBuilder *g_pGraphBuilder; 

IBaseFilter*	g_pSource=NULL;
IBaseFilter*	g_pAviSplitter=NULL;
IBaseFilter*	g_pDivXDecoder=NULL;

IBaseFilter* g_pSampleGrabber2=NULL;
IBaseFilter* g_pSampleGrabberAud=NULL;
IBaseFilter* g_pSampleGrabberTC=NULL;


IBaseFilter*	g_pVideoRenderer=NULL;
IBaseFilter* pVmr = NULL;

IBaseFilter*	g_pMPEG3Decoder=NULL;
IBaseFilter*	g_pDSoundRender=NULL;

IMediaSeeking*	g_pMediaSeeking = NULL;
IBasicAudio*	g_pBasicAudio = NULL;
IMediaControl*	g_pMediaControl;
IMediaEventEx*	g_pMediaEvent;
IVideoWindow* g_pVideoWindow;

ISampleGrabber* pGrabber2;
ISampleGrabber* pGrabberAud;
ISampleGrabber* pGrabberTC;

IQTSource*  iQTFilter;


REFERENCE_TIME rtTotal=0;
REFERENCE_TIME rtNow=0;
HWND hWndMedula;
HRESULT hr;
long total,countSeek=6;
bool scramvideo,isVideoEnc,isAudioEnc;
LONGLONG dur;
long wpdGl;
long fpsVidGlob;

bool BitmapPresent,BitmapPresentPrev,changingSubtitle,useNewVideoMixing,keepPreviousFrame;

long buffSizeUsed;

HWND hwndApp;

int pixel1r,pixel2r,pixel3r,pixel4r,pixel5r,pixel1g,pixel2g,pixel3g,pixel4g,pixel5g,pixel1b,pixel2b,pixel3b,pixel4b,pixel5b;
INT * ptPixels;

//2010
int videoWidth,videoHeight;
bool esVideoMov;

bool g_bUseMMX;

#define TRANSPARENCY_VALUE   (1.0f)
#define PURE_WHITE          RGB(255,255,255)
#define ALMOST_WHITE        RGB(250,250,250)
#define BLEND_TEXT          TEXT("This is a .\0")
#define DYNAMIC_TEXT_SIZE   255
#define DEFAULT_FONT_NAME   TEXT("Comic Sans MS\0")
#define DEFAULT_FONT_STYLE  TEXT("Bold\0")
#define DEFAULT_FONT_SIZE   12
#define DEFAULT_FONT_COLOR  RGB(255,255,255)
#define MAX_FONT_SIZE		25
HFONT g_hFont=0;
LONG g_lFontPointSize   = DEFAULT_FONT_SIZE;
COLORREF g_rgbColors    = DEFAULT_FONT_COLOR;
TCHAR g_szFontName[100] = {DEFAULT_FONT_NAME};
TCHAR g_szFontStyle[32] = {DEFAULT_FONT_STYLE};

//aqui
HBITMAP DirectBitmap;

const wchar_t *fontNameI;
long fontPointSizeI,edgeSizeI,fontBoldI,fontItalicI,fontColorRedI,fontColorGreenI,fontColorBlueI,edgeColorI,edgeColorRedI,edgeColorGreenI,edgeColorBlueI,fontCharSetI;

FILE *traceDecryptPlayer;
bool debugMode;
bool creatingNewFrame;

void printDebugStr(char* debstr)
{
	if (debugMode)
	{
	 Sleep(2);
	 fprintf(traceDecryptPlayer, debstr);
	 Sleep(2);
	}
}

HFONT SetTextFont(const wchar_t *fontName, long fontPointSize, long edgeSize, long fontBold, long fontItalic, long fontColorRed, long fontColorGreen, long fontColorBlue, long edgeColorRed, long edgeColorGreen, long edgeColorBlue, long fontCharSet  /*BOOL bSetItalic, BOOL bSetBold*/)
{
	CHOOSEFONT cf={0}; 
    LOGFONT lf={0}; 
    HFONT hfont; 
    HDC hdc;
    LONG fontHeight;

	//font name
	lstrcpyn(lf.lfFaceName, fontName,32);

	//font size
    hdc = GetDC( hwndApp );
    fontHeight = -MulDiv( fontPointSize, GetDeviceCaps(hdc, LOGPIXELSY), 72 );
    ReleaseDC( hwndApp, hdc );
	lf.lfHeight = fontHeight;      
	
	//font quality
	lf.lfQuality = ANTIALIASED_QUALITY;

	//font charset         
	lf.lfCharSet = fontCharSet;

	// Initialize members of the CHOOSEFONT structure. 
    cf.lStructSize = sizeof(CHOOSEFONT); 
    cf.hwndOwner   = hwndApp; 
    cf.hDC         = (HDC)NULL; 
    cf.lpLogFont   = &lf; 
    cf.iPointSize  = fontPointSize * 10;  
    cf.lCustData   = 0L; 
    cf.lpfnHook    = (LPCFHOOKPROC)NULL; 
    cf.hInstance   = (HINSTANCE) NULL; 
    cf.nFontType   = SCREEN_FONTTYPE; 
    cf.nSizeMin    = 0; 
    cf.lpTemplateName = NULL; 
    cf.Flags = CF_SCREENFONTS | CF_SCALABLEONLY | CF_INITTOLOGFONTSTRUCT | CF_EFFECTS     | CF_USESTYLE     | CF_LIMITSIZE; 

	if (fontBold==1)
		cf.lpLogFont->lfWeight = FW_BOLD;
	else if (fontBold==2)
		cf.lpLogFont->lfWeight = FW_SEMIBOLD;
	else
		cf.lpLogFont->lfWeight = FW_REGULAR;

	if (fontItalic==1)
		cf.lpLogFont->lfItalic = TRUE;
	else
		cf.lpLogFont->lfItalic = FALSE;
	
    // Create a logical font based on the user's selection   
    hfont = CreateFontIndirect(cf.lpLogFont);
	return (hfont); 
	
}

long _cdecl ChangeFont(const wchar_t *fontNameP, long fontPointSizeP, long edgeSizeP, long fontBoldP, long fontItalicP, long fontColorRedP, long fontColorGreenP, long fontColorBlueP, long edgeColorRedP, long edgeColorGreenP, long edgeColorBlueP, long fontCharSetP)
{
	fontNameI = fontNameP;
	fontPointSizeI=fontPointSizeP;
	edgeSizeI=edgeSizeP;
	fontBoldI=fontBoldP;
	fontItalicI=fontItalicP;
	
	fontColorRedI=fontColorRedP;
	fontColorGreenI=fontColorGreenP;
	fontColorBlueI=fontColorBlueP;

	edgeColorRedI=edgeColorRedP;
	edgeColorGreenI=edgeColorGreenP;
	edgeColorBlueI=edgeColorBlueP;

	fontCharSetI=fontCharSetP;

	return 1;
}

long __cdecl ChangeSubtitle(const wchar_t *firstString,long fsx,long fsy,long fsi,const wchar_t *secondString,long ssx,long ssy,long ssi, long alignment)
{
	
	if (creatingNewFrame)
	{
		while(creatingNewFrame)
		{
			Sleep(1);
		}
	}

	changingSubtitle = true;
    printDebugStr( "ChangeSubtitle called_____________\n");

	BitmapPresentPrev = BitmapPresent;
	BitmapPresent=false;

	if(DirectBitmap)
	DeleteObject(DirectBitmap);

	const TCHAR *szText;  
	szText = firstString;

	const TCHAR *szText1;    
	szText1 = secondString;

	HDC hdc = GetDC(hwndApp);
	HDC hdcBmp = CreateCompatibleDC(hdc);

    printDebugStr( "1__Compatible DC created.\n");

	int nLength,nLength1; 
	int nTextBmpHeight,nTextBmpWidth;
	SIZE sz={0};
	nLength = (int) _tcslen(szText);
	nLength1 = (int) _tcslen(szText1);
	GetTextExtentPoint32(hdcBmp, szText, nLength, &sz);
	
	//2010
	nTextBmpHeight = videoHeight;//sz.cy;
	nTextBmpWidth  = videoWidth;//sz.cx;

	// Create and Select our bitmap into the device context and save the old
	HBITMAP hbm = CreateCompatibleBitmap(hdc, nTextBmpWidth, nTextBmpHeight);
	BITMAP bm;
	HBITMAP hbmOld;
	GetObject(hbm, sizeof(bm), &bm);
	hbmOld = (HBITMAP)SelectObject(hdcBmp, hbm);

	printDebugStr( "2__Bitmap into the device.\n");

	// Set initial bitmap settings
	SetBkColor(hdcBmp, RGB(192, 192, 192)); 
    int newColorText;
	newColorText = BGR(fontColorRedI,fontColorGreenI,fontColorBlueI);
	SetTextColor(hdcBmp, newColorText);   

	HBRUSH hbrBackground;
	hbrBackground = CreateSolidBrush(RGB(192, 192, 192));
	SelectObject(hdcBmp, hbrBackground); 
	ExtFloodFill(hdcBmp,0,0,RGB(0, 0, 0),FLOODFILLSURFACE);
	SetBkMode(hdcBmp,TRANSPARENT);

	HPEN hpen, hpenOld;
    static int  iEnd[] = { PS_ENDCAP_ROUND, PS_ENDCAP_SQUARE, PS_ENDCAP_FLAT };
    static int  iJoin[]= { PS_JOIN_ROUND,   PS_JOIN_BEVEL,    PS_JOIN_MITER } ;
	LOGBRUSH lb;

	printDebugStr( "3__Bitmaps settings setted.\n");

	//Text Aligment General
	if (alignment == 0)
		SetTextAlign(hdcBmp,TA_CENTER);
	else if (alignment == 1)
		SetTextAlign(hdcBmp,TA_LEFT);
	else
		SetTextAlign(hdcBmp,TA_RIGHT);

	printDebugStr( "4__Text aligned.\n");
	
	///First Line
	g_hFont = SetTextFont((const wchar_t *)fontNameI,fontPointSizeI,edgeSizeI,fontBoldI,fsi,fontColorRedI,fontColorGreenI,fontColorBlueI,edgeColorRedI,edgeColorGreenI,edgeColorBlueI,fontCharSetI);
	HFONT hOldFont = (HFONT) SelectObject(hdcBmp, g_hFont);
	
    printDebugStr( "5__FIRST LINE: font setted.\n");

	////Smooth Zone
	lb.lbStyle = BS_SOLID ;
    lb.lbColor = RGB (0, 255, 0) ;
    lb.lbHatch = 0 ;
	hpen = ExtCreatePen (PS_SOLID | PS_GEOMETRIC | iEnd [0] | iJoin [0], edgeSizeI + 3, &lb, 0, NULL) ;
    hpenOld = (HPEN)SelectObject(hdcBmp, hpen);	
	BeginPath(hdcBmp);
	TextOut(hdcBmp, fsx, fsy, szText, nLength);
	EndPath(hdcBmp);
	StrokePath(hdcBmp);
	DeleteObject(hpen);

    printDebugStr( "6__FIRST LINE: smoothing zone.\n");

	////Borde
	lb.lbStyle = BS_SOLID ;
    lb.lbColor = RGB (edgeColorRedI, edgeColorGreenI, edgeColorBlueI) ; 
    lb.lbHatch = 0 ;
	hpen = ExtCreatePen (PS_SOLID | PS_GEOMETRIC  | iEnd [0] | iJoin [0], edgeSizeI, &lb, 0, NULL) ;
    hpenOld = (HPEN)SelectObject(hdcBmp, hpen);	
	BeginPath(hdcBmp);
	TextOut(hdcBmp, fsx, fsy, szText, nLength);
	EndPath(hdcBmp);
	StrokePath(hdcBmp);
	DeleteObject(hpen);

	printDebugStr( "7__FIRST LINE: border maked.\n");
	
	////Texto
	TextOut(hdcBmp, fsx, fsy, szText, nLength); 
	
	printDebugStr( "8__FIRST LINE: printed.\n");

    ///Second Line
	g_hFont = SetTextFont((const wchar_t *)fontNameI,fontPointSizeI,edgeSizeI,fontBoldI,ssi,fontColorRedI,fontColorGreenI,fontColorBlueI,edgeColorRedI,edgeColorGreenI,edgeColorBlueI,fontCharSetI);
	hOldFont = (HFONT) SelectObject(hdcBmp, g_hFont);

    printDebugStr( "9__SECOND LINE: font setted.\n");

	////Smooth Zone
	lb.lbStyle = BS_SOLID ;
    lb.lbColor = RGB (0, 255, 0) ;
    lb.lbHatch = 0 ;
	hpen = ExtCreatePen (PS_SOLID | PS_GEOMETRIC | iEnd [0] | iJoin [0], edgeSizeI + 3, &lb, 0, NULL) ;
    hpenOld = (HPEN)SelectObject(hdcBmp, hpen);	
	BeginPath(hdcBmp);
	TextOut(hdcBmp, ssx, ssy, szText1, nLength1);
	EndPath(hdcBmp);
	StrokePath(hdcBmp);
	DeleteObject(hpen);
	
	printDebugStr( "10__SECOND LINE: smoothing zone.\n");

	////Borde
	lb.lbStyle = BS_SOLID ;
    lb.lbColor = RGB (edgeColorRedI, edgeColorGreenI, edgeColorBlueI) ; 
    lb.lbHatch = 0 ;
	hpen = ExtCreatePen (PS_SOLID | PS_GEOMETRIC  | iEnd [0] | iJoin [0], edgeSizeI, &lb, 0, NULL) ;
    hpenOld = (HPEN)SelectObject(hdcBmp, hpen);	
	BeginPath(hdcBmp);
	TextOut(hdcBmp, ssx, ssy, szText1, nLength1);
	EndPath(hdcBmp);
	StrokePath(hdcBmp);
	DeleteObject(hpen);

	printDebugStr( "11__SECOND LINE: border maked.\n");

	////Text
	TextOut(hdcBmp, ssx, ssy, szText1, nLength1);

	printDebugStr( "12__SECOND LINE: printed.\n");

    //Subtitle Buffer Instance
	HBITMAP RetBmp=NULL;
	if (hbm)
	{	
		HDC BufferDC=CreateCompatibleDC(NULL);	// DC for Source Bitmap
		if (BufferDC)
		{
			HBITMAP hTmpBitmap = (HBITMAP) NULL;
			if (hdcBmp && hbm == (HBITMAP)GetCurrentObject(hdcBmp, OBJ_BITMAP))
			{
				hTmpBitmap = CreateBitmap(1, 1, 1, 1, NULL);
				SelectObject(hdcBmp, hTmpBitmap);
			}
			HGDIOBJ PreviousBufferObject=SelectObject(BufferDC,hbm);
			// here BufferDC contains the bitmap				
			HDC DirectDC=CreateCompatibleDC(NULL); // DC for working

			printDebugStr( "13__Buffer filled with subtitle bitmap.\n");

			if (DirectDC)
			{
				// Get bitmap size
				BITMAP bm;
				GetObject(hbm, sizeof(bm), &bm);	
				// create a BITMAPINFO with minimal initilisation for the CreateDIBSection
				BITMAPINFO RGB32BitsBITMAPINFO; 
				ZeroMemory(&RGB32BitsBITMAPINFO,sizeof(BITMAPINFO));
				RGB32BitsBITMAPINFO.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
				RGB32BitsBITMAPINFO.bmiHeader.biWidth=bm.bmWidth;
				RGB32BitsBITMAPINFO.bmiHeader.biHeight=bm.bmHeight;
				RGB32BitsBITMAPINFO.bmiHeader.biPlanes=1;
				RGB32BitsBITMAPINFO.bmiHeader.biBitCount=32;

                printDebugStr( "14__Filling bitmap info for createDIBSection.\n");

				// pointer used for direct Bitmap pixels access				
				DirectBitmap = CreateDIBSection(DirectDC, (BITMAPINFO *)&RGB32BitsBITMAPINFO, DIB_RGB_COLORS,(void **)&ptPixels, NULL, 0);		
				if (DirectBitmap)
				{
					HGDIOBJ PreviousObject=SelectObject(DirectDC, DirectBitmap);
					BitBlt(DirectDC,0,0,bm.bmWidth,bm.bmHeight,BufferDC,0,0,SRCCOPY);
                    
                    printDebugStr( "15__Filling callback buffer with the data.\n");

					SelectObject(DirectDC,PreviousObject);		
					RetBmp=DirectBitmap;
				}
				if (DirectDC)
					DeleteDC(DirectDC);	
			}		
			SelectObject(BufferDC,PreviousBufferObject);
			
			//new
			if (BufferDC)
				DeleteDC(BufferDC);

			if (hTmpBitmap)
			{
				SelectObject(hdcBmp, RetBmp);
				DeleteObject(hTmpBitmap);
			}

			printDebugStr( "16__Returning to previous hdc and hbm.\n");
		}
	}

	if(DirectBitmap)
		BitmapPresent=BitmapPresentPrev;

	SelectObject(hdcBmp, hbmOld);
	//new
	if (hbm)
		DeleteObject(hbm);
    //new
	if (hdc)
		DeleteDC(hdc);
	//new
	if (hdcBmp)
		DeleteDC(hdcBmp);

	printDebugStr( "Exiting ChangeSubtitle____________\n");
	changingSubtitle = false;
	return 1;
}

long _stdcall ChangeFontCall(const wchar_t *fontNameP, long fontPointSizeP, long edgeSizeP, long fontBoldP, long fontItalicP, long fontColorRedP, long fontColorGreenP, long fontColorBlueP, long edgeColorRedP, long edgeColorGreenP, long edgeColorBlueP, long fontCharSetP)
{
	return ChangeFont(fontNameP,fontPointSizeP, edgeSizeP, fontBoldP,fontItalicP,fontColorRedP,fontColorGreenP,fontColorBlueP,edgeColorRedP,edgeColorGreenP,edgeColorBlueP,fontCharSetP);
}

long _stdcall ChangeSubtitleCall(const wchar_t *firstString,long fsx,long fsy,long fsi,const wchar_t *secondString,long ssx,long ssy,long ssi, long alignment)
{
	long csr;
	printDebugStr( "Entering ChangeSubtitleCall____________\n");
	csr = ChangeSubtitle(firstString,fsx,fsy,fsi,secondString,ssx,ssy,ssi,alignment);
	printDebugStr( "Exiting ChangeSubtitleCall____________\n");
	return csr;
}

class CSampleGrabberCB2 : public ISampleGrabberCB 
{
 public:
	long Width;
    long Height;
	long count;
	char *bufsizechar;
	bool firstBool; 
	int firstIndSub,lastIndSub;
	int bufferBitmSize;
	BYTE pBufferStay[230400];

    STDMETHODIMP_(ULONG) AddRef() { return 2; }
    STDMETHODIMP_(ULONG) Release() { return 1; }

    STDMETHODIMP QueryInterface(REFIID riid, void ** ppv)
    {
        CheckPointer(ppv,E_POINTER);
        
        if( riid == IID_ISampleGrabberCB || riid == IID_IUnknown ) 
        {
            *ppv = (void *) static_cast<ISampleGrabberCB*> ( this );
            return NOERROR;
        }    
		firstBool = true;

        return E_NOINTERFACE;

	}
  
    STDMETHODIMP SampleCB( double SampleTime, IMediaSample * pSample )
    {
        return 0;
    }
 
    STDMETHODIMP BufferCB( double SampleTime, BYTE * pBuffer, long BufferSize )
    { 
        printDebugStr( "\nBufferCB Video\n");
		//320*240 o 640x480
		bufferBitmSize=Width*Height;

		if (!changingSubtitle)
        {
		creatingNewFrame=true;
		if (BitmapPresent) 
		{
			int pixelref = ptPixels[0];
			int color1= GetARValue(pixelref);
			int color2= GetAGValue(pixelref);
			int color3= GetABValue(pixelref);

			printDebugStr( "BufferCB BitmapPresent**\n");

			for (int i=0;i<=(bufferBitmSize-2);i++)
			{
					int pixel1;
					unsigned int acolor,rcolor,gcolor,bcolor; 				
					pixel1 = ptPixels[i];
					acolor =GetAAValue(pixel1);
					rcolor=GetARValue(pixel1);
					gcolor=GetAGValue(pixel1);
					bcolor=GetABValue(pixel1);
					
					if (!(rcolor==color1 && gcolor==color2 && bcolor==color3)&&!(rcolor==0 && gcolor==255 && bcolor==0))//(rcolor!=192 && gcolor!=192 && bcolor!=192)
					{
						pBuffer[(i*3)]=rcolor;
						pBuffer[(i*3)+1]=gcolor;
						pBuffer[(i*3)+2]=bcolor;
					}
			}

            printDebugStr( "BufferCB ptPixels copied in frame**\n");

			for (i=0;i<=(bufferBitmSize-2);i++)
			{
				INT pixel1;
				unsigned int acolor,rcolor,gcolor,bcolor; 
				pixel1 = ptPixels[i];	
				acolor =GetAAValue(pixel1);
				rcolor=GetARValue(pixel1);
				gcolor=GetAGValue(pixel1);
				bcolor=GetABValue(pixel1);
					
				if (!(rcolor==192 && gcolor==192 && bcolor==192))
				{
					pixel1r = pixel2r = pixel3r = pixel4r = pixel5r = pBuffer[(i*3)];
					pixel1g = pixel2g = pixel3g = pixel4g = pixel5g = pBuffer[(i*3)+1];
					pixel1b = pixel2b = pixel3b = pixel4b = pixel5b = pBuffer[(i*3)+2];
					
					if (i <= (buffSizeUsed/3)-1-1)
					{
						pixel2r = pBuffer[((i*3))+3];
						pixel2g = pBuffer[((i*3)+1)+3];
						pixel2b = pBuffer[((i*3)+2)+3];
					}
					if (i <= (buffSizeUsed/3) - (Width*3/3)-1)
					{
						pixel3r = pBuffer[((i*3))+(Width*3)];
						pixel3g = pBuffer[((i*3)+1)+(Width*3)];
						pixel3b = pBuffer[((i*3)+2)+(Width*3)];
					}
					if (i >= Width*3/3)
					{
						pixel4r = pBuffer[((i*3))-(Width*3)];
						pixel4g = pBuffer[((i*3)+1)-(Width*3)];
						pixel4b = pBuffer[((i*3)+2)-(Width*3)];
					}
					if (i >= 3/3)
					{
						pixel5r = pBuffer[((i*3))-3];
						pixel5g = pBuffer[((i*3)+1)-3];
						pixel5b = pBuffer[((i*3)+2)-3];
					}
		
					if ((rcolor==0 && gcolor==255 && bcolor==0))
					{
						pBuffer[(i*3)]= (pixel2r+pixel3r+pixel4r+pixel5r)/4;
						pBuffer[(i*3)+1]= (pixel2g+pixel3g+pixel4g+pixel5g)/4;
						pBuffer[(i*3)+2]= (pixel2b+pixel3b+pixel4b+pixel5b)/4;
					}
					else
					{
						pBuffer[(i*3)]= ((pixel1r*20)+pixel2r+pixel3r+pixel4r+pixel5r)/24;
						pBuffer[(i*3)+1]= ((pixel1g*20)+pixel2g+pixel3g+pixel4g+pixel5g)/24;
						pBuffer[(i*3)+2]= ((pixel1b*20)+pixel2b+pixel3b+pixel4b+pixel5b)/24;
					}

				}
			}

			printDebugStr( "BufferCB frame antialiased**\n");

		}

		creatingNewFrame=false;
		}

		return 0;
    }
};


CSampleGrabberCB2 CB2;


class CSampleGrabberCBAud : public ISampleGrabberCB 
{
 public:
	long Width;
    long Height;
	long count;
	char *bufsizechar;

    STDMETHODIMP_(ULONG) AddRef() { return 2; }
    STDMETHODIMP_(ULONG) Release() { return 1; }

    STDMETHODIMP QueryInterface(REFIID riid, void ** ppv)
    {
        CheckPointer(ppv,E_POINTER);
        
        if( riid == IID_ISampleGrabberCB || riid == IID_IUnknown ) 
        {
            *ppv = (void *) static_cast<ISampleGrabberCB*> ( this );
            return NOERROR;
        }    

        return E_NOINTERFACE;
    }
  
    STDMETHODIMP SampleCB( double SampleTime, IMediaSample * pSample )
    {
        return 0;
    }
 
    STDMETHODIMP BufferCB( double SampleTime, BYTE * pBuffer, long BufferSize )
    { 
	
		/*if (isAudioEnc) 
		{
			for (long countEnA=0;countEnA<BufferSize;countEnA++)
			{
			 pBuffer[countEnA]=pBuffer[countEnA]-10;
			}    
		}*/
		printDebugStr( "BufferCB Aud\n");

		return 0;
    }
};

CSampleGrabberCBAud CBAud;



class CSampleGrabberCBTC : public ISampleGrabberCB 
{
 public:
	long Width;
    long Height;
	long count;
	char *bufsizechar;
	wchar_t *strTC;

    STDMETHODIMP_(ULONG) AddRef() { return 2; }
    STDMETHODIMP_(ULONG) Release() { return 1; }

    STDMETHODIMP QueryInterface(REFIID riid, void ** ppv)
    {
        CheckPointer(ppv,E_POINTER);
        
        if( riid == IID_ISampleGrabberCB || riid == IID_IUnknown ) 
        {
            *ppv = (void *) static_cast<ISampleGrabberCB*> ( this );
            return NOERROR;
        }    

        return E_NOINTERFACE;
    }
  
    STDMETHODIMP SampleCB( double SampleTime, IMediaSample * pSample )
    {
        return 0;
    }
 
    STDMETHODIMP BufferCB( double SampleTime, BYTE * pBuffer, long BufferSize )
    { 

		printDebugStr( "BufferCB TC\n");
        printDebugStr((char *)pBuffer);
        printDebugStr( " \n");
		//char *strl;
		//ltoa(strl,BufferSize);
		//sizeof(pBuffer);
		/*for (long countEnA=0;countEnA<BufferSize;countEnA++)
		{
			 strcat(strconst,"n");
		}*/
		//strcpy(strconst,ltoa(BufferSize,strconst,10));
		//	wsprintf(strTC,_T("%s"),/*pBuffer*/"chao");
		
		char *strconst;
		ltoa(BufferSize,strconst,10);
		printDebugStr(strconst);
		printDebugStr( " \n");

		return 0;
    }


	/*wchar_t * getStrTC(){
		return strTC;
	}*/

};

CSampleGrabberCBTC CBTC;




void CreateGraphAndFiltersMov(const wchar_t *wfilename)
{
	
	HRESULT hr; 
	hr = CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
    if (FAILED(hr))
    {
        return;
    }

	hr=CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC,IID_IGraphBuilder,(void**)&g_pGraphBuilder);	
	if (FAILED(hr))
		return;

	g_pGraphBuilder->QueryInterface(IID_IMediaControl, (void**)&g_pMediaControl);
	g_pGraphBuilder->QueryInterface(IID_IMediaEvent, (void**)&g_pMediaEvent);
	g_pGraphBuilder->QueryInterface(IID_IMediaSeeking, (void**)&g_pMediaSeeking);
	g_pGraphBuilder->QueryInterface(IID_IVideoWindow, (void**)&g_pVideoWindow);
    
	CoCreateInstance(CLSID_MediaLooksQT, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSource);
	CoCreateInstance(CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSampleGrabber2);
	CoCreateInstance(CLSID_DSoundRender, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pDSoundRender);

	g_pGraphBuilder->AddSourceFilter(wfilename, L"Source Filter", &g_pSource);
	g_pGraphBuilder->AddFilter(g_pSampleGrabber2,  L"Sample Grabber2");
	g_pGraphBuilder->AddFilter(g_pDSoundRender, NULL);


	useNewVideoMixing = false;
	hr = CoCreateInstance(CLSID_VideoMixingRenderer, NULL,CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&pVmr);
    if (SUCCEEDED(hr)) 
		useNewVideoMixing = true;

	if (useNewVideoMixing)
	{
		hr = g_pGraphBuilder->AddFilter(pVmr, L"Video Mixing Renderer");
	}
	else
	{
		CoCreateInstance(CLSID_VideoRenderer, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pVideoRenderer);
		g_pGraphBuilder->AddFilter(g_pVideoRenderer, NULL);
	}

    g_pSampleGrabber2->QueryInterface(IID_ISampleGrabber, (void**)&pGrabber2);
	pGrabber2->SetBufferSamples( FALSE );
	pGrabber2->SetCallback(&CB2,1);
	CMediaType GrabType2;
    GrabType2.SetType( &MEDIATYPE_Video );
    GrabType2.SetSubtype( &MEDIASUBTYPE_RGB24 );
    hr = pGrabber2->SetMediaType( &GrabType2 );

	g_pSource->QueryInterface(IID_IQTSource, (void**)&iQTFilter);

}


void CreateGraphAndFiltersAvi(const wchar_t *wfilename)
{
	
	HRESULT hr; 
	hr = CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
    if (FAILED(hr))
    {
        return;
    }

	hr=CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC,IID_IGraphBuilder,(void**)&g_pGraphBuilder);	
	if (FAILED(hr))
		return;

	g_pGraphBuilder->QueryInterface(IID_IMediaControl, (void**)&g_pMediaControl);
	g_pGraphBuilder->QueryInterface(IID_IMediaEvent, (void**)&g_pMediaEvent);
	g_pGraphBuilder->QueryInterface(IID_IMediaSeeking, (void**)&g_pMediaSeeking);
	g_pGraphBuilder->QueryInterface(IID_IVideoWindow, (void**)&g_pVideoWindow);
    
	CoCreateInstance(CLSID_FileSource, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSource);
	CoCreateInstance(CLSID_AviSplitter, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pAviSplitter);	
	CoCreateInstance(CLSID_DivXDecoder, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pDivXDecoder);
	CoCreateInstance(CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSampleGrabber2);
	CoCreateInstance(CLSID_MPEG3Decoder, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pMPEG3Decoder);
	CoCreateInstance(CLSID_DSoundRender, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pDSoundRender);
	
	g_pGraphBuilder->AddSourceFilter(wfilename, L"Source Filter", &g_pSource);
	g_pGraphBuilder->AddFilter(g_pAviSplitter, NULL);	
	g_pGraphBuilder->AddFilter(g_pDivXDecoder, NULL);
	g_pGraphBuilder->AddFilter(g_pSampleGrabber2,  L"Sample Grabber2");
	g_pGraphBuilder->AddFilter(g_pMPEG3Decoder, NULL);
	g_pGraphBuilder->AddFilter(g_pDSoundRender, NULL);


	useNewVideoMixing = false;
	hr = CoCreateInstance(CLSID_VideoMixingRenderer, NULL,CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&pVmr);
    if (SUCCEEDED(hr)) 
		useNewVideoMixing = true;

	if (useNewVideoMixing)
	{
		hr = g_pGraphBuilder->AddFilter(pVmr, L"Video Mixing Renderer");
	}
	else
	{
		CoCreateInstance(CLSID_VideoRenderer, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pVideoRenderer);
		g_pGraphBuilder->AddFilter(g_pVideoRenderer, NULL);
	}

    g_pSampleGrabber2->QueryInterface(IID_ISampleGrabber, (void**)&pGrabber2);
	pGrabber2->SetBufferSamples( FALSE );
	pGrabber2->SetCallback(&CB2,1);
	CMediaType GrabType2;
    GrabType2.SetType( &MEDIATYPE_Video );
    GrabType2.SetSubtype( &MEDIASUBTYPE_RGB24 );
    hr = pGrabber2->SetMediaType( &GrabType2 );

}



HRESULT ConnectFiltersA(IGraphBuilder *pGraph,IBaseFilter *pSou,int pinOutNum, IBaseFilter *pDest, int pinInNum)   
{
    if ((pGraph == NULL) || (pSou == NULL) || (pDest == NULL))
    {
        return E_POINTER;
    }

	HRESULT hr;

	CComPtr<IPin> pOut = GetOutPin(pSou,pinOutNum);
	CComPtr<IPin> pIn = GetInPin(pDest,pinInNum);

	hr = pGraph->Connect(pOut, pIn);
	
    return hr;
}

HRESULT DisconnectFiltersA(IGraphBuilder *pGraph,IBaseFilter *pSou,int pinOutNum, IBaseFilter *pDest, int pinInNum)   
{
    if ((pGraph == NULL) || (pSou == NULL) || (pDest == NULL))
    {
        return E_POINTER;
    }

	HRESULT hr;

	CComPtr<IPin> pOut = GetOutPin(pSou,pinOutNum);
	CComPtr<IPin> pIn = GetInPin(pDest,pinInNum);

	hr = pGraph->Disconnect(pIn);

    return hr;
}


bool ConnectFiltersMov()
{
	
	HRESULT hr;

	hr = ConnectFiltersA(g_pGraphBuilder, g_pSource ,1, g_pDSoundRender,0);	
	if (FAILED(hr))
	{
		printDebugStr( "Connect g_pSource ,1, g_pDSoundRender,0 FAIL _______\n");
		return false;
	}

	hr = ConnectFiltersA(g_pGraphBuilder, g_pSource,0, g_pSampleGrabber2,0);
	if (FAILED(hr))
	{
		printDebugStr( "Connect g_pSource,0, g_pAviSplitter,0 FAIL _______\n");
	    return false;
	}
    
	if (useNewVideoMixing)
	{
		printDebugStr( "Connect filters useNewVideoMixing=TRUE_______\n");
		hr = ConnectFiltersA(g_pGraphBuilder, g_pSampleGrabber2, 0, pVmr,0);
	}
	else
	{
		printDebugStr( "Connect filters useNewVideoMixing=FALSE_______\n");
		hr = ConnectFiltersA(g_pGraphBuilder, g_pSampleGrabber2, 0, g_pVideoRenderer,0);
	}

	AM_MEDIA_TYPE mt;
    hr = pGrabber2->GetConnectedMediaType( &mt );
    VIDEOINFOHEADER * vih = (VIDEOINFOHEADER*) mt.pbFormat;
    CB2.Width  = vih->bmiHeader.biWidth;
    CB2.Height = vih->bmiHeader.biHeight; 
    FreeMediaType( mt );
  
	return true;
}



bool ConnectFiltersAvi()
{
	
	HRESULT hr;
	
	hr = ConnectFiltersA(g_pGraphBuilder, g_pSource,0, g_pAviSplitter,0);
	if (FAILED(hr))
	{
		printDebugStr( "Connect g_pSource,0, g_pAviSplitter,0 FAIL _______\n");
	    return false;
	}
	hr = ConnectFiltersA(g_pGraphBuilder, g_pAviSplitter ,1, g_pMPEG3Decoder,0);	
	if (FAILED(hr))
	{
		printDebugStr( "Connect g_pAviSplitter ,1, g_pMPEG3Decoder,0 FAIL _______\n");
		return false;
	}
	hr = ConnectFiltersA(g_pGraphBuilder, g_pMPEG3Decoder ,0, g_pDSoundRender,0);
    if (FAILED(hr))
	{
		printDebugStr( "Connect g_pMPEG3Decoder ,0, g_pDSoundRender,0 FAIL _______\n");
		return false;
	}
    hr = ConnectFiltersA(g_pGraphBuilder, g_pAviSplitter, 0, g_pDivXDecoder,0);
	if (FAILED(hr))
	{
		printDebugStr( "Connect g_pAviSplitter, 0, g_pDivXDecoder,0 FAIL _______\n");
		return false;
	}
	hr = ConnectFiltersA(g_pGraphBuilder, g_pDivXDecoder, 0, g_pSampleGrabber2,0);
	if (FAILED(hr))
	{
		printDebugStr( "Connect g_pDivXDecoder, 0, g_pSampleGrabber2,0 FAIL _______\n");
		return false;
	}
	if (useNewVideoMixing)
	{
		printDebugStr( "Connect filters useNewVideoMixing=TRUE_______\n");
		hr = ConnectFiltersA(g_pGraphBuilder, g_pSampleGrabber2, 0, pVmr,0);
	}
	else
	{
		printDebugStr( "Connect filters useNewVideoMixing=FALSE_______\n");
		hr = ConnectFiltersA(g_pGraphBuilder, g_pSampleGrabber2, 0, g_pVideoRenderer,0);
	}
	if (FAILED(hr))
    {
		printDebugStr( "Connect g_pSampleGrabber2, 0, g_pVideoRenderer,0 FAIL _______\n");
		return false;
    }
	
	AM_MEDIA_TYPE mt;
    hr = pGrabber2->GetConnectedMediaType( &mt );
    VIDEOINFOHEADER * vih = (VIDEOINFOHEADER*) mt.pbFormat;
    CB2.Width  = vih->bmiHeader.biWidth;
    CB2.Height = vih->bmiHeader.biHeight; 
    FreeMediaType( mt );
  
	return true;
}


void CleanUpDirectShow()
{
	//produce error de memoria: HELPER_RELEASE(g_pMediaSeeking);
	HELPER_RELEASE(g_pBasicAudio);
    HELPER_RELEASE(g_pMediaEvent);
    HELPER_RELEASE(g_pMediaControl);
	HELPER_RELEASE(g_pVideoWindow);
	HELPER_RELEASE(g_pSource);
	HELPER_RELEASE(g_pAviSplitter);
	HELPER_RELEASE(g_pDivXDecoder);
	HELPER_RELEASE(g_pSampleGrabber2);

	if (useNewVideoMixing)
	{
		HELPER_RELEASE(pVmr);
	}
	else
	{
		HELPER_RELEASE(g_pVideoRenderer);
	}
		//	
    HELPER_RELEASE(g_pMPEG3Decoder);
	HELPER_RELEASE(g_pDSoundRender);
	HELPER_RELEASE(g_pGraphBuilder);
}


long __declspec(dllexport) CALLBACK StopPlayer()
{
	printDebugStr( "\nStopPlayer:\n");
	g_pMediaControl->Stop();
	return 1;
}


long __declspec(dllexport) CALLBACK PausePlayer()
{
	printDebugStr( "\nPausePlayer:\n");
	g_pMediaControl->Pause();
/*
	AM_MEDIA_TYPE mt;
	hr = pGrabberTC->GetConnectedMediaType( &mt );
	mt.majortype
	FreeMediaType(mt);
	char *strTC;
    strTC = "h";
    printDebugStr(strTC);
*/
	return 1;

}

long __declspec(dllexport) CALLBACK PlayPlayer()
{
	printDebugStr( "\nPlayPlayer:\n");

	HRESULT hr;
	/*char *strTC;
	sprintf(strTC,"%s","Dll PlayPlayer");
    printDebugStr(strTC);
*/
	
	hr = g_pMediaControl->Run();	
	if (FAILED(hr)){
		MessageBoxA(NULL,"Play fail.",NULL,NULL);
	}
	return 1;
}


double __declspec(dllexport) CALLBACK SeekPlayingPlayer(double pos, double offset)
{
	LONGLONG posh,poshb,posa,offseth;
    posa=0;
    posh=(LONGLONG)(pos*10000000);
	offseth = /*1333000;*/(LONGLONG)(offset*10000000);
	poshb=posh-offseth;

	g_pMediaSeeking->SetPositions(&poshb,AM_SEEKING_AbsolutePositioning,NULL,AM_SEEKING_NoPositioning);

//	hr = pGrabber->StopDelivery(true);
	keepPreviousFrame = true;
	
	hr = g_pMediaControl->Run();
    while(posa<=posh)
		g_pMediaSeeking->GetCurrentPosition(&posa);
	g_pMediaControl->Pause();

//	hr = pGrabber->StopDelivery(false);
	keepPreviousFrame = false;

	g_pMediaSeeking->SetPositions(&posh,AM_SEEKING_AbsolutePositioning,NULL,AM_SEEKING_NoPositioning);
	return (double)poshb;
}
   
                                
double __declspec(dllexport) CALLBACK SeekPlayer(double pos)
{
	printDebugStr( "\nSeekPlayer:\n");
	LONGLONG posh;
    posh=(LONGLONG)(pos*10000000);
	g_pMediaSeeking->SetPositions(&posh,AM_SEEKING_AbsolutePositioning,NULL,AM_SEEKING_NoPositioning);
	return (double)posh;
}

long __declspec(dllexport) CALLBACK RefreshPlayer(long leftP, long topP, long widthP, long heightP)
{
	printDebugStr( "\nRefreshPlayer:\n");
	g_pVideoWindow->put_Left(leftP);
	g_pVideoWindow->put_Top(topP);
	g_pVideoWindow->put_Width(widthP);	
	g_pVideoWindow->put_Height(heightP);
	return widthP;
}

double __declspec(dllexport) CALLBACK GetDurationPlayer()
{
	printDebugStr( "\nGetDurationPlayer:\n");
	return (double)((double)dur/10000000);
}


long __declspec(dllexport) CALLBACK GetTC()
{
	long totalFrames;
	char strconsttot[10];

	if (esVideoMov){
		QT_TIMECODE qttimecode;
		iQTFilter->GetLastTimecode(&qttimecode);
		totalFrames = ((int)qttimecode.btHours * 3600 * 29.97) + ((int)qttimecode.btMinutes * 60 * 29.97) + ((int)qttimecode.btSeconds * 29.97) + ((int)qttimecode.btFrames);
		ltoa(totalFrames,strconsttot,10);
		char *separador=":";
		printDebugStr( "\n");
		char *strconst0="";
		itoa((int)qttimecode.btHours,strconst0,10);
		printDebugStr(strconst0);
		printDebugStr(separador);
		char *strconst1="";
		itoa((int)qttimecode.btMinutes,strconst1,10);
		printDebugStr(strconst1);
		printDebugStr(separador);
		char *strconst2="";
		itoa((int)qttimecode.btSeconds,strconst2,10);
		printDebugStr(strconst2);
		printDebugStr(separador);
		char *strconst3="";
		itoa((int)qttimecode.btFrames,strconst3,10);
		printDebugStr(strconst3);
	}
	else{
		totalFrames = 0;
	}
 	
	return totalFrames;
}


double __declspec(dllexport) CALLBACK GetPositionPlayer()
{
	printDebugStr( "\nGetPositionPlayer:\n");
	LONGLONG pos;
	g_pMediaSeeking->GetCurrentPosition(&pos); 
	return (double)((double)pos/10000000);
}

long __declspec(dllexport) CALLBACK SetVolume(long vol)
{
	printDebugStr( "\nSetVolume:\n");
	g_pBasicAudio->put_Volume(vol);
    return vol;
}

long __declspec(dllexport) CALLBACK GetVolume()
{
	printDebugStr( "\nGetVolume:\n");
	long volu;
	g_pBasicAudio->get_Volume (&volu);
    return volu;
}

long __declspec(dllexport) CALLBACK SetBalance(long bal)
{
	printDebugStr( "\nSetBalance:\n");
	g_pBasicAudio->put_Balance (bal);
    return bal;
}

long __declspec(dllexport) CALLBACK CleanPlayer()
{
	printDebugStr( "\nCleanPlayer:\n");
	if(g_pMediaControl)
	{
		g_pMediaControl->Stop();
		CleanUpDirectShow();
		CoUninitialize();
		if (debugMode)
			fclose(traceDecryptPlayer);
	}
	return 1;
}

long __declspec(dllexport) CALLBACK InitializePlayer(const wchar_t *wfilename,const wchar_t *wkeydec,long fpsVid,HWND g_hwnd,long lpd,long tpd,long wpd,long hpd,long debugModeParam,long videoExt)
{
	//&param: videoExt-> 0 Mov, 1 Avi

	if (debugModeParam==1)
		debugMode = true;
	else
        debugMode = false;

	if (debugMode)
	{
		char szProgramFilename[100];
		char *lpszName;
		char szFullPathProgram[999];
		char *szPathProgram;
		int lenFullPathProgram;
		char szTempStringConcat[100];
		lenFullPathProgram = 0;
		szPathProgram = "";
		GetModuleFileNameA(NULL, szProgramFilename, sizeof(szProgramFilename)); 
		szFullPathProgram[0] = 0;
		GetFullPathNameA(szProgramFilename, sizeof(szFullPathProgram), szFullPathProgram, &lpszName);
		lenFullPathProgram = strlen(szFullPathProgram);
		szTempStringConcat[0] = 0;
		szPathProgram = strncat(szTempStringConcat, szFullPathProgram, lenFullPathProgram - 15/*strlen(szProgramFilename)*/);//CAMBIAR ESTO SEGUN SISTEMA 13:QC, 15:trans
		strcat(szPathProgram, "traceDecryptPlayer.txt");  
		traceDecryptPlayer = fopen(szPathProgram, "a");
    }

	printDebugStr( "////////////////////////////>>>>>>>>>In VideoPlayerTM.dll, initializePlayer_______\n");

    bool bComplete = false;
    bool checkitout = true;
    
	BYTE lpDataE[1];
	long cantDivX=4;
	long cantl=1;
	PAVISTREAM ppavi;
 
	char lpDataAVIH[16];
	cantl=18;

	fontColorRedI=250;
	fontColorGreenI=250;
	fontColorBlueI=250;
	edgeColorRedI=0;
	edgeColorGreenI=0;
	edgeColorBlueI=0;

	isAudioEnc=false;
    isVideoEnc=false;
	scramvideo=false;

	bool filtersConnected;

	if (videoExt==0){
		videoWidth = 640; 
		videoHeight = 480;
		CreateGraphAndFiltersMov(wfilename);
		filtersConnected = ConnectFiltersMov();
		esVideoMov = true;
	}
	else{
		videoWidth = 320; 
		videoHeight = 240;
		CreateGraphAndFiltersAvi(wfilename);
		filtersConnected = ConnectFiltersAvi();
		esVideoMov = false;
	}

	if (!filtersConnected)
	{   
		if(g_pMediaControl)
		{
			g_pMediaControl->Stop();
			g_pVideoWindow->put_Owner(NULL);
			CleanUpDirectShow();
			CoUninitialize();
		}

		printDebugStr( "In VideoPlayerTM.dll, initializePlayer fail, connect filters fail (!ConnectFilters())_______\n");
			
		return 2;
	}

	g_pMediaSeeking->GetDuration(&dur);

	g_pGraphBuilder->QueryInterface(IID_IBasicAudio, (void**)&g_pBasicAudio);
	
    g_pVideoWindow->put_WindowStyle( WS_CHILD | WS_CLIPSIBLINGS);
    g_pVideoWindow->put_Height(hpd);
	g_pVideoWindow->put_Left(lpd);
	g_pVideoWindow->put_Top(tpd);
	g_pVideoWindow->put_Width(wpd);
	g_pVideoWindow->put_Owner((OAHWND)g_hwnd);

    hwndApp = g_hwnd;

	//640*480*3
	buffSizeUsed = videoWidth * videoHeight * 3;

	wpdGl=wpd;
	fpsVidGlob=fpsVid;

	printDebugStr( "In VideoPlayerTM.dll, initializePlayer SUCCEDED!!_______\n");

	return 0;	
							   
}


BOOL APIENTRY DllMain( HINSTANCE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	switch(ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		break;
	
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}


double __declspec(dllexport) CALLBACK ShowSubtitle(double cual) 
{
	if (cual==0)
		BitmapPresent=false;
	else
		BitmapPresent=true;
	
	return cual;
}









/*
	En initialize:

	if (AVIStreamOpenFromFile(&ppavi,wfilename,streamtypeVIDEO,0,OF_READ,NULL)==0)
	{	
		BITMAPINFOHEADER dib;
		long FormatBytes;

		AVIStreamReadFormat(ppavi,0,NULL,&FormatBytes);
        AVIStreamReadFormat(ppavi,0,&dib,&FormatBytes);

		if (dib.biCompression!=808802372)
        {
			printDebugStr( "In VideoPlayerTM.dll, initializePlayer fail, bad avi compression format (dib.biCompression!=808802372)_______\n");
			return 1;
		}
		
		if(AVIStreamReadData(ppavi,'TMIE',lpDataE,&cantl)!=AVIERR_NODATA)
		{
			if (lpDataE[0]==1)
			 isVideoEnc=true;
		}
		AVIStreamRelease(ppavi);
	}
	if (AVIStreamOpenFromFile(&ppavi,wfilename,streamtypeVIDEO,0,OF_READ,NULL)==0)
	{
		if(AVIStreamReadData(ppavi,'TMIS',lpDataE,&cantl)!=AVIERR_NODATA)
		{
			if (lpDataE[0]==1)
			 scramvideo=true;
		}
		AVIStreamRelease(ppavi);
	}
    if (AVIStreamOpenFromFile(&ppavi,wfilename,streamtypeAUDIO,0,OF_READ,NULL)==0)
	{
		if(AVIStreamReadData(ppavi,'TMIE',lpDataE,&cantl)!=AVIERR_NODATA)
		{
			if (lpDataE[0]==1)
			 isAudioEnc=true;
		}
		AVIStreamRelease(ppavi);
	}
	PAVIFILE pfavi;
	if (AVIFileOpen(&pfavi, wfilename, OF_READ, NULL)==0)
	{
		if(AVIFileReadData(pfavi,'TMTC',lpDataAVIH,&cantl)!=AVIERR_NODATA)
		{
		}
		else
		{
		 strcpy(lpDataAVIH,"notimecode"); 
		}
		AVIFileRelease(pfavi);
	}*/
