// Mp3ToWav.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h>
#include <string.h>
#include <streams.h>
#include <initguid.h>
#include "dllutil.h"
#include "dshowutil.h"
#include "resource.h"

#include <dshow.h>

#include <Qedit.h>
#include <commctrl.h>

#include <stdio.h>
#include <iostream>
using namespace std;

#include <stdlib.h>


/////////newBar/////////////////
/*
#define PATHSTRINGSIZE 256

char waveFilePath[PATHSTRINGSIZE];
FILE *streamWaveFile;
char riffId[4];
unsigned int riffSize;	
char riffFormat[4];
char formatId[4];
unsigned int formatSize;
char dataId[4];
unsigned int dataSize;
*/
/////////////////////////


#define INITGUID	
DEFINE_GUID(CLSID_WaveParser,
0xD51BD5A1, 0x7548, 0x11CF, 0xA5, 0x20, 0x00, 0x80, 0xC7, 0x7E, 0xF5, 0x8A);

#define INITGUID	
DEFINE_GUID(CLSID_MPEG3Decoder,
0x38BE3000, 0xDBF4, 0x11D0, 0x86, 0x0E, 0x00, 0xA0, 0x24, 0xCF, 0xEF, 0x6D);

#define WM_GRAPHEVENT	WM_USER	

static const GUID CLSID_WavDest = { 0x3c78b8e2, 0x6c4d, 0x11d1, { 0xad, 0xe2, 0x0, 0x0, 0xf8, 0x75, 0x4b, 0x99 } };


IGraphBuilder *g_pGraphBuilder; 

IBaseFilter*	g_pSource=NULL;
IBaseFilter*	g_pStreamSplitter=NULL;
IBaseFilter*	g_pMPEG3Decoder=NULL;
IBaseFilter *g_pSampleGrabber=NULL;
IBaseFilter *g_pWavDest;
IBaseFilter*	g_pFileWriter=NULL;

IFileSinkFilter2 *g_pSink= NULL;
IMediaControl*	g_pMediaControl;
IMediaEventEx*	g_pMediaEvent;

HINSTANCE hInstance;
HWND hWndQCBar;

IMediaSeeking *pSeek = NULL;
REFERENCE_TIME rtTotal=0;
REFERENCE_TIME rtNow=0;
HRESULT hr;
long total=0;
long *mp3barglob;
CComPtr<IPin> pOutSeeking;

FILE *traceDecryptPlayer;
bool debugMode;

void printDebugStr(char* debstr)
{
	if (debugMode)
	{
	 fprintf(traceDecryptPlayer, debstr);
	 fprintf(traceDecryptPlayer, "\n");
	}
}

class CSampleGrabberCB : public ISampleGrabberCB 
{
public:

    STDMETHODIMP_(ULONG) AddRef() { return 2; }
    STDMETHODIMP_(ULONG) Release() { return 1; }
    STDMETHODIMP QueryInterface(REFIID riid, void ** ppv)
    {
        CheckPointer(ppv,E_POINTER);
        
        if( riid == IID_ISampleGrabberCB || riid == IID_IUnknown ) 
        {
            *ppv = (void *) static_cast<ISampleGrabberCB*> ( this );
            return NOERROR;
        }    

        return E_NOINTERFACE;
    }
    
    STDMETHODIMP SampleCB( double SampleTime, IMediaSample * pSample )
    {
        return 0;
    }
    
    STDMETHODIMP BufferCB( double SampleTime, BYTE * pBuffer, long BufferSize )
    { 
        total=total+BufferSize;
	    *mp3barglob=total;
		return 0;
    }
};

CSampleGrabberCB CB;


void CreateGraphAndFilters(const wchar_t *wfilename,const wchar_t *wfiledestname)
{
	HRESULT hr; 
	hr = CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
    if (FAILED(hr))
    {
        return;
    }
  	
	hr=CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC,IID_IGraphBuilder,(void**)&g_pGraphBuilder);	
	if (FAILED(hr))
		return;

	g_pGraphBuilder->QueryInterface(IID_IMediaControl, (void**)&g_pMediaControl);
	g_pGraphBuilder->QueryInterface(IID_IMediaEvent, (void**)&g_pMediaEvent);

	CoCreateInstance(CLSID_FileSource, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSource);

	//2010
	CoCreateInstance(CLSID_MPEG1Splitter, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pStreamSplitter);
	//CoCreateInstance(CLSID_WaveParser, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pStreamSplitter);
	
	CoCreateInstance(CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pSampleGrabber);
	CoCreateInstance(CLSID_MPEG3Decoder, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pMPEG3Decoder);
	CoCreateInstance(CLSID_WavDest, NULL, CLSCTX_INPROC,IID_IBaseFilter, (void **)&g_pWavDest);
	CoCreateInstance(CLSID_FileWriter, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&g_pFileWriter);

	g_pGraphBuilder->AddSourceFilter(wfilename, L"Source Filter", &g_pSource);
	g_pGraphBuilder->AddFilter(g_pStreamSplitter, NULL);
	g_pGraphBuilder->AddFilter(g_pSampleGrabber,  L"Sample Grabber");
	g_pGraphBuilder->AddFilter(g_pMPEG3Decoder, NULL);
	g_pGraphBuilder->AddFilter(g_pWavDest, NULL);
	g_pGraphBuilder->AddFilter(g_pFileWriter, NULL);
	
	g_pFileWriter->QueryInterface(IID_IFileSinkFilter2, (void**)&g_pSink);
	g_pSink->SetMode(AM_FILE_OVERWRITE);
	g_pSink->SetFileName(wfiledestname, NULL);

	ISampleGrabber *pGrabber;
    g_pSampleGrabber->QueryInterface(IID_ISampleGrabber, (void**)&pGrabber);
	pGrabber->SetBufferSamples( FALSE );
	pGrabber->SetCallback(&CB,1);
}


HRESULT ConnectFiltersA(IGraphBuilder *pGraph,IBaseFilter *pSou, IBaseFilter *pDest)   
{
    if ((pGraph == NULL) || (pSou == NULL) || (pDest == NULL))
    {
        return E_POINTER;
    }

	HRESULT hr;

	CComPtr<IPin> pOut = GetOutPin(pSou,0);
	CComPtr<IPin> pIn = GetInPin(pDest,0);

	hr = pGraph->Connect(pOut, pIn);

    return hr;
}


void ConnectFilters()
{
	ConnectFiltersA(g_pGraphBuilder, g_pSource, g_pStreamSplitter);
	ConnectFiltersA(g_pGraphBuilder, g_pStreamSplitter,g_pSampleGrabber);
    
	//2014
	ConnectFiltersA(g_pGraphBuilder, g_pSampleGrabber, g_pMPEG3Decoder);
	ConnectFiltersA(g_pGraphBuilder, g_pMPEG3Decoder,g_pWavDest);
	//ConnectFiltersA(g_pGraphBuilder, g_pSampleGrabber, g_pWavDest);
	
	ConnectFiltersA(g_pGraphBuilder, g_pWavDest,g_pFileWriter);
}

void CleanUpDirectShow()
{
   // KillTimer(hWndQCBar, 1);

	if(g_pMediaControl){(g_pMediaControl)->Release();(g_pMediaControl)=NULL;}
	if(g_pMediaEvent){(g_pMediaEvent)->Release();(g_pMediaEvent)=NULL;}
    if(g_pSink){(g_pSink)->Release();(g_pSink)=NULL;}
					
	pOutSeeking = NULL;
	if(pSeek){(pSeek)->Release();(pSeek)=NULL;}
	
	if(g_pSource)
	{
	  g_pGraphBuilder->RemoveFilter(g_pSource);
	  g_pSource->Release();
	}
	else
	{	
	  g_pSource=NULL;
	}

	if(g_pStreamSplitter)
	{
	  g_pGraphBuilder->RemoveFilter(g_pStreamSplitter);
	  g_pStreamSplitter->Release();
	}
	else
	{	
	  g_pStreamSplitter=NULL;
	}
	
	if(g_pMPEG3Decoder)
	{
	  g_pGraphBuilder->RemoveFilter(g_pMPEG3Decoder);
	  g_pMPEG3Decoder->Release();
	}
	else
	{	
	  g_pMPEG3Decoder=NULL;
	}

	if(g_pWavDest)
	{
	  g_pGraphBuilder->RemoveFilter(g_pWavDest);
	  g_pWavDest->Release();
	}
	else
	{	
	  g_pWavDest=NULL;
	}

	if(g_pFileWriter)
	{
	  g_pGraphBuilder->RemoveFilter(g_pFileWriter);
	  g_pFileWriter->Release();
	}
	else
	{	
	  g_pFileWriter=NULL;
	}

	if(g_pGraphBuilder)
	{
	  g_pGraphBuilder->Release();
	}
	else
	{	
	  g_pGraphBuilder=NULL;
	}
}

/*
#include <iostream>
#include <climits>

template <typename T>
void print_bits ( T val, char out[256] )
{
  T n_bits = sizeof ( val ) * CHAR_BIT;

  for ( unsigned i = 0; i < n_bits; ++i ) {
    strcat(out, (const char *)!!( val & 1 ));
    val >>= 1;
  }
}

template <typename T>
T rev_bits ( T val )
{
  T ret = 0;
  T n_bits = sizeof ( val ) * CHAR_BIT;

  for ( unsigned i = 0; i < n_bits; ++i ) {
    ret = ( ret << 1 ) | ( val & 1 );
    val >>= 1;
  }

  return ret;
}
*/




//BSTR __declspec(dllexport) CALLBACK 
long _cdecl ConvertMp3ToWav(const wchar_t *stringMP3, const wchar_t *stringWAV,long *posmp3bar)
{


	printDebugStr( "ConvertMp3ToWav 1");

	//2010
	long KBitsPSecond=320;
	//long KBitsPSecond=128;
	
	/*
	unsigned KBitsPSecondB=0x0;
	
	WideCharToMultiByte( CP_ACP, 0, stringMP3, -1, waveFilePath, PATHSTRINGSIZE, NULL, NULL );
    streamWaveFile = fopen(waveFilePath, "rb");
	fseek(streamWaveFile,2,SEEK_SET);
	fread(&KBitsPSecondB, sizeof(KBitsPSecondB), 1, streamWaveFile);
	fclose(streamWaveFile);

	char anti[256];
	print_bits ( rev_bits ( KBitsPSecondB ), anti );

	KBitsPSecond = 100;

	if (KBitsPSecondB && 1001 == 0000) KBitsPSecond=128;
    
	if (KBitsPSecondB && 0001 == 0000) KBitsPSecond=320;

	MessageBoxA(NULL,anti,NULL,0);
    */

	long evCode;  	
	long param1, param2;
    bool bComplete = false;
    bool checkitout = true;

    mp3barglob=posmp3bar;

	CoInitialize(NULL);
		
	/*
	WNDCLASSEX wndclass;
	wndclass.cbSize = sizeof(wndclass);
	wndclass.style = 0;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = DLGWINDOWEXTRA;
	wndclass.hInstance = hInstance;
	wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndclass.lpszMenuName = NULL;
	printDebugStr( "ConvertMp3ToWav 2");
	RegisterClassEx(&wndclass);
    printDebugStr( "RegisterClassEx(&wndclass)");
	*/
	
	hWndQCBar = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_QCBAR), 0, NULL);
	printDebugStr( "hWndQCBar");
	
	if (hWndQCBar!= NULL)
	{
		ShowWindow(hWndQCBar,SW_SHOW); 
		printDebugStr( "ShowWindow");
	}


	CreateGraphAndFilters(stringMP3,stringWAV);
	printDebugStr( "CreateGraphAndFilters(stringMP3,stringWAV)");

	ConnectFilters();
	printDebugStr( "ConnectFilters()");
	
	pOutSeeking = GetOutPin(g_pWavDest,0);
	pOutSeeking->QueryInterface(IID_IMediaSeeking, (void**)&pSeek);
	pSeek->GetDuration(&rtTotal);

/*	unsigned long nTotalMS = (unsigned long) ((rtTotal/10000)*KBitsPSecond) / 8;
	char szDuration[256];
    sprintf(szDuration,"%ld",nTotalMS);
	MessageBoxA(NULL,szDuration,NULL,0);
*/	
	
	SendDlgItemMessage(hWndQCBar, IDC_PROGRESS1, PBM_SETRANGE, 0, MAKELPARAM(0, (((rtTotal/10000)* KBitsPSecond) / 8)/10000));
	SendDlgItemMessage(hWndQCBar, IDC_PROGRESS1, PBM_SETPOS, 10, 0);
	total=0;

	printDebugStr( "g_pMediaControl->Run()");
	g_pMediaControl->Run();

    while (checkitout)
	{
		while (SUCCEEDED(g_pMediaEvent->GetEvent(&evCode, &param1, &param2, 0)))
		{
			g_pMediaEvent->FreeEventParams(evCode, param1, param2);
			switch(evCode)
			{
				case EC_USERABORT:
					::MessageBoxA(NULL,"User aborts audio parsing.",NULL,0);
				    bComplete = true;
					checkitout = false;
					break;
				case EC_ERRORABORT:
				    ::MessageBoxA(NULL,"Error parsing audio.",NULL,0);
				    bComplete = true;
					checkitout = false;
					break;
				case EC_COMPLETE:
					bComplete = true;
					checkitout = false;
					break;
			}
		}

		SendDlgItemMessage(hWndQCBar, IDC_PROGRESS1, PBM_SETPOS, total/10000, 0);
        
		if (bComplete)
		{
			g_pMediaControl->Stop(); 
			CleanUpDirectShow();
			CoUninitialize();
			ShowWindow(hWndQCBar,SW_HIDE);
			hWndQCBar = NULL;
			checkitout = false;
		}

		Sleep(300);

	}

/*	char anti[256];
	MessageBoxA(NULL,itoa(total,anti,10),NULL,0);
*/	
/*
    g_pMediaEvent->WaitForCompletion(INFINITE,&evCode); 
    g_pMediaControl->Stop();
    CleanUpDirectShow();
    CoUninitialize();
	ShowWindow(hWndQCBar,SW_HIDE);
	hWndQCBar = NULL;
*/
	SysAllocString(stringWAV);
	return 1; 								   
}


/*__declspec(dllexport) CALLBACK*/
long _stdcall ConvertMp3ToWavCall(const wchar_t *stringMP3, const wchar_t *stringWAV, long *posmp3bar, long audioExtVal)
{


	/*if (videoExt==0)
		isVideoMov = true;
	else
		isVideoMov = false;*/
	return ConvertMp3ToWav(stringMP3, stringWAV, posmp3bar);
}



BOOL APIENTRY DllMain( HINSTANCE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	switch(ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		hInstance = hModule;
		debugMode = false;
		char szProgramFilename[100];
		char *lpszName;
		char szFullPathProgram[999];
		char *szPathProgram;
		int lenFullPathProgram;
		char szTempStringConcat[100];
		lenFullPathProgram = 0;
		szPathProgram = "";
		GetModuleFileNameA(NULL, szProgramFilename, sizeof(szProgramFilename)); 
		szFullPathProgram[0] = 0;
		GetFullPathNameA(szProgramFilename, sizeof(szFullPathProgram), szFullPathProgram, &lpszName);
		lenFullPathProgram = strlen(szFullPathProgram);
		szTempStringConcat[0] = 0;
		szPathProgram = strncat(szTempStringConcat, szFullPathProgram, lenFullPathProgram - 13);//CAMBIAR ESTO SEGUN SISTEMA 13:QC, 15:trans
		strcat(szPathProgram, "traceDecryptPlayer.txt");  
		traceDecryptPlayer = fopen(szPathProgram, "a");
		break;
	
	case DLL_PROCESS_DETACH:
		fclose(traceDecryptPlayer);
		break;
	}
    return TRUE;
}


